////////////////////////////////////////////////
//    module controls which memory to use     //
////////////////////////////////////////////////

module mem_ctrl (
	// inputs:
	input wire clock,

	input wire rd_req_in,
	input wire wr_req_in,
	
	input wire [7:0] data_in,
	input wire [21:0] addr_in,
	
	input wire [15:0] data_from_sdram,
	input wire [7:0] data_from_ram,
	input wire sdram_ready_in,
	
	// outputs:
	output wire [7:0] data_out,
	
	output wire [21:0] addr_for_sdram,
	output wire [15:0] data_for_sdram,
	output wire rd_req_out,
	output wire wr_req_out,
	output wire sdram_ready,
	
	output wire [14:0] addr_for_ram,
	output wire [7:0] data_for_ram,
	output wire wren	

	);
	
	//variables
	reg [3:0] state = 4'b0000;
	//reg [15:0] counter = 16'b1111111111111111;
	reg [15:0] counter = 16'h0000;
	reg [7:0] data;
	
	wire ram_not_sdram;
	
	//assign ram_not_sdram = (addr_in[15:14] == 2'b01);
	assign ram_not_sdram = (addr_in[16:14] == 3'b101) || (addr_in[16:14] == 3'b111);
	
	assign data_out = (ram_not_sdram) ? (data_from_ram) : (data_from_sdram[7:0]);
	assign data_for_ram = data_in;
	assign data_for_sdram = (state==4'b1111) ? {8'b00000000, data_in} : {8'b00000000, data};
	
	assign addr_for_ram   = (state==4'b1111) ? {addr_in[15] , addr_in[13:0]} : counter[14:0];
	assign addr_for_sdram = (state==4'b1111) ? addr_in : {7'b0000100, counter[14:0]};
	
	assign wren = (state==4'b1111) ? (wr_req_in & ram_not_sdram) : 1'b0;
	
	assign rd_req_out = (state==4'b1111) ? rd_req_in & ~ram_not_sdram : 1'b0;
	assign wr_req_out = (state==4'b1111) ? wr_req_in & ~ram_not_sdram & (addr_in[17] == 1'b0): (state==4'b0010);
	
	assign sdram_ready = (state==4'b1111) ? sdram_ready_in : 1'b0;


always @(posedge clock)
begin

	case (state)
	
		4'b0000: begin // waiting for RAM to return data
			state <= 4'b0001; 
		end
		4'b0001: begin
			data <= data_from_ram;
			state <= 4'b0010;
		end
		4'b0010: begin // see above - activating wr_req_out
			state <= 4'b0011;
		end
		4'b0011: begin
			state <= 4'b0100;
		end
		4'b0100: begin
			if(sdram_ready_in == 1'b1) begin
				//if(counter != 0 ) begin
				if(counter < 16'hffff ) begin
					//counter <= counter - 1'b1;
					counter <= counter + 1'b1;
					state <= 4'b0000;
				end else begin
					state <= 4'b1111;
				end
			end
		end

	endcase;

end


endmodule