#!/usr/bin/perl
#
# Create Chameleon DOS empty DSk image.
# MFM disks of 16 sectors and FM disks of 9 sectors
# per track are supported.
#
# (c) 2014 PortaOne, Inc.
# kapitan@portaone.com
#
# Usage:
# lviv-empty-dsk.pl <dsk file> [dencity] [disk name] 
#
$| = 1;

$disk_name = ($ARGV[2] eq '')? 'NEW' : $ARGV[2];

if( $ARGV[1] eq "MFM" ) { 
   $size = 83*2*16*256;
}
elsif( $ARGV[1] eq "FM" ) {
   $size = 83*2*9*256;
} else {
   die "ERROR: Acceptable dencity is MFM or FM.";
}

open(OUT, ">$ARGV[0]")
   || die "Can not create output file $ARGV[0]";

# Write new disk attributes
#
print OUT pack( 'A11 C C C C C C',
  $disk_name,
  1,
  1,
  0,
  0,
  0,
  0 );

# Pad remaining free space in new DSK
#
print OUT "\0"x($size-17);

close(OUT);
