
#define Arc __Arc__
#pragma warning( disable: 4121 4211 )
#include <windows.h>
#pragma warning( default: 4121 )
#undef Arc
#include "wcxhead.h"
#include "fmt.hpp"
#include "plugin.hpp"
#include "wcx.h"

#ifdef DEBUG
#define DebugString(x) {OutputDebugString( __STR__(__LINE__)": " );OutputDebugString( x );OutputDebugString( "\n" );}
#define __STR2__(x) #x
#define __STR__(x) __STR2__(x)
#define assert( x ) if( !(x) ) DebugString( "Assertion "#x" in line "__STR__(__LINE__) )
#else
#define DebugString(x)
#define assert( x )
#endif

#ifdef ZeroMemory
#undef ZeroMemory
#endif

#define ZeroMemory( ptr, size ) {for( int i = 0; i < size; i++ ) *((char*)(ptr) + i) = 0;}


static HANDLE heap = 0;

static void* malloc( size_t size )
{
    assert( heap );
    return HeapAlloc( heap, HEAP_ZERO_MEMORY, size );
}

static void* realloc( void* block, size_t size )
{
    assert( heap );

    if( block && !size )
    {
        HeapFree( heap, 0, block );
        return 0;
    }
    else if( block && size )
        return HeapReAlloc( heap, HEAP_ZERO_MEMORY, block, size );
    else if( !block && size )
        return HeapAlloc( heap, HEAP_ZERO_MEMORY, size );
    else // !block && !size
        return 0;
}

static void free( void* block )
{
    assert( heap );
    if( block )
        HeapFree( heap, 0, block );
    return;
}

static char* lstrchr( char* str, int chr )
{
    assert( str );
    for( int i = 0; str[i]; i++ )
        if( str[i] == chr )
            return str + i;
    return 0;
}

static char* lstrrchr( char* str, int chr )
{
    assert( str );
    for( int i = lstrlen( str ); i >= 0; i-- )
        if( str[i] == chr )
            return str + i;
    return 0;
}

static char* lstrstr( const char* str1, const char* str2 )
{
    assert( str1 && str2 );

    int l1 = lstrlen( str1 );
    int l2 = lstrlen( str2 );
    for( int i = 0; i < l1 - l2; i++ )
    {
        int j;
        for( j = 0; j < l2; j++ )
           if( str1[i + j] != str2[j] )
               break;
        if( j >= l2 )
            return (char*)str1 + i;
    }
    return 0;
}


static SEnum WcxList;
static SArc* Arc;

static char ModuleName[MAX_PATH * 2];
static char ModulePath[sizeof( ModuleName )];

DWORD __stdcall DllMain( HINSTANCE hinstDLL, DWORD fdwReason, LPVOID )
{
    if( !hinstDLL )
        return FALSE;

    char* name;

    switch( fdwReason )
    {
        case DLL_PROCESS_ATTACH:
            DebugString( "process attach" );
            heap = HeapCreate( HEAP_GENERATE_EXCEPTIONS, 10 * 1024, 0 );

            // get module name & path
            GetModuleFileName( hinstDLL, ModuleName, sizeof( ModuleName ) );
            GetFullPathName( ModuleName, sizeof( ModulePath ), ModulePath, &name );
            assert( name );
            *name = 0;
            DebugString( ModuleName );
            DebugString( ModulePath );

            ZeroMemory( &WcxList, sizeof( WcxList ) );
            Arc = 0;
            
            break;
        case DLL_THREAD_ATTACH:
            DebugString( "thread attach" );
            break;
        case DLL_THREAD_DETACH:
            DebugString( "thread detach" );
            break;
        case DLL_PROCESS_DETACH:
            DebugString( "process detach" );
            for( int i = 0; i < WcxList.num; i++ )
            {
                DebugString( "unload" );
                DebugString( WcxList.wcx[i].name );
                FreeLibrary( WcxList.wcx[i].wcx );
            }
            if( WcxList.wcx )
                free( WcxList.wcx );
            if( heap )
            {
                HeapDestroy( heap );
                heap = 0;
            }
            break;
    }

    
    return TRUE;
}

static SWcx* LoadWcx( const char* path, const char* name )
{
    DebugString( "LoadWcx" );
    if( !path )
        return 0;

    SWcx wcx;
    ZeroMemory( &wcx, sizeof( wcx ) );

    if( (wcx.wcx = LoadLibrary( path )) == 0 )
        return 0;

    lstrcpy( wcx.name, name );

    wcx.OpenArchive          = (OpenArchive_t*)GetProcAddress( wcx.wcx, "OpenArchive" );
    wcx.CloseArchive         = (CloseArchive_t*)GetProcAddress( wcx.wcx, "CloseArchive" );
    wcx.ReadHeader           = (ReadHeader_t*)GetProcAddress( wcx.wcx, "ReadHeader" );
    wcx.ProcessFile          = (ProcessFile_t*)GetProcAddress( wcx.wcx, "ProcessFile" );
    wcx.PackFiles            = (PackFiles_t*)GetProcAddress( wcx.wcx, "PackFiles" );
    wcx.DeleteFiles          = (DeleteFiles_t*)GetProcAddress( wcx.wcx, "DeleteFiles" );
    wcx.SetChangeVolProc     = (SetChangeVolProc_t*)GetProcAddress( wcx.wcx, "SetChangeVolProc" );
    wcx.SetProcessDataProc   = (SetProcessDataProc_t*)GetProcAddress( wcx.wcx, "SetProcessDataProc" );
    wcx.ConfigurePacker      = (ConfigurePacker_t*)GetProcAddress( wcx.wcx, "ConfigurePacker" );
    wcx.GetPackerCaps        = (GetPackerCaps_t*)GetProcAddress( wcx.wcx, "GetPackerCaps" );
    wcx.CanYouHandleThisFile = (CanYouHandleThisFile_t*)GetProcAddress( wcx.wcx, "CanYouHandleThisFile" );
    
    if( !wcx.OpenArchive || !wcx.CloseArchive || !wcx.ReadHeader || !wcx.ProcessFile )
    {
        FreeLibrary( wcx.wcx );
        return 0;
    }
    
    if( wcx.GetPackerCaps )
        wcx.caps = wcx.GetPackerCaps();
    
    SWcx* result = (SWcx*)malloc( sizeof( wcx ) );
    assert( result );
    *result = wcx;
    DebugString( result->name );
    
    return result;
}


static bool UpdateWcxList( SEnum* list )
{
    DebugString( "UpdateWcxList" );
    if( !list )
        return false;

    char mask[sizeof( ModulePath )];
    lstrcat( lstrcpy( mask, ModulePath ), "WCX\\*.wcx" );

    WIN32_FIND_DATA find_data;

    HANDLE find = FindFirstFile( mask, &find_data );
    if( find == INVALID_HANDLE_VALUE )
        return false;

    do
    {
        bool present = false;
        char path[sizeof( ModulePath )];
        lstrcat( lstrcat( lstrcpy( path, ModulePath ), "WCX\\" ), find_data.cFileName );
        for( int i = 0; i < list->num; i++ )
            if( !lstrcmpi( list->wcx[i].name, find_data.cFileName ) )
            {
                present = true;
                break;
            }
        if( !present )
        {
            DebugString( path );
            SWcx* wcx = LoadWcx( path, find_data.cFileName );
            if( wcx )
            {
                DebugString( "loaded" );
                list->wcx = (SWcx*)realloc( list->wcx, sizeof( list->wcx[0] ) * (list->num + 1) );
                list->wcx[list->num] = *wcx;
                list->num++;
                free( wcx );
            }
        }
    }while( FindNextFile( find, &find_data ) );

    FindClose( find );

    return true;    
}

static int __stdcall ChangeVolProc( char*, int ) {return 1;}
static int __stdcall ProcessDataProc(char*, int ) {return 1;}

static SArc* OpenArchive( const char* name, SWcx* wcx, bool test = false )
{
    DebugString( "OpenArchive" );
    if( !name || !wcx  )
        return 0;

    SArc arc;
    arc.wcx = wcx;
    lstrcpy( arc.name, name );
    
    tOpenArchiveData arc_data;
    ZeroMemory( &arc_data, sizeof( arc_data ) );

    arc_data.ArcName = (char*)name;
    arc_data.OpenMode = PK_OM_EXTRACT;

    if( (arc.arc = wcx->OpenArchive( &arc_data )) == 0 )
        return 0;

    if( wcx->SetProcessDataProc )
        wcx->SetProcessDataProc( arc.arc, ProcessDataProc );
    if( wcx->SetChangeVolProc )
        wcx->SetChangeVolProc( arc.arc, ChangeVolProc );
    
    if( !test )
    {
        SArc* result = (SArc*)malloc( sizeof( *result ) );
        assert( result );
        *result = arc;
        DebugString( "opened" );
        return result;
    }

    tHeaderData data;
    ZeroMemory( &data, sizeof( data ) );
    lstrcpy( data.ArcName, name );
    int res = wcx->ReadHeader( arc.arc, &data );
    if( res != 10 && res != 22 && res )
    {
        wcx->CloseArchive( arc.arc );
        return 0;
    }

    wcx->CloseArchive( arc.arc ); // reset enumerator
    if( (arc.arc = wcx->OpenArchive( &arc_data )) == 0 )
        return 0;
    if( wcx->SetProcessDataProc )
        wcx->SetProcessDataProc( arc.arc, ProcessDataProc );
    if( wcx->SetChangeVolProc )
        wcx->SetChangeVolProc( arc.arc, ChangeVolProc );

    SArc* result = (SArc*)malloc( sizeof( *result ) );
    assert( result );
    *result = arc;
    DebugString( "tested & opened" );
    return result;
}

static bool CloseArchive( SArc* arc )
{
    DebugString( "CloseArchive" );
    if( !arc || !arc->arc || !arc->wcx )
        return false;

    arc->wcx->CloseArchive( arc->arc );
    free( arc );
    
    return true;
}


DWORD WINAPI LoadFormatModule( const char *ModuleName )
{
    DebugString( "LoadFormatModule" );
    if( !ModuleName )
        return FALSE;

    if( !UpdateWcxList( &WcxList ) )
        return FALSE;

    DebugString( "updated" );

    return TRUE;
}

BOOL WINAPI IsArchive( const char *Name, const unsigned char*, int )
{
    DebugString( "IsArchive" );
    if( !Name )
        return FALSE;

    int i;
	
	DebugString( "check wcx's which supports CanYouHandleThisFile" );
    for( i = 0; i < WcxList.num; i++ )
    {
        DebugString( WcxList.wcx[i].name );
        if( WcxList.wcx[i].GetPackerCaps && WcxList.wcx[i].CanYouHandleThisFile )
        {
            DebugString( "supports CanYouHandleThisFile" );
            if( WcxList.wcx[i].CanYouHandleThisFile( Name ) )
            {
                DebugString( "can handle" );
                return TRUE;
            }
        }
    }
        
	DebugString( "check wcx's which can't supports CanYouHandleThisFile" );
    for( i = 0; i < WcxList.num; i++ )
    {
        DebugString( WcxList.wcx[i].name );
        if( !(WcxList.wcx[i].GetPackerCaps && WcxList.wcx[i].CanYouHandleThisFile) )
        {
            SArc* arc = OpenArchive( Name, &WcxList.wcx[i], true );
            if( arc )
            {
                CloseArchive( arc );
                DebugString( "opened & closed" );
                return TRUE;
            }
        }
    }
        
    return FALSE;
}

DWORD WINAPI GetSFXPos( void )
{
    DebugString( "GetSFXPos" );
    return 0;
}

BOOL WINAPI OpenArchive( const char *Name, int *Type )
{
    DebugString( "Far OpenArchive" );
    if( !Name || !Type )
        return FALSE;

    int i;
	
	DebugString( "check wcx's which supports CanYouHandleThisFile" );
    for( i = 0; i < WcxList.num; i++ )
    {
        DebugString( WcxList.wcx[i].name );
        if( WcxList.wcx[i].GetPackerCaps && WcxList.wcx[i].CanYouHandleThisFile )
        {
            if( WcxList.wcx[i].CanYouHandleThisFile( Name ) &&
		        (Arc = OpenArchive( Name, &WcxList.wcx[i], true )) )
            {
				DebugString( "opened" );
				*Type = i;
				return TRUE;
            }
        }
    }
        
	DebugString( "check wcx's which can't supports CanYouHandleThisFile" );
    for( i = 0; i < WcxList.num; i++ )
    {
        DebugString( WcxList.wcx[i].name );
        if( !(WcxList.wcx[i].GetPackerCaps && WcxList.wcx[i].CanYouHandleThisFile) )
        {
			Arc = OpenArchive( Name, &WcxList.wcx[i], true );
			if( Arc )
			{
				*Type = i;
				return TRUE;
			}
        }
    }

    return FALSE;
}

int WINAPI GetArcItem( struct PluginPanelItem *Item, struct ArcItemInfo *Info )
{
    //DebugString( "GetArcItem" );
    if( !Item || !Info || !Arc || !Arc->arc )
        return GETARC_READERROR;

    tHeaderData data;
    ZeroMemory( &data, sizeof( data ) );
    ZeroMemory( Item, sizeof( *Item ) );
    ZeroMemory( Info, sizeof( *Info ) );
    lstrcpy( data.ArcName, Arc->name );

    int result = Arc->wcx->ReadHeader( Arc->arc, &data );
    if( result )
        return GETARC_EOF;

    Arc->wcx->ProcessFile( Arc->arc, PK_SKIP, 0, 0 );

    FILETIME filetime;
    CharToOem( data.FileName, Item->FindData.cFileName );
    DosDateTimeToFileTime( (WORD)((DWORD)data.FileTime >> 16), (WORD)data.FileTime, &filetime );
    LocalFileTimeToFileTime( &filetime, &Item->FindData.ftLastWriteTime );
    Item->FindData.ftCreationTime = Item->FindData.ftLastAccessTime = Item->FindData.ftLastWriteTime;

    Item->FindData.dwFileAttributes = data.FileAttr; // FILE_ATTRIBUTE_Archive
    Item->FindData.nFileSizeLow = data.UnpSize;

    if( data.CmtBuf )
    {
        lstrcpyn( Info->Description, data.CmtBuf, min( data.CmtBufSize, sizeof( Info->Description ) ) );
        Info->Comment = 1;
    }
    Info->UnpVer = data.UnpVer;

    return GETARC_SUCCESS;
}

BOOL WINAPI CloseArchive( struct ArcInfo* )
{
    DebugString( "Far CloseArchive" );
    if( !Arc || !Arc->arc )
        return FALSE;

    CloseArchive( Arc );
    Arc = 0;
    
    return TRUE;
}

BOOL WINAPI GetFormatName( int Type, char *FormatName, char *DefaultExt )
{
    //DebugString( "GetFormatName" );
    if( !FormatName || !DefaultExt )
        return FALSE;

    if( Type >= WcxList.num )
        return FALSE;

    lstrcpy( FormatName, WcxList.wcx[Type].name );
    lstrcpy( DefaultExt, WcxList.wcx[Type].name );
    char* dot = lstrchr( DefaultExt, '.' );
    if( dot )
        *dot = 0;
    
    return TRUE;
}


enum ArcCommand
{
    extract = 0,
    extract_no_path,
    test,
    del,
    comment,
    comment_files,
    convert_to_sfx,
    lock,
    add_recovery_record,
    recover,
    add_files,
    move_files,
    add_files_and_folders,
    move_files_and_folders,
    all_files_mask
};

static bool SupportCommand( const SWcx* wcx, ArcCommand command )
{
    if( !wcx )
        return false;

    switch( command )
    {
    case extract:
    case extract_no_path:
    case test:
        return true;
    case del:
        if( wcx->DeleteFiles && !wcx->GetPackerCaps ||
            wcx->GetPackerCaps && wcx->caps & PK_CAPS_DELETE )
            return true;
        else
            return false;
    case add_files:
    case add_files_and_folders:
    case move_files:
    case move_files_and_folders:
        if( wcx->PackFiles && !wcx->GetPackerCaps ||
            wcx->GetPackerCaps && wcx->caps & (PK_CAPS_NEW | PK_CAPS_MODIFY) )
            return true;
        else
            return false;
    }
    return false;
}


BOOL WINAPI GetDefaultCommands( int Type, int Command, char *Dest )
{
    DebugString( "GetDefaultCommands" );
    if( !Dest || Type >= WcxList.num )
        return FALSE;

    if( !SupportCommand( &WcxList.wcx[Type], (ArcCommand)Command ) )
        return FALSE;
    
    char name[sizeof( ModuleName )];

    OSVERSIONINFO OsVersion = {sizeof( OsVersion )};
    GetVersionEx( &OsVersion );
    
    if( OsVersion.dwPlatformId != VER_PLATFORM_WIN32_NT ) // win9x
        GetShortPathName( ModuleName, name, sizeof( name ) / sizeof( *name ) );
    else if( lstrchr( ModuleName, ' ' ) )
        lstrcat( lstrcat( lstrcpy( name, "\"" ), ModuleName ), "\"" );
    else
        lstrcpy( name, ModuleName );

    
    switch( Command )
    {
    case extract:
        lstrcpy( Dest, lstrcat( lstrcat( lstrcat( lstrcat( lstrcpy( Dest, "rundll32 " ), name ), ",Process -x -f:"), WcxList.wcx[Type].name ), " -a:%%A {-r:%%R} -l:%%L" ) );
        DebugString( Dest );
        return TRUE;
    case extract_no_path:
        lstrcpy( Dest, lstrcat( lstrcat( lstrcat( lstrcat( lstrcpy( Dest, "rundll32 " ), name ), ",Process -e -f:"), WcxList.wcx[Type].name ), " -a:%%A {-r:%%R} -l:%%L" ) );
        DebugString( Dest );
        return TRUE;
    case test:
        lstrcpy( Dest, lstrcat( lstrcat( lstrcat( lstrcat( lstrcpy( Dest, "rundll32 " ), name ), ",Process -t -f:"), WcxList.wcx[Type].name ), " -a:%%A -l:%%L" ) );
        DebugString( Dest );
        return TRUE;
    case add_files:
        lstrcpy( Dest, lstrcat( lstrcat( lstrcat( lstrcat( lstrcpy( Dest, "rundll32 " ), name ), ",Process -a -f:"), WcxList.wcx[Type].name ), " -a:%%A -l:%%L {-r:%%R}" ) );
        DebugString( Dest );
        return TRUE;
    case add_files_and_folders:
        lstrcpy( Dest, lstrcat( lstrcat( lstrcat( lstrcat( lstrcpy( Dest, "rundll32 " ), name ), ",Process -af -f:"), WcxList.wcx[Type].name ), " -a:%%A -l:%%L {-r:%%R}" ) );
        DebugString( Dest );
        return TRUE;
    case move_files:
        lstrcpy( Dest, lstrcat( lstrcat( lstrcat( lstrcat( lstrcpy( Dest, "rundll32 " ), name ), ",Process -m -f:"), WcxList.wcx[Type].name ), " -a:%%A -l:%%L {-r:%%R}" ) );
        DebugString( Dest );
        return TRUE;
    case move_files_and_folders:
        lstrcpy( Dest, lstrcat( lstrcat( lstrcat( lstrcat( lstrcpy( Dest, "rundll32 " ), name ), ",Process -mf -f:"), WcxList.wcx[Type].name ), " -a:%%A -l:%%L {-r:%%R}" ) );
        DebugString( Dest );
        return TRUE;
    case del:
        lstrcpy( Dest, lstrcat( lstrcat( lstrcat( lstrcat( lstrcpy( Dest, "rundll32 " ), name ), ",Process -d -f:"), WcxList.wcx[Type].name ), " -a:%%A -l:%%L" ) );
        DebugString( Dest );
        return TRUE;
    }

    return FALSE;
}

void  WINAPI SetFarInfo( const struct PluginStartupInfo* )
{
    DebugString( "SetFarInfo" );
    return;
}


static int GetArgv( const char* cmd, char*** argv, DWORD symbol = 32 )
{
    DebugString( "GetArgv" );
    assert( cmd && argv );
    
    if( *argv )
    {
        free( *argv );
        *argv = 0;
    }

    int l = lstrlen( cmd );
    
    // settings for arguments vectors
    int* pos = (int*)malloc( l * sizeof( *pos ) );
    int* len = (int*)malloc( l * sizeof( *pos ) );
    int  num = 0;
    
    assert( pos && len );

    int i;
    for( i = 0; i < l; )
    {
        // skip white space
        while( (unsigned)cmd[i] <= symbol && i < l )
            i++;
        if( i >= l )
            break;

        // get argument
        pos[num] = i;
        while( (unsigned)cmd[i] > symbol && i < l )
        {
            if( cmd[i] == '"' )
            {
                i++;
                while( cmd[i] != '"' && i < l )
                    i++;
                i++;
            }
            else
                i++;
        }

        len[num] = i - pos[num];
        num++;
    }

    *argv = (char**)malloc( num * sizeof( **argv ) );
    for( i = 0; i < num; i++ )
    {
        (*argv)[i] = (char*)malloc( (len[i] + 2) * sizeof( ***argv ) );
        assert( (*argv)[i] );
        lstrcpyn( (*argv)[i], cmd + pos[i], len[i] + 1 );
        DebugString( (*argv)[i] );
    }

    free( len );
    free( pos );
    
    return num;
}

static bool FreeArgv( int argc, char** argv )
{
    if( !argv )
        return false;

    for( int i = 0; i < argc; i++ )
        if( argv[i] )
            free( argv[i] );
    free( argv );

    return true;
}

static bool GetArgument( int argc, char** argv, const char* name, char* value )
{
    assert( argc && argv && name && value );
    *value = 0;
    for( int i = 0; i < argc; i++ )
        if( lstrstr( argv[i], name ) == argv[i] )
        {
            int len = lstrlen( name );
            if( argv[i][len] == '"' )
                lstrcpyn( value, argv[i] + len + 1, lstrlen( argv[i] ) - len - 1 );
            else
                lstrcpy( value, argv[i] + len );
            DebugString( name );
            DebugString( value );
            return true;
        }
    return false;
}


static char* Canonic( char* str )
{
    //DebugString( "Canonic" );
    assert( str );
    char* sym = 0;
    while( (sym = lstrchr( str, '/')) != 0 )
        *sym = '\\';
    return str;
}

static int GetList( const char* file_list, char*** list )
{
    DebugString( "GetList" );
    assert( file_list && list );
    HANDLE file = CreateFile( file_list, GENERIC_READ, FILE_SHARE_READ, 0,
                              OPEN_EXISTING, 0, 0 );
    if( file == INVALID_HANDLE_VALUE )
        return 0;

    DWORD size = SetFilePointer( file, 0, 0, FILE_END );
    SetFilePointer( file, 0, 0, FILE_BEGIN );
    if( !size )
    {
        CloseHandle( file );
        return 0;
    }
    char* text = (char*)malloc( size );
    if( !text )
    {
        CloseHandle( file );
        return 0;
    }

    DWORD read = 0;
    ReadFile( file, text, size, &read, 0 );
    CloseHandle( file );

    if( !read )
    {
        free( text );
        return 0;
    }

    int result = GetArgv( text, list, 31 );
    free( text );

    for( int i = 0; i < result; i++ )
    {
        Canonic( (*list)[i] );
        OemToChar( (*list)[i], (*list)[i] );
        DebugString( "converted" );
        DebugString( (*list)[i] );
    }

    return result;
}


static bool Match( const char* pattern, const char* path, const char* sub_path,
                   char* result )
{
    assert( pattern && path );

    int plen = lstrlen( pattern );
    if( lstrlen( path ) < plen || plen < (sub_path ? lstrlen( sub_path ) : 0) )
        return false;
    
    char pth[MAX_PATH * 2];
    lstrcpyn( pth, path, plen + 1 );
    if( lstrcmpi( pth, pattern ) )
        return false;

    if( plen < lstrlen( path ) && path[plen] != '\\' )
        return false;

    if( result )
    {
        char* ptr = (char*)path + (sub_path ? lstrlen( sub_path ) : 0);
        while( *ptr == '\\' )
            ptr++;
        lstrcpy( result, ptr );
    }
    DebugString( "Match" );
    DebugString( result ? result : "no result" );
    return true;
}


static bool CreateDir( const char* dir, bool lstdir = false )
{
    //DebugString( "CreateDir" );
    //DebugString( dir );
    //assert( dir );
    
    char path[MAX_PATH * 2];
    int  size[MAX_PATH];
    int  num = 0;
    char* sym = (char*)dir;

    while( (sym = lstrchr( sym, '\\' )) != 0 )
    {
        size[num] = sym - dir + 1;
        num++;
        sym++;
    }
    
    if( lstdir )
    {
        size[num] = lstrlen( dir ) + 1;
        num++;
    }
    
#ifdef DEBUG
    lstrcpy( path, dir );
#endif //DEBUG

    int start = (dir[0] == '\\' && dir[1] == '\\') ? 4 : 1;

    for( int i = start; i < num; i++ )
    {
        lstrcpyn( path, dir, size[i] );
        DebugString( path );
        DWORD attr = GetFileAttributes( path );
        if( attr != 0xffffffff && !(attr & FILE_ATTRIBUTE_DIRECTORY) )
        {
            DebugString( "Error: can't create directory (file exists):" );
            DebugString( path );
            return false;
        }
        if( attr == 0xffffffff && !CreateDirectory( path, 0 ) )
        {
            DebugString( "Error: can't create directory:" );
            DebugString( path );
            return false;
        }
    }
    //DebugString( "CreatedDirectory" );
    //DebugString( path );
    return true;
}


static int Extract( SArc* arc, const char* list, const char* sub_path,
                    const char* dest, bool path, bool test = false )
{
    DebugString( "Extract" );
    assert( arc && list && sub_path && dest );

    char** files = 0;
    int fnum = GetList( list, &files );

    if( !fnum )
        return 1;

    bool empty = false;

	int result = 0;

    while( !empty )
    {
        tHeaderData data;
        ZeroMemory( &data, sizeof( data ) );
        lstrcpy( data.ArcName, arc->name );

        int result = arc->wcx->ReadHeader( arc->arc, &data );
        if( result )
        {
            FreeArgv( fnum, files );
            return 0;
        }
        Canonic( data.FileName );
        
        int i;
        char dest_name[MAX_PATH * 2];
        for( i = 0; i < fnum; i++ )
        {
            if( (path || !(data.FileAttr & FILE_ATTRIBUTE_DIRECTORY)) &&
                files[i] && Match( files[i], data.FileName, sub_path, dest_name ) )
            {
                char dest_path[MAX_PATH * 2];
                if( path )
                    lstrcat( lstrcat( lstrcpy( dest_path, dest ), "\\"), dest_name );
                else
                {
                    lstrcpy( dest_path, dest );
                    char* sym = lstrrchr( data.FileName, '\\' );
                    lstrcat( lstrcat( dest_path, sym ? "" : "\\" ), sym ? sym : data.FileName );
                }
                //if( data.FileAttr & FILE_ATTRIBUTE_DIRECTORY )
                //    *lstrrchr( dest_path, '\\' ) = 0;
                    
                DebugString( (data.FileAttr & FILE_ATTRIBUTE_DIRECTORY) ?
                             "extract directory from: " : "extract from: " );
                DebugString( data.FileName );
                DebugString( (data.FileAttr & FILE_ATTRIBUTE_DIRECTORY) ?
                             "extract directory to: " : "extract to: " );
                DebugString( dest_path );
                if( !CreateDir( dest_path,
                    (data.FileAttr & FILE_ATTRIBUTE_DIRECTORY) != 0 ) )
                {
                    FreeArgv( fnum, files );
                    return 1;
                }
                if( !(data.FileAttr & FILE_ATTRIBUTE_DIRECTORY) )
                {
					int res = arc->wcx->ProcessFile( arc->arc, test ? PK_TEST : PK_EXTRACT,
                                                     0, test ? 0 : dest_path );
					if( res != 0 && res != E_END_ARCHIVE )
					{
						result = res;
						DebugString( "Detected error in extraction\n" );
					}
					
                    DebugString( "Extracted, setting permissions...\n" );
                    if( !test )
                    {
                        HANDLE f = CreateFile( dest_path, FILE_WRITE_ATTRIBUTES,
                                    FILE_SHARE_READ | FILE_SHARE_WRITE,
                                    0, OPEN_EXISTING, 0, 0 );
                        if( f != INVALID_HANDLE_VALUE )
                        {
                            FILETIME filetime;
                            FILETIME ftime;
                            DosDateTimeToFileTime( (WORD)((DWORD)data.FileTime >> 16), (WORD)data.FileTime, &filetime );
                            LocalFileTimeToFileTime( &filetime, &ftime );
                            SetFileTime( f, &ftime, &ftime, &ftime );
                            CloseHandle( f );
                        }
                        SetFileAttributes( dest_path, data.FileAttr );
                    }
                }
                else
                    arc->wcx->ProcessFile( arc->arc, PK_SKIP, 0, 0 );
                
                if( !(data.FileAttr & FILE_ATTRIBUTE_DIRECTORY) &&
                    !lstrcmpi( files[i], dest_name ) )
                {
                    free( files[i] );
                    files[i] = 0;
                }
                empty = true;
                for( int k = 0; k < fnum; k++ )
                    if( files[k] )
                    {
                        empty = false;
                        break;
                    }

                break;
            }
        }
        if( i >= fnum )
        {
            DebugString( data.FileName );
            DebugString( " skipping" );
            arc->wcx->ProcessFile( arc->arc, PK_SKIP, 0, 0 );
        }
    }

    FreeArgv( fnum, files );
    return result;
}

static int ExpandDir( const char* dir, int num, char*** expanded )
{
    DebugString( "ExpandDir" );
    assert( dir );

    char mask[MAX_PATH * 2];
    lstrcat( lstrcpy( mask, dir ), "\\*.*" );
    WIN32_FIND_DATA data;
    HANDLE find = FindFirstFile( mask, &data );
    if( find == INVALID_HANDLE_VALUE )
        return 0;

    do
    {
        if( !lstrcmp( data.cFileName, "." ) || !lstrcmp( data.cFileName, ".." ) )
            continue;
        char name[MAX_PATH * 2];
        lstrcat( lstrcat( lstrcpy( name, dir ), "\\" ), data.cFileName );
        if( GetFileAttributes( name ) & FILE_ATTRIBUTE_DIRECTORY )
            num = ExpandDir( name, num, expanded );
        else
        {
            *expanded = (char**)realloc( *expanded, sizeof( **expanded ) * (num + 1) );
            assert( *expanded );
            (*expanded)[num] = (char*)malloc( (lstrlen( name ) + 1) * sizeof( ***expanded ) );
            lstrcpy( (*expanded)[num], name );
            DebugString( (*expanded)[num] );
            num++;
        }
    } while( FindNextFile( find, &data ) );
    FindClose( find );

    return num;
}


static int AddFiles( SWcx* wcx, const char* arc, const char* list, const char* sub_path, bool move )
{
    DebugString( "AddFiles" );
    assert( wcx && arc && list && sub_path );

    char** files = 0;
    int lnum = GetList( list, &files );

    if( !lnum )
        return 1;

    char** expanded = 0;
    int fnum = 0;

    int i;
    for( i = 0; i < lnum; i++ )
    {
        DWORD attr = GetFileAttributes( files[i] );
        if( attr != 0xffffffff )
        {
            if( attr & FILE_ATTRIBUTE_DIRECTORY )
                fnum = ExpandDir( files[i], fnum, &expanded );
            else
            {
                expanded = (char**)realloc( expanded, (fnum + 1) * sizeof( *expanded ) );
                assert( expanded );
                expanded[fnum] = (char*)malloc( (lstrlen( files[i] ) + 1) * sizeof( **expanded ) );
                lstrcpy( expanded[fnum], files[i] );
                DebugString( expanded[fnum] );
                fnum++;
            }
        }
    }
    FreeArgv( lnum, files );

    if( !fnum )
    {
        DebugString( "no files to process" );
        return 1;
    }
    
    int size = 0;
    for( i = 0; i < fnum; i++ )
        size += lstrlen( expanded[i] ) + 1;
    size++;

    char* arg = (char*)malloc( size );
    assert( arg );
    for( size = 0, i = 0; i < fnum; i++ )
    {
        lstrcpy( arg + size, expanded[i] );
        size += lstrlen( expanded[i] ) + 1;
    }
    arg[size] = 0;
    FreeArgv( fnum, expanded );

    if( wcx->SetProcessDataProc )
        wcx->SetProcessDataProc( INVALID_HANDLE_VALUE, ProcessDataProc );
    if( wcx->SetChangeVolProc )
        wcx->SetChangeVolProc( INVALID_HANDLE_VALUE, ChangeVolProc );
    
    int result = wcx->PackFiles( (char*)arc, (char*)sub_path, ".\\", arg,
                                 PK_PACK_SAVE_PATHS | (move ? PK_PACK_MOVE_FILES : 0) );
    free( arg );
    
    return result;
}

static int DeleteFiles( SWcx* wcx, const char* arc_name, const char* list )
{
    DebugString( "DeleteFiles" );
    assert( wcx && arc_name && list );

    char** files = 0;
    int fnum = GetList( list, &files );

    if( !fnum )
        return 1;

    SArc* arc = OpenArchive( arc_name, wcx );
    if( !arc )
    {
        FreeArgv( fnum, files );
        return 1;
    }

    char* arg = 0;
    int size = 0;

    while( 1 )
    {
        tHeaderData data;
        ZeroMemory( &data, sizeof( data ) );
        lstrcpy( data.ArcName, arc->name );

        int result = arc->wcx->ReadHeader( arc->arc, &data );
        if( result )
            break;
        Canonic( data.FileName );
        for( int i = 0; i < fnum; i++ )
            if( Match( files[i], data.FileName, "", 0 ) )
            {
                int len = lstrlen( data.FileName ) + 1;
                arg = (char*)realloc( arg, size + len + 2 );
                lstrcpy( arg + size, data.FileName );
                size += len;
                DebugString( data.FileName );
                break;
            }
    }
    arg[size] = 0;
    CloseArchive( arc );
    FreeArgv( fnum, files );

    if( wcx->SetProcessDataProc )
        wcx->SetProcessDataProc( INVALID_HANDLE_VALUE, ProcessDataProc );
    if( wcx->SetChangeVolProc )
        wcx->SetChangeVolProc( INVALID_HANDLE_VALUE, ChangeVolProc );
    
    int result = wcx->DeleteFiles( (char*)arc_name, arg );
    free( arg );
    return result;
}


// functions for rundll32.exe
void CALLBACK Process( HWND, HINSTANCE, LPTSTR lpCmdLine, int )
{
    DebugString( "Process" );
    DebugString( lpCmdLine );

    if( !lpCmdLine )
        ExitProcess( 1 );

    if( !UpdateWcxList( &WcxList ) )
        ExitProcess( 1 );

    char** argv;
    int argc = GetArgv( lpCmdLine, &argv );
    if( !argc )
    {
        FreeArgv( argc, argv );
        ExitProcess( 1 );
    }

    ArcCommand command = extract;
    if( !lstrcmp( argv[0], "-x" ) )
        command = extract;
    else if( !lstrcmp( argv[0], "-e" ) )
        command = extract_no_path;
    else if( !lstrcmp( argv[0], "-t" ) )
        command = test;
    else if( !lstrcmp( argv[0], "-a" ) )
        command = add_files;
    else if( !lstrcmp( argv[0], "-af" ) )
        command = add_files_and_folders;
    else if( !lstrcmp( argv[0], "-m" ) )
        command = move_files;
    else if( !lstrcmp( argv[0], "-mf" ) )
        command = move_files_and_folders;
    else if( !lstrcmp( argv[0], "-d" ) )
        command = del;
    else
    {
        FreeArgv( argc, argv );
        ExitProcess( 1 );
    }

    char current_directory[MAX_PATH * 2];
    char arc_name[MAX_PATH * 2];
    char sub_path[MAX_PATH * 2];
    char file_list[MAX_PATH * 2];
    char format[MAX_PATH];

    GetCurrentDirectory( sizeof( current_directory ), current_directory );

    GetArgument( argc, argv, "-a:", arc_name );
    GetArgument( argc, argv, "-l:", file_list );
    GetArgument( argc, argv, "-f:", format );
    GetArgument( argc, argv, "-r:", sub_path );
    Canonic( sub_path );

    SArc* arc = 0;
    for( int i = 0; i < WcxList.num; i++ )
        if( !lstrcmpi( WcxList.wcx[i].name, format )   &&
            SupportCommand( &WcxList.wcx[i], command ) &&   
            (command != extract && command != extract_no_path && command != test ||
            (arc = OpenArchive( arc_name, &WcxList.wcx[i], false)) != 0) )
            break;

    if( !arc && (command == extract || command == extract_no_path || command == test) )
    {
        DebugString( "Error: can't detect required WCX" );
        FreeArgv( argc, argv );
        ExitProcess( 1 );
    }

    SWcx* wcx = &WcxList.wcx[i];
    
    int result = 1;
    switch( command )
    {
    case extract:
        DebugString( "Extract" );
        result = Extract( arc, file_list, sub_path, current_directory, true );
        break;
    case extract_no_path:
        DebugString( "Extract without path" );
        result = Extract( arc, file_list, sub_path, current_directory, false );
        break;
    case test:
        DebugString( "Test" );
        result = Extract( arc, file_list, sub_path, current_directory, false, true );
        break;
    case add_files:
    case add_files_and_folders:
        DebugString( "Add files" );
        result = AddFiles( wcx, arc_name, file_list, sub_path, false );
        break;
    case move_files:
    case move_files_and_folders:
        DebugString( "Move files" );
        result = AddFiles( wcx, arc_name, file_list, sub_path, true );
        break;
    case del:
        DebugString( "Delete files" );
        result = DeleteFiles( wcx, arc_name, file_list );
        break;
    }
    
    if( arc )
        CloseArchive( arc );
    FreeArgv( argc, argv );
    ExitProcess( result );
}


SEnum* GetWcxList()
{
    DebugString( "GetWcxList" );
    UpdateWcxList( &WcxList );
    return &WcxList;
}


