
#pragma once

// typedefs
typedef HANDLE __stdcall OpenArchive_t( tOpenArchiveData* ArchiveData );
typedef int    __stdcall CloseArchive_t( HANDLE hArcData );
typedef int    __stdcall ReadHeader_t( HANDLE hArcData, tHeaderData* HeaderData );
typedef int    __stdcall ProcessFile_t( HANDLE hArcData, int Operation, char* DestPath, char* DestName );
typedef int    __stdcall PackFiles_t( char* PackedFile, char* SubPath, char* SrcPath, char* AddList, int Flags );
typedef int    __stdcall DeleteFiles_t( char* PackedFile, char* DeleteList );
typedef void   __stdcall SetChangeVolProc_t( HANDLE hArcData, tChangeVolProc pChangeVolProc1 );
typedef void   __stdcall SetProcessDataProc_t( HANDLE hArcData, tProcessDataProc pProcessDataProc );
typedef void   __stdcall ConfigurePacker_t( HWND Parent, HINSTANCE DllInstance );
typedef int    __stdcall GetPackerCaps_t();
typedef BOOL   __stdcall CanYouHandleThisFile_t( const char* FileName );

struct SWcx
{
    HMODULE wcx;
    char    name[MAX_PATH];
    int     caps;

    OpenArchive_t*          OpenArchive;
    CloseArchive_t*         CloseArchive;
    ReadHeader_t*           ReadHeader;
    ProcessFile_t*          ProcessFile;
    PackFiles_t*            PackFiles;
    DeleteFiles_t*          DeleteFiles;
    SetChangeVolProc_t*     SetChangeVolProc;
    SetProcessDataProc_t*   SetProcessDataProc;
    ConfigurePacker_t*      ConfigurePacker;
    GetPackerCaps_t*        GetPackerCaps;
    CanYouHandleThisFile_t* CanYouHandleThisFile;
};

struct SArc
{
    HANDLE arc;
    SWcx*  wcx;
    char   name[MAX_PATH];
};

struct SEnum
{
    SWcx* wcx;
    int   num;
};

