
#define Arc __Arc__
#pragma warning( disable: 4121 4211 )
#include <windows.h>
#pragma warning( default: 4121 )
#undef Arc
#include "wcxhead.h"
#include "fmt.hpp"
#include "plugin.hpp"
#include "wcx.h"

#ifdef DEBUG
#define DebugString(x) {OutputDebugString( __STR__(__LINE__)": " );OutputDebugString( x );OutputDebugString( "\n" );}
#define __STR2__(x) #x
#define __STR__(x) __STR2__(x)
#define assert( x ) if( !(x) ) DebugString( "Assertion "#x" in line "__STR__(__LINE__) )
#else
#define DebugString(x)
#define assert( x )
#endif

#ifdef ZeroMemory
#undef ZeroMemory
#endif

#define ZeroMemory( ptr, size ) {for( int i = 0; i < size; i++ ) *((char*)(ptr) + i) = 0;}


static HANDLE heap = 0;

static void* malloc( size_t size )
{
    assert( heap );
    return HeapAlloc( heap, HEAP_ZERO_MEMORY, size );
}

/*
static void* realloc( void* block, size_t size )
{
    assert( heap );

    if( block && !size )
    {
        HeapFree( heap, 0, block );
        return 0;
    }
    else if( block && size )
        return HeapReAlloc( heap, HEAP_ZERO_MEMORY, block, size );
    else if( !block && size )
        return HeapAlloc( heap, HEAP_ZERO_MEMORY, size );
    else // !block && !size
        return 0;
}
*/

static void free( void* block )
{
    assert( heap );
    if( block )
        HeapFree( heap, 0, block );
    return;
}


static char ModuleName[MAX_PATH * 2];
static char ModulePath[sizeof( ModuleName )];

DWORD __stdcall DllMain( HINSTANCE hinstDLL, DWORD fdwReason, LPVOID )
{
    if( !hinstDLL )
        return FALSE;

    char* name;

    switch( fdwReason )
    {
        case DLL_PROCESS_ATTACH:
            DebugString( "process attach" );
            heap = HeapCreate( HEAP_GENERATE_EXCEPTIONS, 10 * 1024, 0 );

            // get module name & path
            GetModuleFileName( hinstDLL, ModuleName, sizeof( ModuleName ) );
            GetFullPathName( ModuleName, sizeof( ModulePath ), ModulePath, &name );
            assert( name );
            *name = 0;
            DebugString( ModuleName );
            DebugString( ModulePath );
            break;
        case DLL_THREAD_ATTACH:
            DebugString( "thread attach" );
            break;
        case DLL_THREAD_DETACH:
            DebugString( "thread detach" );
            break;
        case DLL_PROCESS_DETACH:
            DebugString( "process detach" );
            if( heap )
            {
                HeapDestroy( heap );
                heap = 0;
            }
            break;
    }

    return TRUE;
}


    
void WINAPI GetPluginInfo( struct PluginInfo *Info )
{
    DebugString( "GetPluginInfo" );
    if( !Info )
        return;
    ZeroMemory( Info, sizeof( *Info ) );

    static char* config[] = {"WCX Config"};
    
    Info->StructSize = sizeof( *Info );
    Info->PluginConfigStrings = config;
    Info->PluginConfigStringsNumber = 1;
}


static PluginStartupInfo Info;

void WINAPI SetStartupInfo( const struct PluginStartupInfo *info )
{
    DebugString( "SetStartupInfo" );
    if( info )
        ::Info = *info;
}

typedef SEnum* GetWcxList_t();

const char* dll_name = "wcx.fmt";
int WINAPI Configure( int )
{
    DebugString( "Configure" );

    HMODULE wcx = GetModuleHandle( dll_name );
    bool loaded = false;
    if( wcx )
    {
        loaded = true;
        DebugString( "dll already loaded" );
    }
    else
    {
        char dll[MAX_PATH * 2];
        lstrcat( lstrcpy( dll, ModulePath ), dll_name );
        wcx = LoadLibrary( dll );
        if( !wcx )
        {
            DebugString( "can't load library" );
            static char* message[] = {"WCX Connector",
                                      "Can't load format module (wcx.fmt)"};
            
            Info.Message( Info.ModuleNumber, FMSG_WARNING | FMSG_MB_OK,
                          0, message, 2, 0 );
            return FALSE;
        }
        DebugString( "loading dll" );
        DebugString( dll );
    }

    GetWcxList_t* GetWcxList = (GetWcxList_t*)GetProcAddress( wcx, "GetWcxList" );
    if( !GetWcxList )
    {
        DebugString( "can't find export function GetWcxList" );
        static char* message[] = {"WCX Connector",
                                  "Can't find export function GetWcxList"};
        
        Info.Message( Info.ModuleNumber, FMSG_WARNING | FMSG_MB_OK,
                      0, message, 2, 0 );
        if( !loaded )
            FreeLibrary( wcx );
        return FALSE;
    }

    SEnum* list = GetWcxList();
    assert( list );

    int* wcx_num = (int*)malloc( list->num * sizeof( *wcx_num ) );
    FarMenuItem* item = (FarMenuItem*)malloc( list->num * sizeof( *item ) );
    assert( wcx_num && item );

    int num = 0;

    for( int i = 0; i < list->num; i++ )
        if( list->wcx[i].ConfigurePacker )
        {
            DebugString( "adding" );
            DebugString( list->wcx[i].name );
            wcx_num[num] = i;
            lstrcpy( item[num].Text, list->wcx[i].name );
            num++;
        }
    
    int select;
    do
    {
        select = Info.Menu( Info.ModuleNumber, -1, -1, 0,
                            FMENU_WRAPMODE | FMENU_AUTOHIGHLIGHT,
                            "WCX Connector", "Select WCX module", 0, 0, 0, item, num );
        if( select >= 0 )
        {
            DebugString( "call configure for" );
            DebugString( list->wcx[wcx_num[select]].name );
            HWND wnd = (HWND)Info.AdvControl( Info.ModuleNumber, ACTL_GETFARHWND, 0 );
    //      SetWindowPos( GetForegroundWindow(), HWND_NOTOPMOST, 0, 0, 0, 0,
    //                    SWP_NOMOVE | SWP_NOSIZE | SWP_ASYNCWINDOWPOS | SWP_SHOWWINDOW );
    //      BringWindowToTop( wnd );
            list->wcx[wcx_num[select]].ConfigurePacker( wnd, list->wcx[wcx_num[select]].wcx );
        }
    }while( select >= 0 );
    
    free( wcx_num );
    free( item );
    
    if( !loaded )
        FreeLibrary( wcx );
    
    return select >= 0 ? TRUE : FALSE;
    
}

