#define F_CPU 16000000UL

#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/io.h>
#include "lcd_lib.c"
#include "key.c"
#include <util/delay.h>

static const unsigned char GOSTxx[102][4] PROGMEM ={ 
	{'','','3',' '},
	{'','','8',' '},
	{'','','1',' '},
	{'','','1',' '},
	{'','','2',' '},
	{'','','3',' '},
	{'','','9',' '},
	{'','','1',' '},
	{'','','4',' '},
	{'','','1','0'},
	{'','','1',' '},
	{'','','2',' '},
	{'','','5',' '},
	{'','','4',' '},
	{'','','1',' '},
	{'','','7',' '},
	{'','','2',' '},
	{'','','3',' '},
	{'','','1','1'},
	{'','','4',' '},
	{'','','2',' '},
	{'','','1',' '},
	{'','','1','2'},
	{'','','1','3'},
	{'','','6',' '},
	{'','','2','4'},
	{'','','1',' '},
	{'','','3',' '},
	{'','','4',' '},
	{'','','1',' '},
	{'','','1',' '},
	{'','','2',' '},
	{'','','7',' '},
	{'','','5',' '},
	{'','','1',' '},
	{'','','1',' '},
	{'','','2',' '},
	{'','','3',' '},
	{'','','3',' '},
	{'','','1',' '},
	{'','','5',' '},
	{'','','2',' '},
	{'','','2',' '},
	{'','','4',' '},
	{'','','5',' '},
	{'','','1',' '},
	{'','','8',' '},
	{'','','1','5'},
	{'','','1',' '},
	{'','','3',' '},
	{'','','8',' '},
	{'','','3',' '},
	{'','','1',' '},
	{'','','1','0'},
	{'','','1',' '},
	{'','','1',' '},
	{'','','7',' '},
	{'','','5',' '},
	{'','','2',' '},
	{'','','3',' '},
	{'','','4',' '},
	{'','','9',' '},
	{'','','3','2'},
	{'','','1',' '},
	{'','','3',' '},
	{'','','1','5'},
	{'','','8',' '},
	{'','','2',' '},
	{'','','3',' '},
	{'','','4',' '},
	{'','','6',' '},
	{'','','7',' '},
	{'','','2','1'},
	{'','','2','2'},
	{'','','2','3'},
	{'','','2','4'},
	{'','','6',' '},
	{'','','7',' '},
	{'','','1','4'},
	{'','','1','3'},
	{'','','1','0'},
	{'','','6',' '},
	{'','','7',' '},
	{'','','7',' '},
	{'','','5',' '},
	{'','','1','8'},
	{'','','2',' '},
	{'','','5',' '},
	{'','','7',' '},
	{'','','1','7'},
	{'','','3',' '},
	{'','','1','1'},
	{'','','1','2'},
	{'','','1','3'},
	{'','','1','5'},
	{'','','1','6'},
	{'','','8',' '},
	{'','','9',' '},
	{'','','1',' '},
	{'','','3',' '},
	{'','','1',' '}
};

static const unsigned char SN74xx[102][4] PROGMEM ={
	{'0','0',' ',' '},
	{'0','1',' ',' '},
	{'0','2',' ',' '},
	{'0','4',' ',' '},
	{'0','5',' ',' '},
	{'0','6',' ',' '},
	{'0','7',' ',' '},
	{'0','8',' ',' '},
	{'1','0',' ',' '},
	{'1','2',' ',' '},
	{'1','3',' ',' '},
	{'1','4',' ',' '},
	{'1','6',' ',' '},
	{'1','7',' ',' '},
	{'2','0',' ',' '},
	{'2','2',' ',' '},
	{'2','3',' ',' '},
	{'2','5',' ',' '},
	{'2','6',' ',' '},
	{'2','7',' ',' '},
	{'3','0',' ',' '},
	{'3','2',' ',' '},
	{'3','7',' ',' '},
	{'3','8',' ',' '},
	{'4','0',' ',' '},
	{'4','5',' ',' '},
	{'5','0',' ',' '},
	{'5','3',' ',' '},
	{'5','5',' ',' '},
	{'6','0',' ',' '},
	{'7','2',' ',' '},
	{'7','4',' ',' '},
	{'7','5',' ',' '},
	{'7','7',' ',' '},
	{'8','0',' ',' '},
	{'8','1',' ',' '},
	{'8','2',' ',' '},
	{'8','3',' ',' '},
	{'8','4',' ',' '},
	{'8','5',' ',' '},
	{'8','6',' ',' '},
	{'8','9',' ',' '},
	{'9','0',' ',' '},
	{'9','2',' ',' '},
	{'9','3',' ',' '},
	{'9','5',' ',' '},
	{'9','7',' ',' '},
	{'1','0','9',' '},
	{'1','2','1',' '},
	{'1','2','3',' '},
	{'1','2','5',' '},
	{'1','3','2',' '},
	{'1','4','1',' '},
	{'1','4','5',' '},
	{'1','4','8',' '},
	{'1','5','0',' '},
	{'1','5','1',' '},
	{'1','5','2',' '},
	{'1','5','3',' '},
	{'1','5','4',' '},
	{'1','5','5',' '},
	{'1','6','0',' '},
	{'1','7','0',' '},
	{'1','7','0',' '},
	{'1','7','2',' '},
	{'1','7','3',' '},
	{'1','7','5',' '},
	{'1','8','0',' '},
	{'1','8','1',' '},
	{'1','8','2',' '},
	{'1','8','4',' '},
	{'1','8','5',' '},
	{'1','8','7',' '},
	{'1','8','7',' '},
	{'1','8','7',' '},
	{'1','8','7',' '},
	{'1','9','2',' '},
	{'1','9','3',' '},
	{'1','9','6',' '},
	{'1','9','8',' '},
	{'3','6','5',' '},
	{'3','6','6',' '},
	{'3','6','8',' '},
	{'4','5','0',' '},
	{'4','5','1',' '},
	{'4','5','2',' '},
	{'4','5','3',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
	{'','/','',' '},
};


const unsigned char GOST_X[7] PROGMEM = {'','','','','','',''};

const unsigned char GOST_A[2] PROGMEM = {'',''};
const unsigned char GOST_I[6] PROGMEM = {'','','','','',''};
const unsigned char GOST_K[1] PROGMEM = {''};
const unsigned char GOST_L[8] PROGMEM = {'','','','','','','',''};
const unsigned char GOST_P[2] PROGMEM = {'',''};
const unsigned char GOST_R[3] PROGMEM = {'','',''};
const unsigned char GOST_T[3] PROGMEM = {'','',''};

const unsigned char GOST_AG[2] PROGMEM = {'1','3'};
const unsigned char GOST_AP[1] PROGMEM = {'1'};
const unsigned char GOST_IV[1] PROGMEM = {'1'};
const unsigned char GOST_ID[5] PROGMEM = {'1','3','4','8','9'};
const unsigned char GOST_ID1[6] PROGMEM = {' ','0','1','2','3','5'};
const unsigned char GOST_IE[8] PROGMEM = {'1','2','4','5','6','7','8','9'};
const unsigned char GOST_IE1[2] PROGMEM = {' ','4'};
const unsigned char GOST_IM[3] PROGMEM = {'1','2','3'};
const unsigned char GOST_IP[3] PROGMEM = {'2','3','4'};
const unsigned char GOST_IR[2] PROGMEM = {'1','3'};
const unsigned char GOST_IR1[4] PROGMEM = {' ','3','5','7'};
const unsigned char GOST_KP[4] PROGMEM = {'1','2','5','7'};
const unsigned char GOST_LA[7] PROGMEM = {'1','2','3','4','6','7','8'};
const unsigned char GOST_LA1[6] PROGMEM = {' ','0','1','2','3','8'};
const unsigned char GOST_LD[2] PROGMEM = {'1','3'};
const unsigned char GOST_LE[6] PROGMEM = {'1','2','3','4','5','6'};
const unsigned char GOST_LI[2] PROGMEM = {'1','5'};
const unsigned char GOST_LL[2] PROGMEM = {'1','2'};
const unsigned char GOST_LN[5] PROGMEM = {'1','2','3','5','6'};
const unsigned char GOST_LP[6] PROGMEM = {'1','4','5','7','8','9'};
const unsigned char GOST_LP1[2] PROGMEM = {'0','1'};
const unsigned char GOST_LR[2] PROGMEM = {'1','3'};
const unsigned char GOST_PP[1] PROGMEM = {'5'};
const unsigned char GOST_PR[2] PROGMEM = {'6','7'};
const unsigned char GOST_RE[2] PROGMEM = {'2','3'};
const unsigned char GOST_RE2[4] PROGMEM = {'1','2','3','4'};
const unsigned char GOST_RP[1] PROGMEM = {'3'};
const unsigned char GOST_RU[4] PROGMEM = {'1','2','5','7'};
const unsigned char GOST_TV[1] PROGMEM = {'1'};
const unsigned char GOST_TV1[2] PROGMEM = {' ','5'};
const unsigned char GOST_TL[3] PROGMEM = {'1','2','3'};
const unsigned char GOST_TM[4] PROGMEM = {'2','5','7','8'};


const unsigned char sup01[] PROGMEM = {4,8};
const unsigned char sup02[] PROGMEM = {7,14};
const unsigned char sup03[] PROGMEM = {8,16};
const unsigned char sup04[] PROGMEM = {12,5};
const unsigned char sup05[] PROGMEM = {10,5};
const unsigned char sup06[] PROGMEM = {11,4};


/*		+---------DIP16---------+
		|	+-----DIP14-----+	|		
		|	|	+-DIP8--+	|	|
B.7		1	|	|		|	|	16		A.7
B.6		2	1	|		|	14	15		A.6
B.5		3	2	|		|	13	14		A.5
B.4		4	3	|		|	12	13		A.4
B.3		5	4	1		8	11	12		A.3
B.2		6	5	2		7	10	11		A.2
B.1		7	6	3		6	9	10		A.1
B.0		8	7	4		5	8	9		A.0
		+---+---+-------+---+---+

{PORT B, PORT A, ...}
*/


const unsigned char dir01[] PROGMEM = {0b11010101,0b11101010};	//1(04), 2(05), 3(06), 4(-),  5(16), 7(1004), 10(1005), 9(07), 16(1034), 17(1035), 2(14)
const unsigned char dir02[] PROGMEM = {0b11010101,0b11101010}; //6(366), 10(365)
const unsigned char dir03[] PROGMEM = {0b11010101,0b11101010}; //11(367), 8(368), 11(367)
const unsigned char dir04[] PROGMEM = {0b11101101,0b11110110}; //3(00), 9(03), 11(26), 12(37), 13(38), 15(/), 21(1000), 23(1003), 1(08), 2(09), 8(1008), 1(32), 4(1032), 5(86), 3(132)
const unsigned char dir05[] PROGMEM = {0b11101101,0b11110110}; //8(125)
const unsigned char dir06[] PROGMEM = {0b10110111,0b11011011}; //8(01), 1(02), 5(28), 6(128), 10(1002), 11(33)
const unsigned char dir07[] PROGMEM = {0b11111101,0b11101110}; //4(10, 10(12), 24(1010), 4(27), 3(11), 4(15)
const unsigned char dir08[] PROGMEM = {0b11111101,0b11111110}; //1(20), 6(40), 7(22), 6(21), 1(13)
const unsigned char dir09[] PROGMEM = {0b11111101,0b11111110}; //3(25)
const unsigned char dir10[] PROGMEM = {0b01111101,0b10111110}; //2(23)
const unsigned char dir11[] PROGMEM = {0b11111001,0b11111111}; //7(260)
const unsigned char dir12[] PROGMEM = {0b11111111,0b11111110}; //2(30)
const unsigned char dir13[] PROGMEM = {0b11111111,0b11111110}; //19(134)
const unsigned char dir14[] PROGMEM = {0b11111101,0b11100110}; //1(50)
const unsigned char dir15[] PROGMEM = {0b11111111,0b11100110}; //3(53, 53).   53  6 .
const unsigned char dir16[] PROGMEM = {0b11111001,0b11111100}; //4(55).   LS55  5  9 .
//const unsigned char dir17[] PROGMEM = {0b11111111,0b11111101}; //9(64), 10(65)
const unsigned char dir18[] PROGMEM = {0b11111101,0b11111110}; //11(51).   51, 51  11  12 .
const unsigned char dir19[] PROGMEM = {0b11111101,0b11111111}; //13(LS54)
const unsigned char dir20[] PROGMEM = {0b11111111,0b11101101}; //1(60)
//const unsigned char dir21[] PROGMEM = {0b11111111,0b11111111}; //20(804), 8(805), 7(808), 3(832)
const unsigned char dir22[] PROGMEM = {0b11100111,0b11110011}; //13(266)
//const unsigned char dir23[] PROGMEM = {0b11111101,0b11111110}; //17(/)
const unsigned char dir24[] PROGMEM = {0b11111101,0b11111110}; //18(75452), 2(75453)
const unsigned char dir25[] PROGMEM = {0b11111011,0b11111011}; //5(75451)
const unsigned char dir26[] PROGMEM = {0b11111101,0b11101110}; //5333(/)
const unsigned char dir27[] PROGMEM = {0b11111101,0b11101110}; //15333(/)
const unsigned char dir28[] PROGMEM = {0b11100001,0b11100000}; //7(75450)
const unsigned char dir29[] PROGMEM = {0b11111111,0b11101111}; //3(/)
const unsigned char dir30[] PROGMEM = {0b11111001,0b10011110}; //1(148)
const unsigned char dir31[] PROGMEM = {0b11111001,0b11011110}; //3(147)
const unsigned char dir32[] PROGMEM = {0b11001001,0b11111111}; //1(141)
const unsigned char dir33[] PROGMEM = {0b11100001,0b11110000}; //4(155)
const unsigned char dir34[] PROGMEM = {0b11111101,0b10000000}; //7(138)
const unsigned char dir35[] PROGMEM = {0b00000001,0b11111000}; //10(145), 24(45)
const unsigned char dir36[] PROGMEM = {0b11111101,0b11111110}; //2(153), 12(253)
const unsigned char dir37[] PROGMEM = {0b11111101,0b11111111}; //5(152)
const unsigned char dir38[] PROGMEM = {0b11110011,0b11111111}; //7(151), 15(251)
const unsigned char dir39[] PROGMEM = {0b11101101,0b11110110}; //11(257), 14(258), 16(157)
const unsigned char dir40[] PROGMEM = {0b11111001,0b11111100}; //2(74)
const unsigned char dir41[] PROGMEM = {0b11111111,0b10011100}; //5(77)
const unsigned char dir42[] PROGMEM = {0b01111110,0b00011000}; //7(75)
const unsigned char dir43[] PROGMEM = {0b10011001,0b10011001}; //8(175)
const unsigned char dir44[] PROGMEM = {0b11111101,0b11111110}; //1(72)
const unsigned char dir45[] PROGMEM = {0b11111001,0b11111100}; //15(109)
const unsigned char dir46[] PROGMEM = {0b11110001,0b11111111}; //1(80)
const unsigned char dir47[] PROGMEM = {0b10111111,0b11101011}; //2(82)
const unsigned char dir48[] PROGMEM = {0b10111011,0b10101110}; //3(83)
const unsigned char dir49[] PROGMEM = {0b11111001,0b11111111}; //2(180)
const unsigned char dir50[] PROGMEM = {0b11111001,0b11111100}; //1(170), 32(170)
const unsigned char dir51[] PROGMEM = {0b11111011,0b11111111}; //1(/)
const unsigned char dir52[] PROGMEM = {0b11111111,0b11100100}; //2(90)
const unsigned char dir53[] PROGMEM = {0b11111111,0b11100100}; //4(92), 5(93)
const unsigned char dir54[] PROGMEM = {0b10011000,0b11100111}; //6(192), 7(193)
const unsigned char dir55[] PROGMEM = {0b11111111,0b11000011}; //1(95)



const unsigned char LA1_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10111110,0b11011111}; //1(20), 6(40), 7(22), 1(13)
const unsigned char LA1_in[] PROGMEM =  {2, 0b11111100,0b11111110,0b10111110,0b11011111}; //1(20), 6(40), 7(22), 1(13)
const unsigned char LA2_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10111110,0b11111111}; //2(30)
const unsigned char LA2_in[] PROGMEM =  {2, 0b11111110,0b11111110,0b10111110,0b11111111}; //2(30)
const unsigned char LA3_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10110110,0b11011011}; //3(00), 11(26), 12(37), 13(38), 3(132)
const unsigned char LA3_in[] PROGMEM =  {2, 0b11101100,0b11110110,0b10110110,0b11011011}; //3(00), 11(26), 12(37), 13(38), 3(132)
const unsigned char LA4_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10101110,0b11110111}; //4(10, 10(12)
const unsigned char LA4_in[] PROGMEM =  {2, 0b11111100,0b11101110,0b10101110,0b11110111}; //4(10, 10(12)
const unsigned char LA8_out[] PROGMEM = {2, 0b11111110,0b11111111,0b11011010,0b11011011}; //8(01)
const unsigned char LA8_in[] PROGMEM =  {2, 0b10110110,0b11011011,0b11011010,0b11011011}; //8(01)
const unsigned char LA18_out[] PROGMEM ={2, 0b11111110,0b11111111,0b11110110,0b11111011}; //18(75452)
const unsigned char LA18_in[] PROGMEM = {2, 0b11111100,0b11111110,0b11110100,0b11111010}; //18(75452)
const unsigned char LI1_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10110110,0b11011011}; //1(08), 2(09), 8(1008)
const unsigned char LI1_in[] PROGMEM =  {2, 0b11111110,0b11111111,0b10100100,0b11010010}; //1(08), 2(09), 8(1008)
const unsigned char LI3_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10101110,0b11110111}; //3(11), 4(15)
const unsigned char LI3_in[] PROGMEM =  {2, 0b11111110,0b11111111,0b10101100,0b11100110}; //3(11), 4(15)
const unsigned char LI5_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10111110,0b11011111}; //5(21)
const unsigned char LI5_in[] PROGMEM =  {2, 0b11111110,0b11111111,0b10111010,0b11011011}; //5(21)
const unsigned char LI6_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10111110,0b11011111}; //6(21)
const unsigned char LI6_in[] PROGMEM =  {2, 0b11111110,0b11111111,0b11111110,0b11111111}; //6(21)
const unsigned char LL1_out[] PROGMEM = {2, 0b10010010,0b11001001,0b10110110,0b11011011}; //1(32), 4(1032)
const unsigned char LL1_in[] PROGMEM =  {2, 0b10000000,0b11000000,0b10110110,0b11011011}; //1(32), 4(1032)
const unsigned char LL2_out[] PROGMEM = {2, 0b11110010,0b11111001,0b11111010,0b11111101}; //2(75453)
const unsigned char LL2_in[] PROGMEM =  {2, 0b11110000,0b11111000,0b11111010,0b11111101}; //2(75453)
const unsigned char LE1_out[] PROGMEM = {2, 0b11001000,0b11100100,0b11101100,0b11110110}; //1(02), 5(28), 6(128), 10(1002), 11(33)
const unsigned char LE1_in[] PROGMEM =  {2, 0b11001000,0b11100100,0b10100100,0b11010010}; //1(02), 5(28), 6(128), 10(1002), 11(33)
const unsigned char LE2_out[] PROGMEM = {3, 0b00000010,0b10000001,0b00010010,0b10001001,0b01010010,0b10101001}; //2(23)
const unsigned char LE2_in[] PROGMEM =  {3, 0b00000010,0b10000001,0b00010010,0b10001001,0b01010000,0b10101000}; //2(23)
const unsigned char LE3_out[] PROGMEM = {3, 0b10000010,0b11000001,0b10010010,0b11001001,0b11010010,0b11101001}; //3(25)
const unsigned char LE3_in[] PROGMEM =  {3, 0b10000010,0b11000001,0b10010010,0b11001001,0b11010000,0b11101000}; //3(25)
const unsigned char LE4_out[] PROGMEM = {2, 0b10000010,0b11010001,0b11010010,0b11011001}; //4(27)
const unsigned char LE4_in[] PROGMEM =  {2, 0b10000010,0b11010001,0b11010000,0b11001000}; //4(27)
const unsigned char LP5_out[] PROGMEM = {3, 0b11111110,0b11111111,0b10110110,0b11011011,0b10010010,0b11001001}; //5(86)
const unsigned char LP5_in[] PROGMEM =  {3, 0b11101100,0b11110110,0b10110110,0b11011011,0b10000000,0b11000000}; //5(86)
const unsigned char LP7_out[] PROGMEM = {2, 0b11110000,0b11110000,0b10110000,0b11110000}; //7(450)
const unsigned char LP7_in[] PROGMEM =  {2, 0b11100000,0b11100000,0b10110000,0b11110000}; //7(450)
const unsigned char LP8_out[] PROGMEM = {2, 0b10110110,0b11011011,0b10010010,0b11001001}; //8(125)
const unsigned char LP8_in[] PROGMEM =  {2, 0b10100100,0b11010010,0b10010010,0b11001001}; //8(125)
const unsigned char LP10_out[] PROGMEM ={2, 0b01111110,0b10111111,0b00101010,0b10010101}; //10(365), 11(367)
const unsigned char LP10_in[] PROGMEM = {2, 0b01111110,0b10111111,0b00000000,0b10000000}; //10(365), 11(367)
const unsigned char LR1_out[] PROGMEM = {2, 0b11111110,0b11100111,0b11010110,0b11000101}; //1(50)
const unsigned char LR1_in[] PROGMEM =  {2, 0b11111100,0b11100110,0b11010110,0b11000101}; //1(50)
const unsigned char LR3_out[] PROGMEM = {2, 0b11111110,0b11100111,0b11010100,0b11000101}; //3(53, 53).   53  6 .
const unsigned char LR3_in[] PROGMEM =  {2, 0b11111110,0b11100110,0b11010100,0b11000101}; //3(53, 53).   53  6 .
const unsigned char LR4_out[] PROGMEM = {2, 0b11111000,0b11111101,0b10111000,0b11111001}; //4(55).   LS55  5  9 .
const unsigned char LR4_in[] PROGMEM =  {2, 0b11111000,0b11111100,0b10111000,0b11111001}; //4(55).   LS55  5  9 .
const unsigned char LR11_out[] PROGMEM ={2, 0b11111110,0b11111111,0b10010110,0b11111101}; //11(51).   51, 51  11  12 .
const unsigned char LR11_in[] PROGMEM = {2, 0b11111100,0b11111110,0b10010110,0b11111101}; //11(51).   51, 51  11  12 .
const unsigned char LR13_out[] PROGMEM ={2, 0b11111110,0b11111111,0b10101110,0b11101101}; //13(LS54)
const unsigned char LR13_in[] PROGMEM = {2, 0b11111100,0b11111111,0b10101110,0b11101101}; //13(LS54)
const unsigned char LD1_out[] PROGMEM = {2, 0b11111110,0b11110011,0b11110110,0b11010011}; //1(60)
const unsigned char LD1_in[] PROGMEM =  {2, 0b11111110,0b11100001,0b10110110,0b11010011}; //1(60)
const unsigned char LD3_out[] PROGMEM = {2, 0b11111110,0b11110111,0b11111110,0b11010111}; //3(/)
const unsigned char LD3_in[] PROGMEM =  {2, 0b11111110,0b11100111,0b11111110,0b11010111}; //3(/)
const unsigned char LN1_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10101010,0b11010101}; //1(04), 2(05), 3(06),  5(16), 8(368), 10(1005), 2(14)
const unsigned char LN1_in[] PROGMEM =  {2, 0b11010100,0b11101010,0b10101010,0b11010101}; //1(04), 2(05), 3(06),  5(16), 8(368), 10(1005), 2(14)
const unsigned char LN4_out[] PROGMEM = {2, 0b11111110,0b11111111,0b10101010,0b11010101}; //4(-), 10(1005), 4(17),9(07), 16(1034), 17(1035)
const unsigned char LN4_in[] PROGMEM =  {2, 0b11111110,0b11111111,0b10000000,0b11000000}; //4(-), 10(1005), 4(17),9(07), 16(1034), 17(1035)
const unsigned char LN6_out[] PROGMEM = {2, 0b01111110,0b10111111,0b00101010,0b10010101}; //6(366), 7(1004)
const unsigned char LN6_in[] PROGMEM =  {2, 0b01010100,0b10101010,0b00101010,0b10010101}; //6(366), 7(1004)
const unsigned char IV1_out[] PROGMEM = {2, 0b11110110,0b11111101,0b11100110,0b11111101}; //1(148)
const unsigned char IV1_in[] PROGMEM =  {2, 0b11110110,0b11011101,0b11100000,0b11111100}; //1(148)
const unsigned char IV3_out[] PROGMEM = {2, 0b11111110,0b11111101,0b11011110,0b11111111}; //3(147)
const unsigned char IV3_in[] PROGMEM =  {2, 0b11111110,0b11011100,0b11011000,0b11111111}; //3(147)
const unsigned char ID1_out[] PROGMEM = {2, 0b11001001,0b11110111,0b11111001,0b11110111}; //1(141)
const unsigned char ID1_in[] PROGMEM =  {2, 0b11001001,0b01110111,0b10111001,0b11110111}; //1(141)
const unsigned char ID4_out[] PROGMEM = {2, 0b10011110,0b10001111,0b10011110,0b11111111}; //4(155)
const unsigned char ID4_in[] PROGMEM =  {2, 0b10011100,0b10001110,0b10001110,0b11110111}; //4(155)
const unsigned char ID7_out[] PROGMEM = {2, 0b00000110,0b11111111,0b11100110,0b11111111}; //7(138)
const unsigned char ID7_in[] PROGMEM =  {2, 0b00000110,0b10111111,0b11100100,0b11111111}; //7(138)
const unsigned char ID10_out[] PROGMEM ={2, 0b11111110,0b10001111,0b11111110,0b11001111}; //10(145), 24(45)
const unsigned char ID10_in[] PROGMEM = {2, 0b01111110,0b11111111,0b11111110,0b11001011}; //10(145), 24(45)
const unsigned char KP2_out[] PROGMEM = {2, 0b00111010,0b10011101,0b00111110,0b10011111}; //2(153), 12(253)
const unsigned char KP2_in[] PROGMEM =  {2, 0b00111000,0b10011100,0b00111110,0b10011111}; //2(153), 12(253)
const unsigned char KP5_out[] PROGMEM = {2, 0b11111110,0b11111000,0b11111010,0b11111000}; //5(152)
const unsigned char KP5_in[] PROGMEM =  {2, 0b11111110,0b11111000,0b11111000,0b11111000}; //5(152)
const unsigned char KP7_out[] PROGMEM = {2, 0b11111100,0b11111000,0b11101100,0b11111000}; //7(151), 15(251)
const unsigned char KP7_in[] PROGMEM =  {2, 0b11111000,0b11111000,0b11100100,0b11111000}; //7(151), 15(251)
const unsigned char KP11_out[] PROGMEM ={2, 0b01111110,0b10111111,0b00110110,0b10011011}; //11(257), 16(157)
const unsigned char KP11_in[] PROGMEM = {2, 0b01111110,0b10111111,0b01100100,0b10110010}; //11(257), 16(157)
const unsigned char KP14_out[] PROGMEM ={2, 0b01111110,0b10111111,0b00110110,0b10011011}; //14(258)
const unsigned char KP14_in[] PROGMEM = {2, 0b01101100,0b10110110,0b00110110,0b10011011}; //14(258)
const unsigned char TM2_out[] PROGMEM = {2, 0b10111110,0b11011111,0b11110110,0b11111011}; //2(74)
const unsigned char TM2_in[] PROGMEM =  {2, 0b10111010,0b11011101,0b11110100,0b11111010}; //2(74)
const unsigned char TM5_out[] PROGMEM = {2, 0b10111011,0b11110111,0b11011101,0b11110111}; //5(77)
const unsigned char TM5_in[] PROGMEM =  {2, 0b10111011,0b10110101,0b11011101,0b11010110}; //5(77)
const unsigned char TM7_out[] PROGMEM = {2, 0b10111011,0b11110111,0b11011101,0b11110111}; //7(77)
const unsigned char TM7_in[] PROGMEM =  {2, 0b10111011,0b01010110,0b01011101,0b10110010}; //7(75)
const unsigned char TM8_out[] PROGMEM = {3, 0b01101110,0b11110110,0b11101110,0b11110110,0b11101110,0b11110111}; //8(175)
const unsigned char TM8_in[] PROGMEM =  {3, 0b00101100,0b10110100,0b10101100,0b10110100,0b10101010,0b11010101}; //8(175)
const unsigned char TV1_out[] PROGMEM = {2, 0b11111110,0b11011111,0b11011110,0b11111111}; //1(72)
const unsigned char TV1_in[] PROGMEM =  {2, 0b11111110,0b11011110,0b11011100,0b11111111}; //1(72)
const unsigned char TV15_out[] PROGMEM ={2, 0b01111110,0b10111111,0b11110110,0b11111010}; //15(109)
const unsigned char TV15_in[] PROGMEM = {2, 0b01111010,0b10111101,0b11110100,0b11111010}; //15(109)
const unsigned char IM1_out[] PROGMEM = {2, 0b11101110,0b11001100,0b11101110,0b11000011}; //1(80)
const unsigned char IM1_in[] PROGMEM =  {2, 0b11101010,0b11001100,0b11101100,0b11000011}; //1(80)
const unsigned char IM2_out[] PROGMEM = {2, 0b11001011,0b10010111,0b11111011,0b11110111}; //2(82)
const unsigned char IM2_in[] PROGMEM =  {2, 0b10001011,0b10000011,0b10111011,0b11110111}; //2(82)
const unsigned char IM3_out[] PROGMEM = {2, 0b11000101,0b11101101,0b11010111,0b01111001}; //3(83)
const unsigned char IM3_in[] PROGMEM =  {2, 0b10000101,0b10101101,0b11010011,0b01011000}; //3(83)
const unsigned char IP2_out[] PROGMEM = {2, 0b10010110,0b11000001,0b10010110,0b11000011}; //2(180)
const unsigned char IP2_in[] PROGMEM =  {2, 0b10010010,0b11000001,0b10010100,0b11000011}; //2(180)
const unsigned char RP1_out[] PROGMEM = {2, 0b01011110,0b11000111,0b11100110,0b11111011}; //1(170), 32(170)
const unsigned char RP1_in[] PROGMEM =  {2, 0b01011000,0b11000100,0b11100010,0b11111010}; //1(170), 32(170)
const unsigned char IE1_out[] PROGMEM = {20, 0b11111110,0b11111111,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100}; //1(/)
const unsigned char IE1_in[] PROGMEM =  {20, 0b11111110,0b11111111,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011110,0b11111100,0b10011110,0b11111111,0b10011100,0b11111100}; //1(/)
const unsigned char IE2_out[] PROGMEM = {2, 0b11111100,0b11111011,0b10011111,0b11111011}; //2(90)
const unsigned char IE2_in[] PROGMEM =  {2, 0b11111100,0b11100000,0b10011111,0b11111000}; //2(90)
const unsigned char IE4_out[] PROGMEM = {5, 0b11001100,0b11111011,0b11111111,0b11111011,0b11111111,0b10111011,0b11111111,0b11111011,0b11111111,0b10111011}; //4(92), 5(93)
const unsigned char IE4_in[] PROGMEM =  {5, 0b11001100,0b11100000,0b11111111,0b11100000,0b11111111,0b10100000,0b11111111,0b11100000,0b11111111,0b10110000}; //4(92), 5(93)
const unsigned char IE6_out[] PROGMEM = {2, 0b01111110,0b11111110,0b01111110,0b11011010}; //6(192), 7(193)
const unsigned char IE6_in[] PROGMEM =  {2, 0b00011000,0b11111110,0b00111100,0b11011010}; //6(192), 7(193)
const unsigned char IR1_out[] PROGMEM = {3, 0b11101010,0b11111100,0b11101010,0b11111110,0b11101010,0b11111100}; //1(95)
const unsigned char IR1_in[] PROGMEM =  {3, 0b11101010,0b11111100,0b11101010,0b11111110,0b11101010,0b11101000}; //1(95)


const unsigned char *xx_addr[] PROGMEM =  {&TM8_out[0],&TM8_in[0]};

//------------------------------------------------------------------------------


char gost_name[5];
char sn74_name[5];
unsigned char *xx_dir=0;
unsigned char *xx_out=0;
unsigned char *xx_in=0;

int test()
{
	unsigned char steps=0;
	unsigned char r=0;
	unsigned char i=0;
	unsigned char b=0;
	DDRB=pgm_read_byte(&xx_dir);
	DDRA=pgm_read_byte(&xx_dir+1);
	steps=pgm_read_byte(&xx_out);
	&xx_out++;
	&xx_in++;
	for (i=0;i<steps;i++)
	{
		PORTB=pgm_read_byte(&xx_out+i*2);
		PORTA=pgm_read_byte(&xx_out+i*2+1);
		if ((PINB != pgm_read_byte(&xx_in+i*2)) || (PINA != pgm_read_byte(&xx_in+i*2+1)))
		{
			b=1;
			break;
		}
	}
	PORTA=0b00111111;
	PORTB=0b11111110;
	return b;
}


int SN74_GOST()
{
	unsigned char i=0;
	unsigned char t=0;
//	unsigned char c=0;
	gost_name[0] = ' ';
	gost_name[1] = ' ';
	gost_name[2] = ' ';	
	gost_name[3] = ' ';
	gost_name[4] = 0;
	LCDstringXY (sn74_name, 0, 1);
	for(i=0;i<102;i++)
	{
		if (sn74_name[0] == pgm_read_byte(&SN74xx[i][0]))
		{
			if (sn74_name[1] == pgm_read_byte(&SN74xx[i][1]))
			{
				if (sn74_name[2] == pgm_read_byte(&SN74xx[i][2]))
				{
					if (sn74_name[3] == pgm_read_byte(&SN74xx[i][3]))
					{
						break;
					}
				}			
			}		
		}
	}
	LCDGotoXY (4,1);
	LCDsendChar('=');
	if (i<102)
	{
		gost_name[0] = pgm_read_byte(&GOSTxx[i][0]);
		gost_name[1] = pgm_read_byte(&GOSTxx[i][1]);
		gost_name[2] = pgm_read_byte(&GOSTxx[i][2]);
		gost_name[3] = pgm_read_byte(&GOSTxx[i][3]);
		LCDstringXY (gost_name, 5, 1);	
	}
	else
	{
		LCDstringXY ("- ", 4, 1);
	}
}


int GOST_SN74()
{
	unsigned char i=0;
	unsigned char t=0;
//	unsigned char c=0;
	sn74_name[0] = ' ';
	sn74_name[1] = ' ';
	sn74_name[2] = ' ';	
	sn74_name[3] = ' ';
	sn74_name[4] = 0;
	LCDstringXY (gost_name, 0, 1);
	for(i=0;i<102;i++)
	{
		if (gost_name[0] == pgm_read_byte(&GOSTxx[i][0]))
		{
			if (gost_name[1] == pgm_read_byte(&GOSTxx[i][1]))
			{
				if (gost_name[2] == pgm_read_byte(&GOSTxx[i][2]))
				{
					if (gost_name[3] == pgm_read_byte(&GOSTxx[i][3]))
					{
						sn74_name[0] = pgm_read_byte(&SN74xx[i][0]);
						sn74_name[1] = pgm_read_byte(&SN74xx[i][1]);
						sn74_name[2] = pgm_read_byte(&SN74xx[i][2]);
						sn74_name[3] = pgm_read_byte(&SN74xx[i][3]);
						break;
					}
				}			
			}		
		}
		}
	LCDGotoXY (4,1);
	LCDsendChar('=');
	LCDstringXY (sn74_name, 5, 1);	
}


int GOST(void)
{
	_delay_ms(100);
	LCDclr();
	LCDstringXY ("   ", 0, 0);
	LCDGotoXY(0, 0);
	LCDcursorOn();
	//LCDcursorOnBlink();
	gost_name[0] = ' ';
	gost_name[1] = ' ';
	gost_name[2] = ' ';	
	gost_name[3] = ' ';
	gost_name[4] = 0;
	unsigned char y=0;
	unsigned char t=0;
	unsigned char c=0;
	unsigned char max=6;
	unsigned char *FlashLoc = 0;
	FlashLoc=&GOST_X[0];
	while(1)
	{
		while(y == 0) y=get_key();
		switch (y)
		{
			case 1: //DOWN
				if (t == 0) t = max;
				else t--;
				break;
			case 2: //OK
				c++;
				LCDcursorRight(1);
				switch (c)
				{
					case 1:
						gost_name[0] = pgm_read_byte(FlashLoc+t);
						switch (t)	//'','','','','','',''
						{
							case 0:
								FlashLoc=&GOST_A[0];
								max = 1;
								break;
							case 1:
								FlashLoc=&GOST_I[0];
								max = 5;
								break;
							case 2:
								FlashLoc=&GOST_K[0];
								max = 0;
								break;
							case 3:
								FlashLoc=&GOST_L[0];
								max = 7;
								break;
							case 4:
								FlashLoc=&GOST_P[0];
								max = 1;
								break;
							case 5:
								FlashLoc=&GOST_R[0];
								max = 2;
								break;
							case 6:							
								FlashLoc=&GOST_T[0];
								max = 2;
						}
						break;
					case 2:
						gost_name[1] = pgm_read_byte(FlashLoc+t);
						switch (gost_name[0])	//'','','','','','',''
						{
							case '':
								switch (t)
								{
									case 0:
										FlashLoc=&GOST_AG[0];
										max = 1;
										break;
									case 1:
										FlashLoc=&GOST_AP[0];
										max = 0;									
								}
								break;
							case '':
								switch (t)
								{
									case 0:
										FlashLoc=&GOST_IV[0];
										max = 0;
										break;
									case 1:
										FlashLoc=&GOST_ID[0];
										max = 4;			
										break;
									case 2:
										FlashLoc=&GOST_IE[0];
										max = 7;
										break;
									case 3:
										FlashLoc=&GOST_IM[0];
										max = 2;
										break;
									case 4:
										FlashLoc=&GOST_IP[0];
										max = 0;
										break;
									case 5:
										FlashLoc=&GOST_IR[0];
										max = 0;			
								}
								break;
							case '':
								FlashLoc=&GOST_KP[0];
								max = 3;
								break;
							case '':
								switch (t)
								{
									case 0:
										FlashLoc=&GOST_LA[0];
										max = 6;
										break;
									case 1:
										FlashLoc=&GOST_LD[0];
										max = 1;			
										break;
									case 2:
										FlashLoc=&GOST_LE[0];
										max = 5;
										break;
									case 3:
										FlashLoc=&GOST_LI[0];
										max = 1;
										break;
									case 4:
										FlashLoc=&GOST_LL[0];
										max = 1;
										break;
									case 5:
										FlashLoc=&GOST_LN[0];
										max = 4;			
										break;
									case 6:
										FlashLoc=&GOST_LP[0];
										max = 5;			
										break;
									case 7:
										FlashLoc=&GOST_LR[0];
										max = 1;			
										
								}
								break;
							case '':
								switch (t)
								{
									case 0:
										FlashLoc=&GOST_PP[0];
										max = 0;
										break;
									case 1:
										FlashLoc=&GOST_PR[0];
										max = 1;									
								}
								break;
							case '':
								switch (t)
								{
									case 0:
										FlashLoc=&GOST_RE[0];
										max = 1;
										break;
									case 1:
										FlashLoc=&GOST_RP[0];
										max = 0;			
										break;
									case 2:
										FlashLoc=&GOST_RU[0];
										max = 3;										
								}
								break;
							case '':							
								switch (t)
								{
									case 0:
										FlashLoc=&GOST_TV[0];
										max = 0;
										break;
									case 1:
										FlashLoc=&GOST_TL[0];
										max = 2;			
										break;
									case 2:
										FlashLoc=&GOST_TM[0];
										max = 3;										
								}
						}
						break;	
					case 3:
						gost_name[2] = pgm_read_byte(FlashLoc+t);
						if (t==0)
						{
							if (((gost_name[0] =='') && (gost_name[1] == ''))||((gost_name[0] =='') && ((gost_name[1] == '')||(gost_name[1] == '')||(gost_name[1] == '')))||((gost_name[0] =='') && ((gost_name[1] == '')||(gost_name[1] == '')))||((gost_name[0] =='') && (gost_name[1] == '')))
							{
								switch (gost_name[1])
								{
									case '':	//
										FlashLoc=&GOST_ID1[0];
										max = 5;
										break;
									case '':	//
										FlashLoc=&GOST_IR1[0];
										max = 3;
										break;
									case '':	//  
										if (gost_name[0] =='') 
										{
											FlashLoc=&GOST_RE2[0];
											max = 3;
										}
										else
										{
											FlashLoc=&GOST_IE1[0];
											max = 1;
										}
										break;
									case '':	//
										FlashLoc=&GOST_LA1[0];
										max = 5;
										break;
									case '':	//
										FlashLoc=&GOST_LP1[0];
										max = 1;
										break;
									case '':	//
										FlashLoc=&GOST_TV1[0];
										max = 1;
								}
								break;
							}
						}
						gost_name[3] = ' ';
						GOST_SN74();
						c=0;
						max=6;
						FlashLoc=&GOST_X[0];
						LCDstringXY ("   ", 0, 0);
						LCDGotoXY(0, 0);
						break;
					case 4:
						gost_name[3] = pgm_read_byte(FlashLoc+t);
						GOST_SN74();
						c=0;
						LCDstringXY ("   ", 0, 0);
						max=6;
						FlashLoc=&GOST_X[0];
						LCDGotoXY(0, 0);						
				}
				t = 0;
				break;
			case 4: //UP
				if (t == max) t=0;
				else t++;
		}
		LCDsendChar(pgm_read_byte(FlashLoc+t));
		LCDcursorLeft(1);	 
		y=0;
	}

}


int SN74(void)
{
_delay_ms(100);
LCDclr();
LCDstringXY ("74    ", 0, 0);
LCDGotoXY(2, 0);
LCDcursorOn();
sn74_name[0] = ' ';
sn74_name[1] = ' ';
sn74_name[2] = ' ';	
sn74_name[3] = ' ';
sn74_name[4] = 0;
int y=0;
int t=32;
int c=0;
	while(1)
	{ 
		while(y == 0) y=get_key();
		switch (y)
		{
			case 1: //DOWN
				switch (t) 
				{
					case 32:
						t=57;
						break;
					case 48:
						t=32;
						break;
					default:
						t--;
				}
				LCDsendChar(t);
				LCDcursorLeft(1);				
				break;
			case 2: //OK
				sn74_name[c] = t;
				c++;
				LCDcursorRight(1);
				if ((c==4) || (t == 32))
				{
					SN74_GOST();
					sn74_name[2] = ' ';	
					sn74_name[3] = ' ';
					LCDstringXY ("74    ", 0, 0);
					LCDGotoXY(2, 0);
					c=0;
				}
				t=32;
				break;
			case 4: //UP
				switch (t)
				{
					case 32:
						t=48;
						break;
					case 57:
						t=32;
						break;
					default:
						t++;
				}
				LCDsendChar(t);
				LCDcursorLeft(1);
		}
		y=0;
	}
}


int main (void) 
{

	int y=0;
	int t=0;
	int c=0;
	init_kb();
	LCDinit();
	LCDclr();
	LCDGotoXY(0, 0);
	LCDstringXY (">", 0, 0);
	LCDstringXY	(" 74xx", 0, 1);
	while(1)
	{ 
		while(y == 0) y=get_key();
		switch (y)
		{
			case 1: //DOWN
				if (t==1) break;
				t++;
				LCDstringXY	(" ", 0, 0);
				LCDstringXY	(">", 0, 1);
				c=1;
				break;
			case 2: //OK
				switch (c)
				{
					case 0:
						GOST();
					case 1:
						SN74();
				}
				break;
			case 4: //UP
				if (t==0) break;
				t--;
				LCDstringXY	(">", 0, 0);
				LCDstringXY	(" ", 0, 1);
				c=0;
		}
		y=0;
	}

}
