//**********************************************************************************************************************
//*  файл vga_60_sync_tb.v из проекта "Meteor Graphics"
//*  тестовый модуль для модуля vga_60_sync.v
//*  (C) 2015 Вадим Сабиржанов
//*  150807-02
//**********************************************************************************************************************
//`timescale 10ns / 1ns

module vga_60_sync_tb;

reg reset, clk;               // сигнал сброса для тестбенча, частота FPGA 126 МГц

wire [2:0]p_cnt;              // счетчик-делитель для получения pixel clock VGA (126 / 5 = 25,2 МГц)
wire [9:0]h_cnt;              // счетчик по-горизонтали (пикселов в строке)
wire [9:0]v_cnt;              // счетчик по-вертикали (строк в кадре)

wire ssi;                     // строчные синхроимпульсы 
wire sgi;                     // строчные гасящие импульсы

wire ksi;                     // кадровые синхроимпульсы
wire kgi;                     // кадровые гасящие импульсы

vga_60_sync vga_60_sync_inst(
    reset,                    // сигнал сброса для тестбенча
    clk,                      // частота FPGA 126 МГц

    p_cnt [2:0],              // счетчик-делитель для получения pixel clock VGA (126 / 5 = 25,2 МГц)
    h_cnt [9:0],              // счетчик по-горизонтали (пикселов в строке)
    v_cnt [9:0],              // счетчик по-вертикали (строк в кадре)

    ssi,                      // строчные синхроимпульсы 
    sgi,                      // строчные гасящие импульсы

    ksi,                      // кадровые синхроимпульсы
    kgi                       // кадровые гасящие импульсы
	);

always
    #5 clk = ~clk;

initial
begin
    clk = 0;
    reset = 1'b1;
    #1;
    reset = 1'b0;
end

initial
begin
	#50000000 $finish;
end

initial
begin
    $dumpfile("out.vcd");
    $dumpvars(0,vga_60_sync_tb);
end
    
endmodule    
