library IEEE; 
use IEEE.std_logic_1164.all; 
use IEEE.numeric_std.ALL;  

entity top_zed is                    
	port(
    JA4 : in std_logic;
    JA3 : in std_logic;
    LD : out std_logic_vector(7 downto 0);
    SW : in std_logic_vector(7 downto 0);
    BTNC : in std_logic;
    BTND : in std_logic;
    BTNL : in std_logic;
    BTNU : in std_logic;
    BTNR : in std_logic;
    VGA_HS : out std_logic;
    VGA_VS : out std_logic;
    VGA_R : out std_logic_vector(4 downto 1);
    VGA_G : out std_logic_vector(4 downto 1);
    VGA_B : out std_logic_vector(4 downto 1);

   AC_ADR0  : out   STD_LOGIC;
   AC_ADR1  : out   STD_LOGIC;
   AC_GPIO0 : out   STD_LOGIC;  -- I2S MISO
   AC_GPIO1 : in    STD_LOGIC;  -- I2S MOSI
   AC_GPIO2 : in    STD_LOGIC;  -- I2S_bclk
   AC_GPIO3 : in    STD_LOGIC;  -- I2S_LR
   AC_MCLK  : out   STD_LOGIC;
   AC_SCK   : out   STD_LOGIC;
   AC_SDA   : inout STD_LOGIC;

    GCLK : in std_logic
    );
end     entity top_zed;

architecture top_zed_arch of top_zed is

component zynq_design_wrapper is
  port (
    DDR_addr : inout STD_LOGIC_VECTOR ( 14 downto 0 );
    DDR_ba : inout STD_LOGIC_VECTOR ( 2 downto 0 );
    DDR_cas_n : inout STD_LOGIC;
    DDR_ck_n : inout STD_LOGIC;
    DDR_ck_p : inout STD_LOGIC;
    DDR_cke : inout STD_LOGIC;
    DDR_cs_n : inout STD_LOGIC;
    DDR_dm : inout STD_LOGIC_VECTOR ( 3 downto 0 );
    DDR_dq : inout STD_LOGIC_VECTOR ( 31 downto 0 );
    DDR_dqs_n : inout STD_LOGIC_VECTOR ( 3 downto 0 );
    DDR_dqs_p : inout STD_LOGIC_VECTOR ( 3 downto 0 );
    DDR_odt : inout STD_LOGIC;
    DDR_ras_n : inout STD_LOGIC;
    DDR_reset_n : inout STD_LOGIC;
    DDR_we_n : inout STD_LOGIC;
    FIXED_IO_ddr_vrn : inout STD_LOGIC;
    FIXED_IO_ddr_vrp : inout STD_LOGIC;
    FIXED_IO_mio : inout STD_LOGIC_VECTOR ( 53 downto 0 );
    FIXED_IO_ps_clk : inout STD_LOGIC;
    FIXED_IO_ps_porb : inout STD_LOGIC;
    FIXED_IO_ps_srstb : inout STD_LOGIC
  );
end component zynq_design_wrapper;

component b2m_de1 is port(
	clk50mhz : in std_logic;
	KEY : in std_logic_vector(3 downto 0);
	LEDr : out std_logic_vector(9 downto 0);
	LEDg : out std_logic_vector(7 downto 0);
	SW : in std_logic_vector(9 downto 0);

	HEX0 : out std_logic_vector(6 downto 0);
	HEX1 : out std_logic_vector(6 downto 0);
	HEX2 : out std_logic_vector(6 downto 0);
	HEX3 : out std_logic_vector(6 downto 0);

	SRAM_DQ : inout std_logic_vector(15 downto 0);--				//	SRAM Data bus 16 Bits
	SRAM_ADDR : out std_logic_vector(17 downto 0);--				//	SRAM Address bus 18 Bits
	SRAM_UB_N : out std_logic;--				//	SRAM High-byte Data Mask 
	SRAM_LB_N : out std_logic;--				//	SRAM Low-byte Data Mask 
	SRAM_WE_N : out std_logic;--				//	SRAM Write Enable
	SRAM_CE_N : out std_logic;--				//	SRAM Chip Enable
	SRAM_OE_N : out std_logic;--				//	SRAM Output Enable

--	DRAM_DQ : inout std_logic_vector(15 downto 0);--				//	SDRAM Data bus 16 Bits
--	DRAM_ADDR : out std_logic_vector(11 downto 0);--				//	SDRAM Address bus 12 Bits
--	DRAM_LDQM : out std_logic;--				//	SDRAM Low-byte Data Mask 
--	DRAM_UDQM : out std_logic;--				//	SDRAM High-byte Data Mask
--	DRAM_WE_N : out std_logic;--				//	SDRAM Write Enable
--	DRAM_CAS_N : out std_logic;--				//	SDRAM Column Address Strobe
--	DRAM_RAS_N : out std_logic;--				//	SDRAM Row Address Strobe
--	DRAM_CS_N : out std_logic;--				//	SDRAM Chip Select
--	DRAM_BA_0 : out std_logic;--				//	SDRAM Bank Address 0
--	DRAM_BA_1 : out std_logic;--				//	SDRAM Bank Address 0
--	DRAM_CLK : out std_logic;--				//	SDRAM Clock
--	DRAM_CKE : out std_logic;--				//	SDRAM Clock Enable

	VGA_HS : out std_logic;--
	VGA_VS : out std_logic;--
	VGA_R : out std_logic_vector(3 downto 0);--
	VGA_G : out std_logic_vector(3 downto 0);--
	VGA_B : out std_logic_vector(3 downto 0);--

	I2C_SDAT : inout std_logic;--				//	I2C Data
	I2C_SCLK : out std_logic;--				//	I2C Clock

	AUD_BCLK : inout std_logic;--
	AUD_DACDAT : out std_logic;--
	AUD_DACLRCK : out std_logic;--
	AUD_XCK : out std_logic;--
	AUD_ADCLRCK : out std_logic;--			//	Audio CODEC ADC LR Clock
	AUD_ADCDAT : in std_logic;--				//	Audio CODEC ADC Data

	PS2_CLK : in std_logic;--
	PS2_DAT : in std_logic;--

--	////////////////////	USB JTAG link	////////////////////////////
	TDI : in std_logic;--					// CPLD -> FPGA (data in)
	TCK : in std_logic;--					// CPLD -> FPGA (clk)
	TCS : in std_logic;--					// CPLD -> FPGA (CS)
	TDO : out std_logic;--					// FPGA -> CPLD (data out)

	SD_DAT : in std_logic;--				//	SD Card Data 			(MISO)
	SD_DAT3 : out std_logic;--				//	SD Card Data 3 			(CSn)
	SD_CMD : out std_logic;--					//	SD Card Command Signal	(MOSI)
	SD_CLK : out std_logic;--					//	SD Card Clock			(SCK)

	UART_TXD : out std_logic;--
	UART_RXD : in std_logic;--

	tape_in: in std_logic;--
	tape_out : out std_logic;--
	beep_out : out std_logic;--
	
	GPIO_0 : out std_logic_vector(12 downto 0);--
	GPIO_1 : out std_logic_vector(35 downto 0)-- 
);
end component b2m_de1;

component gclk_100_50 is 
 port (
clk_in1 : in std_logic;
         clk_out1 : out std_logic;
         clk_out2 : out std_logic;
         clk_out3 : out std_logic;
  reset : in std_logic;
  locked : out std_logic
 );
 end component gclk_100_50;
 
component ram_64k_16 IS
   PORT (
     clka : IN STD_LOGIC;
     wea : IN STD_LOGIC_VECTOR(1 DOWNTO 0);
     addra : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
     dina : IN STD_LOGIC_VECTOR(15 DOWNTO 0);
     douta : OUT STD_LOGIC_VECTOR(15 DOWNTO 0)
   );
 END component ram_64k_16;

          signal CLK_50MHz : std_logic;
          signal CLK_50MHz_ram : std_logic;

          signal CLK_14MHz : std_logic;
          signal CLK_14MHz_ram : std_logic;
          signal CLK_100MHz : std_logic;
			 
		-- TAPE
      signal TAPE_IN_sig            : std_logic;
      signal TAPE_OUT_sig        : std_logic;
          -- BEEP
      signal BEEP_OUT_sig        : std_logic;
       
          signal nRST : std_logic;
--//          -- PS2
--          signal PS2_KBCLK : std_logic;
--          signal PS2_KBDAT : std_logic;

          signal KEY_sig :  std_logic_vector(3 downto 0);
          signal LEDr_sig :  std_logic_vector(9 downto 0);
          signal LEDg_sig :  std_logic_vector(7 downto 0);
          signal SW_sig :  std_logic_vector(9 downto 0);

          signal SRAM_DQ_sig :  std_logic_vector(15 downto 0);--				//	SRAM Data bus 16 Bits
          signal SRAM_ADDR_sig :  std_logic_vector(17 downto 0);--				//	SRAM Address bus 18 Bits
          signal SRAM_UB_N_sig :  std_logic;--				//	SRAM High-byte Data Mask 
          signal SRAM_LB_N_sig :  std_logic;--				//	SRAM Low-byte Data Mask 
          signal SRAM_WE_N_sig :  std_logic;--				//	SRAM Write Enable
          signal SRAM_CE_N_sig :  std_logic;--				//	SRAM Chip Enable
          signal SRAM_OE_N_sig :  std_logic;--				//	SRAM Output Enable

          signal PS2_CLK_sig :  std_logic;--
          signal PS2_DAT_sig :  std_logic;--
           
    signal dina : std_logic_vector(15 downto 0);
    signal douta : std_logic_vector(15 downto 0);

    signal wea : STD_LOGIC_VECTOR(1 DOWNTO 0);

signal locked : std_logic;

component adau1761_test is
    Port ( clk_100  : in    STD_LOGIC;
           AC_ADR0  : out   STD_LOGIC;
           AC_ADR1  : out   STD_LOGIC;
           AC_GPIO0 : out   STD_LOGIC;  -- I2S MISO
           AC_GPIO1 : in    STD_LOGIC;  -- I2S MOSI
           AC_GPIO2 : in    STD_LOGIC;  -- I2S_bclk
           AC_GPIO3 : in    STD_LOGIC;  -- I2S_LR
           AC_MCLK  : out   STD_LOGIC;
           AC_SCK   : out   STD_LOGIC;
           AC_SDA   : inout STD_LOGIC;

           in_l       : in   STD_LOGIC_VECTOR(15 downto 0);
           in_r       : in   STD_LOGIC_VECTOR(15 downto 0);
           out_l      : out   STD_LOGIC_VECTOR(15 downto 0);
           out_r      : out   STD_LOGIC_VECTOR(15 downto 0);
           
           sw       : in    STD_LOGIC_VECTOR(7 downto 0)
           );
end component adau1761_test;

signal in_l       : STD_LOGIC_VECTOR(15 downto 0);
signal in_r       : STD_LOGIC_VECTOR(15 downto 0);
signal out_l      : STD_LOGIC_VECTOR(15 downto 0);
signal out_r      : STD_LOGIC_VECTOR(15 downto 0);
               
    begin
PS2_CLK_sig <= JA4;
PS2_DAT_sig <= JA3;

gclk_inst : gclk_100_50
 port map(
clk_in1 =>  GCLK,
         clk_out1 => CLK_50MHz,
         clk_out2 => CLK_50MHz_ram,
         clk_out3 => CLK_100MHz,
  reset => BTNC,
  locked => locked
 );

nRST <= locked;

--          signal SRAM_DQ_sig :  std_logic_vector(15 downto 0);--				//	SRAM Data bus 16 Bits
--          signal SRAM_ADDR_sig :  std_logic_vector(17 downto 0);--				//	SRAM Address bus 18 Bits
--          signal SRAM_UB_N_sig :  std_logic;--				//	SRAM High-byte Data Mask 
--          signal SRAM_LB_N_sig :  std_logic;--				//	SRAM Low-byte Data Mask 
--          signal SRAM_WE_N_sig :  std_logic;--				//	SRAM Write Enable
--          signal SRAM_CE_N_sig :  std_logic;--				//	SRAM Chip Enable
--          signal SRAM_OE_N_sig :  std_logic;--				//	SRAM Output Enable

--SRAM_D <= ~SRAM_nOE ?    douta[7:0]    : 8'bZZZZZZZZ;
SRAM_DQ_sig(15 downto 8) <=  douta(15 downto 8) when (SRAM_OE_N_sig='0' and SRAM_UB_N_sig='0') else (others=>'Z');
SRAM_DQ_sig(7 downto 0) <=  douta(7 downto 0) when (SRAM_OE_N_sig='0' and SRAM_LB_N_sig='0') else (others=>'Z');

--dina <= ~SRAM_nWE ? SRAM_D[7:0] : 8'bXXXXXXXX;
dina(15 downto 8) <= SRAM_DQ_sig(15 downto 8) when (SRAM_WE_N_sig='0' and SRAM_UB_N_sig='0') else (others=>'-');
dina(7 downto 0) <= SRAM_DQ_sig(7 downto 0) when (SRAM_WE_N_sig='0' and SRAM_LB_N_sig='0') else (others=>'-');

wea(1) <= (not (SRAM_WE_N_sig or SRAM_UB_N_sig));
wea(0) <= (not (SRAM_WE_N_sig or SRAM_LB_N_sig));

ssram : ram_64k_16
  PORT map(
    clka =>CLK_50MHz_ram,
    wea => wea,
    addra => SRAM_ADDR_sig(15 downto 0),
    dina => dina,
    douta => douta
  );

in_l <= X"7fff" when TAPE_OUT_sig = '1' else X"8000";
in_r <= X"7fff" when BEEP_OUT_sig = '1' else X"8000";

TAPE_IN_sig <= '1' when signed(out_l) > 0 else '0';

adau1761: adau1761_test
    Port map ( 
           clk_100  =>(CLK_100MHz),--: in    STD_LOGIC;
           AC_ADR0  =>(AC_ADR0),--: out   STD_LOGIC;
           AC_ADR1  =>(AC_ADR1),--: out   STD_LOGIC;
           AC_GPIO0 =>(AC_GPIO0),--: out   STD_LOGIC;  -- I2S MISO
           AC_GPIO1 =>(AC_GPIO1),--: in    STD_LOGIC;  -- I2S MOSI
           AC_GPIO2 =>(AC_GPIO2),--: in    STD_LOGIC;  -- I2S_bclk
           AC_GPIO3 =>(AC_GPIO3),--: in    STD_LOGIC;  -- I2S_LR
           AC_MCLK  =>(AC_MCLK),--: out   STD_LOGIC;
           AC_SCK   =>(AC_SCK),--: out   STD_LOGIC;
           AC_SDA   =>(AC_SDA),--: inout STD_LOGIC
           in_l     =>(in_l),--  : in   STD_LOGIC_VECTOR(15 downto 0);
           in_r     =>(in_r),--  : in   STD_LOGIC_VECTOR(15 downto 0);
           out_l    =>(out_l),--  : out   STD_LOGIC_VECTOR(15 downto 0);
           out_r    =>(out_r),--  : out   STD_LOGIC_VECTOR(15 downto 0);
           sw       =>(others=>'0')--: in    STD_LOGIC_VECTOR(7 downto 0)
           );

LD <= LEDg_sig;
SW_sig <= SW(7 downto 4) & "--" & SW(3 downto 0);
KEY_sig <= not (BTND & BTNL & BTNU & BTNR);

b2m: b2m_de1 port map(
	clk50mhz => CLK_50MHz,--: in std_logic;
	KEY => KEY_sig,--: in std_logic_vector(3 downto 0);
	LEDr => LEDr_sig,--: out std_logic_vector(9 downto 0);
	LEDg => LEDg_sig,--: out std_logic_vector(7 downto 0);
	SW => SW_sig,--: in std_logic_vector(9 downto 0);

	HEX0 => open,--: out std_logic_vector(6 downto 0);
	HEX1 => open,--: out std_logic_vector(6 downto 0);
	HEX2 => open,--: out std_logic_vector(6 downto 0);
	HEX3 => open,--: out std_logic_vector(6 downto 0);

	SRAM_DQ => SRAM_DQ_sig,--: inout std_logic_vector(15 downto 0);--				//	SRAM Data bus 16 Bits
	SRAM_ADDR => SRAM_ADDR_sig,--: out std_logic_vector(17 downto 0);--				//	SRAM Address bus 18 Bits
	SRAM_UB_N => SRAM_UB_N_sig,--: out std_logic;--				//	SRAM High-byte Data Mask 
	SRAM_LB_N => SRAM_LB_N_sig,--: out std_logic;--				//	SRAM Low-byte Data Mask 
	SRAM_WE_N => SRAM_WE_N_sig,--: out std_logic;--				//	SRAM Write Enable
	SRAM_CE_N => SRAM_CE_N_sig,--: out std_logic;--				//	SRAM Chip Enable
	SRAM_OE_N => SRAM_OE_N_sig,--: out std_logic;--				//	SRAM Output Enable

--	DRAM_DQ => open,--(others=>'-'),--: inout std_logic_vector(15 downto 0);--				//	SDRAM Data bus 16 Bits
--	DRAM_ADDR => open,--: out std_logic_vector(11 downto 0);--				//	SDRAM Address bus 12 Bits
--	DRAM_LDQM => open,--: out std_logic;--				//	SDRAM Low-byte Data Mask 
--	DRAM_UDQM => open,--: out std_logic;--				//	SDRAM High-byte Data Mask
--	DRAM_WE_N => open,--: out std_logic;--				//	SDRAM Write Enable
--	DRAM_CAS_N => open,--: out std_logic;--				//	SDRAM Column Address Strobe
--	DRAM_RAS_N => open,--: out std_logic;--				//	SDRAM Row Address Strobe
--	DRAM_CS_N => open,--: out std_logic;--				//	SDRAM Chip Select
--	DRAM_BA_0 => open,--: out std_logic;--				//	SDRAM Bank Address 0
--	DRAM_BA_1 => open,--: out std_logic;--				//	SDRAM Bank Address 0
--	DRAM_CLK => open,--: out std_logic;--				//	SDRAM Clock
--	DRAM_CKE => open,--: out std_logic;--				//	SDRAM Clock Enable

	VGA_HS => VGA_HS,--: out std_logic;--
	VGA_VS => VGA_VS,--: out std_logic;--
	VGA_R => VGA_R,--: out std_logic_vector(3 downto 0);--
	VGA_G => VGA_G,--: out std_logic_vector(3 downto 0);--
	VGA_B => VGA_B,--: out std_logic_vector(3 downto 0);--

	I2C_SDAT => open,--: inout std_logic;--				//	I2C Data
	I2C_SCLK => open,--: out std_logic;--				//	I2C Clock

	AUD_BCLK => open,--: inout std_logic;--
	AUD_DACDAT => open,--: out std_logic;--
	AUD_DACLRCK => open,--: out std_logic;--
	AUD_XCK => open,--: out std_logic;--
	AUD_ADCLRCK => open,--: out std_logic;--			//	Audio CODEC ADC LR Clock
	AUD_ADCDAT => '-',--: in std_logic;--				//	Audio CODEC ADC Data

	PS2_CLK => PS2_CLK_sig,--: in std_logic;--
	PS2_DAT => PS2_DAT_sig,--: in std_logic;--

--	////////////////////	USB JTAG link	////////////////////////////
	TDI => '-',--: in std_logic;--					// CPLD -> FPGA (data in)
	TCK => '-',--: in std_logic;--					// CPLD -> FPGA (clk)
	TCS => '-',--: in std_logic;--					// CPLD -> FPGA (CS)
	TDO => open,--: out std_logic;--					// FPGA -> CPLD (data out)

	SD_DAT => '-',--: in std_logic;--				//	SD Card Data 			(MISO)
	SD_DAT3 => open,--: out std_logic;--				//	SD Card Data 3 			(CSn)
	SD_CMD => open,--: out std_logic;--					//	SD Card Command Signal	(MOSI)
	SD_CLK => open,--: out std_logic;--					//	SD Card Clock			(SCK)

	UART_TXD => open,--: out std_logic;--
	UART_RXD => '-',--: in std_logic;--

    tape_in => TAPE_IN_sig,
    tape_out => TAPE_OUT_sig,
    beep_out => BEEP_OUT_sig,

	GPIO_0 => open,--: out std_logic_vector(12 downto 0);--
	GPIO_1 => open--: out std_logic_vector(35 downto 0)-- 
);

zynq: zynq_design_wrapper
  port map(
    DDR_addr => open,--: inout STD_LOGIC_VECTOR ( 14 downto 0 );
    DDR_ba => open,-- : inout STD_LOGIC_VECTOR ( 2 downto 0 );
    DDR_cas_n => open,-- : inout STD_LOGIC;
    DDR_ck_n => open,-- : inout STD_LOGIC;
    DDR_ck_p => open,-- : inout STD_LOGIC;
    DDR_cke => open,-- : inout STD_LOGIC;
    DDR_cs_n => open,-- : inout STD_LOGIC;
    DDR_dm => open,-- : inout STD_LOGIC_VECTOR ( 3 downto 0 );
    DDR_dq => open,-- : inout STD_LOGIC_VECTOR ( 31 downto 0 );
    DDR_dqs_n => open,-- : inout STD_LOGIC_VECTOR ( 3 downto 0 );
    DDR_dqs_p => open,-- : inout STD_LOGIC_VECTOR ( 3 downto 0 );
    DDR_odt => open,-- : inout STD_LOGIC;
    DDR_ras_n => open,-- : inout STD_LOGIC;
    DDR_reset_n => open,-- : inout STD_LOGIC;
    DDR_we_n => open,-- : inout STD_LOGIC;
    FIXED_IO_ddr_vrn => open,-- : inout STD_LOGIC;
    FIXED_IO_ddr_vrp => open,-- : inout STD_LOGIC;
    FIXED_IO_mio => open,-- : inout STD_LOGIC_VECTOR ( 53 downto 0 );
    FIXED_IO_ps_clk => open,-- : inout STD_LOGIC;
    FIXED_IO_ps_porb => open,-- : inout STD_LOGIC;
    FIXED_IO_ps_srstb => open-- : inout STD_LOGIC
  );

end architecture top_zed_arch;
