        ideal
        p586
        model flat, stdcall
        locals @@

        %NOINCL

include         "windef.inc"
include         "kernel32.inc"

includelib      "imp32i.lib"


procdesc printf CPP fstr:dword, args:dword:?
procdesc _getch


ROM_START_ADDR  = 4000h
ROM_END_ADDR    = 7FF6h
TM8_START_ADDR  = 7FF7h
TM8_END_ADDR    = 7FF7h
VG93_START_ADDR = 7FF8h
VG93_END_ADDR   = 7FFBh
IR23_START_ADDR = 7FFCh
IR23_END_ADDR   = 7FFFh

ROM_LINE        = 6
TM8_LINE        = 4
VG93_LINE       = 5
IR23_LINE       = 3


dataseg
  szFile        db "rt2.bin",0

udataseg
  hFile         dd ?
  Buffer        db 65536 dup (?)


codeseg

proc FillBuffer
        lea     edi, [Buffer]
        mov     ecx, length Buffer
        mov     al, 0FFh
        cld
        rep     stosb
        ret
endp


proc PutByte uses ebx edi ecx, @@addr, @@b: byte
        ;      ,   
        mov     eax, [@@addr]
        xor     edi, edi
        mov     ecx, 16
    @@rev:
        ror     eax, 1
        rcl     edi, 1
        loop    @@rev
        ;   
        add     edi, offset Buffer
        mov     al, [@@b]
        stosb
        ret
endp

proc MarkAddr near, @@addr, @@length, @@b: byte
        mov     ebx, [@@addr]
        mov     ecx, [@@length]
    @@while:
        movzx   eax, [@@b]
        call    PutByte, ebx, eax
        inc     ebx
        loop    @@while
        ret
endp



proc MakeBuffer
        call    FillBuffer
        ; 
        call    MarkAddr, ROM_START_ADDR, ROM_END_ADDR-ROM_START_ADDR+1, not (1 shl ROM_LINE)
        ; 8
        call    MarkAddr, TM8_START_ADDR, TM8_END_ADDR-TM8_START_ADDR+1, not (1 shl TM8_LINE)
        ; 93
        call    MarkAddr, VG93_START_ADDR, VG93_END_ADDR-VG93_START_ADDR+1, not (1 shl VG93_LINE)
        ; 23
        call    MarkAddr, IR23_START_ADDR, IR23_END_ADDR-IR23_START_ADDR+1, not (1 shl IR23_LINE)
        ret
endp


Begin:  ; program entry point ...
        invoke  printf, <"Generate file '%s'",13,10>, <offset szFile>
        call    CreateFile, offset szFile, GENERIC_WRITE, 0, 0, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0
        mov     [hFile], eax
        inc     eax             ; cmp     eax, INVALID_HANDLE_VALUE
        jz      Fatal1

        ;  
        call    MakeBuffer

        ;  
        push    eax
        mov     eax, esp
        call    WriteFile, [hFile], offset Buffer, length Buffer, eax, 0
        pop     edx
        or      eax, eax
        jz      Fatal2
        invoke  printf, <"Write %u bytes",13,10>, edx
        call    CloseHandle, [hFile]
Exit:
        invoke  printf, <"Good Bye!",13,10>
        call    ExitProcess, 0


Fatal1:
        call    GetLastError
        invoke  printf, <"FATAL: create file error: 0x%X",13,10>, eax
        ;       
        call    _getch
        jmp     Exit
Fatal2:
        call    GetLastError
        invoke  printf, <"FATAL: write file error: 0x%X",13,10>, eax
        ;       
        call    CloseHandle, [hFile]
        call    _getch
        jmp     Exit



end Begin

