//**********************************************************************************************************************
//*  файл color_lines.v из проекта "Meteor Graphics"
//*  формируются цветные полоски для режима VGA 640х480@60Hz
//*  (C) 2015 Вадим Сабиржанов
//*  150919-01
//**********************************************************************************************************************
module color_lines (
    input wire clk,                                                // частота FPGA 126 МГц (у Speccy2010 125 МГц)

    input wire kgi,                                                // кадровые гасящие импульсы
    input wire sgi,                                                // строчные гасящие импульсы

    output reg [7:0]R,                                             // выходы VideoDAC 8+8+8:      
    output reg [7:0]G,
    output reg [7:0]B
	);

reg [3:0]p_cnt;                                                    // счетчик-делитель для получения pixel clock
                                                                   // для режимов 256х192 и 320x240 (126/10 = 12,6 МГц)
reg [8:0]h_320_cnt;                                                // счетчик 320 по-горизонтали (пикселов в строке)
reg [8:0]v_480_cnt;                                                // счетчик 480 по-вертикали (строк в кадре)

reg [8:0]h_256_cnt;                                                // счетчик 256 по-горизонтали (пикселов в строке)
reg [8:0]v_384_cnt;                                                // счетчик 384 по-вертикали (строк в кадре)

reg border_h, border_v;                                            // BORDER по-горизонтали и по-вертикали

//----------------------------------------------------------------------------------------------------------------------
always @(posedge clk)                                              // формирование сигналов счетчиков и BORDERa
begin

if (kgi)                                                           // во время видимой части кадра  счетчики считают 
    begin
    if (sgi)                                                       // во время видимой части строки счетчики считают
        begin
        if (p_cnt == 9)                                            // если max значение счетчика pixel clock
            begin
            p_cnt <= 0;                                            // обнуляем счетчик pixel clock
            h_320_cnt <= h_320_cnt + 1'b1;                         // увеличиваем счетчик 320 по-горизонтали
            border_h <= (h_320_cnt > 30) && (h_320_cnt < 287);     // формируем BORDER по-горизонтали
            if (border_h)                                          // если SCREEN, то
                begin
                h_256_cnt <= h_256_cnt + 1'b1;                     // увеличиваем счетчик 256 по-горизонтали
                end

            if (h_320_cnt == 319)                                  // если последняя точка в строке
                begin
                v_480_cnt <= v_480_cnt + 1'b1;                     // увеличиваем счетчик 480 по-вертикали
                border_v <= (v_480_cnt > 46) && (v_480_cnt < 431); // формируем BORDER по-вертикали
                if (border_v)                                      // если SCREEN, то
                    begin
                    v_384_cnt <= v_384_cnt + 1'b1;                 // увеличиваем счетчик 384 по-вертикали
                    end
                end    
            end
        else
            begin
            p_cnt <= p_cnt + 1'b1;                                 // иначе - увеличиваем счетчик pixel clock
            end
        end
    else                                                           // во время строчного гасящего импулься счетчики обн.
        begin
        p_cnt     <= 0;
        h_320_cnt <= 0;
        h_256_cnt <= 0;
        end
    end

else                                                               // во время кадрового гасящего импулься счетчики обн.
    begin
    v_480_cnt <= 0;
    v_384_cnt <= 0;
    end
end

//----------------------------------------------------------------------------------------------------------------------
always @(posedge clk)                                       // формирование цветных полос                       
begin

if (kgi && sgi)                                             // во время видимой части экрана - цвет 
    begin
    if (border_h && border_v)                               // во время центральной части экрана - полосы 
        begin
        G[6] <= v_384_cnt[7] && h_256_cnt[7];               // по-горизонтали 32 оттенка яркости по 8 точек          
        G[5] <= v_384_cnt[7] && h_256_cnt[6];               // по-вертикали 12 цветных полос основных цветов                  
        G[4] <= v_384_cnt[7] && h_256_cnt[5];               // по 16 точек (32 линии) каждая              
        G[3] <= v_384_cnt[7] && h_256_cnt[4];               
        G[2] <= v_384_cnt[7] && h_256_cnt[3];               
 
        R[6] <= v_384_cnt[6] && h_256_cnt[7];               
        R[5] <= v_384_cnt[6] && h_256_cnt[6];               
        R[4] <= v_384_cnt[6] && h_256_cnt[5];               
        R[3] <= v_384_cnt[6] && h_256_cnt[4];               
        R[2] <= v_384_cnt[6] && h_256_cnt[3];               

        B[6] <= v_384_cnt[5] && h_256_cnt[7];               
        B[5] <= v_384_cnt[5] && h_256_cnt[6];               
        B[4] <= v_384_cnt[5] && h_256_cnt[5];               
        B[3] <= v_384_cnt[5] && h_256_cnt[4];               
        B[2] <= v_384_cnt[5] && h_256_cnt[3];               

        end 
    else                                                    // во время BORDERa цвет - синий
        begin
        R[6:2] <= 5'b00000;
        G[6:2] <= 5'b00000;
        B[6:2] <= 5'b11111;
        end 

    end 
else                                                        // во время гасящих синхроимпульсов - экран черный
    begin
    R[6:2] <= 5'b00000;
    G[6:2] <= 5'b00000;
    B[6:2] <= 5'b00000;
    end 

R[7]   <= 1'b0;                                             // "лишние" биты VideoDAC равны нулю
G[7]   <= 1'b0;
B[7]   <= 1'b0;
R[1:0] <= 2'b00;
G[1:0] <= 2'b00;
B[1:0] <= 2'b00;
    
end
//----------------------------------------------------------------------------------------------------------------------
    
endmodule



