//**********************************************************************************************************************
//*  speccy2010.v главный модуль из проекта "Meteor Graphics" для Speccy2010
//*  отладка отдельных задач на плате Speccy2010 с кварцем 20 MHz
//*  FPGA EP2C8Q208C8N
//*  (C) 2015 Вадим Сабиржанов
//*  150919-01
//**********************************************************************************************************************
// Total logic elements	123 / 8,256 ( 1 % )
// Total pins	29 / 138 ( 21 % )
// Warnings 77

module speccy2010 (
     input  wire CLK20_0,                                   // частота 20 MHz с генератора на входе FPGA 
     output wire VS,                                        // кадровые синхроимпульсы
     output wire HS,                                        // строчные синхроимпульсы
     output wire [7:0]R,                                    // выходы VideoDAC 8+8+8:      
     output wire [7:0]G,
     output wire [7:0]B,
     output wire SDRAM_CLK,                                 // тактовая SDRAM
     output wire SDRAM_CS_N
     );

wire clk, kgi, sgi;

pll_ep2c8q208_20_125 (CLK20_0, clk);                        // подключение модуля PLL 20 * 25 / 4 = 125 MHz
vga_60_sync (clk, VS, HS, kgi, sgi);                        // подключение модуля синхроимульсов VGA
color_lines (clk, kgi, sgi, R, G, B);                       // модуль, формирующий цветные полосы на экране

assign SDRAM_CLK = clk;                                     // тактовая SDRAM = 125 MHz
assign SDRAM_CS_N = 1'b1;                                   // команда INHIBIT (NOP)

endmodule
