//**********************************************************************************************************************
//*  файл vga_60_sync.v из проекта "Meteor Graphics"
//*  формируются синхро- и гасящие импульсы для режима VGA 640х480@60Hz
//*  (C) 2015 Вадим Сабиржанов
//*  150918-05
//**********************************************************************************************************************
module vga_60_sync (
    input wire clk,                                         // частота FPGA 126 МГц (у Speccy2010 125 МГц)

    output reg ksi,                                         // кадровые синхроимпульсы
    output reg ssi,                                         // строчные синхроимпульсы 
 
    output reg kgi,                                         // кадровые гасящие импульсы
    output reg sgi                                          // строчные гасящие импульсы
	);

reg [2:0]p_cnt;                                             // счетчик-делитель для получения pixel clock  
                                                            // для режима VGA 640x480@60Hz (126 / 5 = 25,2 МГц)
reg [9:0]h_cnt;                                             // счетчик по-горизонтали (пикселов в строке)
reg [9:0]v_cnt;                                             // счетчик по-вертикали (строк в кадре)

always @(posedge clk)
begin
if (p_cnt == 4)                                             // если max значение счетчика pixel clock VGA
    begin
    p_cnt <= 0;                                             // обнуляем счетчик pixel clock
    ssi   <= (h_cnt >  94) && (h_cnt < 799);                // формируем строчный синхроимпульс
    sgi   <= (h_cnt > 142) && (h_cnt < 783);                // формируем строчный гасящий импульс
    if (h_cnt == 799)                                       // если max значение счетчика пикселов в строке
        begin
        h_cnt <= 0;                                         // обнуляем счетчик пикселов в строке
        ksi   <= (v_cnt >  0) && (v_cnt < 524);             // формируем кадровый синхроимпульс
        kgi   <= (v_cnt > 33) && (v_cnt < 514);             // формируем кадровый гасящий импульс
        if (v_cnt == 524)                                   // если max значение счетчика строк в кадре
            v_cnt <= 0;                                     // обнуляем счетчик строк в кадре
        else 
            v_cnt <= v_cnt + 1'b1;                          // иначе - увеличиваем счетчик строк в кадре      
        end
    else
        h_cnt <= h_cnt + 1'b1;                              // иначе - увеличиваем счетчик пикселов в строке       
    end
else
    p_cnt <= p_cnt + 1'b1;                                  // иначе - увеличиваем счетчик pixel clock
end

endmodule


