#include <dos.h>

static volatile unsigned elapsed;

static void interrupt (*std_timer)(void);

static void interrupt timer_handler (void)
{{	/*serve vector 0x1C*/
 if (elapsed) elapsed --;
}}

void cdecl end_time (void)
{{
  setvect (0x1C, std_timer);
}}

void init_time (void)
{{
  std_timer = getvect (0x1C);
  setvect (0x1C, timer_handler);
  elapsed = 0;
  atexit (end_time);
}}

void run_delay (unsigned ticks)
{{
  elapsed = ticks;
}}

void wait_delay (void)
{{
  while (elapsed)	;
}}

void cdecl sndoff (void)
{{
 outportb (0x61, inportb (0x61) & 0xFC);
}}

static unsigned get_timer (void)
{{
 unsigned z;

 outportb (0x43, 0);
 z = inportb (0x40);
 return z = z | (inportb (0x40) << 8);
}}

void snd (unsigned fr, unsigned ln)
{{
 unsigned timing = get_timer ();
 long LN = ln;

 LN *= fr *= 6;
 outportb (0x43, 0xB6);
 outportb (0x42, ((unsigned char *)&fr)[0]);
 outportb (0x42, ((unsigned char *)&fr)[1]);
 outportb (0x61, inportb (0x61) | 0x3);
 while (LN > 0) {
  unsigned time2 = get_timer ();

  LN -= (timing - time2);
  timing = time2;
   }
 sndoff ();

  {
  unsigned int HL = ((unsigned long)(437500 * fr)) / 198863.5 - 30.125;
  unsigned int ms;
  unsigned int Hz = (unsigned long)(1193181 / fr);
  unsigned int DE;
  printf("fr=%u ", fr);
  LN *= fr *= 6;
  ms = LN / 1000;
  DE = ((unsigned long)Hz*ms) / 1000;
  printf("PB=%u LN=%ld ", fr, LN);
  printf("Hz=%u ms=%u ", Hz, ms);
  printf("HL=%u DE=%u\n", HL, DE);
  }
}}

void game_title (void) {

 unsigned p = 0; int loop = 300;

  while (loop--) {
    unsigned m = p, k;

    run_delay (1);
    m = ++ p; printf("p=%u ", p);
    for (k = 0; m; m >>= 1)
     if (m & 1)
      k ++;
    printf("k=%u ", k);
    snd (30 + (k << 4), 30);
    wait_delay ();
  }
}

cdecl main (int argc, char * argv[])
{{
  init_time ();
  game_title();
}}
