' ------------------------------------------------------------------------------
' "PIXEL QUEST" (C) 2015
'
' CODE+GRAPHICS BY:     EINAR SAUKAS
' SOUNDTRACK BY:        SERGEY KOSOV (MMCM)
' LOAD SCREEN BY:       CRAIG STEVENSON (REDBALLOON)
' ------------------------------------------------------------------------------
GOTO 10

' ------------------------------------------------------------------------------
' Compressed soundtrack
' ------------------------------------------------------------------------------
    asm
soundtrack:
        defw music01ay
        defw music02ay
        defw music03ay
        defw music04ay
music01ay:
        incbin "mmcm-AshesOfDreams.bin.zx7"
music02ay:
        incbin "mmcm-JaNuAryDaYs.bin.zx7"
music03ay:
        incbin "mmcm-Classification.bin.zx7"
music04ay:
        incbin "mmcm-Recollection.bin.zx7"
    end asm

' ------------------------------------------------------------------------------
' Compressed gallery screens (without attributes)
' ------------------------------------------------------------------------------
gallery:
    asm
        defw page00scr
        defw page01scr
        defw page02scr
        defw page03scr
        defw page04scr
page00scr:
        incbin "page00.bin.rcs.zx7"
page01scr:
        incbin "page01.bin.rcs.zx7"
page02scr:
        incbin "page02.bin.rcs.zx7"
page03scr:
        incbin "page03.bin.rcs.zx7"
page04scr:
        incbin "page04.bin.rcs.zx7"
    end asm

' ------------------------------------------------------------------------------
' Compressed intro screen
' ------------------------------------------------------------------------------
introscr:
    asm
        incbin "intro.scr.rcs.zx7"
    end asm

' ------------------------------------------------------------------------------
' FZX font for text messages
' ------------------------------------------------------------------------------
fontfzx:
    asm
        incbin "pixelquest.fzx"
    end asm

' ------------------------------------------------------------------------------
' FZX font for tiny numbers
' ------------------------------------------------------------------------------
microfzx:
    asm
        incbin "micro.fzx"
    end asm

' ------------------------------------------------------------------------------
' UDG characters for board graphics
' ------------------------------------------------------------------------------
boardchr:
    asm
        incbin "board.chr"
    end asm

' ------------------------------------------------------------------------------
' Main menu text
' ------------------------------------------------------------------------------
menumsg:
    asm
        defb 22, 106, 81
        defb "1-KEYBOARD 1"
        defb 22, 117, 81
        defb "2-KEYBOARD 2"
        defb 22, 128, 81
        defb "3-KEYBOARD 3"
        defb 22, 139, 81
        defb "4-KEMPSTON"
        defb 22, 150, 81
        defb "5-SINCLAIR"
        defb 22, 171, 60
        defb "PRESS T+Y TO MUTE"
        defb 22, 182, 60
        defb "PRESS G+H TO RESET"
        defb 255
    end asm

' ------------------------------------------------------------------------------
' Keyboard mapping text
' ------------------------------------------------------------------------------
keyboardmsg:
    asm
        defb "LEFT .."
        defb 255
        defb "RIGHT ."
        defb 255
        defb "DOWN .."
        defb 255
        defb "UP ...."
        defb 255
        defb "SET ..."
        defb 255
        defb "RESET ."
        defb 255
        defb "CLEAR ."
        defb 255
        defb "FIRE .."
        defb 255
    end asm

' ------------------------------------------------------------------------------
' Keyboard separator text
' ------------------------------------------------------------------------------
separatormsg:
    asm
        defb 22, 0, 134
        defb "... "
        defb 255
    end asm

' ------------------------------------------------------------------------------
' Key "ENTER" text
' ------------------------------------------------------------------------------
entermsg:
    asm
        defb "ENTER"
        defb 255
    end asm

' ------------------------------------------------------------------------------
' Key "SPACE" text
' ------------------------------------------------------------------------------
spacemsg:
    asm
        defb "SPACE"
        defb 255
    end asm

' ------------------------------------------------------------------------------
' Key "SYMBOL" text
' ------------------------------------------------------------------------------
symbolmsg:
    asm
        defb "SYMBOL"
        defb 255
    end asm

' ------------------------------------------------------------------------------
' Key "CAPS" text
' ------------------------------------------------------------------------------
capsmsg:
    asm
        defb "CAPS"
        defb 255
    end asm

' ------------------------------------------------------------------------------
' Redefine keys text
' ------------------------------------------------------------------------------
redefmsg:
    asm
        defb 22, 182, 61
        defb "REDEFINE KEYS? Y-N"
        defb 255
    end asm

' ------------------------------------------------------------------------------
' Pixel art definitions - page 0 (PRACTICE)
' ------------------------------------------------------------------------------
page00:
    asm
        ; HUNGRY HORACE
        defb $20, $00, $00
        defb $f8, $00, $00
        defb $50, $00, $00
        defb $f8, $00, $00
        defb $20, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; PYJAMARAMA
        defb $bc, $00, $00
        defb $bf, $00, $00
        defb $bd, $00, $00
        defb $bd, $00, $00
        defb $bf, $00, $00
        defb $bc, $00, $00
        defb $78, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; T.L.L.
        defb $78, $00, $00
        defb $4c, $00, $00
        defb $4a, $00, $00
        defb $7a, $00, $00
        defb $7e, $00, $00
        defb $7a, $00, $00
        defb $78, $00, $00
        defb $fc, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; CYCLONE
        defb $10, $00, $00
        defb $68, $00, $00
        defb $94, $00, $00
        defb $cc, $00, $00
        defb $f4, $00, $00
        defb $e4, $00, $00
        defb $68, $00, $00
        defb $30, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; JETSET WILLY (apple)
        defb $74, $00, $00
        defb $38, $00, $00
        defb $66, $00, $00
        defb $bf, $00, $00
        defb $bf, $00, $00
        defb $9d, $00, $00
        defb $42, $00, $00
        defb $3c, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; HEARTLAND
        defb $0e, $00, $00
        defb $3e, $00, $00
        defb $7d, $00, $00
        defb $73, $00, $00
        defb $8f, $00, $00
        defb $5f, $40, $00
        defb $5f, $60, $00
        defb $2e, $e0, $00
        defb $29, $c0, $00
        defb $c7, $80, $00
        defb $fe, $00, $00
        defb $38, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; ALIEN HIGHWAY
        defb $03, $00, $00
        defb $03, $00, $00
        defb $03, $00, $00
        defb $03, $00, $00
        defb $04, $80, $00
        defb $0b, $c0, $00
        defb $15, $e0, $00
        defb $2b, $f0, $00
        defb $55, $f8, $00
        defb $eb, $fc, $00
        defb $35, $f0, $00
        defb $cf, $cc, $00
        defb $33, $30, $00
        defb $0c, $c0, $00
        defb $03, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; FIRELORD
        defb $00, $0c, $00
        defb $0c, $1c, $00
        defb $03, $fe, $00
        defb $1f, $fe, $00
        defb $63, $ff, $00
        defb $1f, $ff, $00
        defb $7f, $fc, $00
        defb $67, $f0, $00
        defb $de, $70, $00
        defb $b8, $60, $00
        defb $30, $e0, $00
        defb $61, $c0, $00
        defb $43, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; 3 WEEKS IN PARADISE
        defb $bf, $f0, $00
        defb $bf, $f0, $00
        defb $00, $00, $00
        defb $5f, $e6, $00
        defb $5f, $ee, $00
        defb $5f, $ef, $00
        defb $5f, $eb, $00
        defb $5f, $e3, $00
        defb $5f, $e3, $00
        defb $5f, $e3, $00
        defb $5f, $e7, $00
        defb $5f, $ae, $00
        defb $5f, $ac, $00
        defb $5f, $a8, $00
        defb $4f, $20, $00
        defb $3f, $c0, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; SLIGHTLY MAGIC
        defb $30, $00, $00
        defb $6c, $00, $00
        defb $6f, $00, $00
        defb $de, $fa, $00
        defb $dd, $9b, $00
        defb $dd, $fb, $00
        defb $dd, $51, $00
        defb $da, $aa, $00
        defb $65, $00, $00
        defb $68, $61, $00
        defb $30, $31, $00
        defb $00, $1f, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; HERBERT'S DUMMY RUN
        defb $07, $fe, $00
        defb $0e, $22, $04
        defb $3e, $23, $fe
        defb $43, $ff, $c2
        defb $bd, $af, $bc
        defb $66, $af, $66
        defb $5a, $ff, $5a
        defb $18, $00, $18
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
    end asm

' ------------------------------------------------------------------------------
' Pixel art definitions - page 1 (EASY)
' ------------------------------------------------------------------------------
page01:
    asm
        ; MANIC MINER
        defb $06, $00, $00
        defb $3e, $00, $00
        defb $7c, $00, $00
        defb $34, $00, $00
        defb $3e, $00, $00
        defb $3c, $00, $00
        defb $18, $00, $00
        defb $3c, $00, $00
        defb $7e, $00, $00
        defb $7e, $00, $00
        defb $f7, $00, $00
        defb $fb, $00, $00
        defb $3c, $00, $00
        defb $76, $00, $00
        defb $6e, $00, $00
        defb $77, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; JETSET WILLY (hero)
        defb $3c, $00, $00
        defb $3c, $00, $00
        defb $7e, $00, $00
        defb $34, $00, $00
        defb $3e, $00, $00
        defb $3c, $00, $00
        defb $18, $00, $00
        defb $3c, $00, $00
        defb $7e, $00, $00
        defb $7e, $00, $00
        defb $f7, $00, $00
        defb $fb, $00, $00
        defb $3c, $00, $00
        defb $76, $00, $00
        defb $6e, $00, $00
        defb $77, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; PSSST
        defb $0c, $18, $00
        defb $0f, $f8, $00
        defb $18, $8c, $00
        defb $17, $74, $00
        defb $34, $16, $00
        defb $34, $96, $00
        defb $38, $8e, $00
        defb $3f, $fe, $00
        defb $00, $00, $00
        defb $7f, $ff, $00
        defb $6a, $ab, $00
        defb $75, $57, $00
        defb $7e, $bf, $00
        defb $07, $70, $00
        defb $37, $f6, $00
        defb $30, $06, $00
        defb $48, $09, $00
        defb $b4, $16, $80

        ; FINDERS KEEPERS
        defb $3f, $80, $00
        defb $7f, $e0, $00
        defb $fa, $b0, $00
        defb $ea, $b0, $00
        defb $aa, $b0, $00
        defb $fa, $b0, $00
        defb $7f, $e0, $00
        defb $0e, $00, $00
        defb $1b, $00, $00
        defb $1b, $80, $00
        defb $1b, $80, $00
        defb $07, $00, $00
        defb $0e, $c0, $00
        defb $13, $c0, $00
        defb $1b, $80, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; EQUINOX
        defb $33, $cc, $00
        defb $6f, $f6, $00
        defb $9f, $f9, $00
        defb $1c, $98, $00
        defb $39, $2c, $00
        defb $79, $2e, $00
        defb $bb, $6d, $00
        defb $fc, $9f, $00
        defb $bf, $fd, $00
        defb $ff, $ff, $00
        defb $be, $bd, $00
        defb $de, $bb, $00
        defb $9f, $79, $00
        defb $0f, $f0, $00
        defb $33, $cc, $00
        defb $78, $1e, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; BUBBLE BOBBLE
        defb $33, $80, $00
        defb $1f, $e0, $00
        defb $1f, $f8, $00
        defb $0f, $f8, $00
        defb $0f, $9c, $00
        defb $1f, $6c, $00
        defb $0e, $d4, $00
        defb $16, $0c, $00
        defb $1f, $f8, $00
        defb $1f, $e0, $00
        defb $3f, $dc, $00
        defb $3f, $be, $00
        defb $3f, $e0, $00
        defb $fc, $dc, $00
        defb $73, $3c, $00
        defb $07, $b0, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; STARQUAKE (enemy)
        defb $0e, $70, $00
        defb $1f, $f8, $00
        defb $1d, $b8, $00
        defb $19, $98, $00
        defb $6e, $76, $00
        defb $f1, $8f, $00
        defb $ff, $fe, $00
        defb $3f, $ff, $00
        defb $37, $bf, $00
        defb $03, $18, $00
        defb $04, $80, $00
        defb $0f, $0e, $00
        defb $0f, $9f, $00
        defb $0f, $fb, $80
        defb $07, $f0, $80
        defb $01, $e0, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; FRANK N STEIN
        defb $3c, $00, $00
        defb $7a, $00, $00
        defb $84, $00, $00
        defb $bb, $00, $00
        defb $ef, $00, $00
        defb $f0, $00, $00
        defb $7e, $00, $00
        defb $3c, $00, $00
        defb $7e, $00, $00
        defb $76, $00, $00
        defb $f7, $00, $00
        defb $fb, $00, $00
        defb $3c, $00, $00
        defb $76, $00, $00
        defb $66, $00, $00
        defb $77, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; XECUTOR
        defb $01, $00, $00
        defb $01, $00, $00
        defb $00, $00, $00
        defb $85, $42, $00
        defb $8d, $62, $00
        defb $0b, $a0, $00
        defb $82, $82, $00
        defb $85, $42, $00
        defb $85, $42, $00
        defb $35, $58, $00
        defb $f4, $5e, $00
        defb $f2, $9e, $00
        defb $f3, $9e, $00
        defb $f0, $1e, $00
        defb $c5, $46, $00
        defb $05, $40, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; PHANTOMAS
        defb $01, $e0, $00
        defb $07, $e0, $00
        defb $7f, $f8, $00
        defb $ff, $c0, $00
        defb $7f, $e0, $00
        defb $3c, $1c, $00
        defb $41, $bc, $00
        defb $7c, $20, $00
        defb $7f, $e0, $00
        defb $3e, $00, $00
        defb $1f, $80, $00
        defb $47, $3c, $00
        defb $fb, $fc, $00
        defb $77, $f8, $00
        defb $37, $c0, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; TRANZ AM
        defb $03, $00, $00
        defb $37, $b0, $00
        defb $37, $b0, $00
        defb $37, $b0, $00
        defb $37, $b0, $00
        defb $07, $80, $00
        defb $0c, $c0, $00
        defb $18, $60, $00
        defb $18, $60, $00
        defb $1f, $e0, $00
        defb $e8, $5c, $00
        defb $ef, $dc, $00
        defb $e8, $5c, $00
        defb $ef, $dc, $00
        defb $f7, $bc, $00
        defb $04, $80, $00
        defb $00, $00, $00
        defb $00, $00, $00
    end asm

' ------------------------------------------------------------------------------
' Pixel art definitions - page 2 (MEDIUM)
' ------------------------------------------------------------------------------
page02:
    asm
        ; NEBULUS
        defb $00, $60, $00
        defb $00, $f0, $00
        defb $00, $f0, $00
        defb $0d, $98, $00
        defb $3d, $48, $00
        defb $7d, $08, $00
        defb $fe, $96, $00
        defb $fe, $f7, $00
        defb $f3, $6f, $00
        defb $fd, $9d, $00
        defb $7e, $fe, $00
        defb $6e, $dc, $00
        defb $2d, $e0, $00
        defb $0c, $80, $00
        defb $1b, $00, $00
        defb $1f, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; STARQUAKE (hero)
        defb $16, $00, $00
        defb $36, $00, $00
        defb $05, $c0, $00
        defb $2d, $b0, $00
        defb $6b, $60, $00
        defb $76, $78, $00
        defb $fc, $34, $00
        defb $fe, $0c, $00
        defb $ff, $1c, $00
        defb $ff, $bc, $00
        defb $73, $f8, $00
        defb $0d, $f8, $00
        defb $fb, $f6, $00
        defb $e1, $ce, $00
        defb $7e, $3c, $00
        defb $3e, $78, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; CYBERNOID
        defb $0e, $c0, $00
        defb $3e, $50, $00
        defb $7e, $ac, $00
        defb $fe, $55, $00
        defb $00, $00, $00
        defb $ff, $ff, $00
        defb $7f, $fc, $00
        defb $0f, $e0, $00
        defb $00, $00, $00
        defb $77, $c0, $00
        defb $ef, $ba, $00
        defb $5f, $00, $00
        defb $00, $00, $00
        defb $7b, $00, $00
        defb $fb, $6a, $00
        defb $7b, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; BUBBLE BOBBLE
        defb $00, $e0, $00
        defb $0f, $f0, $00
        defb $7f, $f0, $00
        defb $ff, $f0, $00
        defb $fe, $d0, $00
        defb $fe, $d0, $00
        defb $3e, $d0, $00
        defb $df, $f0, $00
        defb $df, $f0, $00
        defb $3f, $00, $00
        defb $d0, $00, $00
        defb $ca, $a8, $00
        defb $15, $50, $00
        defb $aa, $a8, $00
        defb $f9, $c0, $00
        defb $03, $e0, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; ZANTHRAX
        defb $43, $08, $00
        defb $46, $88, $00
        defb $6f, $58, $00
        defb $af, $54, $00
        defb $ec, $dc, $00
        defb $f8, $7c, $00
        defb $eb, $5c, $00
        defb $6f, $d8, $00
        defb $6f, $d8, $00
        defb $f7, $bc, $00
        defb $b8, $64, $00
        defb $bb, $5c, $00
        defb $cb, $5c, $00
        defb $7b, $78, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; PROJECT FUTURE
        defb $03, $80, $00
        defb $0f, $e0, $00
        defb $0c, $00, $00
        defb $1d, $f0, $00
        defb $7d, $d0, $00
        defb $5d, $f0, $00
        defb $44, $00, $00
        defb $ee, $e0, $00
        defb $fd, $10, $00
        defb $ed, $d0, $00
        defb $4c, $10, $00
        defb $07, $e0, $00
        defb $03, $80, $00
        defb $00, $30, $00
        defb $1e, $f0, $00
        defb $1e, $c0, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; TANTALUS
        defb $09, $40, $00
        defb $4d, $a8, $00
        defb $36, $aa, $00
        defb $1d, $54, $00
        defb $eb, $f8, $00
        defb $37, $c4, $00
        defb $15, $bc, $00
        defb $eb, $a6, $00
        defb $25, $a6, $00
        defb $6b, $fe, $00
        defb $13, $e0, $00
        defb $0d, $fc, $00
        defb $fb, $f8, $00
        defb $e3, $f0, $00
        defb $7c, $08, $00
        defb $3e, $7c, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; NODES OF YESOD
        defb $1e, $f0, $00
        defb $71, $1c, $00
        defb $ce, $e6, $00
        defb $be, $fa, $00
        defb $3e, $f8, $00
        defb $74, $5c, $00
        defb $72, $9c, $00
        defb $7e, $fc, $00
        defb $71, $1c, $00
        defb $8b, $a2, $00
        defb $fb, $be, $00
        defb $f7, $de, $00
        defb $75, $dc, $00
        defb $14, $d0, $00
        defb $63, $8c, $00
        defb $f8, $3e, $00
        defb $fc, $7e, $00
        defb $00, $00, $00

        ; BUBBLE DIZZY
        defb $0f, $80, $00
        defb $3f, $e0, $00
        defb $3f, $f0, $00
        defb $7f, $e0, $00
        defb $7f, $d0, $00
        defb $7f, $b0, $00
        defb $ff, $a0, $00
        defb $ff, $a0, $00
        defb $f3, $c8, $00
        defb $ed, $f8, $00
        defb $d9, $f8, $00
        defb $5d, $a0, $00
        defb $4b, $c0, $00
        defb $23, $e0, $00
        defb $0f, $80, $00
        defb $60, $38, $00
        defb $f8, $f8, $00
        defb $78, $f0, $00

        ; ARMOUR OF ANTIRIAD
        defb $00, $7e, $00
        defb $03, $e7, $c0
        defb $07, $db, $e0
        defb $07, $db, $e0
        defb $0d, $e7, $b0
        defb $0c, $ff, $30
        defb $18, $3c, $18
        defb $7f, $ff, $fe
        defb $ff, $ff, $ff
        defb $e7, $81, $e7
        defb $ec, $7e, $37
        defb $ef, $bd, $f7
        defb $6f, $00, $f6
        defb $07, $3c, $e0
        defb $3a, $3c, $5c
        defb $3c, $3c, $3c
        defb $3c, $00, $3c
        defb $00, $00, $00

        ; SCUMBALL
        defb $7f, $f8, $00
        defb $d1, $fc, $00
        defb $d5, $c0, $00
        defb $91, $b8, $00
        defb $99, $64, $00
        defb $ff, $64, $00
        defb $e3, $38, $00
        defb $dd, $80, $00
        defb $be, $c0, $00
        defb $be, $fc, $00
        defb $3c, $f8, $00
        defb $1c, $00, $00
        defb $18, $00, $00
        defb $18, $00, $00
        defb $27, $80, $00
        defb $3f, $80, $00
        defb $00, $00, $00
        defb $00, $00, $00
    end asm

' ------------------------------------------------------------------------------
' Pixel art definitions - page 3 (HARD)
' ------------------------------------------------------------------------------
page03:
    asm
        ; AUF MONTY
        defb $01, $00, $00
        defb $0e, $e0, $00
        defb $0e, $f8, $00
        defb $17, $f8, $00
        defb $39, $e0, $00
        defb $76, $10, $00
        defb $75, $b8, $00
        defb $d1, $b8, $00
        defb $df, $d8, $00
        defb $db, $e0, $00
        defb $67, $e0, $00
        defb $f7, $c0, $00
        defb $fb, $d8, $00
        defb $71, $f0, $00
        defb $3c, $e0, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; GHOULS'N'GHOSTS
        defb $0e, $06, $00
        defb $18, $07, $00
        defb $37, $83, $00
        defb $77, $cb, $00
        defb $62, $4b, $00
        defb $e6, $5b, $00
        defb $c9, $db, $00
        defb $cf, $db, $00
        defb $c0, $33, $00
        defb $c1, $d3, $00
        defb $c3, $eb, $00
        defb $43, $fb, $00
        defb $43, $ca, $00
        defb $6d, $b2, $00
        defb $2d, $b2, $00
        defb $24, $b2, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; TERMINUS
        defb $82, $a0, $00
        defb $8a, $a8, $00
        defb $4a, $aa, $00
        defb $49, $54, $00
        defb $c7, $3b, $00
        defb $f4, $fc, $00
        defb $bb, $fd, $00
        defb $f9, $c2, $00
        defb $56, $f2, $00
        defb $f6, $fe, $00
        defb $f6, $7e, $00
        defb $0b, $76, $00
        defb $03, $78, $00
        defb $04, $00, $00
        defb $06, $c0, $00
        defb $07, $c0, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; SOLOMON'S KEY (enemy)
        defb $01, $fc, $00
        defb $03, $fe, $00
        defb $01, $f0, $00
        defb $02, $f5, $00
        defb $87, $75, $00
        defb $d7, $b0, $00
        defb $f7, $df, $00
        defb $77, $e0, $00
        defb $fb, $f6, $00
        defb $fc, $fb, $00
        defb $7f, $3b, $00
        defb $7f, $bb, $00
        defb $7f, $bb, $00
        defb $3f, $76, $00
        defb $0f, $00, $00
        defb $0c, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; PI-BALLED
        defb $07, $e0, $00
        defb $0e, $70, $00
        defb $1d, $b8, $00
        defb $3c, $b0, $00
        defb $3e, $78, $00
        defb $77, $fc, $00
        defb $5d, $fe, $00
        defb $ee, $d9, $00
        defb $af, $09, $00
        defb $1f, $e6, $00
        defb $0f, $e0, $00
        defb $0d, $c0, $00
        defb $06, $20, $00
        defb $0c, $70, $00
        defb $0f, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; SABRE WULF
        defb $0f, $80, $00
        defb $19, $c0, $00
        defb $2e, $b8, $00
        defb $2e, $60, $00
        defb $29, $80, $00
        defb $26, $40, $00
        defb $39, $b0, $00
        defb $67, $f0, $00
        defb $0f, $c0, $00
        defb $40, $00, $00
        defb $ec, $80, $00
        defb $58, $c0, $00
        defb $59, $c0, $00
        defb $59, $c0, $00
        defb $04, $c2, $00
        defb $5c, $e6, $00
        defb $4f, $ee, $00
        defb $07, $ee, $00

        ; KNIGHT LORE
        defb $06, $1c, $00
        defb $07, $fc, $00
        defb $07, $38, $00
        defb $03, $3c, $00
        defb $03, $fe, $00
        defb $03, $7f, $00
        defb $03, $89, $00
        defb $0f, $ca, $00
        defb $3f, $76, $00
        defb $7f, $dc, $00
        defb $7d, $e0, $00
        defb $33, $e8, $00
        defb $4f, $c6, $00
        defb $ef, $7b, $00
        defb $77, $ba, $00
        defb $19, $c0, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; DYNAMITE DAN (hero)
        defb $00, $00, $04
        defb $00, $00, $02
        defb $00, $00, $2d
        defb $01, $61, $7d
        defb $03, $79, $ed
        defb $87, $7d, $ff
        defb $8f, $1e, $fa
        defb $fc, $07, $e6
        defb $fa, $ff, $36
        defb $02, $fe, $0c
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; EGGHEAD
        defb $00, $7c, $00
        defb $03, $fc, $00
        defb $0f, $fe, $00
        defb $1f, $e2, $00
        defb $3f, $da, $00
        defb $7f, $d2, $00
        defb $7f, $42, $00
        defb $ff, $42, $00
        defb $ff, $64, $00
        defb $ff, $bc, $00
        defb $73, $c0, $00
        defb $0d, $f8, $00
        defb $fb, $f6, $00
        defb $e1, $ce, $00
        defb $7e, $3c, $00
        defb $3e, $70, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; GAME OVER
        defb $01, $e0, $00
        defb $1a, $f0, $00
        defb $23, $80, $00
        defb $ed, $90, $00
        defb $9e, $f0, $00
        defb $b6, $e0, $00
        defb $7d, $18, $00
        defb $73, $80, $40
        defb $e4, $ff, $f0
        defb $7b, $53, $00
        defb $1a, $fc, $00
        defb $01, $bc, $00
        defb $17, $8e, $00
        defb $37, $5e, $00
        defb $7a, $cc, $00
        defb $4d, $9f, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; CAULDRON
        defb $00, $0f, $e0
        defb $00, $3f, $b0
        defb $00, $0f, $70
        defb $00, $3c, $c0
        defb $00, $fb, $38
        defb $00, $01, $cc
        defb $00, $38, $e0
        defb $00, $ec, $00
        defb $01, $de, $00
        defb $03, $ce, $00
        defb $07, $b7, $80
        defb $03, $e3, $c0
        defb $73, $cd, $b0
        defb $fd, $fe, $77
        defb $f8, $ff, $00
        defb $60, $0e, $00
        defb $00, $60, $00
        defb $00, $00, $00
    end asm

' ------------------------------------------------------------------------------
' Pixel art definitions - page 4 (BONUS)
' ------------------------------------------------------------------------------
page04:
    asm
        ; SIR LANCELOT
        defb $18, $00, $00
        defb $3c, $00, $00
        defb $72, $00, $00
        defb $7f, $00, $00
        defb $7e, $04, $00
        defb $3c, $18, $00
        defb $77, $60, $00
        defb $ed, $80, $00
        defb $d8, $c0, $00
        defb $ed, $80, $00
        defb $6d, $80, $00
        defb $27, $00, $00
        defb $2a, $00, $00
        defb $6c, $00, $00
        defb $df, $80, $00
        defb $df, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; REBELSTAR II
        defb $03, $00, $00
        defb $07, $80, $00
        defb $36, $00, $00
        defb $29, $80, $00
        defb $1e, $40, $00
        defb $37, $e0, $00
        defb $71, $a0, $00
        defb $a6, $0c, $00
        defb $b7, $fe, $00
        defb $9b, $0c, $00
        defb $61, $40, $00
        defb $0c, $60, $00
        defb $18, $60, $00
        defb $18, $30, $00
        defb $0c, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; DYNAMITE DAN (snail) 
        defb $07, $f8, $00
        defb $1f, $fe, $00
        defb $3d, $5f, $00
        defb $38, $0f, $00
        defb $73, $e7, $84
        defb $66, $33, $89
        defb $74, $5b, $8a
        defb $66, $5b, $8a
        defb $33, $db, $8a
        defb $38, $37, $00
        defb $1a, $b6, $1e
        defb $0f, $e0, $ff
        defb $30, $0f, $fe
        defb $7f, $ff, $f0
        defb $aa, $aa, $a0
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; ATIC ATAC
        defb $0a, $00, $00
        defb $17, $00, $00
        defb $27, $80, $00
        defb $4f, $c0, $00
        defb $40, $c0, $00
        defb $9f, $e0, $00
        defb $9e, $00, $00
        defb $9d, $60, $00
        defb $fb, $58, $00
        defb $07, $98, $00
        defb $3f, $e0, $00
        defb $67, $90, $00
        defb $43, $b0, $00
        defb $21, $80, $00
        defb $1b, $b0, $00
        defb $63, $70, $00
        defb $70, $e0, $00
        defb $38, $c0, $00

        ; JACK THE NIPPER II
        defb $01, $b0, $00
        defb $40, $c8, $00
        defb $a1, $b4, $00
        defb $a1, $00, $00
        defb $50, $84, $00
        defb $a9, $cc, $00
        defb $55, $f4, $00
        defb $ab, $f0, $00
        defb $57, $f0, $00
        defb $0f, $e0, $00
        defb $3f, $c0, $00
        defb $77, $80, $00
        defb $a4, $80, $00
        defb $43, $60, $00
        defb $02, $40, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; ZYNAPS
        defb $1f, $a0, $00
        defb $22, $00, $00
        defb $44, $00, $00
        defb $28, $00, $00
        defb $10, $00, $00
        defb $38, $00, $00
        defb $86, $30, $00
        defb $df, $68, $00
        defb $d7, $a4, $00
        defb $01, $b2, $00
        defb $91, $7f, $00
        defb $28, $1c, $00
        defb $4c, $00, $00
        defb $44, $00, $00
        defb $3f, $a0, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; SOLOMON'S KEY (hero) 
        defb $07, $e0, $00
        defb $03, $f8, $00
        defb $03, $ff, $00
        defb $1f, $00, $00
        defb $00, $ee, $00
        defb $03, $f8, $00
        defb $08, $00, $00
        defb $37, $fc, $00
        defb $2e, $fe, $00
        defb $6e, $00, $00
        defb $60, $f4, $00
        defb $6e, $e8, $00
        defb $76, $e8, $00
        defb $70, $00, $00
        defb $e3, $f4, $00
        defb $03, $fa, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; CYBERNOID II
        defb $2f, $c0, $00
        defb $b7, $ec, $70
        defb $2f, $98, $88
        defb $00, $35, $c4
        defb $7f, $0c, $92
        defb $f3, $fe, $07
        defb $ed, $83, $fc
        defb $58, $3d, $f0
        defb $17, $80, $00
        defb $07, $3e, $a0
        defb $0e, $28, $00
        defb $88, $00, $00
        defb $d7, $c0, $00
        defb $bb, $f8, $c0
        defb $7c, $ff, $e8
        defb $3f, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; KOSMOS
        defb $40, $c0, $00
        defb $03, $f0, $00
        defb $47, $88, $00
        defb $47, $28, $00
        defb $0d, $64, $00
        defb $6d, $74, $00
        defb $47, $14, $00
        defb $83, $c4, $00
        defb $a8, $38, $80
        defb $8b, $83, $80
        defb $6b, $db, $80
        defb $01, $d8, $00
        defb $6c, $00, $00
        defb $67, $f0, $00
        defb $00, $f0, $00
        defb $50, $00, $00
        defb $a8, $3c, $00
        defb $20, $3c, $00

        ; REX
        defb $09, $00, $00
        defb $05, $00, $00
        defb $02, $c8, $00
        defb $35, $90, $00
        defb $72, $f8, $00
        defb $e1, $c0, $00
        defb $d0, $b8, $00
        defb $68, $10, $00
        defb $97, $82, $00
        defb $d8, $d0, $00
        defb $06, $64, $00
        defb $03, $00, $00
        defb $1b, $00, $00
        defb $31, $a0, $00
        defb $31, $c0, $00
        defb $18, $80, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; STORMLORD
        defb $02, $54, $00
        defb $06, $a2, $00
        defb $15, $5d, $00
        defb $39, $2a, $00
        defb $3a, $bd, $00
        defb $75, $5a, $00
        defb $72, $e4, $00
        defb $75, $f0, $00
        defb $6b, $f8, $00
        defb $63, $58, $60
        defb $46, $e1, $d8
        defb $86, $e6, $07
        defb $05, $df, $80
        defb $0d, $fd, $e0
        defb $0b, $f8, $38
        defb $31, $e0, $07
        defb $00, $00, $00
        defb $00, $00, $00
    end asm

' ------------------------------------------------------------------------------
' Map of "locked" positions in page 4 only (with pixel art puzzles that would
' not be "solvable" otherwise)
' ------------------------------------------------------------------------------
page04lock:
    asm
        ; SIR LANCELOT
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $04, $00
        defb $00, $08, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; REBELSTAR II
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $40, $00
        defb $08, $10, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; DYNAMITE DAN (snail)
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $02
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; ATIC ATAC
        defb $00, $00, $00
        defb $20, $00, $00
        defb $40, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; JACK THE NIPPER II
        defb $00, $00, $00
        defb $20, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $02, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; ZYNAPS
        defb $20, $00, $00
        defb $00, $00, $00
        defb $08, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $10, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $08, $00
        defb $00, $00, $00
        defb $08, $00, $00
        defb $40, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $40, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; SOLOMON'S KEY (hero)
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $80, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; CYBERNOID II
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $04
        defb $00, $00, $10
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; KOSMOS
        defb $01, $00, $00
        defb $04, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $40, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $40, $00
        defb $00, $00, $00

        ; REX
        defb $04, $00, $00
        defb $00, $00, $00
        defb $08, $06, $00
        defb $40, $00, $00
        defb $01, $00, $00
        defb $00, $00, $00
        defb $04, $00, $00
        defb $00, $00, $00
        defb $00, $60, $00
        defb $00, $08, $00
        defb $00, $02, $00
        defb $10, $00, $00
        defb $00, $80, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00

        ; STORMLORD
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $40, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $02, $00
        defb $00, $00, $01
        defb $00, $00, $40
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $01, $00
        defb $00, $00, $00
        defb $00, $00, $00
        defb $00, $00, $00
    end asm

' ------------------------------------------------------------------------------
' Libraries
' ------------------------------------------------------------------------------
#include "zx7.bas"
#include "joy.bas"
#include "defkey.bas"

' ------------------------------------------------------------------------------
' Player controls
' ------------------------------------------------------------------------------
#define  KEY_LEFT          DEFKEY7
#define  KEY_RIGHT         DEFKEY6
#define  KEY_DOWN          DEFKEY5
#define  KEY_UP            DEFKEY4
#define  KEY_ENABLE        DEFKEY3
#define  KEY_DISABLE       DEFKEY2
#define  KEY_CLEAR         DEFKEY1

' ------------------------------------------------------------------------------
' Possible "states" that player can select for each board position
' ------------------------------------------------------------------------------
#define  STATE_BLANK       0            ' .   (unmarked position)
#define  STATE_PIXEL       1            ' O   (position marked as PIXEL)
#define  STATE_CROSS       2            ' X   (position marked as CROSS)

' ------------------------------------------------------------------------------
' Possible player "actions" that may produce "state transitions" in the board
' ------------------------------------------------------------------------------
#define  ACTION_NONE       0            ' none
#define  ACTION_SET        1            ' . -> O
#define  ACTION_RESET      2            ' . -> X
#define  ACTION_UNSET      3            ' O -> .
#define  ACTION_UNRESET    4            ' X -> .
#define  ACTION_ENABLE     5            ' * -> O
#define  ACTION_DISABLE    6            ' * -> X
#define  ACTION_CLEAR      7            ' * -> .
#define  ACTION_INVALID    8            ' invalid

' ------------------------------------------------------------------------------
' Gameplay constants
' ------------------------------------------------------------------------------
#define  TOTAL_PAGES       5
#define  PIXEL_ROWS        18
#define  PIXEL_COLS        24
#define  COUNT_ROWS        8            ' how many counts of pixels in consecutive rows for each column
#define  COUNT_COLS        11           ' how many counts of pixels in consecutive columns for each row
#define  SPRITESIZE        (INT ((PIXEL_COLS+7)/8)*PIXEL_ROWS)

' ------------------------------------------------------------------------------
' Memory addresses storing current board data
' ------------------------------------------------------------------------------
' In this area, each bit indicates a board position marked as PIXEL
#define  ADDR_PIXEL_TABLE  53000
' In this area, each bit indicates a board position marked as CROSS
#define  ADDR_CROSS_TABLE  (ADDR_PIXEL_TABLE+SPRITESIZE)
' This area stores counts of pixels in consecutive rows for each column
#define  ADDR_COUNT_ROWS   (ADDR_CROSS_TABLE+SPRITESIZE)
' This area stores counts of pixels in consecutive columns for each row
#define  ADDR_COUNT_COLS   (ADDR_COUNT_ROWS+COUNT_ROWS*PIXEL_COLS)
' Temporary area for counting pixels in consecutive rows or columns for current cursor position
#define  ADDR_TMP_COUNT    (ADDR_COUNT_COLS+COUNT_COLS*PIXEL_ROWS)


' ------------------------------------------------------------------------------
' Global variables
' ------------------------------------------------------------------------------
    DIM width AS UBYTE          ' width of current puzzle board
    DIM height AS UBYTE         ' height of current puzzle board

' ------------------------------------------------------------------------------
' Switch music on/off. Stop playing music (if it was playing), or start playing
' a new music track (if it wasn't).
' ------------------------------------------------------------------------------
sub FASTCALL switchMusic()
    asm
        di
        push    ix
        ld      a, i            ; check IM2 interrupt to see if music was playing
        rla
        jr      nc, next_track  ; if there was no music, start playing it
        call    62863+8         ; otherwise stop Vortex Tracker player
        ld      a, $3f
        ld      i, a
        im      1               ; disable IM2 interrupt
        pop     ix
        ei
    end asm
end sub

' ------------------------------------------------------------------------------
' If music is playing, then change to next music track.
' ------------------------------------------------------------------------------
sub FASTCALL nextMusicTrack()
    asm
        ld      a, i            ; check IM2 interrupt to see if music was playing
        rla
        ret     nc              ; if there's no music, there's no need to change music track
        di
        push    ix
        call    62863+8         ; stop Vortex Tracker player
next_track:
        ld      hl, (play_track+1)
        inc     hl
        inc     hl              ; next music track
        ld      a, l
        cp      music01ay - (music01ay/256)*256
        jr      nz, store_track
        ld      hl, soundtrack
store_track:
        ld      (play_track+1), hl
play_track:
        ld      hl, (soundtrack-2)
        ld      de, 53535
        ld      (62863+1), de
        call    dzx7_agilercs   ; decompress next music track
        call    62863           ; start Vortex Tracker player
        ld      a, $fe
        ld      i, a            ; enable IM2 interrupt to play music automatically
        im      2
        pop     ix
        ei
    end asm
end sub

' ------------------------------------------------------------------------------
' Check if both keys T+Y were pressed.
'
' Returns:
'   zero if both keys G+H are currently pressed, not zero otherwise.
' ------------------------------------------------------------------------------
function FASTCALL checkRestartKeys() AS UBYTE
    asm
        ld      a, $fd
        in      a, ($fe)
        and     $1f
        xor     $0f
        ret     nz
        ld      a, $bf
        in      a, ($fe)
        and     $1f
        xor     $0f
    end asm
end function

' ------------------------------------------------------------------------------
' Check if both keys T+Y were pressed.
'
' Returns:
'   zero if both keys T+Y are currently pressed, not zero otherwise.
' ------------------------------------------------------------------------------
function FASTCALL checkMusicKeys() AS UBYTE
    asm
        ld      a, $fb
        in      a, ($fe)
        and     $1f
        xor     $0f
        ret     nz
        ld      a, $df
        in      a, ($fe)
        and     $1f
        xor     $0f
    end asm
end function

' ------------------------------------------------------------------------------
' Pause for specified number of frames
'
' Parameters:
'   frames - Specified number of frames to pause (frames > 0)
' ------------------------------------------------------------------------------
sub FASTCALL delay(frames AS UBYTE)
    asm
        ld      b, a
delay_loop:
        halt
        djnz    delay_loop
    end asm
end sub

' ------------------------------------------------------------------------------
' Switch music on/off if keys T+Y were pressed simultaneously.
' ------------------------------------------------------------------------------
sub checkMusic()
    IF NOT checkMusicKeys() THEN
        switchMusic()
        WHILE NOT checkMusicKeys() END WHILE
    END IF
end sub

' ------------------------------------------------------------------------------
' Wait until no keys are pressed.
' ------------------------------------------------------------------------------
sub waitNoKey()
    WHILE INKEY$<>"" OR NOT checkRestartKeys() END WHILE
end sub

' ------------------------------------------------------------------------------
' Wait until a new key is pressed.
' ------------------------------------------------------------------------------
sub waitNewKey()
    waitNoKey()
    WHILE INKEY$="" END WHILE
end sub

' ------------------------------------------------------------------------------
' Read player control keys depending on selected control method.
'
' Parameters:
'   control - Selected control method (1-5)
'
' Returns:
'   Single value representing all pressed keys (1 bit for each possible key)
' ------------------------------------------------------------------------------
function readPlayerKeys(control AS UBYTE) AS UBYTE
    IF control < 4 THEN
        RETURN readkeys() << (3-control)
    ELSE
        RETURN joyControl(control-3) << 2
    END IF
end function

' ------------------------------------------------------------------------------
' Pause for the specified number of frame cycles, unless all directional keys
' are released earlier. This way, if player keeps any directional key pressed,
' the cursor will move at a constant (comfortable) speed. But if player
' releases all directional controls, then press one of them again, then cursor
' will respond instantly.
'
' Parameters:
'   control - Selected control method (1-5)
'   frames - pause duration in frame cycles (1-255)
' ------------------------------------------------------------------------------
sub waitNoDirections(control AS UBYTE, frames AS UBYTE)
    WHILE frames > 0 AND (readPlayerKeys(control) & (KEY_UP | KEY_DOWN | KEY_LEFT | KEY_RIGHT))
        LET frames = frames-1
        asm
            halt
        end asm
    END WHILE
end sub

' ------------------------------------------------------------------------------
' Fill specified memory area with specified value.
'
' Parameters:
'   addr - Initial address of memory area
'   value - Specified value
'   size - Size of memory area (2-65535)
' ------------------------------------------------------------------------------
sub FASTCALL fillMemory(addr AS UINTEGER, value AS UBYTE, size AS UINTEGER)
    asm
        pop     de              ; RET address
        pop     af              ; A=value
        pop     bc              ; BC=size
        push    de              ; restore RET address
        ld      (hl), a
        ld      d, h
        ld      e, l
        inc     de
        dec     bc
        ldir
    end asm
end sub

' ------------------------------------------------------------------------------
' Compare 2 memory areas.
'
' Parameters:
'   size - Size of each memory area (1-255)
'   addr1 - Initial address of 1st memory area
'   addr2 - Initial address of 2nd memory area
'
' Returns:
'   zero if memory areas are identical, not zero otherwise
' ------------------------------------------------------------------------------
function FASTCALL diffMemory(size AS UBYTE, addr1 AS UINTEGER, addr2 AS UINTEGER) AS UBYTE
    asm
        pop     hl              ; RET address
        pop     de              ; DE=addr1
        ex      (sp), hl        ; HL=addr2
        ld      b, a            ; B=size
diff_next:
        ld      a, (de)
        sub     (hl)
        ret     nz
        inc     hl
        inc     de
        djnz    diff_next
    end asm
end function

' ------------------------------------------------------------------------------
' Obtain value of specified bit at specified position from specified table.
'
' Parameters:
'   table - Initial table address (pixel table, cross table, or gallery table)
'   row - row position at table (1 to PIXEL_ROWS)
'         or gallery page (1 to TOTAL_PAGES+1)
'   col - column position at table (1 to PIXEL_COLS)
'         or puzzle index within gallery page (1 to 11)
'
' Returns:
'   Bit value (0 or 1)
' ------------------------------------------------------------------------------
function FASTCALL getBit(table AS UINTEGER, row AS UBYTE, col AS UBYTE) AS UBYTE
    asm
        pop     bc              ; RET address
        pop     de              ; D=row
        pop     af              ; A=col
        push    bc              ; restore RET address
        ld      b, a            ; B=col
        dec     a               ; A=col-1
        sra     a
        sra     a
        sra     a               ; A=(col-1)/8
        dec     d               ; D=row-1
        add     a, d
        add     a, d
        add     a, d            ; A=(row-1)*3+(col-1)/8
        ld      d, 0
        ld      e, a            ; DE=(row-1)*3+(col-1)/8
        add     hl, de          ; HL=table+(row-1)*3+(col-1)/8
        ld      a, (hl)         ; obtain byte
find_next:
        rlca                    ; rotate bit into LSB position
        djnz    find_next
        and     1               ; obtain specified bit only
    end asm
end function

' ------------------------------------------------------------------------------
' Set specified bit at specified position in specified table.
'
' Parameters:
'   table - Initial table address (pixel table, cross table, or gallery table)
'   row - row position at table (1 to PIXEL_ROWS)
'         or gallery page (1 to TOTAL_PAGES+1)
'   col - column position at table (1 to PIXEL_COLS)
'         or puzzle index within gallery page (1 to 11)
' ------------------------------------------------------------------------------
sub FASTCALL setBit(table AS UINTEGER, row AS UBYTE, col AS UBYTE)
    asm
        pop     bc              ; RET address
        pop     de              ; D=row
        pop     af              ; A=col
        push    bc              ; restore RET address
        ld      b, a            ; B=col
        dec     a               ; A=col-1
        sra     a
        sra     a
        sra     a               ; A=(col-1)/8
        dec     d
        add     a, d
        add     a, d
        add     a, d            ; A=(row-1)*3+(col-1)/8
        ld      e, a
        ld      d, 0
        add     hl, de          ; HL=table+(row-1)*3+(col-1)/8
        ld      a, 1
set_next:
        rrca                    ; rotate bit into position
        djnz    set_next
        or      (hl)            ; set bit
        ld      (hl), a
    end asm
end sub

' ------------------------------------------------------------------------------
' Invert value of specified bit at specified position in specified table.
'
' Parameters:
'   table - Initial table address (pixel table, cross table, or gallery table)
'   row - row position at table (1 to PIXEL_ROWS)
'         or gallery page (1 to TOTAL_PAGES+1)
'   col - column position at table (1 to PIXEL_COLS)
'         or puzzle index within gallery page (1 to 11)
' ------------------------------------------------------------------------------
sub FASTCALL invertBit(table AS UINTEGER, row AS UBYTE, col AS UBYTE)
    asm
        pop     bc              ; RET address
        pop     de              ; D=row
        pop     af              ; A=col
        push    bc              ; restore RET address
        ld      b, a            ; B=col
        dec     a               ; A=col-1
        sra     a
        sra     a
        sra     a               ; A=(col-1)/8
        dec     d
        add     a, d
        add     a, d
        add     a, d            ; A=(row-1)*3+(col-1)/8
        ld      e, a
        ld      d, 0
        add     hl, de          ; HL=table+(row-1)*3+(col-1)/8
        ld      a, 1
invert_next:
        rrca                    ; rotate bit into position
        djnz    invert_next
        xor     (hl)            ; invert bit
        ld      (hl), a
    end asm
end sub

' ------------------------------------------------------------------------------
' Calculate height of current puzzle by identifying largest row that contains
' any active pixel.
'
' Parameters:
'   puzzleAddr - Puzzle address
' ------------------------------------------------------------------------------
function findHeight(puzzleAddr AS UINTEGER) AS UBYTE
    DIM row, col as UBYTE
    FOR row=PIXEL_ROWS TO 1 STEP -1
        FOR col=1 TO PIXEL_COLS
            IF getBit(puzzleAddr, row, col) THEN
                RETURN row
            END IF
        NEXT col
    NEXT row
    RETURN 1
end function

' ------------------------------------------------------------------------------
' Calculate width of current puzzle by identifying largest column that contains
' any active pixel.
'
' Parameters:
'   puzzleAddr - Puzzle address
' ------------------------------------------------------------------------------
function findWidth(puzzleAddr AS UINTEGER) AS UBYTE
    DIM row, col as UBYTE
    FOR col=PIXEL_COLS TO 1 STEP -1
        FOR row=1 TO PIXEL_ROWS
            IF getBit(puzzleAddr, row, col) THEN
                RETURN col
            END IF
        NEXT row
    NEXT col
    RETURN 1
end function

' ------------------------------------------------------------------------------
' Count sequences of pixels in specified row of a certain puzzle, storing
' counters at specified address.
'
' Parameters:
'   puzzleAddr - Puzzle address
'   countAddr - Address to store obtained set of counters
'   row - specified puzzle row (1 to PIXEL_ROWS)
' ------------------------------------------------------------------------------
sub countRow(puzzleAddr AS UINTEGER, countAddr AS UINTEGER, row AS UBYTE)
    DIM col AS UBYTE

    fillMemory(countAddr, 0, 11)
    FOR col = width TO 1 STEP -1
        IF getBit(puzzleAddr, row, col) THEN
            POKE countAddr, (PEEK countAddr)+1
        ELSEIF PEEK countAddr THEN
            LET countAddr = countAddr+1
        END IF
    NEXT col
end sub

' ------------------------------------------------------------------------------
' Count sequences of pixels in specified column of a certain puzzle, storing
' counters at specified address.
'
' Parameters:
'   puzzleAddr - Puzzle address
'   countAddr - Address to store obtained set of counters
'   col - specified puzzle column (1 to PIXEL_COLS)
' ------------------------------------------------------------------------------
sub countCol(addr AS UINTEGER, countAddr AS UINTEGER, col AS UBYTE)
    DIM row AS UBYTE

    fillMemory(countAddr, 0, 8)
    FOR row = height TO 1 STEP -1
        IF getBit(addr, row, col) THEN
            POKE countAddr, (PEEK countAddr)+1
        ELSEIF PEEK countAddr THEN
            LET countAddr = countAddr+1
        END IF
    NEXT row
end sub

' ------------------------------------------------------------------------------
' Obtain current state of an specified position at current puzzle board.
'
' Parameters:
'   row - row position at current puzzle board (1 to PIXEL_ROWS)
'   col - column position at current puzzle board (1 to PIXEL_COLS)
'
' Returns:
'   Current position state (see STATE_*)
' ------------------------------------------------------------------------------
function readState(row AS UBYTE, col AS UBYTE) AS UBYTE
    RETURN (getBit(ADDR_CROSS_TABLE, row, col)<<1) + getBit(ADDR_PIXEL_TABLE, row, col)
end function

' ------------------------------------------------------------------------------
' Modify state of an specified position at current puzzle board.
'
' Parameters:
'   row - row position at current puzzle board (1 to PIXEL_ROWS)
'   col - column position at current puzzle board (1 to PIXEL_COLS)
'   prevState - previous state
'   nextState - next state
' ------------------------------------------------------------------------------
sub changeState(row AS UBYTE, col AS UBYTE, prevState AS UBYTE, nextState AS UBYTE)
    DIM x,y AS UBYTE

    IF (prevState bXOR nextState) & 1 THEN
        LET x = 54-((width-col)<<1)
        LET y = 152+((height-row)<<1)
        PLOT INK 7;OVER 1;x,y
        PLOT INK 7;OVER 1;x+1,y
        PLOT INK 7;OVER 1;x,y+1
        PLOT INK 7;OVER 1;x+1,y+1
        invertBit(ADDR_PIXEL_TABLE, row, col)
    END IF
    IF (prevState bXOR nextState) & 2 THEN
        invertBit(ADDR_CROSS_TABLE, row, col)
    END IF
end sub

' ------------------------------------------------------------------------------
' Check if specified position at current puzzle board is "locked", i.e. this
' position state cannot be modified by player.
'
' Parameters:
'   puzzleAddr - Puzzle address
'   row - row position at puzzle board (1 to PIXEL_ROWS)
'   col - column position at puzzle board (1 to PIXEL_COLS)
' ------------------------------------------------------------------------------
function isLocked(puzzleAddr AS UINTEGER, row AS UBYTE, col AS UBYTE) AS UBYTE
    IF puzzleAddr < @page04 THEN
        ' If puzzle doesn't belong to page 4 (bonus), it doesn't have locked positions
        RETURN 0
    ELSE
        ' If puzzle belongs to page 4 (bonus), check its map of locked positions
        RETURN getBit(puzzleAddr+(@page04lock-@page04), row, col)
    END IF
end function

' ------------------------------------------------------------------------------
' Erase lower half of screen, painting it with specified INK color.
'
' Parameters:
'   color - INK color
' ------------------------------------------------------------------------------
sub paintHalfScreen(color AS UBYTE)
    DIM i AS UINTEGER
    PRINT AT 12,0;: FOR i=1 TO 384: PRINT INK color;" ";:NEXT i
end sub

' ------------------------------------------------------------------------------
' Paint specified puzzle in current gallery page with specified attribute.
'
' Parameters:
'   row - row position at current gallery page (0-3)
'   col - column position at current gallery page (0-2)
'   attr - attribute
' ------------------------------------------------------------------------------
sub FASTCALL paintArea(row AS UBYTE, col AS UBYTE, attr AS UBYTE)
    asm
        pop     hl              ; RET address
        pop     bc              ; B = col
        pop     de              ; D = attr
        push    hl              ; restore RET address
        ld      h, a            ; H=row
        ld      l, 0            ; HL=256*row
        sra     a               ; A=row/2
        rr      l               ; AL=128*row
        add     a, h            ; A=3*row/2, AL=3*128*row
        rra                     ; A=3*row/4
        rr      l               ; AL=3*64*row
        add     a, $58          ; AL=$5800+3*64*row
        ld      h, a            ; HL=$5800+3*64*row
        ld      a, b            ; A=col
        add     a, a            ; A=2*col
        add     a, b            ; A=3*col
        add     a, a            ; A=6*col
        add     a, a            ; A=12*col
        sub     b               ; A=11*col
        add     a, l
        ld      l, a            ; HL=$5800+3*64*row+11*col
        ld      a, 6
pa_row:
        ld      bc, 10*256+22
pa_col:
        ld      (hl), d
        inc     hl
        djnz    pa_col
        add     hl, bc
        cp      4
        jr      nz, pa_skip
        res     1, d
pa_skip:
        dec     a
        jr      nz, pa_row
    end asm
end sub

' ------------------------------------------------------------------------------
' Paint main puzzle board area with specified attribute.
'
' Parameters:
'   attr - attribute
' ------------------------------------------------------------------------------
sub FASTCALL paintBoard(attr AS UBYTE)
    asm
        ld      e, a
        ld      hl, $58c8
        ld      c, 18
pb_row:
        ld      b, 24
pb_col:
        ld      a, (hl)
        rrca
        jr      c, pb_skip
        rlca
        and     $c0
        or      e
        ld      (hl), a
pb_skip:
        inc     hl
        djnz    pb_col
        set     3, l
        dec     c
        jr      nz, pb_row
    end asm
end sub

' ------------------------------------------------------------------------------
' Paint a single row of sequence counters at left side of puzzle board.
'
' Parameters:
'   row - row position in puzzle board (1 to PIXEL_ROWS)
'   highlight -
'   diff - flag indicating if sequence counters match current board content
'          (zero for match, not zero for mismatch)
' ------------------------------------------------------------------------------
sub FASTCALL paintRow(row AS UBYTE, highlight AS UBYTE, diff AS UBYTE)
    asm
        pop     de              ; RET address
        pop     bc              ; B=highlight
        add     a, 5            ; A=row+5
        ld      c, a
        rlca                    ; A=(row+5)*2
        rlca                    ; A=(row+5)*4
        rlca                    ; A=(row+5)*8
        ld      h, $16
        ld      l, a            ; HL=$1600+(row+5)*8
        add     hl, hl          ; HL=$2c00+(row+5)*16
        add     hl, hl          ; HL=$5800+(row+5)*32
        pop     af              ; A=diff
        push    de
        and     a               ; diff?
        ld      a, 1
        jr      z, pr_equal
        ld      a, b
        and     3               ; highlight?
        jr      nz, pr_equal
        ld      a, c
        and     1
        add     a, 5
pr_equal:
        ld      b, 8
pr_loop:
        ld      (hl), a
        inc     l
        djnz    pr_loop
    end asm
end sub

' ------------------------------------------------------------------------------
' Paint a single column of sequence counters above puzzle board.
'
' Parameters:
'   col - column position in puzzle board (1 to PIXEL_COLS)
'   highlight -
'   diff - flag indicating if sequence counters match current board content
'          (zero for match, not zero for mismatch)
' ------------------------------------------------------------------------------
sub FASTCALL paintCol(col AS UBYTE, highlight AS UBYTE, diff AS UBYTE)
    asm
        pop     de              ; RET address
        pop     bc              ; B=highlight
        add     a, 7            ; A=col+7
        ld      h, $58
        ld      l, a            ; HL=$5800+(col+7)
        pop     af              ; A=diff
        push    de
        and     a               ; diff?
        ld      a, 1
        jr      z, pc_equal
        ld      a, b
        and     3               ; highlight?
        jr      nz, pc_equal
        ld      a, l
        and     1
        add     a, 5
pc_equal:
        ld      de, 32
        ld      b, 6
pc_loop:
        ld      (hl), a
        add     hl, de
        djnz    pc_loop
    end asm
end sub

' ------------------------------------------------------------------------------
' Hide unsolved puzzle image from current gallery page, replacing its area with
' a generic rectangle.
'
' Parameters:
'   row - row position at current gallery page (0-3)
'   col - column position at current gallery page (0-2)
' ------------------------------------------------------------------------------
sub hideArea(row AS UBYTE, col AS UBYTE)
    DIM r AS UBYTE
    DIM c AS UBYTE

    LET r = row*6
    LET c = col*11
    PRINT AT r,c;"          ";AT r+1,c;"          ";AT r+2,c;"   \#148\#149\#149\#150   ";_
          AT r+3,c;"   \#148__\#150   ";AT r+4,c;"          ";AT r+5,c;"          ";
end sub

' ------------------------------------------------------------------------------
' Print single character using FZX.
'
' Parameters:
'   ch - character code
' ------------------------------------------------------------------------------
sub FASTCALL printFZX(ch AS UBYTE)
    asm
        push ix
        call 65288+34
        pop ix
    end asm
end sub

' ------------------------------------------------------------------------------
' Print message (marked with terminator value 255) using FZX.
'
' Parameters:
'   msg - message adddress
' ------------------------------------------------------------------------------
sub printMessage(msg AS UINTEGER)
    WHILE (PEEK msg) <> 255
        printFZX(PEEK msg)
        LET msg = msg+1
    END WHILE
end sub

' ------------------------------------------------------------------------------
' Print specified key using FZX.
'
' Parameters:
'   key - key code
' ------------------------------------------------------------------------------
sub printKey(key AS UBYTE)
    IF key = $0d THEN
        printMessage(@entermsg)
    ELSEIF key = $20 THEN
        printMessage(@spacemsg)
    ELSEIF key = $0e THEN
        printMessage(@symbolmsg)
    ELSEIF key = $e3 THEN
        printMessage(@capsmsg)
    ELSEIF key >= CODE "a" AND key <= CODE "z" THEN
        printFZX(key-(CODE "a"-CODE "A"))
    ELSE
        printFZX(key)
    END IF
end sub

' ------------------------------------------------------------------------------
' Update specified position in puzzle board according to its current state and
' cursor position
'
' Parameters:
'   puzzleAddr - Puzzle address
'   row - row position in puzzle board (1 to PIXEL_ROWS)
'   col - column position in puzzle board (1 to PIXEL_COLS)
'   cursor - flag indicating if cursor is located at this position (0 or 1)
' ------------------------------------------------------------------------------
sub printPos(puzzleAddr AS UINTEGER, row AS UBYTE, col AS UBYTE, cursor AS UBYTE)
    DIM state AS UBYTE
    DIM ch AS UBYTE
    DIM i AS UBYTE

    IF isLocked(puzzleAddr, row, col) THEN
        LET ch = 147
        LET i = 4
    ELSE
        LET state = readState(row, col)
        IF state=STATE_BLANK AND (row=1 OR col=1) THEN
            LET ch = 144
        ELSE
            LET ch = 145+state
        END IF
        IF cursor THEN
            LET i = 3
        ELSE
            LET i = (4+3*state)&7
        END IF
    END IF
    PRINT AT row+5,col+7;INK i; PAPER cursor; BRIGHT (((row-1)>>3) bXOR ((col-1)>>3))&1; CHR$(ch);
end sub

' ------------------------------------------------------------------------------
' Local variables, used by main program only
' ------------------------------------------------------------------------------

    ' Default player keys
    DIM keys(0 TO 6) AS UBYTE => { CODE "o", CODE "p", CODE "a", CODE "q", CODE "m", CODE "n", CODE "1" }

    ' Table of solved puzzles in gallery (3 bytes per gallery page, 1 bit per puzzle)
    DIM gTable(0 TO 3*TOTAL_PAGES-1) AS UBYTE => { 8, 0, 0, _
                                                   8, 0, 0, _
                                                   8, 0, 0, _
                                                   8, 0, 0, _
                                                   8, 0, 0 }
    ' Main menu variables
    DIM control AS UBYTE                ' Currently selected control method (1-5)

    ' Gallery variables
    DIM gPage AS UBYTE = 0              ' Current gallery page (0-4)
    DIM gRow AS UBYTE = 0               ' Cursor row position at gallery page (0-3)
    DIM gCol AS UBYTE = 1               ' Cursor column position at gallery page (0-2)
    DIM newTrack AS UBYTE = 0           ' Flag to indicate if game must play new music track (0-1)

    ' Puzzle board variables
    DIM countAddr AS UINTEGER           ' Row or column counting address
    DIM puzzleAddr AS UINTEGER          ' Current puzzle memory address
    DIM pRow AS UBYTE                   ' Current row position at puzzle board (1 to PIXEL_ROWS)
    DIM pCol AS UBYTE                   ' Current column position at puzzle board (1 to PIXEL_COLS)
    DIM state AS UBYTE                  ' Current cursor position state (see STATE_*)
    DIM action AS UBYTE                 ' Current cursor action (see ACTION_*)

    ' Generic variables
    DIM k AS UBYTE                      ' Input key
    DIM row2 AS UBYTE                   ' Next row position
    DIM col2 AS UBYTE                   ' Next column position
    DIM updated AS UBYTE                ' Flag to indicate if cursor position has changed (0 or 1)

' ------------------------------------------------------------------------------
' Main program
' ------------------------------------------------------------------------------

    ' Initialize game
10  BORDER 0
    POKE UINTEGER 23675, @boardchr

    ' Play music at loading screen until pressed key
    switchMusic()
    waitNewKey()

    ' Play next music track
20  nextMusicTrack()
    INK 0: PAPER 0: BRIGHT 0: FLASH 0: CLS
    POKE UINTEGER (65288+60), @fontfzx

    ' Display initial credits and wait until pressed key
    dzx7AgileRCS(@introscr, 16384)
    waitNewKey()

    ' Display control menu
    paintHalfScreen(4)
    printMessage(@menumsg)
    waitNoKey()

    ' Wait until player chooses valid control option
    DO

        ' Repeatedly check restart and music keys
        IF NOT checkRestartKeys() THEN GOTO 20: END IF
        checkMusic()

        ' Read player control option
        LET control = CODE INKEY$-CODE "0"
    LOOP UNTIL control >= 1 AND control <= 5

    ' If player selected a keyboard control method, then show and allow redefining keys
    IF control < 4 THEN

        ' Only display keys at first iteration
        LET k = 255
        DO

            ' If first iteration or redefining keys, then show each key on screen
            IF k=255 OR k=CODE "y" THEN
                paintHalfScreen(5)
                initkeys(control+4)

                ' For each control key
                FOR f=0 TO control+3

                    ' Position cursor on screen
                    printFZX(22)
                    printFZX(106+f*10)
                    printFZX(86)

                    ' Print control key name
                    IF control = 1 AND f = 4 THEN
                        ' Single fire has generic name "FIRE"
                        printMessage(@keyboardmsg+(7<<3))
                    ELSE
                        ' Otherwise each control key has a special name
                        printMessage(@keyboardmsg+(f<<3))
                    END IF

                    ' Pring separator
                    POKE @separatormsg+1,106+f*10
                    printMessage(@separatormsg)

                    ' If redefining key, then read player key
                    IF k=CODE "y" THEN
                        keys(f)=defkey()
                    END IF

                    ' Print currently selected key
                    printKey(keys(f))
                NEXT f

                ' Print "REDEFINE KEYS? Y-N"
                printMessage(@redefmsg)
            END IF

            ' Repeatedly check restart and music keys
            IF NOT checkRestartKeys() THEN GOTO 20: END IF
            checkMusic()

            ' Read player answer
            LET k = CODE INKEY$

        ' Repeat until player doesn't want to redefine keys anymore
        LOOP UNTIL k=CODE "n"
    END IF

    DO
        DO
            ' Show current gallery page
            CLS
            dzx7AgileRCS(PEEK (UINTEGER, @gallery+(gPage<<1)), 16384)

            ' Hide unsolved puzzles
            FOR f=0 TO 3
                FOR g=0 TO 2
                    IF NOT getBit(@gTable(0), gPage+1, f+(g<<2)+1) THEN
                        hideArea(f, g)
                    END IF
                    paintArea(f, g, 7)
                NEXT g
            NEXT f

            ' If player has just returned from puzzle board screen, then play another music track
            IF newTrack THEN
                nextMusicTrack()
                LET newTrack = 0
            END IF
            waitNoKey()

            ' Choose puzzle at current gallery screen
            LET updated = 1
            LET row2 = gRow
            LET col2 = gCol
            DO
                ' If first time or cursor moved, then update cursor position
                IF updated THEN
                    paintArea(gRow, gCol, 7)
                    LET gRow = row2
                    LET gCol = col2
                    paintArea(gRow, gCol, 7+8)
                    waitNoDirections(control, 10)
                    LET updated = 0
                END IF

                ' Repeatedly check restart and music keys
                IF NOT checkRestartKeys() THEN GOTO 20: END IF
                checkMusic()

                ' Move cursor
                LET k = readPlayerKeys(control)
                IF (k & KEY_UP)    AND gRow<>0 THEN LET row2 = row2-1: LET updated = 1: END IF
                IF (k & KEY_DOWN)  AND gRow<>3 THEN LET row2 = row2+1: LET updated = 1: END IF
                IF (k & KEY_LEFT)  AND gCol<>0 THEN LET col2 = col2-1: LET updated = 1: END IF
                IF (k & KEY_RIGHT) AND gCol<>2 THEN LET col2 = col2+1: LET updated = 1: END IF

            ' Repeat until any fire key is pressed
            LOOP UNTIL NOT updated AND (k & (KEY_ENABLE | KEY_DISABLE | KEY_CLEAR))

            ' If gallery page title was selected, then move to next page
            IF gRow=0 AND gCol=1 THEN
                LET gPage = gPage+1
                IF gPage = TOTAL_PAGES THEN
                    LET gPage = 0
                END IF
            ' Otherwise prepare to play selected puzzle
            ELSE
                EXIT DO
            END IF
        LOOP

        ' Calculate selected puzzle address (11 puzzles per gallery page, excluding gallery page title)
        LET puzzleAddr = @page00 + CAST(UINTEGER, SPRITESIZE)*(11*gPage + 3*gRow + gCol)
        IF gRow<>0 OR gCol<>0 THEN
            LET puzzleAddr = puzzleAddr - SPRITESIZE
        END IF

        ' Initialize puzzle board
        CLS
        POKE UINTEGER (65288+60), @microfzx
        fillMemory(ADDR_PIXEL_TABLE, 0, 2*SPRITESIZE)

        ' Calculate puzzle board size
        LET height = findHeight(puzzleAddr)
        LET width = findWidth(puzzleAddr)

        ' Calculate and display sequences of counters in all columns above puzzle board
        LET countAddr = ADDR_COUNT_ROWS
        LET pCol = 59
        FOR g = 1 TO width
            countCol(puzzleAddr, countAddr, g)
            LET pCol = pCol+8
            LET pRow = 42
            FOR f=0 TO 7
                LET k = PEEK countAddr
                IF k OR f=0 THEN
                    printFZX(22)
                    printFZX(pRow)
                    IF k > 9 THEN
                        printFZX(pCol-2)
                        printFZX(CODE "0"+INT(k/10))
                    ELSE
                        printFZX(pCol)
                    END IF
                    printFZX(CODE "0"+(k MOD 10))
                    LET pRow = pRow-6
                END IF
                LET countAddr = countAddr+1
            NEXT f
        NEXT g

        ' Calculate and display sequences of counters in all rows at left side of puzzle board
        LET countAddr = ADDR_COUNT_COLS
        LET pRow = 42
        FOR f=1 TO height
            countRow(puzzleAddr, countAddr, f)
            LET pRow = pRow+8
            LET pCol = 62
            FOR g = 0 TO 10
                LET k = PEEK countAddr
                IF k OR g=0 THEN
                    printFZX(22)
                    printFZX(pRow)
                    IF k > 9 THEN
                        printFZX(pCol-6)
                        printFZX(CODE "0"+INT (k/10))
                        LET pCol = pCol-4
                    ELSE
                        printFZX(pCol-2)
                    END IF
                    printFZX(CODE "0"+(k MOD 10))
                    IF pCol < 58 THEN
                        printFZX(CODE ".")
                    END IF
                    LET pCol = pCol-6
                END IF
                LET countAddr = countAddr+1
            NEXT g
        NEXT f

        ' Show puzzle board and counters
        FOR g=1 TO width
            paintCol(g, g=1, PEEK (ADDR_COUNT_ROWS-8+8*g))
        NEXT g
        FOR f=1 TO height
            paintRow(f, f=1, PEEK (ADDR_COUNT_COLS-11+11*f))
            FOR g=1 TO width
                printPos(puzzleAddr, f, g, 0)
            NEXT g
        NEXT f

        ' Play current puzzle
        LET action = ACTION_INVALID
        LET row2 = 1
        LET col2 = 1
        LET updated = 1
        DO
            ' If cursor moved or modified board, then update next cursor position
            IF updated THEN
                LET pRow = row2
                LET pCol = col2
                printPos(puzzleAddr, pRow, pCol, 1)
                waitNoDirections(control, 10)
                LET updated = 0
            END IF

            ' Repeatedly check restart and music keys
            IF NOT checkRestartKeys() THEN GOTO 30: END IF
            checkMusic()

            ' Move cursor
            LET k = readPlayerKeys(control)
            IF (k & KEY_UP)    AND pRow>1      THEN LET row2 = row2-1: LET updated = 1: END IF
            IF (k & KEY_DOWN)  AND pRow<height THEN LET row2 = row2+1: LET updated = 1: END IF
            IF (k & KEY_LEFT)  AND pCol>1      THEN LET col2 = col2-1: LET updated = 1: END IF
            IF (k & KEY_RIGHT) AND pCol<width  THEN LET col2 = col2+1: LET updated = 1: END IF
            LET k = k & (KEY_ENABLE | KEY_DISABLE | KEY_CLEAR)

            ' Process fire keys
            LET state = readState(row2, col2)
            IF k=0 THEN
                ' No fire keys are currently pressed
                LET action = ACTION_NONE
            ELSEIF NOT isLocked(puzzleAddr, row2, col2) THEN
                ' Process control method with 2 fire keys
                IF control = 2 THEN
                    IF k=KEY_ENABLE THEN
                        IF action = ACTION_NONE THEN
                            IF state=STATE_CROSS THEN
                                LET action = ACTION_UNRESET
                            ELSE
                                LET action = ACTION_SET
                            END IF
                        ELSEIF action = ACTION_RESET OR action = ACTION_UNSET THEN
                            LET action = ACTION_INVALID
                        END IF
                    ELSEIF k=KEY_DISABLE THEN
                        IF action = ACTION_NONE THEN
                            IF state=STATE_PIXEL THEN
                                LET action = ACTION_UNSET
                            ELSE
                                LET action = ACTION_RESET
                            END IF
                        ELSEIF action = ACTION_SET OR action = ACTION_UNRESET THEN
                            LET action = ACTION_INVALID
                        END IF
                    ELSE
                        LET action = ACTION_INVALID
                    END IF
                ' Process control method with 3 fire keys
                ELSEIF control = 3 THEN
                    IF k=KEY_ENABLE THEN
                        LET action = ACTION_ENABLE
                    ELSEIF k=KEY_DISABLE THEN
                        LET action = ACTION_DISABLE
                    ELSEIF k=KEY_CLEAR THEN
                        LET action = ACTION_CLEAR
                    ELSE
                        LET action = ACTION_INVALID
                    END IF
                ' Process control method with 1 fire key
                ELSE
                    IF action = ACTION_NONE THEN
                        IF state=STATE_PIXEL THEN
                            LET action = ACTION_DISABLE
                        ELSEIF state=STATE_CROSS THEN
                            LET action = ACTION_CLEAR
                        ELSE
                            LET action = ACTION_ENABLE
                        END IF
                    END IF
                END IF

                ' Modify puzzle board according to currently pressed fire keys
                IF (action = ACTION_SET AND state = STATE_BLANK) OR _
                   (action = ACTION_ENABLE AND state <> STATE_PIXEL) THEN
                    changeState(row2, col2, state, STATE_PIXEL)
                    LET updated = 1
                ELSEIF (action = ACTION_RESET AND state = STATE_BLANK) OR _
                       (action = ACTION_DISABLE AND state <> STATE_CROSS) THEN
                    changeState(row2, col2, state, STATE_CROSS)
                    LET updated = 1
                ELSEIF (action = ACTION_UNSET AND state = STATE_PIXEL) OR _
                       (action = ACTION_UNRESET AND state = STATE_CROSS) OR _
                       (action = ACTION_CLEAR AND state <> STATE_BLANK) THEN
                    changeState(row2, col2, state, STATE_BLANK)
                    LET updated = 1
                END IF
            END IF

            ' If cursor moved or modified board, then update previous cursor position
            IF updated THEN
                printPos(puzzleAddr, pRow, pCol, 0)
                IF pCol <> col2 THEN
                    countCol(ADDR_PIXEL_TABLE, ADDR_TMP_COUNT, pCol)
                    paintCol(pCol, 0, diffMemory(8, ADDR_TMP_COUNT, ADDR_COUNT_ROWS-8+8*pCol))
                END IF
                IF pRow <> row2 THEN
                    countRow(ADDR_PIXEL_TABLE, ADDR_TMP_COUNT, pRow)
                    paintRow(pRow, 0, diffMemory(11, ADDR_TMP_COUNT, ADDR_COUNT_COLS-11+11*pRow))
                END IF
                countCol(ADDR_PIXEL_TABLE, ADDR_TMP_COUNT, col2)
                paintCol(col2, 255, diffMemory(8, ADDR_TMP_COUNT, ADDR_COUNT_ROWS-8+8*col2))
                countRow(ADDR_PIXEL_TABLE, ADDR_TMP_COUNT, row2)
                paintRow(row2, 255, diffMemory(11, ADDR_TMP_COUNT, ADDR_COUNT_COLS-11+11*row2))
            END IF

        ' Repeat until player solves current puzzle
        LOOP UNTIL NOT diffMemory(SPRITESIZE, ADDR_PIXEL_TABLE, puzzleAddr)

        ' Update last modified position on screen
        printPos(puzzleAddr, row2, col2, 0)

        ' Mark current puzzle as solved
        setBit(@gTable(0), gPage+1, gRow+(gCol<<2)+1)

        ' Change puzzle board color to indicate success
        paintBoard(3)

        ' Small delay to ensure player noticed that puzzle is solved
        waitNoKey()
        delay(50)
        waitNewKey()

        ' Back to gallery screen and play next music track
30      LET newTrack = 1
    LOOP
