#define ORG .org
#define END .end
#define EQU .equ
#define DB  .db
#define DW  .dw
#define DS  .ds

#define N 100
#define LEN (10*N/3)
#define BUF 800h
#define EXIT $
#define PRINTC 0F809h

	ORG 0FCh

	DB 1,0,_END>>8,_END&0FFh

	LXI H,PISTR
	CALL PRINTS
	LXI B,LEN ; for(j=0;j<LEN;j++) a[j]=2;
	LXI H,BUF
L1:	MVI M,2
	INX H
	MVI M,0
	INX H
	DCX B
	MOV A,B
	ORA C
	JNZ L1
	STA NINES ; NINES = 0;
	DCR A
	STA DIGIT ; DIGIT = -1;
	STA DOT   ; DOT = true;
	LXI B,N	  ; for(j=0;j<N;j++) {
L2:     PUSH B
	LXI D,0   ; q=0
	LXI B,LEN ; for(i=LEN;i;i--) {
	LXI H,LEN*2-1+BUF
L3:	PUSH B
	PUSH H
		; x = 10*a[i-1] + q * i;
	CALL MUL  ; q*i
	XTHL
	MOV D,M
	DCX H
	MOV E,M
	INX H
	XTHL
	PUSH H
	xchg
	dad h
	mov d,h
	mov e,l
	dad h
	dad h
	dad d	; 10*a[i-1]
	POP D
	DAD D
	MOV B,H   ; a[i-1] = x % (2*i-1);
	MOV C,L
	POP D
	POP H
	PUSH H
	PUSH D
	DAD H
	DCX H     ; 2*i-1
	CALL DIV  ; q = x / (2*i-1);
	POP H
	MOV M,B
	DCX H
	MOV M,C
	DCX H
	POP B
	DCX B
	MOV A,B
	ORA C
	JNZ L3    ; }
	MOV B,D
	MOV C,E
	LXI H,10  ; a[0] = q % 10; q = q / 10;
	CALL DIV
	LXI H,BUF
	MOV M,C
	INX H
	MOV M,B
	MOV A,E   ; if (q==9) nines++;
	CPI 9
	JNZ L4
	LXI H,NINES
	INR M
	JMP L6
L4:	CPI 10      ; else if (q==10) {
	JNZ L5
	LDA DIGIT   ; printf("%d", predigit+1);
	INR A
	CALL PRINT
	XRA A       ; predigit = 0;
	STA DIGIT
	MVI C,'0'   ; for(;nines;nines--) printf("0");
	CALL PNCHAR
	JMP L6      ; } else {
L5:	LDA DIGIT   ; printf(j==0?"":j==1?"%d.":"%d", predigit);
	RLC
	JC L7
	CALL PDIGIT
	LDA DOT
	ORA A
	JZ L7
	XRA A
	STA DOT
	MVI C,'.'
	CALL PRINTC
L7:	MOV A,E     ; predigit = q;
	STA DIGIT
	MVI C,'9'   ; for(;nines;nines--) printf("9");
	CALL PNCHAR
L6:	POP B       ; }
	DCX B
	MOV A,B
	ORA C
	JNZ L2      ; }
	CALL PDIGIT ; printf("%d\n", predigit);
	LXI H,OKSTR
	CALL PRINTS
	JMP EXIT

PDIGIT:	LDA DIGIT
PRINT:	ADI 30h
	MOV C,A
	JMP PRINTC

PNCHAR:	LXI H,NINES
	INR M
PNCH1:	DCR M
	RZ
	CALL PRINTC
	JMP PNCH1

PRINTS:	MOV A,M
	INX H
	ORA A
	RZ
	MOV C,A
	CALL PRINTC
	JMP PRINTS


; HL=BC*DE
MUL:
	xra	a
	ora	b
        lxi     h,0
	mov	a,c
	jz	MUL2
	mov	a,e
	mov	d,b
	mov	e,c
MUL2:
	add a\ jnc $+4 \ dad d
	dad h\ add a\ jnc $+4 \ dad d
	dad h\ add a\ jnc $+4 \ dad d
	dad h\ add a\ jnc $+4 \ dad d
	dad h\ add a\ jnc $+4 \ dad d
	dad h\ add a\ jnc $+4 \ dad d
	dad h\ add a\ jnc $+4 \ dad d
	dad h\ add a\ rnc \ dad d
        ret

DIV:
; DE = BC/HL, BC=BC%HL
	push h
	mov a,l
	cma
	adi 1
	mov d,a
	mov a,h
	mov h,c
	cma
	mvi e,0
	adc e
	mov c,a
	mov a,b
	mov b,c
	mov l,e
	mvi c,-1
DIV2:
	inr c
	dad d
	adc b
	jp DIV2
	mov d,e
	mov e,c
	mov l,h
	mov h,a
	pop b
	dad b
	mov b,h
	mov c,l
	ret



PISTR:	DB 13,10,"PI=",0
OKSTR:	DB 13,10,"OK",13,10,0

DIGIT:	DB 0
NINES:	DB 0
DOT:	DB 0

_END:	DB 0,0,0E6h,68h,0F5h

	END

