/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public class Qaop
extends Applet
implements KeyListener,
FocusListener,
ComponentListener,
Runnable {
    protected Spectrum spectrum;
    private Loader loader;
    private Image img;
    private Dimension size;
    private int posx;
    private int posy;
    static final String[][] info = new String[][]{{"rom", "filename", "alternative ROM image"}, {"if1rom", "filename", "enable Interface1, use this as it's ROM"}, {"tape", "filename", "tape file"}, {"load", "filename", "snapshot or tape to load"}, {"focus", "yes/no", "grab focus on start"}, {"arrows", "keys", "define arrow keys"}};
    private Image dl_image;
    private InputStream dl_input;
    private int dl_kind;
    private boolean dl_gz;

    public synchronized void init() {
        InputStream inputstream;
        String s;
        this.showStatus(this.getAppletInfo());
        this.spectrum = new Spectrum();
        this.addKeyListener(this);
        this.addFocusListener(this);
        if (this.param("focus", true)) {
            this.addComponentListener(this);
        }
        if ((s = this.getParameter("rom")) == null && ((inputstream = this.resource("spectrum.rom")) == null || Qaop.tomem(this.spectrum.rom48k, 0, 16384, inputstream) != 0)) {
            this.showStatus("Can't read spectrum.rom");
        }
        this.loader = new Loader(this, s, this.getParameter("if1rom"));
        this.loader.load(this.getParameter("load"));
        this.loader.tape(this.getParameter("tape"));
        String s1 = this.getParameter("arrows");
        if (s1 != null) {
            this.spectrum.setArrows(s1);
        }
        this.spectrum.start();
        Thread.yield();
        this.loader.start();
    }

    public synchronized void destroy() {
        this.spectrum.interrupt();
        this.loader.interrupt();
    }

    public String getAppletInfo() {
        return "Qaop - ZX Spectrum emulator by Jan Bobrowski";
    }

    public String[][] getParameterInfo() {
        return info;
    }

    public Dimension getPreferredSize() {
        return new Dimension(352, 288);
    }

    public synchronized void reset() {
        this.spectrum.reset();
    }

    public void load(String s) {
        if (this.loader != null) {
            this.loader.load(s);
        }
    }

    public void tape(String s) {
        if (this.loader != null) {
            this.loader.tape(s);
        }
    }

    public void focus() {
        this.requestFocus();
    }

    private void resized(Dimension dimension) {
        this.size = dimension;
        byte byte0 = (byte)(dimension.width < 512 || dimension.height < 384 ? 1 : 2);
        if (this.spectrum.scale() != byte0) {
            this.img = null;
            this.spectrum.scale(byte0);
            this.img = this.createImage(this.spectrum);
        }
        this.posx = (dimension.width - this.spectrum.width) / 2;
        this.posy = (dimension.height - this.spectrum.height) / 2;
        this.dl_image = null;
        this.loader.reshape(dimension);
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public synchronized void update(Graphics g) {
        Dimension dimension = this.getSize();
        if (!dimension.equals(this.size)) {
            this.resized(dimension);
        }
        if (this.loader.flength > 0) {
            this.paint_dl(g);
            return;
        }
        g.drawImage(this.img, this.posx, this.posy, this);
    }

    private void paint_dl(Graphics g) {
        int i = this.posx;
        int j = this.posy;
        int k = this.spectrum.width;
        int l = this.spectrum.height;
        if (this.dl_image == null) {
            this.dl_image = this.createImage(k, l);
        }
        Graphics g1 = this.dl_image.getGraphics();
        g1.drawImage(this.img, 0, 0, this);
        g1.translate(this.loader.x - i, this.loader.y - j);
        this.loader.paint(g1);
        g1.dispose();
        g.drawImage(this.dl_image, i, j, null);
    }

    public boolean imageUpdate(Image image, int i, int j, int k, int l, int i1) {
        if ((i & 0x10) != 0) {
            this.repaint(this.posx + j, this.posy + k, l, i1);
            return true;
        }
        if ((i & 0xFFFFFFF7) == 0) {
            return true;
        }
        return super.imageUpdate(image, i, j, k, l, i1);
    }

    public void keyTyped(KeyEvent keyevent) {
    }

    public void keyPressed(KeyEvent keyevent) {
        int i = keyevent.getKeyCode();
        if (i == 127 && keyevent.isControlDown()) {
            this.spectrum.reset();
        } else if (i == 122) {
            boolean flag = !this.spectrum.audio.muted();
            this.spectrum.audio.mute(flag);
            this.showStatus("Sound " + (flag ? "off" : "on"));
        } else if (i == 33 || i == 34) {
            int j = this.spectrum.audio.volumeChg(i != 33 ? -10 : 10);
            this.showStatus("Volume: " + j + "%" + (this.spectrum.audio.muted() ? " MUTED" : ""));
        } else {
            this.keyEvent(keyevent);
        }
    }

    public void keyReleased(KeyEvent keyevent) {
        this.keyEvent(keyevent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keyEvent(KeyEvent keyevent) {
        KeyEvent[] akeyevent = this.spectrum.keys;
        int i = keyevent.getKeyCode();
        int j = -1;
        KeyEvent[] keyEventArray = akeyevent;
        synchronized (akeyevent) {
            int k = 0;
            while (k < akeyevent.length) {
                if (akeyevent[k] == null) {
                    j = k;
                } else {
                    int l = akeyevent[k].getKeyCode();
                    if (l == i) {
                        j = k;
                        break;
                    }
                }
                ++k;
            }
            if (j >= 0) {
                akeyevent[j] = keyevent.getID() != 401 ? null : keyevent;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void focusGained(FocusEvent focusevent) {
        this.showStatus(this.getAppletInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusLost(FocusEvent focusevent) {
        KeyEvent[] akeyevent;
        KeyEvent[] keyEventArray = akeyevent = this.spectrum.keys;
        synchronized (akeyevent) {
            int i = 0;
            while (i < akeyevent.length) {
                akeyevent[i] = null;
                ++i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void componentResized(ComponentEvent componentevent) {
    }

    public void componentMoved(ComponentEvent componentevent) {
    }

    public void componentHidden(ComponentEvent componentevent) {
    }

    public void componentShown(ComponentEvent componentevent) {
        this.removeComponentListener(this);
        this.requestFocus();
    }

    boolean param(String s, boolean flag) {
        String s1 = this.getParameter(s);
        if (s1 == null || s1.length() == 0) {
            return flag;
        }
        char c = Character.toUpperCase(s1.charAt(0));
        return c != 'N' && c != 'F' && c != '0';
    }

    private final InputStream resource(String s) {
        return this.getClass().getResourceAsStream(s);
    }

    private static int tomem(int[] ai, int i, int j, InputStream inputstream) {
        do {
            try {
                int k = inputstream.read();
                if (k < 0) break;
                ai[i++] = k;
            }
            catch (IOException iOException) {
                break;
            }
        } while (--j > 0);
        return j;
    }

    protected URL url_of_file(String s) {
        if (s != null) {
            try {
                return new URL(this.getDocumentBase(), s);
            }
            catch (MalformedURLException malformedurlexception) {
                this.showStatus(malformedurlexception.toString());
                System.out.println(malformedurlexception);
            }
        }
        return null;
    }

    protected void do_load(InputStream inputstream, int i, boolean flag) {
        this.dl_input = inputstream;
        this.dl_kind = i;
        this.dl_gz = flag;
    }

    public void run() {
        InputStream obj = this.dl_input;
        this.dl_input = null;
        try {
            if (this.dl_gz) {
                obj = new GZIPInputStream(obj);
            }
            switch (this.dl_kind) {
                case 3: {
                    this.load_tape(obj);
                    break;
                }
                case 4: {
                    this.load_sna(obj);
                    break;
                }
                case 5: {
                    this.load_z80(obj);
                    break;
                }
                case 16386: {
                    this.spectrum.reset();
                }
                default: {
                    this.load_rom(obj, this.dl_kind);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void load_rom(InputStream inputstream, int i) throws IOException {
        int[] ai = new int[32768];
        if (Qaop.tomem(ai, 0, i & 0xFFF0, inputstream) != 0) {
            this.showStatus("Rom image truncated");
            return;
        }
        if (i == 8193) {
            System.arraycopy(ai, 0, ai, 16384, 16384);
            this.spectrum.if1rom = ai;
            return;
        }
        if (i == 16384) {
            this.spectrum.rom48k = ai;
        }
        this.spectrum.rom = ai;
    }

    private void load_tape(InputStream inputstream) {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        byte[] abyte0 = new byte[1024];
        byte[] abyte1 = null;
        try {
            int i;
            while ((i = inputstream.read(abyte0)) > 0) {
                bytearrayoutputstream.write(abyte0, 0, i);
                abyte1 = bytearrayoutputstream.toByteArray();
                this.spectrum.tape(abyte1, false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (abyte1 != null) {
            this.spectrum.tape(abyte1, true);
        }
    }

    private static int get8(DataInputStream datainputstream) throws IOException {
        return datainputstream.readUnsignedByte();
    }

    private static int get16(DataInputStream datainputstream) throws IOException {
        int i = datainputstream.readUnsignedByte();
        return i | datainputstream.readUnsignedByte() << 8;
    }

    private void poke_stream(DataInputStream datainputstream, int i, int j) throws IOException {
        do {
            this.spectrum.mem(i++, Qaop.get8(datainputstream));
        } while (--j > 0);
    }

    private void load_sna(InputStream inputstream) throws IOException {
        DataInputStream datainputstream = new DataInputStream(inputstream);
        this.spectrum.reset();
        Z80 z80 = this.spectrum.cpu;
        z80.i(Qaop.get8(datainputstream));
        z80.hl(Qaop.get16(datainputstream));
        z80.de(Qaop.get16(datainputstream));
        z80.bc(Qaop.get16(datainputstream));
        z80.af(Qaop.get16(datainputstream));
        z80.exx();
        z80.ex_af();
        z80.hl(Qaop.get16(datainputstream));
        z80.de(Qaop.get16(datainputstream));
        z80.bc(Qaop.get16(datainputstream));
        z80.iy(Qaop.get16(datainputstream));
        z80.ix(Qaop.get16(datainputstream));
        z80.ei(Qaop.get8(datainputstream) != 0);
        z80.r(Qaop.get8(datainputstream));
        z80.af(Qaop.get16(datainputstream));
        z80.sp(Qaop.get16(datainputstream));
        z80.im(Qaop.get8(datainputstream));
        this.spectrum.out(254, Qaop.get8(datainputstream));
        this.poke_stream(datainputstream, 16384, 49152);
        try {
            z80.pc(Qaop.get16(datainputstream));
            System.out.println("Is it 128K .SNA?");
        }
        catch (EOFException eofexception) {
            int i = z80.sp();
            z80.pc(this.spectrum.mem16(i));
            z80.sp((char)(i + 2));
            this.spectrum.mem16(i, 0);
        }
    }

    private void load_z80(InputStream inputstream) throws IOException {
        DataInputStream datainputstream = new DataInputStream(inputstream);
        this.spectrum.reset();
        Z80 z80 = this.spectrum.cpu;
        z80.a(Qaop.get8(datainputstream));
        z80.f(Qaop.get8(datainputstream));
        z80.bc(Qaop.get16(datainputstream));
        z80.hl(Qaop.get16(datainputstream));
        int i = Qaop.get16(datainputstream);
        z80.pc(i);
        z80.sp(Qaop.get16(datainputstream));
        z80.i(Qaop.get8(datainputstream));
        int j = Qaop.get16(datainputstream);
        z80.r(j & 0x7F | j >> 1 & 0x80);
        if ((j >>>= 8) == 255) {
            j = 0;
        }
        this.spectrum.out(254, j >> 1 & 7);
        z80.de(Qaop.get16(datainputstream));
        z80.exx();
        z80.ex_af();
        z80.bc(Qaop.get16(datainputstream));
        z80.de(Qaop.get16(datainputstream));
        z80.hl(Qaop.get16(datainputstream));
        z80.a(Qaop.get8(datainputstream));
        z80.f(Qaop.get8(datainputstream));
        z80.exx();
        z80.ex_af();
        z80.iy(Qaop.get16(datainputstream));
        z80.ix(Qaop.get16(datainputstream));
        int k = Qaop.get8(datainputstream);
        z80.iff((k != 0 ? 1 : 0) | (Qaop.get8(datainputstream) != 0 ? 2 : 0));
        z80.im(Qaop.get8(datainputstream));
        if (i != 0) {
            if ((j & 0x20) != 0) {
                this.uncompress_z80(datainputstream, 16384, 49152);
            } else {
                this.poke_stream(datainputstream, 16384, 49152);
            }
            return;
        }
        int l = Qaop.get16(datainputstream);
        z80.pc(Qaop.get16(datainputstream));
        int j1 = Qaop.get8(datainputstream);
        if (j1 > 1) {
            System.out.println("Unsupported model: #" + j1);
        }
        Qaop.get8(datainputstream);
        if (Qaop.get8(datainputstream) == 255 && this.spectrum.if1rom != null) {
            this.spectrum.rom = this.spectrum.if1rom;
        }
        if ((Qaop.get8(datainputstream) & 4) != 0) {
            System.out.println("AY!");
        }
        datainputstream.skip(l - 6);
        block5: while (true) {
            int k1;
            int i1 = Qaop.get16(datainputstream);
            switch (Qaop.get8(datainputstream)) {
                case 8: {
                    k1 = 16384;
                    break;
                }
                case 4: {
                    k1 = 32768;
                    break;
                }
                case 5: {
                    k1 = 49152;
                    break;
                }
                default: {
                    datainputstream.skip(i1);
                    continue block5;
                }
            }
            if (i1 == 65535) {
                this.poke_stream(datainputstream, k1, 16384);
                continue;
            }
            this.uncompress_z80(datainputstream, k1, 16384);
        }
    }

    private int uncompress_z80(DataInputStream datainputstream, int i, int j) throws IOException {
        int k = i + j;
        int l = 0;
        block0: do {
            int i1 = Qaop.get8(datainputstream);
            ++l;
            if (i1 != 237) {
                this.spectrum.mem(i++, i1);
                continue;
            }
            i1 = Qaop.get8(datainputstream);
            ++l;
            if (i1 != 237) {
                this.spectrum.mem16(i, i1 << 8 | 0xED);
                i += 2;
                continue;
            }
            int j1 = Qaop.get8(datainputstream);
            i1 = Qaop.get8(datainputstream);
            l += 2;
            while (j1 > 0) {
                this.spectrum.mem(i++, i1);
                if (i >= k) break block0;
                --j1;
            }
        } while (i < k);
        return l;
    }
}

