/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.util.Vector;

public class Spectrum
extends Thread
implements Z80.Env,
ImageProducer {
    final Z80 cpu = new Z80(this);
    int[] rom48k;
    final int[] ram = new int[49152];
    int[] rom;
    int[] if1rom;
    final Audio audio = Audio.getAudio();
    long time;
    int timet;
    boolean paused = true;
    boolean want_pause = true;
    byte beeper;
    int beepert;
    static final ColorModel cm = new IndexColorModel(8, 16, Spectrum.palcolor(2), Spectrum.palcolor(4), Spectrum.palcolor(1));
    private Vector consumers;
    private static final int Mh = 6;
    private static final int Mv = 6;
    static final int W = 352;
    static final int H = 288;
    int width = 352;
    int height = 288;
    int scale = 0;
    final int[] screen = new int[12672];
    final int[] scrchg = new int[24];
    int flash_count = 16;
    int flash = 32768;
    private int refresh_t;
    private int refresh_a;
    private int refresh_b;
    private int refresh_s;
    private static final int BORDER_START = -10772;
    private int refrb_p;
    private int refrb_t;
    private int refrb_x;
    private int refrb_y;
    private int refrb_r;
    private int brdchg_ud;
    private int brdchg_l;
    private int brdchg_r;
    static final int[] canonic;
    byte border;
    byte border_solid;
    public final int[] keyboard = new int[8];
    public int kempston = 0;
    public final KeyEvent[] keys = new KeyEvent[8];
    static final int[] arrowsDefault;
    int[] arrows;
    private boolean loading;
    private boolean stop_loading;
    private byte[] tape;
    private int tape_blk;
    private int tape_pos;
    private boolean tape_changed = false;
    private boolean tape_ready = false;

    static {
        arrowsDefault = new int[]{99, 84, 92, 100};
        canonic = new int[32768];
        int i = 0;
        while (i < 32768) {
            int j = i >> 3 & 0x800;
            int k = i >> 3 & 0x700;
            int l = i & 0x700;
            if (k != 0) {
                k |= j;
            }
            if (l != 0) {
                l |= j;
            }
            Spectrum.canonic[i] = k << 4 | 0xFF;
            Spectrum.canonic[i | 0xFF] = l << 4 | 0xFF;
            int i1 = 1;
            while (i1 < 255) {
                if (l != k) {
                    int j1 = i1 >>> 4 | i1 << 4;
                    j1 = j1 >>> 2 & 0x33 | j1 << 2 & 0xCC;
                    j1 = j1 >>> 1 & 0x55 | j1 << 1 & 0xAA;
                    Spectrum.canonic[i | i1] = l << 4 | k | j1;
                    Spectrum.canonic[i | i1 ^ 0xFF] = k << 4 | l | j1;
                } else {
                    int n = k << 4 | 0xFF;
                    Spectrum.canonic[i | i1 ^ 0xFF] = n;
                    Spectrum.canonic[i | i1] = n;
                }
                i1 += 2;
            }
            i += 256;
        }
    }

    Spectrum() {
        super("Spectrum");
        this.rom48k = new int[16384];
        this.rom = this.rom48k;
        this.consumers = new Vector(1);
        this.border = (byte)7;
        this.border_solid = (byte)-1;
        this.arrows = arrowsDefault;
        int i = 0;
        while (i < 8) {
            this.keyboard[i] = 255;
            ++i;
        }
        int j = 6144;
        while (j < 6912) {
            this.ram[j] = 56;
            ++j;
        }
    }

    public void run() {
        try {
            this.frames();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.audio.close();
    }

    private void end_frame() {
        this.audio.drain(this.cpu.ticks - this.beepert);
        this.refresh_screen();
        if (this.border != this.border_solid) {
            int i = this.refrb_t;
            this.refresh_border();
            if (i == -10772) {
                this.border_solid = this.border;
            }
        }
        int j = 0;
        while (j < this.consumers.size()) {
            ImageConsumer imageconsumer = (ImageConsumer)this.consumers.elementAt(this.consumers.size() - ++j);
            this.update_screen(imageconsumer);
        }
        this.cpu.ticks -= 69888;
        this.beepert = this.cpu.ticks;
        if (--this.flash_count <= 0) {
            this.flash ^= 0xFF;
            this.flash_count = 16;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void frames() throws InterruptedException {
        this.time = System.currentTimeMillis();
        this.cpu.ticks = -14337;
        this.cpu.ticks_limit = 55553;
        this.beepert = this.cpu.ticks;
        while (true) {
            byte[] abyte0 = null;
            boolean flag = false;
            Spectrum spectrum = this;
            synchronized (spectrum) {
                if (this.want_pause != this.paused) {
                    this.paused = this.want_pause;
                    this.notifyAll();
                }
                if (this.stop_loading) {
                    this.stop_loading = false;
                    this.loading = false;
                    this.notifyAll();
                }
                if (!this.paused) {
                    abyte0 = this.tape;
                    flag = this.tape_ready;
                    if (!this.loading && abyte0 != null) {
                        this.loading = this.check_load();
                    }
                }
            }
            this.update_keyboard();
            this.refresh_new();
            if (this.paused) {
                this.cpu.ticks = this.cpu.ticks_limit;
            } else if (this.loading) {
                this.loading = this.do_load(abyte0, flag);
                this.cpu.ticks = this.cpu.ticks_limit;
            } else {
                this.cpu.interrupt(255);
                this.cpu.execute();
            }
            this.end_frame();
            this.timet += 121;
            if (this.timet >= 125) {
                this.timet -= 125;
                ++this.time;
            }
            this.time += 19L;
            long l = System.currentTimeMillis();
            if (l < this.time) {
                l = this.time - l;
                Thread.sleep(l);
                continue;
            }
            Thread.yield();
            if (Thread.interrupted()) break;
            if ((l -= 100L) <= this.time) continue;
            this.time = l;
        }
    }

    public synchronized void pause(boolean flag) throws InterruptedException {
        this.want_pause = flag;
        while (this.paused != this.want_pause) {
            this.wait();
        }
    }

    public synchronized void reset() {
        this.stop_loading();
        this.cpu.reset();
        this.rom = this.rom48k;
    }

    private final void contention(int i) {
        if ((i += this.cpu.ticks) < 0 || i >= 42910) {
            return;
        }
        if ((i & 7) >= 6) {
            return;
        }
        if (i % 224 < 126) {
            this.cpu.ticks += 6 - (i & 7);
        }
    }

    public final void cont(int i, int j) {
        if (i >= 16384 && i < 32768 && this.cpu.ticks + j > 0) {
            int k = 0;
            while (k < j) {
                this.contention(k);
                ++k;
            }
        }
    }

    public final int m1(int i) {
        if (i >= 16384) {
            if ((i -= 16384) < 16384) {
                this.contention(0);
            }
            return this.ram[i];
        }
        int j = this.rom[i];
        if (this.if1rom == null) {
            return j;
        }
        if ((i & 0xE8F7) != 0) {
            return j;
        }
        if (i == 8 || i == 5896) {
            if (this.rom == this.rom48k) {
                this.rom = this.if1rom;
            }
        } else if (i == 1792 && this.rom == this.if1rom) {
            this.rom = this.rom48k;
        }
        return j;
    }

    public final int mem(int i) {
        if ((i -= 16384) >= 0) {
            if (i < 16384) {
                this.contention(0);
            }
            return this.ram[i];
        }
        return this.rom[i + 16384];
    }

    public final int mem16(int i) {
        if ((i & 0x3FFF) != 16383) {
            if (i < 16384) {
                return this.rom[i] | this.rom[i + 1] << 8;
            }
            if ((i -= 16384) < 16384) {
                this.contention(0);
                this.contention(3);
            }
            return this.ram[i] | this.ram[i + 1] << 8;
        }
        int j = this.mem(i);
        this.cpu.ticks += 3;
        this.cpu.ticks -= 3;
        return j += this.mem((char)(i + 1)) << 8;
    }

    public final void mem(int i, int j) {
        if ((i -= 16384) < 16384) {
            if (i < 0) {
                return;
            }
            this.contention(0);
            if (i < 6912 && this.ram[i] != j) {
                this.refresh_screen();
            }
        }
        this.ram[i] = j;
    }

    public final void mem16(int i, int j) {
        if ((i + 1 & 0x3FFF) != 0) {
            if ((i -= 16384) < 0) {
                return;
            }
            if (i >= 32768) {
                this.ram[i] = j & 0xFF;
                this.ram[i + 1] = j >>> 8;
                return;
            }
            i += 16384;
        }
        this.mem(i, j & 0xFF);
        this.cpu.ticks += 3;
        this.mem((char)(i + 1), j >>> 8);
        this.cpu.ticks -= 3;
    }

    public void out(int i, int j) {
        if ((i & 1) == 0) {
            this.contention(1);
            byte byte0 = (byte)(j & 7);
            if (byte0 != this.border) {
                this.refresh_border();
                this.border = byte0;
            }
            if ((byte0 = (byte)(j & 0x10)) != this.beeper) {
                this.beeper = byte0;
                int k = this.cpu.ticks;
                this.audio.pulse(k - this.beepert);
                this.beepert = k;
            }
        }
    }

    public int in(int i) {
        int j = 255;
        if ((i & 0xE0) == 0) {
            return this.kempston;
        }
        if ((i & 1) == 0) {
            this.contention(1);
            int k = 0;
            while (k < 8) {
                if ((i & 256 << k) == 0) {
                    j &= this.keyboard[k];
                }
                ++k;
            }
            j &= this.beeper << 2 | 0xBF;
        } else if (this.cpu.ticks >= -2) {
            int l = this.cpu.ticks;
            int i1 = l / 224;
            if (i1 < 192 && (l %= 224) < 124 && (l & 4) == 0) {
                int j1 = l >> 1 & 1 | l >> 2;
                j1 = (l & 1) == 0 ? (j1 += i1 & 0x1800 | i1 << 2 & 0xE0 | i1 << 8 & 0x700) : (j1 += 0x1800 | i1 << 2 & 0x3E0);
                j = this.ram[j1];
            }
        }
        return j;
    }

    static byte[] palcolor(int i) {
        byte[] abyte0 = new byte[16];
        int j = 0;
        while (j < 8) {
            if ((j & i) != 0) {
                abyte0[j] = -51;
                abyte0[j + 8] = -1;
            }
            ++j;
        }
        return abyte0;
    }

    public synchronized void addConsumer(ImageConsumer imageconsumer) {
        block3: {
            try {
                imageconsumer.setDimensions(this.width, this.height);
                this.consumers.addElement(imageconsumer);
                imageconsumer.setHints(9);
                if (this.isConsumer(imageconsumer)) {
                    imageconsumer.setColorModel(cm);
                }
                this.force_redraw();
            }
            catch (Exception exception) {
                if (!this.isConsumer(imageconsumer)) break block3;
                imageconsumer.imageComplete(1);
            }
        }
    }

    public boolean isConsumer(ImageConsumer imageconsumer) {
        return this.consumers.contains(imageconsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageconsumer) {
        this.consumers.removeElement(imageconsumer);
    }

    public void startProduction(ImageConsumer imageconsumer) {
        this.addConsumer(imageconsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageconsumer) {
    }

    public synchronized void scale(int i) {
        int j;
        while ((j = this.consumers.size()) != 0) {
            ImageConsumer imageconsumer = (ImageConsumer)this.consumers.elementAt(--j);
            this.consumers.removeElementAt(j);
            imageconsumer.imageComplete(4);
        }
        this.scale = i;
        this.width = i * 352;
        this.height = i * 288;
    }

    public int scale() {
        return this.scale;
    }

    private void force_redraw() {
        int i = 0;
        while (i < this.screen.length) {
            this.screen[i] = 511;
            ++i;
        }
        this.border_solid = (byte)-1;
    }

    private final void refresh_new() {
        this.refresh_b = 0;
        this.refresh_t = 0;
        this.refresh_s = 2118;
        this.refresh_a = 6144;
        this.refrb_p = 0;
        this.refrb_t = -10772;
        this.refrb_x = -6;
        this.refrb_y = -48;
        this.refrb_r = 1;
    }

    private final void refresh_screen() {
        int i = this.cpu.ticks;
        if (i < this.refresh_t) {
            return;
        }
        int j = this.flash;
        int k = this.refresh_a;
        int l = this.refresh_b;
        int i1 = this.refresh_t;
        int j1 = this.refresh_s;
        do {
            int l1;
            int k1 = 0;
            if ((l1 = this.ram[k] << 8 | this.ram[l++]) >= 32768) {
                l1 ^= j;
            }
            if ((l1 = canonic[l1]) != this.screen[j1]) {
                this.screen[j1] = l1;
                k1 = 1;
            }
            if ((l1 = this.ram[k + 1] << 8 | this.ram[l++]) >= 32768) {
                l1 ^= j;
            }
            if ((l1 = canonic[l1]) != this.screen[++j1]) {
                this.screen[j1] = l1;
                k1 += 2;
            }
            if (k1 != 0) {
                int n = k - 6144 >> 5;
                this.scrchg[n] = this.scrchg[n] | k1 << (k & 0x1F);
            }
            i1 += 8;
            ++j1;
            if (((k += 2) & 0x1F) != 0) continue;
            i1 += 96;
            j1 += 12;
            k -= 32;
            if (((l += 224) & 0x700) != 0) continue;
            k += 32;
            if (((l -= 2016) & 0xE0) != 0 || (l += 1792) < 6144) continue;
            i1 = 99999;
            break;
        } while (i >= i1);
        this.refresh_a = k;
        this.refresh_b = l;
        this.refresh_t = i1;
        this.refresh_s = j1;
    }

    private final void refresh_border() {
        int i = this.cpu.ticks;
        if (i < this.refrb_t) {
            return;
        }
        this.border_solid = (byte)-1;
        int j = this.refrb_t;
        int k = canonic[this.border << 11];
        int l = this.refrb_p;
        int i1 = this.refrb_x;
        int j1 = this.refrb_r;
        block0: do {
            if (this.refrb_y < 0 || this.refrb_y >= 192) {
                do {
                    if (this.screen[l] != k) {
                        this.screen[l] = k;
                        this.brdchg_ud |= j1;
                    }
                    ++l;
                    j += 4;
                    if (++i1 < 38) continue;
                    i1 = -6;
                    j += 48;
                    if ((++this.refrb_y & 7) != 0) continue;
                    if (this.refrb_y == 0) {
                        j1 = 1;
                        continue block0;
                    }
                    if (this.refrb_y == 240) {
                        j = 99999;
                        break block0;
                    }
                    j1 <<= 1;
                } while (i >= j);
                break;
            }
            do {
                block15: {
                    if (i1 < 0) {
                        block14: {
                            do {
                                if (this.screen[l] != k) {
                                    this.screen[l] = k;
                                    this.brdchg_l |= j1;
                                }
                                ++l;
                                j += 4;
                                if (++i1 == 0) break block14;
                            } while (i >= j);
                            break block0;
                        }
                        i1 = 32;
                        l += 32;
                        if (i < (j += 128)) break block0;
                    }
                    do {
                        if (this.screen[l] != k) {
                            this.screen[l] = k;
                            this.brdchg_r |= j1;
                        }
                        ++l;
                        j += 4;
                        if (++i1 == 38) break block15;
                    } while (i >= j);
                    break block0;
                }
                i1 = -6;
                j += 48;
                if ((++this.refrb_y & 7) != 0) continue;
                if (this.refrb_y == 192) {
                    j1 = 64;
                    continue block0;
                }
                j1 <<= 1;
            } while (i >= j);
            break;
        } while (i >= j);
        this.refrb_r = j1;
        this.refrb_x = i1;
        this.refrb_p = l;
        this.refrb_t = j;
    }

    private final void update_box(ImageConsumer imageconsumer, int i, int j, int k, byte[] abyte0) {
        int j1;
        int k1;
        int l = i * 352 + j;
        int i1 = 0;
        j <<= 3;
        i <<= 3;
        if (this.scale == 1) {
            k1 = k * 8;
            int l1 = 0;
            while (l1 < 8) {
                int j2 = 0;
                while (j2 < k) {
                    int l2 = this.screen[l++];
                    byte byte0 = (byte)(l2 >>> 8 & 0xF);
                    byte byte2 = (byte)(l2 >>> 12);
                    l2 &= 0xFF;
                    while (l2 != 0) {
                        abyte0[i1++] = (l2 & 1) != 0 ? byte2 : byte0;
                        l2 >>>= 1;
                    }
                    ++j2;
                }
                l += 44 - k;
                ++l1;
            }
            j1 = 8;
        } else {
            j1 = this.scale << 3;
            k1 = k * j1;
            int i2 = 0;
            while (i2 < 8) {
                int k2 = 0;
                while (k2 < k) {
                    int i3 = this.screen[l++];
                    byte byte1 = (byte)(i3 >>> 8 & 0xF);
                    byte byte3 = (byte)(i3 >>> 12);
                    i3 &= 0xFF;
                    while (i3 != 0) {
                        byte byte4;
                        byte by = byte4 = (i3 & 1) != 0 ? byte3 : byte1;
                        abyte0[i1 + k1 + 1] = by;
                        abyte0[i1 + k1] = by;
                        abyte0[i1 + 1] = by;
                        abyte0[i1] = by;
                        i1 += 2;
                        i3 >>>= 1;
                    }
                    ++k2;
                }
                i1 += k1;
                l += 44 - k;
                ++i2;
            }
            j *= this.scale;
            i *= this.scale;
        }
        imageconsumer.setPixels(j, i, k1, j1, cm, abyte0, 0, k1);
    }

    private void update_screen(ImageConsumer imageconsumer) {
        int i = this.brdchg_ud;
        this.brdchg_ud = 0;
        int j = this.brdchg_l;
        this.brdchg_l = 0;
        int k = this.brdchg_r;
        this.brdchg_r = 0;
        boolean flag = (i | j | k) != 0;
        byte[] abyte0 = new byte[2816 * this.scale * this.scale];
        if (i != 0) {
            int l = 0;
            while (l < 6) {
                if ((i & 1) != 0) {
                    this.update_box(imageconsumer, l, 0, 44, abyte0);
                }
                ++l;
                i >>>= 1;
            }
        }
        int i1 = 0;
        while (i1 < 24) {
            int j1 = this.scrchg[i1];
            this.scrchg[i1] = 0;
            int l1 = 6;
            int i2 = 0;
            if ((j & 1) != 0) {
                i2 = l1;
                l1 = 0;
            }
            while (true) {
                if ((j1 & 1) != 0) {
                    ++i2;
                    j1 >>>= 1;
                    continue;
                }
                if (i2 != 0) {
                    if (l1 + i2 == 38 && (k & 1) != 0) {
                        i2 += 6;
                    }
                    flag = true;
                    this.update_box(imageconsumer, 6 + i1, l1, i2, abyte0);
                    if ((l1 += i2) >= 38) break;
                }
                if (j1 == 0) {
                    if ((k & 1) == 0) break;
                    l1 = 38;
                    i2 = 6;
                    continue;
                }
                do {
                    ++l1;
                } while (((j1 >>>= 1) & 1) == 0);
                i2 = 1;
                j1 >>>= 1;
            }
            j >>>= 1;
            k >>>= 1;
            ++i1;
        }
        if (i != 0) {
            int k1 = 30;
            while (k1 < 36) {
                if ((i & 1) != 0) {
                    this.update_box(imageconsumer, k1, 0, 44, abyte0);
                }
                ++k1;
                i >>>= 1;
            }
        }
        if (flag) {
            imageconsumer.imageComplete(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update_keyboard() {
        int i = 0;
        while (i < 8) {
            this.keyboard[i] = 255;
            ++i;
        }
        this.kempston = 0;
        int[] ai = new int[]{-1, -1, -1, -1, -1};
        int j = 0;
        KeyEvent[] keyEventArray = this.keys;
        synchronized (this.keys) {
            int k = 0;
            while (k < this.keys.length) {
                int l;
                if (this.keys[k] != null && (l = this.key(this.keys[k])) >= 0) {
                    j |= l;
                    if (l < 512) {
                        this.pressed(l, ai);
                    }
                }
                ++k;
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if ((j & 0xC0) == 0) {
                j |= j >>> 3 & 0xC0;
            }
            if ((j & 0x40) != 0) {
                this.pressed(0, ai);
            }
            if ((j & 0x80) != 0) {
                this.pressed(15, ai);
            }
            return;
        }
    }

    private final void pressed(int i, int[] ai) {
        int j = i & 7;
        int k = i >>> 3 & 7;
        int l = this.keyboard[j] & ~(1 << k);
        int i1 = ai[k];
        this.keyboard[j] = l;
        ai[k] = j;
        if (i1 >= 0) {
            l |= this.keyboard[i1];
        }
        int j1 = 0;
        while (j1 < 8) {
            if ((this.keyboard[j1] | l) != 255) {
                this.keyboard[j1] = l;
            }
            ++j1;
        }
    }

    private int key(KeyEvent keyevent) {
        int byte0;
        int k;
        char c;
        int i;
        block16: {
            int byte1;
            int j;
            block17: {
                i = keyevent.getKeyCode();
                c = keyevent.getKeyChar();
                j = "[AQ10P\n ZSW29OL]XDE38IKMCFR47UJNVGT56YHB".indexOf((char)i);
                if (j < 0) break block16;
                byte1 = 0;
                if (i < 48 || i > 57) break block17;
                if (i != c) break block16;
                if (keyevent.isAltDown()) {
                    byte1 = 64;
                }
            }
            return j | byte1;
        }
        if (c != '\u0000' && (k = "\t\u0000\u0000!_\"\u0000\u0000:\u0000\u0000@);=\u0000\u0000\u0000\u0000#(\u0000+.?\u0000<$'\u0000-,/\u0000>%&\u0000^*".indexOf(c)) >= 0) {
            return k | 0x80;
        }
        switch (i) {
            case 27: 
            case 155: {
                return 67;
            }
            case 37: 
            case 226: {
                byte0 = 0;
                break;
            }
            case 40: 
            case 225: {
                byte0 = 3;
                break;
            }
            case 38: 
            case 224: {
                byte0 = 2;
                break;
            }
            case 39: 
            case 227: {
                byte0 = 1;
                break;
            }
            case 8: {
                return 68;
            }
            case 16: {
                return 512;
            }
            case 17: {
                this.kempston |= 0x10;
            }
            case 18: {
                return 1024;
            }
            default: {
                return -1;
            }
        }
        this.kempston |= 1 << (byte0 ^ 1);
        return keyevent.isAltDown() ? arrowsDefault[byte0] : this.arrows[byte0];
    }

    public void setArrows(String s) {
        this.arrows = new int[4];
        int i = 0;
        while (i < 4) {
            int j = -1;
            if (i < s.length()) {
                j = "Caq10pE_zsw29olSxde38ikmcfr47ujnvgt56yhb".indexOf(s.charAt(i));
            }
            if (j < 0) {
                j = arrowsDefault[i];
            }
            this.arrows[i] = j;
            ++i;
        }
    }

    private boolean check_load() {
        int i = this.cpu.pc();
        if (this.cpu.ei() || i < 1387 || i > 1540) {
            return false;
        }
        char c = (char)this.cpu.sp();
        if (i >= 1507) {
            i = this.mem16(c);
            c = (char)(c + 2);
            if (i == 1510) {
                i = this.mem16(c);
                c = (char)(c + 2);
            }
        }
        if (i < 1387 || i > 1422) {
            return false;
        }
        this.cpu.sp(c);
        this.cpu.ex_af();
        if (this.tape_changed || this.tape_ready && this.tape.length <= this.tape_blk) {
            this.tape_changed = false;
            this.tape_blk = 0;
        }
        this.tape_pos = this.tape_blk;
        return true;
    }

    public synchronized void stop_loading() {
        this.stop_loading = true;
        try {
            while (this.loading) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedexception) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void tape(byte[] abyte0, boolean flag) {
        if (abyte0 == null) {
            this.tape_changed = true;
        }
        this.tape_ready = flag;
        this.tape = abyte0;
    }

    private final boolean do_load(byte[] abyte0, boolean flag) {
        if (this.tape_changed || (this.keyboard[7] & 1) == 0) {
            this.cpu.f(0);
            return false;
        }
        int i = this.tape_pos;
        char c = (char)this.cpu.ix();
        int j = this.cpu.de();
        int l = this.cpu.hl();
        int k = l >> 8 & 0xFF;
        l &= 0xFF;
        int i1 = this.cpu.a();
        int j1 = this.cpu.f();
        int byte0 = -1;
        if (i == this.tape_blk) {
            if (abyte0.length < (i += 2)) {
                if (flag) {
                    this.cpu.pc(this.cpu.pop());
                    this.cpu.f(64);
                }
                return !flag;
            }
            this.tape_blk = i + (abyte0[i - 2] & 0xFF | abyte0[i - 1] << 8 & 0xFF00);
            k = 0;
        }
        while (true) {
            if (i == this.tape_blk) {
                Spectrum _tmp = this;
                byte0 = 64;
                break;
            }
            if (i == abyte0.length) {
                if (!flag) break;
                Spectrum _tmp1 = this;
                byte0 = 64;
                break;
            }
            l = abyte0[i++] & 0xFF;
            k ^= l;
            if (j == 0) {
                i1 = k;
                byte0 = 0;
                if (i1 >= 1) break;
                Spectrum _tmp2 = this;
                byte0 = 1;
                break;
            }
            if ((j1 & 0x40) == 0) {
                if ((i1 ^= l) != 0) {
                    byte0 = 0;
                    break;
                }
                Spectrum _tmp3 = this;
                j1 |= 0x40;
                continue;
            }
            if ((j1 & 1) != 0) {
                this.mem(c, l);
            } else {
                i1 = this.mem(c) ^ l;
                if (i1 != 0) {
                    byte0 = 0;
                    break;
                }
            }
            c = (char)(c + '\u0001');
            --j;
        }
        this.cpu.ix(c);
        this.cpu.de(j);
        this.cpu.hl(k << 8 | l);
        this.cpu.a(i1);
        if (byte0 >= 0) {
            j1 = byte0;
            this.cpu.pc(this.cpu.pop());
        }
        this.cpu.f(j1);
        this.tape_pos = i;
        return byte0 < 0;
    }

    public final void autoload() {
        this.rom = this.rom48k;
        this.cpu.i(63);
        int i = 16384;
        do {
            this.mem(i++, 0);
        } while (i < 22528);
        do {
            this.mem(i++, 56);
        } while (i < 23296);
        do {
            this.mem(i++, 0);
        } while (i < 65536);
        this.mem16(23732, --i);
        System.arraycopy(this.rom48k, 15880, this.ram, (i -= 167) - 16384, 168);
        this.mem16(23675, i--);
        this.mem(23608, 64);
        this.mem16(23730, i);
        this.mem16(23606, 15360);
        this.mem(i--, 62);
        this.cpu.sp(i);
        this.mem16(23613, i - 2);
        this.cpu.iy(23610);
        this.cpu.im(1);
        this.cpu.ei(true);
        this.mem16(23631, 23734);
        System.arraycopy(this.rom48k, 5551, this.ram, 7350, 21);
        i = 23754;
        this.mem16(23639, i++);
        this.mem16(23635, i);
        this.mem16(23627, i);
        this.mem(i++, 128);
        this.mem16(23641, i);
        this.mem16(i, 8943);
        this.mem16(i + 2, 3362);
        this.mem(i + 4, 128);
        this.mem16(23649, i += 5);
        this.mem16(23651, i);
        this.mem16(23653, i);
        this.mem(23693, 56);
        this.mem(23695, 56);
        this.mem(23624, 56);
        this.mem16(23561, 1315);
        this.mem(23552, 255);
        this.mem(23556, 255);
        System.arraycopy(this.rom48k, 5574, this.ram, 7184, 14);
        this.mem(23679, 33);
        this.mem16(23680, 23296);
        this.mem16(23688, 6177);
        this.mem16(23684, 16384);
        this.mem(23659, 2);
        this.mem16(23656, 23698);
        this.mem(23611, 12);
        this.cpu.pc(4788);
    }
}

