/*
 * Decompiled with CFR 0.152.
 */
public final class Z80 {
    private final Env env;
    private int PC;
    private int SP;
    private int A;
    private int B;
    private int C;
    private int D;
    private int E;
    private int HL;
    private int A_;
    private int B_;
    private int C_;
    private int D_;
    private int E_;
    private int HL_;
    private int IX;
    private int IY;
    private int I;
    private int R;
    private int R7;
    private int ir;
    private int Ff;
    private int Fr;
    private int Fa;
    private int Fb;
    private int Ff_;
    private int Fr_;
    private int Fa_;
    private int Fb_;
    static final int FC = 1;
    static final int FN = 2;
    static final int FP = 4;
    static final int F3 = 8;
    static final int FH = 16;
    static final int F5 = 32;
    static final int FZ = 64;
    static final int FS = 128;
    static final int F53 = 40;
    int ticks;
    int ticks_limit;
    private int IFF;
    private int IM;
    private boolean halted;

    Z80(Env env1) {
        this.env = env1;
    }

    private int flags() {
        int j = this.Ff;
        int k = this.Fa;
        int l = this.Fb;
        int i1 = this.Fr;
        j = j & 0xA8 | j >>> 8 & 1;
        int j1 = l >> 8;
        if (i1 == 0) {
            j |= 0x40;
        }
        int k1 = i1 ^ k;
        j |= j1 & 2;
        j |= (k1 ^ l ^ j1) & 0x10;
        if ((k & 0xFFFFFF00) == 0) {
            k = k1 & (l ^ i1);
            l = 5;
        } else {
            k = 154020;
            l = (i1 ^ i1 >>> 4) & 0xF;
        }
        return j | k >>> l & 4;
    }

    private void flags(int j) {
        this.Ff = j & 0xA8 | (j & 1) << 8;
        this.Fr = ~j & 0x40;
        int k = (j & 4) << 5;
        this.Fa = k | j & 0x10;
        if ((j & 2) != 0) {
            k |= 0xFFFFFF7F;
        }
        this.Fb = k;
    }

    int a() {
        return this.A;
    }

    int f() {
        return this.flags();
    }

    int bc() {
        return this.B << 8 | this.C;
    }

    int de() {
        return this.D << 8 | this.E;
    }

    int hl() {
        return this.HL;
    }

    int ix() {
        return this.IX;
    }

    int iy() {
        return this.IY;
    }

    int pc() {
        return this.PC;
    }

    int sp() {
        return this.SP;
    }

    int af() {
        return this.A << 8 | this.flags();
    }

    void a(int j) {
        this.A = j;
    }

    void f(int j) {
        this.flags(j);
    }

    void bc(int j) {
        this.C = j & 0xFF;
        this.B = j >>> 8;
    }

    void de(int j) {
        this.E = j & 0xFF;
        this.D = j >>> 8;
    }

    void hl(int j) {
        this.HL = j;
    }

    void ix(int j) {
        this.IX = j;
    }

    void iy(int j) {
        this.IY = j;
    }

    void pc(int j) {
        this.PC = j;
    }

    void sp(int j) {
        this.SP = j;
    }

    void af(int j) {
        this.A = j >>> 8;
        this.flags(j & 0xFF);
    }

    void i(int j) {
        this.I = j;
    }

    void r(int j) {
        this.R = j;
        this.R7 = j & 0x80;
    }

    void im(int j) {
        if ((j &= 3) != 0) {
            ++j;
        }
        this.IM = j;
    }

    void iff(int j) {
        this.IFF = j;
    }

    void ei(boolean flag) {
        this.IFF = flag ? 3 : 0;
    }

    int i() {
        return this.I;
    }

    int r() {
        return this.R & 0x7F | this.R7;
    }

    boolean ei() {
        return (this.IFF & 1) != 0;
    }

    void exx() {
        int j = this.B_;
        this.B_ = this.B;
        this.B = j;
        j = this.C_;
        this.C_ = this.C;
        this.C = j;
        j = this.D_;
        this.D_ = this.D;
        this.D = j;
        j = this.E_;
        this.E_ = this.E;
        this.E = j;
        j = this.HL_;
        this.HL_ = this.HL;
        this.HL = j;
    }

    void ex_af() {
        int j = this.A_;
        this.A_ = this.A;
        this.A = j;
        j = this.Ff_;
        this.Ff_ = this.Ff;
        this.Ff = j;
        j = this.Fr_;
        this.Fr_ = this.Fr;
        this.Fr = j;
        j = this.Fa_;
        this.Fa_ = this.Fa;
        this.Fa = j;
        j = this.Fb_;
        this.Fb_ = this.Fb;
        this.Fb = j;
    }

    public void push(int j) {
        ++this.ticks;
        this.env.mem((char)(this.SP - 1), j >>> 8);
        this.ticks += 3;
        char c = (char)(this.SP - 2);
        this.SP = c;
        this.env.mem(c, j & 0xFF);
        this.ticks += 3;
    }

    int pop() {
        int j = this.env.mem16(this.SP);
        this.SP = (char)(this.SP + 2);
        this.ticks += 6;
        return j;
    }

    private void add(int j) {
        int k = this.A + j;
        this.Fa = this.A;
        this.Fb = j;
        this.Ff = k;
        this.A = this.Fr = k & 0xFF;
    }

    private void adc(int j) {
        int k = this.A + j + (this.Ff >>> 8 & 1);
        this.Fa = this.A;
        this.Fb = j;
        this.Ff = k;
        this.A = this.Fr = k & 0xFF;
    }

    private void sub(int j) {
        int k = this.A - j;
        this.Fa = this.A;
        this.Fb = ~j;
        this.Ff = k;
        this.A = this.Fr = k & 0xFF;
    }

    private void sbc(int j) {
        int k = this.A - j - (this.Ff >>> 8 & 1);
        this.Fa = this.A;
        this.Fb = ~j;
        this.Ff = k;
        this.A = this.Fr = k & 0xFF;
    }

    private void cp(int j) {
        int k = this.A - j;
        this.Fa = this.A;
        this.Fb = ~j;
        this.Ff = k & 0xFFFFFFD7 | j & 0x28;
        this.Fr = k & 0xFF;
    }

    private void and(int j) {
        int k;
        this.Ff = this.Fr = (k = this.A & j);
        this.A = this.Fr;
        this.Fa = ~k;
        this.Fb = 0;
    }

    private void or(int j) {
        int k;
        this.Ff = this.Fr = (k = this.A | j);
        this.A = this.Fr;
        this.Fa = k | 0x100;
        this.Fb = 0;
    }

    private void xor(int j) {
        int k;
        this.Ff = this.Fr = (k = this.A ^ j);
        this.A = this.Fr;
        this.Fa = k | 0x100;
        this.Fb = 0;
    }

    private void cpl() {
        this.Ff = this.Ff & 0xFFFFFFD7 | (this.A ^= 0xFF) & 0x28;
        this.Fb |= 0xFFFFFF7F;
        this.Fa = this.Fa & 0xFFFFFFEF | ~this.Fr & 0x10;
    }

    private int inc(int j) {
        int k = j + 1 & 0xFF;
        this.Fa = j;
        this.Fb = 0;
        this.Fr = k;
        this.Ff = this.Ff & 0xFFFFFF00 | k;
        return k;
    }

    private int dec(int j) {
        int k = j - 1 & 0xFF;
        this.Fa = j;
        this.Fb = -1;
        this.Fr = k;
        this.Ff = this.Ff & 0xFFFFFF00 | k;
        return k;
    }

    private void bit(int j, int k) {
        this.Ff = this.Ff & 0xFFFFFF00 | (k &= 1 << j);
        this.Fr = k;
        this.Fa = ~this.Fr;
        this.Fb = 0;
    }

    private void f_szh0n0p(int j) {
        this.Ff = this.Ff & 0xFFFFFF00 | j;
        this.Fr = j;
        this.Fa = j | 0x100;
        this.Fb = 0;
    }

    private void f_h0n0_c35(int j) {
        this.Ff = this.Ff & 0xD7 | j & 0x128;
        this.Fb &= 0x80;
        this.Fa = this.Fa & 0xFFFFFFEF | this.Fr & 0x10;
    }

    private int shifter(int j, int k) {
        if ((j & 1) == 0) {
            int l = j <= 2 ? (j != 0 ? this.Ff : (k <<= 1)) >> 8 : j >> 1;
            this.Ff = k |= l & 1;
            k &= 0xFF;
        } else {
            int i1 = 0;
            switch (j) {
                case 1: {
                    i1 = k << 8;
                    break;
                }
                case 3: {
                    i1 = this.Ff;
                    break;
                }
                case 5: {
                    i1 = k << 1;
                }
            }
            this.Ff = (k |= i1 & 0x100) << 8;
            this.Ff |= (k >>>= 1);
        }
        this.Fr = k;
        this.Fa = k | 0x100;
        this.Fb = 0;
        return k;
    }

    private int add16(int j, int k) {
        int l = j + k;
        this.Ff = this.Ff & 0x80 | l >>> 8 & 0x128;
        this.Fa &= 0xFFFFFFEF;
        this.Fb = this.Fb & 0x80 | ((l ^ j ^ k) >>> 8 ^ this.Fr) & 0x10;
        this.ir = j;
        this.ticks += 7;
        return (char)l;
    }

    private void adc_hl(int j) {
        int k = this.HL + j + (this.Ff >>> 8 & 1);
        this.Ff = k >>> 8;
        this.Fa = this.HL >>> 8;
        this.Fb = j >>> 8;
        char c = (char)k;
        k = c;
        this.HL = c;
        this.Fr = k >>> 8 | k << 8;
        this.ticks += 7;
    }

    private void sbc_hl(int j) {
        int k = this.HL - j - (this.Ff >>> 8 & 1);
        this.Ff = k >>> 8;
        this.Fa = this.HL >>> 8;
        this.Fb = ~(j >>> 8);
        char c = (char)k;
        k = c;
        this.HL = c;
        this.Fr = k >>> 8 | k << 8;
        this.ticks += 7;
    }

    private void scf_ccf(int j) {
        this.Fa &= 0xFFFFFFEF;
        this.Fb = this.Fb & 0x80 | (j >>> 4 ^ this.Fr) & 0x10;
        this.Ff = 0x100 ^ j | this.Ff & 0x80 | this.A & 0x28;
    }

    private int getd(int j) {
        int k = this.env.mem(this.PC);
        this.PC = (char)(this.PC + 1);
        this.ticks += 8;
        char c = (char)(j + (byte)k);
        this.ir = c;
        return c;
    }

    private int imm8() {
        int j = this.env.mem(this.PC);
        this.PC = (char)(this.PC + 1);
        this.ticks += 3;
        return j;
    }

    private int imm16() {
        int j = this.env.mem16(this.PC);
        this.PC = (char)(this.PC + 2);
        this.ticks += 6;
        return j;
    }

    private void daa() {
        int j = (this.Fr ^ this.Fa ^ this.Fb ^ this.Fb >> 8) & 0x10;
        int k = 0;
        if ((this.A | this.Ff & 0x100) > 153) {
            k = 352;
        }
        if ((this.A & 0xF | j) > 9) {
            k += 6;
        }
        this.Fa = this.A | 0x100;
        if ((this.Fb & 0x200) == 0) {
            this.Fb = k;
            this.A += this.Fb;
        } else {
            this.A -= k;
            this.Fb = ~k;
        }
        this.A &= 0xFF;
        this.Ff = this.A | k & 0x100;
        this.Fr = this.A;
    }

    private void rrd() {
        int j = this.env.mem(this.HL) | this.A << 8;
        this.ticks += 7;
        this.A = this.A & 0xF0 | j & 0xF;
        this.f_szh0n0p(this.A);
        j = j >>> 4 & 0xFF;
        this.env.mem(this.HL, j);
        this.ticks += 3;
    }

    private void rld() {
        int j = this.env.mem(this.HL) << 4 | this.A & 0xF;
        this.ticks += 7;
        this.A = this.A & 0xF0 | j >>> 8;
        this.f_szh0n0p(this.A);
        this.env.mem(this.HL, j &= 0xFF);
        this.ticks += 3;
    }

    private void ld_a_ir(int j) {
        this.A = j;
        this.Ff = this.Ff & 0xFFFFFF00 | j;
        this.Fr = j != 0 ? 1 : 0;
        this.Fa = this.Fb = this.IFF << 6 & 0x80;
        ++this.ticks;
    }

    private void jp(boolean flag) {
        int j = this.ir = this.imm16();
        if (flag) {
            this.PC = j;
        }
    }

    private void jr(boolean flag) {
        int j = this.PC;
        byte byte0 = (byte)this.env.mem(j);
        this.ticks += 3;
        if (flag) {
            this.env.cont(j, 5);
            this.ticks += 5;
            char c = (char)(j + byte0 + 1);
            j = c;
            this.ir = c;
        } else {
            j = (char)(j + 1);
        }
        this.PC = j;
    }

    private void call(boolean flag) {
        int j = this.ir = this.imm16();
        if (flag) {
            this.env.cont(this.PC, 1);
            this.push(this.PC);
            this.PC = j;
        }
    }

    private void halt() {
        this.halted = true;
        int j = this.ticks_limit - this.ticks + 3 >> 2;
        if (j > 0) {
            this.R += j;
            this.ticks += 4 * j;
        }
    }

    private void ldir(int j, boolean flag) {
        int j1;
        int k = this.HL;
        char c = (char)this.de();
        int l = (char)(this.bc() - 1) + '\u0001';
        char i1 = (char)(this.PC - 2);
        while (true) {
            j1 = this.env.mem(k);
            k = (char)(k + j);
            this.ticks += 3;
            char k1 = c;
            this.env.mem(k1, j1);
            this.ticks += 3;
            c = (char)(c + j);
            if (--l == 0 || !flag) {
                this.env.cont(k1, 2);
                this.ticks += 2;
                break;
            }
            this.env.cont(k1, 7);
            if (this.ticks >= this.ticks_limit || k1 == i1 || k1 == (char)(i1 + '\u0001')) {
                this.PC = i1;
                this.ticks += 7;
                break;
            }
            this.ticks += 15;
        }
        this.HL = k;
        this.de(c);
        this.bc(l);
        if (this.Fr != 0) {
            this.Fr = 1;
        }
        this.Fb = l == 0 ? 0 : 128;
        this.Fa = this.Fb;
        this.Ff = this.Ff & 0xFFFFFFD7 | (j1 += this.A) & 8 | j1 << 4 & 0x20;
    }

    private void cpir(int j, boolean flag) {
        int k = this.env.mem(this.HL);
        int l = this.A - k & 0xFF;
        this.HL = (char)(this.HL + j);
        this.Fr = l & 0x7F | l >>> 7;
        this.Fb = ~(k | 0x80);
        this.Fa = this.A & 0x7F;
        this.ticks += 8;
        char c = (char)(this.bc() - 1);
        if (c != '\u0000') {
            this.Fa |= 0x80;
            this.Fb |= 0x80;
            if (flag && l != 0) {
                this.PC = (char)(this.PC - 2);
                this.ticks += 5;
            }
        }
        this.bc(c);
        this.Ff = this.Ff & 0xFFFFFF00 | l & 0xFFFFFFD7;
        if (((l ^ k ^ this.A) & 0x10) != 0) {
            --l;
        }
        this.Ff |= l << 4 & 0x20 | l & 8;
    }

    private void inir_otir(int j) {
        int k;
        int i1 = this.HL;
        int l = 1 - (j >> 2 & 2);
        int j1 = i1 + l;
        int k1 = this.B - 1 & 0xFF;
        ++this.ticks;
        this.HL = j1;
        if ((j & 1) == 0) {
            k = this.env.in(k1 << 8 | this.C);
            this.ticks += 4;
            this.env.mem(i1, k);
            this.ticks += 3;
            j1 = (this.Ff >> 8 & 1) + l;
        } else {
            k = this.env.mem(i1);
            this.ticks += 3;
            this.env.out(this.B << 8 | this.C, k);
            this.ticks += 4;
        }
        j1 = (j1 & 0xFF) + k;
        if (k1 != 0 && j >= 176) {
            this.PC = (char)(this.PC - 2);
            this.ticks += 5;
        }
        this.Fr = this.B = k1;
        this.Ff = k1 | j1 & 0x100;
        this.Fb = (j1 & 0x100) << 4 | k << 2 & 0x200;
        j1 = j1 & 7 ^ k1;
        j1 ^= j1 << 4;
        j1 ^= j1 << 2;
        j1 ^= j1 << 1;
        this.Fb |= (j1 ^ k1) & 0x80;
        this.Fa = this.Fb;
    }

    void execute() {
        if (this.halted) {
            this.halt();
            return;
        }
        do {
            int j = this.env.m1(this.PC);
            this.PC = (char)(this.PC + 1);
            this.ticks += 4;
            ++this.R;
            switch (j) {
                case 8: {
                    this.ex_af();
                    break;
                }
                case 16: {
                    ++this.ticks;
                    int k = this.PC;
                    byte byte1 = (byte)this.env.mem(k);
                    this.ticks += 3;
                    this.B = this.B - 1 & 0xFF;
                    if (this.B != 0) {
                        this.env.cont(k, 5);
                        this.ticks += 5;
                        k += byte1;
                    }
                    this.PC = (char)(k + 1);
                    break;
                }
                case 24: {
                    byte byte0 = (byte)this.env.mem(this.PC);
                    this.ticks += 3;
                    this.env.cont(this.PC, 5);
                    this.ticks += 5;
                    char c = (char)(this.PC + 1 + byte0);
                    this.ir = c;
                    this.PC = c;
                    break;
                }
                case 9: {
                    this.HL = this.add16(this.HL, this.B << 8 | this.C);
                    break;
                }
                case 25: {
                    this.HL = this.add16(this.HL, this.D << 8 | this.E);
                    break;
                }
                case 41: {
                    this.HL = this.add16(this.HL, this.HL);
                    break;
                }
                case 57: {
                    this.HL = this.add16(this.HL, this.SP);
                    break;
                }
                case 1: {
                    int l = this.imm16();
                    this.B = l >>> 8;
                    this.C = l & 0xFF;
                    break;
                }
                case 3: {
                    char c = (char)((this.B << 8 | this.C) + 1);
                    this.B = c >>> 8;
                    this.C = c & 0xFF;
                    this.ticks += 2;
                    break;
                }
                case 11: {
                    char c1 = (char)((this.B << 8 | this.C) - 1);
                    this.B = c1 >>> 8;
                    this.C = c1 & 0xFF;
                    this.ticks += 2;
                    break;
                }
                case 17: {
                    int i1 = this.imm16();
                    this.D = i1 >>> 8;
                    this.E = i1 & 0xFF;
                    break;
                }
                case 19: {
                    char c2 = (char)((this.D << 8 | this.E) + 1);
                    this.D = c2 >>> 8;
                    this.E = c2 & 0xFF;
                    this.ticks += 2;
                    break;
                }
                case 27: {
                    char c3 = (char)((this.D << 8 | this.E) - 1);
                    this.D = c3 >>> 8;
                    this.E = c3 & 0xFF;
                    this.ticks += 2;
                    break;
                }
                case 33: {
                    this.HL = this.imm16();
                    break;
                }
                case 35: {
                    this.HL = (char)(this.HL + 1);
                    this.ticks += 2;
                    break;
                }
                case 43: {
                    this.HL = (char)(this.HL - 1);
                    this.ticks += 2;
                    break;
                }
                case 49: {
                    this.SP = this.imm16();
                    break;
                }
                case 51: {
                    this.SP = (char)(this.SP + 1);
                    this.ticks += 2;
                    break;
                }
                case 59: {
                    this.SP = (char)(this.SP - 1);
                    this.ticks += 2;
                    break;
                }
                case 2: {
                    this.env.mem(this.B << 8 | this.C, this.A);
                    this.ticks += 3;
                    break;
                }
                case 10: {
                    this.A = this.env.mem(this.B << 8 | this.C);
                    this.ticks += 3;
                    break;
                }
                case 18: {
                    this.env.mem(this.D << 8 | this.E, this.A);
                    this.ticks += 3;
                    break;
                }
                case 26: {
                    this.A = this.env.mem(this.D << 8 | this.E);
                    this.ticks += 3;
                    break;
                }
                case 34: {
                    this.env.mem16(this.imm16(), this.HL);
                    this.ticks += 6;
                    break;
                }
                case 42: {
                    this.HL = this.env.mem16(this.imm16());
                    this.ticks += 6;
                    break;
                }
                case 50: {
                    this.env.mem(this.imm16(), this.A);
                    this.ticks += 3;
                    break;
                }
                case 58: {
                    this.A = this.env.mem(this.imm16());
                    this.ticks += 3;
                    break;
                }
                case 4: {
                    this.B = this.inc(this.B);
                    break;
                }
                case 5: {
                    this.B = this.dec(this.B);
                    break;
                }
                case 6: {
                    this.B = this.imm8();
                    break;
                }
                case 12: {
                    this.C = this.inc(this.C);
                    break;
                }
                case 13: {
                    this.C = this.dec(this.C);
                    break;
                }
                case 14: {
                    this.C = this.imm8();
                    break;
                }
                case 20: {
                    this.D = this.inc(this.D);
                    break;
                }
                case 21: {
                    this.D = this.dec(this.D);
                    break;
                }
                case 22: {
                    this.D = this.imm8();
                    break;
                }
                case 28: {
                    this.E = this.inc(this.E);
                    break;
                }
                case 29: {
                    this.E = this.dec(this.E);
                    break;
                }
                case 30: {
                    this.E = this.imm8();
                    break;
                }
                case 36: {
                    this.HL = this.HL & 0xFF | this.inc(this.HL >>> 8) << 8;
                    break;
                }
                case 37: {
                    this.HL = this.HL & 0xFF | this.dec(this.HL >>> 8) << 8;
                    break;
                }
                case 38: {
                    this.HL = this.HL & 0xFF | this.imm8() << 8;
                    break;
                }
                case 44: {
                    this.HL = this.HL & 0xFF00 | this.inc(this.HL & 0xFF);
                    break;
                }
                case 45: {
                    this.HL = this.HL & 0xFF00 | this.dec(this.HL & 0xFF);
                    break;
                }
                case 46: {
                    this.HL = this.HL & 0xFF00 | this.imm8();
                    break;
                }
                case 52: {
                    int j1 = this.inc(this.env.mem(this.HL));
                    this.ticks += 4;
                    this.env.mem(this.HL, j1);
                    this.ticks += 3;
                    break;
                }
                case 53: {
                    int k1 = this.dec(this.env.mem(this.HL));
                    this.ticks += 4;
                    this.env.mem(this.HL, k1);
                    this.ticks += 3;
                    break;
                }
                case 54: {
                    this.env.mem(this.HL, this.imm8());
                    this.ticks += 3;
                    break;
                }
                case 60: {
                    this.A = this.inc(this.A);
                    break;
                }
                case 61: {
                    this.A = this.dec(this.A);
                    break;
                }
                case 62: {
                    this.A = this.imm8();
                    break;
                }
                case 32: {
                    this.jr(this.Fr != 0);
                    break;
                }
                case 40: {
                    this.jr(this.Fr == 0);
                    break;
                }
                case 48: {
                    this.jr((this.Ff & 0x100) == 0);
                    break;
                }
                case 56: {
                    this.jr((this.Ff & 0x100) != 0);
                    break;
                }
                case 7: {
                    int l1 = this.A << 1 | this.A >>> 7;
                    this.f_h0n0_c35(l1);
                    this.A = l1 & 0xFF;
                    break;
                }
                case 15: {
                    int i2 = this.A >>> 1;
                    this.f_h0n0_c35(i2 | this.A << 8);
                    this.A = i2 | this.A << 7 & 0xFF;
                    break;
                }
                case 23: {
                    int j2 = this.A << 1;
                    this.A = j2 & 0xFF | this.Ff >>> 8 & 1;
                    this.f_h0n0_c35(j2);
                    break;
                }
                case 31: {
                    int k2 = this.A;
                    this.A = (k2 | this.Ff & 0x100) >>> 1;
                    this.f_h0n0_c35(this.A | k2 << 8);
                    break;
                }
                case 39: {
                    this.daa();
                    break;
                }
                case 47: {
                    this.cpl();
                    break;
                }
                case 55: {
                    this.scf_ccf(0);
                    break;
                }
                case 63: {
                    this.scf_ccf(this.Ff & 0x100);
                    break;
                }
                case 65: {
                    this.B = this.C;
                    break;
                }
                case 66: {
                    this.B = this.D;
                    break;
                }
                case 67: {
                    this.B = this.E;
                    break;
                }
                case 68: {
                    this.B = this.HL >>> 8;
                    break;
                }
                case 69: {
                    this.B = this.HL & 0xFF;
                    break;
                }
                case 70: {
                    this.B = this.env.mem(this.HL);
                    this.ticks += 3;
                    break;
                }
                case 71: {
                    this.B = this.A;
                    break;
                }
                case 72: {
                    this.C = this.B;
                    break;
                }
                case 74: {
                    this.C = this.D;
                    break;
                }
                case 75: {
                    this.C = this.E;
                    break;
                }
                case 76: {
                    this.C = this.HL >>> 8;
                    break;
                }
                case 77: {
                    this.C = this.HL & 0xFF;
                    break;
                }
                case 78: {
                    this.C = this.env.mem(this.HL);
                    this.ticks += 3;
                    break;
                }
                case 79: {
                    this.C = this.A;
                    break;
                }
                case 80: {
                    this.D = this.B;
                    break;
                }
                case 81: {
                    this.D = this.C;
                    break;
                }
                case 83: {
                    this.D = this.E;
                    break;
                }
                case 84: {
                    this.D = this.HL >>> 8;
                    break;
                }
                case 85: {
                    this.D = this.HL & 0xFF;
                    break;
                }
                case 86: {
                    this.D = this.env.mem(this.HL);
                    this.ticks += 3;
                    break;
                }
                case 87: {
                    this.D = this.A;
                    break;
                }
                case 88: {
                    this.E = this.B;
                    break;
                }
                case 89: {
                    this.E = this.C;
                    break;
                }
                case 90: {
                    this.E = this.D;
                    break;
                }
                case 92: {
                    this.E = this.HL >>> 8;
                    break;
                }
                case 93: {
                    this.E = this.HL & 0xFF;
                    break;
                }
                case 94: {
                    this.E = this.env.mem(this.HL);
                    this.ticks += 3;
                    break;
                }
                case 95: {
                    this.E = this.A;
                    break;
                }
                case 96: {
                    this.HL = this.HL & 0xFF | this.B << 8;
                    break;
                }
                case 97: {
                    this.HL = this.HL & 0xFF | this.C << 8;
                    break;
                }
                case 98: {
                    this.HL = this.HL & 0xFF | this.D << 8;
                    break;
                }
                case 99: {
                    this.HL = this.HL & 0xFF | this.E << 8;
                    break;
                }
                case 101: {
                    this.HL = this.HL & 0xFF | (this.HL & 0xFF) << 8;
                    break;
                }
                case 102: {
                    this.HL = this.HL & 0xFF | this.env.mem(this.HL) << 8;
                    this.ticks += 3;
                    break;
                }
                case 103: {
                    this.HL = this.HL & 0xFF | this.A << 8;
                    break;
                }
                case 104: {
                    this.HL = this.HL & 0xFF00 | this.B;
                    break;
                }
                case 105: {
                    this.HL = this.HL & 0xFF00 | this.C;
                    break;
                }
                case 106: {
                    this.HL = this.HL & 0xFF00 | this.D;
                    break;
                }
                case 107: {
                    this.HL = this.HL & 0xFF00 | this.E;
                    break;
                }
                case 108: {
                    this.HL = this.HL & 0xFF00 | this.HL >>> 8;
                    break;
                }
                case 110: {
                    this.HL = this.HL & 0xFF00 | this.env.mem(this.HL);
                    this.ticks += 3;
                    break;
                }
                case 111: {
                    this.HL = this.HL & 0xFF00 | this.A;
                    break;
                }
                case 112: {
                    this.env.mem(this.HL, this.B);
                    this.ticks += 3;
                    break;
                }
                case 113: {
                    this.env.mem(this.HL, this.C);
                    this.ticks += 3;
                    break;
                }
                case 114: {
                    this.env.mem(this.HL, this.D);
                    this.ticks += 3;
                    break;
                }
                case 115: {
                    this.env.mem(this.HL, this.E);
                    this.ticks += 3;
                    break;
                }
                case 116: {
                    this.env.mem(this.HL, this.HL >>> 8);
                    this.ticks += 3;
                    break;
                }
                case 117: {
                    this.env.mem(this.HL, this.HL & 0xFF);
                    this.ticks += 3;
                    break;
                }
                case 118: {
                    this.halt();
                    break;
                }
                case 119: {
                    this.env.mem(this.HL, this.A);
                    this.ticks += 3;
                    break;
                }
                case 120: {
                    this.A = this.B;
                    break;
                }
                case 121: {
                    this.A = this.C;
                    break;
                }
                case 122: {
                    this.A = this.D;
                    break;
                }
                case 123: {
                    this.A = this.E;
                    break;
                }
                case 124: {
                    this.A = this.HL >>> 8;
                    break;
                }
                case 125: {
                    this.A = this.HL & 0xFF;
                    break;
                }
                case 126: {
                    this.A = this.env.mem(this.HL);
                    this.ticks += 3;
                    break;
                }
                case 128: {
                    this.add(this.B);
                    break;
                }
                case 129: {
                    this.add(this.C);
                    break;
                }
                case 130: {
                    this.add(this.D);
                    break;
                }
                case 131: {
                    this.add(this.E);
                    break;
                }
                case 132: {
                    this.add(this.HL >>> 8);
                    break;
                }
                case 133: {
                    this.add(this.HL & 0xFF);
                    break;
                }
                case 134: {
                    this.add(this.env.mem(this.HL));
                    this.ticks += 3;
                    break;
                }
                case 135: {
                    this.add(this.A);
                    break;
                }
                case 136: {
                    this.adc(this.B);
                    break;
                }
                case 137: {
                    this.adc(this.C);
                    break;
                }
                case 138: {
                    this.adc(this.D);
                    break;
                }
                case 139: {
                    this.adc(this.E);
                    break;
                }
                case 140: {
                    this.adc(this.HL >>> 8);
                    break;
                }
                case 141: {
                    this.adc(this.HL & 0xFF);
                    break;
                }
                case 142: {
                    this.adc(this.env.mem(this.HL));
                    this.ticks += 3;
                    break;
                }
                case 143: {
                    this.adc(this.A);
                    break;
                }
                case 144: {
                    this.sub(this.B);
                    break;
                }
                case 145: {
                    this.sub(this.C);
                    break;
                }
                case 146: {
                    this.sub(this.D);
                    break;
                }
                case 147: {
                    this.sub(this.E);
                    break;
                }
                case 148: {
                    this.sub(this.HL >>> 8);
                    break;
                }
                case 149: {
                    this.sub(this.HL & 0xFF);
                    break;
                }
                case 150: {
                    this.sub(this.env.mem(this.HL));
                    this.ticks += 3;
                    break;
                }
                case 151: {
                    this.sub(this.A);
                    break;
                }
                case 152: {
                    this.sbc(this.B);
                    break;
                }
                case 153: {
                    this.sbc(this.C);
                    break;
                }
                case 154: {
                    this.sbc(this.D);
                    break;
                }
                case 155: {
                    this.sbc(this.E);
                    break;
                }
                case 156: {
                    this.sbc(this.HL >>> 8);
                    break;
                }
                case 157: {
                    this.sbc(this.HL & 0xFF);
                    break;
                }
                case 158: {
                    this.sbc(this.env.mem(this.HL));
                    this.ticks += 3;
                    break;
                }
                case 159: {
                    this.sbc(this.A);
                    break;
                }
                case 160: {
                    this.and(this.B);
                    break;
                }
                case 161: {
                    this.and(this.C);
                    break;
                }
                case 162: {
                    this.and(this.D);
                    break;
                }
                case 163: {
                    this.and(this.E);
                    break;
                }
                case 164: {
                    this.and(this.HL >>> 8);
                    break;
                }
                case 165: {
                    this.and(this.HL & 0xFF);
                    break;
                }
                case 166: {
                    this.and(this.env.mem(this.HL));
                    this.ticks += 3;
                    break;
                }
                case 167: {
                    this.and(this.A);
                    break;
                }
                case 168: {
                    this.xor(this.B);
                    break;
                }
                case 169: {
                    this.xor(this.C);
                    break;
                }
                case 170: {
                    this.xor(this.D);
                    break;
                }
                case 171: {
                    this.xor(this.E);
                    break;
                }
                case 172: {
                    this.xor(this.HL >>> 8);
                    break;
                }
                case 173: {
                    this.xor(this.HL & 0xFF);
                    break;
                }
                case 174: {
                    this.xor(this.env.mem(this.HL));
                    this.ticks += 3;
                    break;
                }
                case 175: {
                    this.xor(this.A);
                    break;
                }
                case 176: {
                    this.or(this.B);
                    break;
                }
                case 177: {
                    this.or(this.C);
                    break;
                }
                case 178: {
                    this.or(this.D);
                    break;
                }
                case 179: {
                    this.or(this.E);
                    break;
                }
                case 180: {
                    this.or(this.HL >>> 8);
                    break;
                }
                case 181: {
                    this.or(this.HL & 0xFF);
                    break;
                }
                case 182: {
                    this.or(this.env.mem(this.HL));
                    this.ticks += 3;
                    break;
                }
                case 183: {
                    this.or(this.A);
                    break;
                }
                case 184: {
                    this.cp(this.B);
                    break;
                }
                case 185: {
                    this.cp(this.C);
                    break;
                }
                case 186: {
                    this.cp(this.D);
                    break;
                }
                case 187: {
                    this.cp(this.E);
                    break;
                }
                case 188: {
                    this.cp(this.HL >>> 8);
                    break;
                }
                case 189: {
                    this.cp(this.HL & 0xFF);
                    break;
                }
                case 190: {
                    this.cp(this.env.mem(this.HL));
                    this.ticks += 3;
                    break;
                }
                case 191: {
                    this.cp(this.A);
                    break;
                }
                case 221: 
                case 253: {
                    this.group_xy(j);
                    break;
                }
                case 203: {
                    this.group_cb();
                    break;
                }
                case 237: {
                    this.group_ed();
                    break;
                }
                case 192: {
                    ++this.ticks;
                    if (this.Fr == 0) break;
                    this.ir = this.PC = this.pop();
                    break;
                }
                case 194: {
                    this.jp(this.Fr != 0);
                    break;
                }
                case 196: {
                    this.call(this.Fr != 0);
                    break;
                }
                case 200: {
                    ++this.ticks;
                    if (this.Fr != 0) break;
                    this.ir = this.PC = this.pop();
                    break;
                }
                case 202: {
                    this.jp(this.Fr == 0);
                    break;
                }
                case 204: {
                    this.call(this.Fr == 0);
                    break;
                }
                case 208: {
                    ++this.ticks;
                    if ((this.Ff & 0x100) != 0) break;
                    this.ir = this.PC = this.pop();
                    break;
                }
                case 210: {
                    this.jp((this.Ff & 0x100) == 0);
                    break;
                }
                case 212: {
                    this.call((this.Ff & 0x100) == 0);
                    break;
                }
                case 216: {
                    ++this.ticks;
                    if ((this.Ff & 0x100) == 0) break;
                    this.ir = this.PC = this.pop();
                    break;
                }
                case 218: {
                    this.jp((this.Ff & 0x100) != 0);
                    break;
                }
                case 220: {
                    this.call((this.Ff & 0x100) != 0);
                    break;
                }
                case 224: {
                    ++this.ticks;
                    if ((this.flags() & 4) != 0) break;
                    this.ir = this.PC = this.pop();
                    break;
                }
                case 226: {
                    this.jp((this.flags() & 4) == 0);
                    break;
                }
                case 228: {
                    this.call((this.flags() & 4) == 0);
                    break;
                }
                case 232: {
                    ++this.ticks;
                    if ((this.flags() & 4) == 0) break;
                    this.ir = this.PC = this.pop();
                    break;
                }
                case 234: {
                    this.jp((this.flags() & 4) != 0);
                    break;
                }
                case 236: {
                    this.call((this.flags() & 4) != 0);
                    break;
                }
                case 240: {
                    ++this.ticks;
                    if ((this.Ff & 0x80) != 0) break;
                    this.ir = this.PC = this.pop();
                    break;
                }
                case 242: {
                    this.jp((this.Ff & 0x80) == 0);
                    break;
                }
                case 244: {
                    this.call((this.Ff & 0x80) == 0);
                    break;
                }
                case 248: {
                    ++this.ticks;
                    if ((this.Ff & 0x80) == 0) break;
                    this.ir = this.PC = this.pop();
                    break;
                }
                case 250: {
                    this.jp((this.Ff & 0x80) != 0);
                    break;
                }
                case 252: {
                    this.call((this.Ff & 0x80) != 0);
                    break;
                }
                case 193: {
                    int l2 = this.pop();
                    this.B = l2 >> 8;
                    this.C = l2 & 0xFF;
                    break;
                }
                case 197: {
                    this.push(this.B << 8 | this.C);
                    break;
                }
                case 209: {
                    int i3 = this.pop();
                    this.D = i3 >> 8;
                    this.E = i3 & 0xFF;
                    break;
                }
                case 213: {
                    this.push(this.D << 8 | this.E);
                    break;
                }
                case 225: {
                    this.HL = this.pop();
                    break;
                }
                case 229: {
                    this.push(this.HL);
                    break;
                }
                case 241: {
                    this.af(this.pop());
                    break;
                }
                case 245: {
                    this.push(this.A << 8 | this.flags());
                    break;
                }
                case 195: {
                    this.PC = this.imm16();
                    break;
                }
                case 198: {
                    this.add(this.imm8());
                    break;
                }
                case 206: {
                    this.adc(this.imm8());
                    break;
                }
                case 214: {
                    this.sub(this.imm8());
                    break;
                }
                case 222: {
                    this.sbc(this.imm8());
                    break;
                }
                case 230: {
                    this.and(this.imm8());
                    break;
                }
                case 238: {
                    this.xor(this.imm8());
                    break;
                }
                case 246: {
                    this.or(this.imm8());
                    break;
                }
                case 254: {
                    this.cp(this.imm8());
                    break;
                }
                case 201: {
                    this.ir = this.PC = this.pop();
                    break;
                }
                case 205: {
                    int j3 = this.imm16();
                    this.env.cont(this.PC, 1);
                    this.push(this.PC);
                    this.ir = this.PC = j3;
                    break;
                }
                case 211: {
                    this.env.out(this.imm8() | this.A << 8, this.A);
                    this.ticks += 4;
                    break;
                }
                case 219: {
                    this.A = this.env.in(this.imm8() | this.A << 8);
                    this.ticks += 4;
                    break;
                }
                case 217: {
                    this.exx();
                    break;
                }
                case 227: {
                    int k3 = this.env.mem16(this.SP);
                    this.ticks += 7;
                    this.env.mem16(this.SP, this.HL);
                    this.HL = k3;
                    this.ticks += 8;
                    break;
                }
                case 233: {
                    this.PC = this.HL;
                    break;
                }
                case 235: {
                    int l3 = this.HL;
                    this.HL = this.D << 8 | this.E;
                    this.D = l3 >>> 8;
                    this.E = l3 & 0xFF;
                    break;
                }
                case 243: {
                    this.IFF = 0;
                    break;
                }
                case 251: {
                    this.IFF = 3;
                    break;
                }
                case 249: {
                    this.SP = this.HL;
                    this.ticks += 2;
                    break;
                }
                case 199: 
                case 207: 
                case 215: 
                case 223: 
                case 231: 
                case 239: 
                case 247: 
                case 255: {
                    this.push(this.PC);
                    this.PC = j - 199;
                }
            }
        } while (this.ticks_limit - this.ticks > 0);
    }

    private void group_xy(int j) {
        int k;
        block242: while (true) {
            k = j != 221 ? this.IY : this.IX;
            int l = this.env.m1(this.PC);
            this.PC = (char)(this.PC + 1);
            this.ticks += 4;
            ++this.R;
            switch (l) {
                default: {
                    break block242;
                }
                case 8: {
                    this.ex_af();
                    break block242;
                }
                case 16: {
                    ++this.ticks;
                    this.B = this.B - 1 & 0xFF;
                    this.jr(this.B != 0);
                    break block242;
                }
                case 24: {
                    this.jr(true);
                    break block242;
                }
                case 9: {
                    k = this.add16(k, this.B << 8 | this.C);
                    break block242;
                }
                case 25: {
                    k = this.add16(k, this.D << 8 | this.E);
                    break block242;
                }
                case 41: {
                    k = this.add16(k, k);
                    break block242;
                }
                case 57: {
                    k = this.add16(k, this.SP);
                    break block242;
                }
                case 1: {
                    this.bc(this.imm16());
                    break block242;
                }
                case 3: {
                    this.bc((char)(this.bc() + 1));
                    this.ticks += 2;
                    break block242;
                }
                case 11: {
                    this.bc((char)(this.bc() - 1));
                    this.ticks += 2;
                    break block242;
                }
                case 17: {
                    this.de(this.imm16());
                    break block242;
                }
                case 19: {
                    this.de((char)(this.de() + 1));
                    this.ticks += 2;
                    break block242;
                }
                case 27: {
                    this.de((char)(this.de() - 1));
                    this.ticks += 2;
                    break block242;
                }
                case 33: {
                    k = this.imm16();
                    break block242;
                }
                case 35: {
                    k = (char)(k + 1);
                    this.ticks += 2;
                    break block242;
                }
                case 43: {
                    k = (char)(k - 1);
                    this.ticks += 2;
                    break block242;
                }
                case 49: {
                    this.SP = this.imm16();
                    break block242;
                }
                case 51: {
                    this.SP = (char)(this.SP + 1);
                    this.ticks += 2;
                    break block242;
                }
                case 59: {
                    this.SP = (char)(this.SP - 1);
                    this.ticks += 2;
                    break block242;
                }
                case 2: {
                    this.env.mem(this.bc(), this.A);
                    this.ticks += 3;
                    break block242;
                }
                case 10: {
                    this.A = this.env.mem(this.bc());
                    this.ticks += 3;
                    break block242;
                }
                case 18: {
                    this.env.mem(this.de(), this.A);
                    this.ticks += 3;
                    break block242;
                }
                case 26: {
                    this.A = this.env.mem(this.de());
                    this.ticks += 3;
                    break block242;
                }
                case 34: {
                    this.env.mem16(this.imm16(), k);
                    this.ticks += 6;
                    break block242;
                }
                case 42: {
                    k = this.env.mem16(this.imm16());
                    this.ticks += 6;
                    break block242;
                }
                case 50: {
                    this.env.mem(this.imm16(), this.A);
                    this.ticks += 3;
                    break block242;
                }
                case 58: {
                    this.A = this.env.mem(this.imm16());
                    this.ticks += 3;
                    break block242;
                }
                case 4: {
                    this.B = this.inc(this.B);
                    break block242;
                }
                case 5: {
                    this.B = this.dec(this.B);
                    break block242;
                }
                case 6: {
                    this.B = this.imm8();
                    break block242;
                }
                case 12: {
                    this.C = this.inc(this.C);
                    break block242;
                }
                case 13: {
                    this.C = this.dec(this.C);
                    break block242;
                }
                case 14: {
                    this.C = this.imm8();
                    break block242;
                }
                case 20: {
                    this.D = this.inc(this.D);
                    break block242;
                }
                case 21: {
                    this.D = this.dec(this.D);
                    break block242;
                }
                case 22: {
                    this.D = this.imm8();
                    break block242;
                }
                case 28: {
                    this.E = this.inc(this.E);
                    break block242;
                }
                case 29: {
                    this.E = this.dec(this.E);
                    break block242;
                }
                case 30: {
                    this.E = this.imm8();
                    break block242;
                }
                case 36: {
                    k = k & 0xFF | this.inc(k >>> 8) << 8;
                    break block242;
                }
                case 37: {
                    k = k & 0xFF | this.dec(k >>> 8) << 8;
                    break block242;
                }
                case 38: {
                    k = k & 0xFF | this.imm8() << 8;
                    break block242;
                }
                case 44: {
                    k = k & 0xFF00 | this.inc(k & 0xFF);
                    break block242;
                }
                case 45: {
                    k = k & 0xFF00 | this.dec(k & 0xFF);
                    break block242;
                }
                case 46: {
                    k = k & 0xFF00 | this.imm8();
                    break block242;
                }
                case 52: {
                    int i1 = this.getd(k);
                    int k3 = this.inc(this.env.mem(i1));
                    this.ticks += 4;
                    this.env.mem(i1, k3);
                    this.ticks += 3;
                    break block242;
                }
                case 53: {
                    int j1 = this.getd(k);
                    int l3 = this.dec(this.env.mem(j1));
                    this.ticks += 4;
                    this.env.mem(j1, l3);
                    this.ticks += 3;
                    break block242;
                }
                case 54: {
                    char c = (char)(k + (byte)this.env.mem(this.PC));
                    this.ticks += 3;
                    int i4 = this.env.mem((char)(this.PC + 1));
                    this.ticks += 5;
                    this.env.mem(c, i4);
                    this.PC = (char)(this.PC + 2);
                    this.ticks += 3;
                    break block242;
                }
                case 60: {
                    this.A = this.inc(this.A);
                    break block242;
                }
                case 61: {
                    this.A = this.dec(this.A);
                    break block242;
                }
                case 62: {
                    this.A = this.imm8();
                    break block242;
                }
                case 32: {
                    this.jr(this.Fr != 0);
                    break block242;
                }
                case 40: {
                    this.jr(this.Fr == 0);
                    break block242;
                }
                case 48: {
                    this.jr((this.Ff & 0x100) == 0);
                    break block242;
                }
                case 56: {
                    this.jr((this.Ff & 0x100) != 0);
                    break block242;
                }
                case 7: {
                    int k1 = this.A << 1 | this.A >>> 7;
                    this.f_h0n0_c35(k1);
                    this.A = k1 & 0xFF;
                    break block242;
                }
                case 15: {
                    int l1 = this.A >>> 1;
                    this.f_h0n0_c35(l1 | this.A << 8);
                    this.A = l1 | this.A << 7 & 0xFF;
                    break block242;
                }
                case 23: {
                    int i2 = this.A << 1;
                    this.A = i2 & 0xFF | this.Ff >>> 8 & 1;
                    this.f_h0n0_c35(i2);
                    break block242;
                }
                case 31: {
                    int j2 = this.A;
                    this.A = (j2 | this.Ff & 0x100) >>> 1;
                    this.f_h0n0_c35(this.A | j2 << 8);
                    break block242;
                }
                case 39: {
                    this.daa();
                    break block242;
                }
                case 47: {
                    this.cpl();
                    break block242;
                }
                case 55: {
                    this.scf_ccf(0);
                    break block242;
                }
                case 63: {
                    this.scf_ccf(this.Ff & 0x100);
                    break block242;
                }
                case 65: {
                    this.B = this.C;
                    break block242;
                }
                case 66: {
                    this.B = this.D;
                    break block242;
                }
                case 67: {
                    this.B = this.E;
                    break block242;
                }
                case 68: {
                    this.B = k >>> 8;
                    break block242;
                }
                case 69: {
                    this.B = k & 0xFF;
                    break block242;
                }
                case 70: {
                    this.B = this.env.mem(this.getd(k));
                    this.ticks += 3;
                    break block242;
                }
                case 71: {
                    this.B = this.A;
                    break block242;
                }
                case 72: {
                    this.C = this.B;
                    break block242;
                }
                case 74: {
                    this.C = this.D;
                    break block242;
                }
                case 75: {
                    this.C = this.E;
                    break block242;
                }
                case 76: {
                    this.C = k >>> 8;
                    break block242;
                }
                case 77: {
                    this.C = k & 0xFF;
                    break block242;
                }
                case 78: {
                    this.C = this.env.mem(this.getd(k));
                    this.ticks += 3;
                    break block242;
                }
                case 79: {
                    this.C = this.A;
                    break block242;
                }
                case 80: {
                    this.D = this.B;
                    break block242;
                }
                case 81: {
                    this.D = this.C;
                    break block242;
                }
                case 83: {
                    this.D = this.E;
                    break block242;
                }
                case 84: {
                    this.D = k >>> 8;
                    break block242;
                }
                case 85: {
                    this.D = k & 0xFF;
                    break block242;
                }
                case 86: {
                    this.D = this.env.mem(this.getd(k));
                    this.ticks += 3;
                    break block242;
                }
                case 87: {
                    this.D = this.A;
                    break block242;
                }
                case 88: {
                    this.E = this.B;
                    break block242;
                }
                case 89: {
                    this.E = this.C;
                    break block242;
                }
                case 90: {
                    this.E = this.D;
                    break block242;
                }
                case 92: {
                    this.E = k >>> 8;
                    break block242;
                }
                case 93: {
                    this.E = k & 0xFF;
                    break block242;
                }
                case 94: {
                    this.E = this.env.mem(this.getd(k));
                    this.ticks += 3;
                    break block242;
                }
                case 95: {
                    this.E = this.A;
                    break block242;
                }
                case 96: {
                    k = k & 0xFF | this.B << 8;
                    break block242;
                }
                case 97: {
                    k = k & 0xFF | this.C << 8;
                    break block242;
                }
                case 98: {
                    k = k & 0xFF | this.D << 8;
                    break block242;
                }
                case 99: {
                    k = k & 0xFF | this.E << 8;
                    break block242;
                }
                case 101: {
                    k = k & 0xFF | (k & 0xFF) << 8;
                    break block242;
                }
                case 102: {
                    this.HL = this.HL & 0xFF | this.env.mem(this.getd(k)) << 8;
                    this.ticks += 3;
                    break block242;
                }
                case 103: {
                    k = k & 0xFF | this.A << 8;
                    break block242;
                }
                case 104: {
                    k = k & 0xFF00 | this.B;
                    break block242;
                }
                case 105: {
                    k = k & 0xFF00 | this.C;
                    break block242;
                }
                case 106: {
                    k = k & 0xFF00 | this.D;
                    break block242;
                }
                case 107: {
                    k = k & 0xFF00 | this.E;
                    break block242;
                }
                case 108: {
                    k = k & 0xFF00 | k >>> 8;
                    break block242;
                }
                case 110: {
                    this.HL = this.HL & 0xFF00 | this.env.mem(this.getd(k));
                    this.ticks += 3;
                    break block242;
                }
                case 111: {
                    k = k & 0xFF00 | this.A;
                    break block242;
                }
                case 112: {
                    this.env.mem(this.getd(k), this.B);
                    this.ticks += 3;
                    break block242;
                }
                case 113: {
                    this.env.mem(this.getd(k), this.C);
                    this.ticks += 3;
                    break block242;
                }
                case 114: {
                    this.env.mem(this.getd(k), this.D);
                    this.ticks += 3;
                    break block242;
                }
                case 115: {
                    this.env.mem(this.getd(k), this.E);
                    this.ticks += 3;
                    break block242;
                }
                case 116: {
                    this.env.mem(this.getd(k), this.HL >>> 8);
                    this.ticks += 3;
                    break block242;
                }
                case 117: {
                    this.env.mem(this.getd(k), this.HL & 0xFF);
                    this.ticks += 3;
                    break block242;
                }
                case 118: {
                    this.halt();
                    break block242;
                }
                case 119: {
                    this.env.mem(this.getd(k), this.A);
                    this.ticks += 3;
                    break block242;
                }
                case 120: {
                    this.A = this.B;
                    break block242;
                }
                case 121: {
                    this.A = this.C;
                    break block242;
                }
                case 122: {
                    this.A = this.D;
                    break block242;
                }
                case 123: {
                    this.A = this.E;
                    break block242;
                }
                case 124: {
                    this.A = k >>> 8;
                    break block242;
                }
                case 125: {
                    this.A = k & 0xFF;
                    break block242;
                }
                case 126: {
                    this.A = this.env.mem(this.getd(k));
                    this.ticks += 3;
                    break block242;
                }
                case 128: {
                    this.add(this.B);
                    break block242;
                }
                case 129: {
                    this.add(this.C);
                    break block242;
                }
                case 130: {
                    this.add(this.D);
                    break block242;
                }
                case 131: {
                    this.add(this.E);
                    break block242;
                }
                case 132: {
                    this.add(k >>> 8);
                    break block242;
                }
                case 133: {
                    this.add(k & 0xFF);
                    break block242;
                }
                case 134: {
                    this.add(this.env.mem(this.getd(k)));
                    this.ticks += 3;
                    break block242;
                }
                case 135: {
                    this.add(this.A);
                    break block242;
                }
                case 136: {
                    this.adc(this.B);
                    break block242;
                }
                case 137: {
                    this.adc(this.C);
                    break block242;
                }
                case 138: {
                    this.adc(this.D);
                    break block242;
                }
                case 139: {
                    this.adc(this.E);
                    break block242;
                }
                case 140: {
                    this.adc(k >>> 8);
                    break block242;
                }
                case 141: {
                    this.adc(k & 0xFF);
                    break block242;
                }
                case 142: {
                    this.adc(this.env.mem(this.getd(k)));
                    this.ticks += 3;
                    break block242;
                }
                case 143: {
                    this.adc(this.A);
                    break block242;
                }
                case 144: {
                    this.sub(this.B);
                    break block242;
                }
                case 145: {
                    this.sub(this.C);
                    break block242;
                }
                case 146: {
                    this.sub(this.D);
                    break block242;
                }
                case 147: {
                    this.sub(this.E);
                    break block242;
                }
                case 148: {
                    this.sub(k >>> 8);
                    break block242;
                }
                case 149: {
                    this.sub(k & 0xFF);
                    break block242;
                }
                case 150: {
                    this.sub(this.env.mem(this.getd(k)));
                    this.ticks += 3;
                    break block242;
                }
                case 151: {
                    this.sub(this.A);
                    break block242;
                }
                case 152: {
                    this.sbc(this.B);
                    break block242;
                }
                case 153: {
                    this.sbc(this.C);
                    break block242;
                }
                case 154: {
                    this.sbc(this.D);
                    break block242;
                }
                case 155: {
                    this.sbc(this.E);
                    break block242;
                }
                case 156: {
                    this.sbc(k >>> 8);
                    break block242;
                }
                case 157: {
                    this.sbc(k & 0xFF);
                    break block242;
                }
                case 158: {
                    this.sbc(this.env.mem(this.getd(k)));
                    this.ticks += 3;
                    break block242;
                }
                case 159: {
                    this.sbc(this.A);
                    break block242;
                }
                case 160: {
                    this.and(this.B);
                    break block242;
                }
                case 161: {
                    this.and(this.C);
                    break block242;
                }
                case 162: {
                    this.and(this.D);
                    break block242;
                }
                case 163: {
                    this.and(this.E);
                    break block242;
                }
                case 164: {
                    this.and(k >>> 8);
                    break block242;
                }
                case 165: {
                    this.and(k & 0xFF);
                    break block242;
                }
                case 166: {
                    this.and(this.env.mem(this.getd(k)));
                    this.ticks += 3;
                    break block242;
                }
                case 167: {
                    this.and(this.A);
                    break block242;
                }
                case 168: {
                    this.xor(this.B);
                    break block242;
                }
                case 169: {
                    this.xor(this.C);
                    break block242;
                }
                case 170: {
                    this.xor(this.D);
                    break block242;
                }
                case 171: {
                    this.xor(this.E);
                    break block242;
                }
                case 172: {
                    this.xor(k >>> 8);
                    break block242;
                }
                case 173: {
                    this.xor(k & 0xFF);
                    break block242;
                }
                case 174: {
                    this.xor(this.env.mem(this.getd(k)));
                    this.ticks += 3;
                    break block242;
                }
                case 175: {
                    this.xor(this.A);
                    break block242;
                }
                case 176: {
                    this.or(this.B);
                    break block242;
                }
                case 177: {
                    this.or(this.C);
                    break block242;
                }
                case 178: {
                    this.or(this.D);
                    break block242;
                }
                case 179: {
                    this.or(this.E);
                    break block242;
                }
                case 180: {
                    this.or(k >>> 8);
                    break block242;
                }
                case 181: {
                    this.or(k & 0xFF);
                    break block242;
                }
                case 182: {
                    this.or(this.env.mem(this.getd(k)));
                    this.ticks += 3;
                    break block242;
                }
                case 183: {
                    this.or(this.A);
                    break block242;
                }
                case 184: {
                    this.cp(this.B);
                    break block242;
                }
                case 185: {
                    this.cp(this.C);
                    break block242;
                }
                case 186: {
                    this.cp(this.D);
                    break block242;
                }
                case 187: {
                    this.cp(this.E);
                    break block242;
                }
                case 188: {
                    this.cp(k >>> 8);
                    break block242;
                }
                case 189: {
                    this.cp(k & 0xFF);
                    break block242;
                }
                case 190: {
                    this.cp(this.env.mem(this.getd(k)));
                    this.ticks += 3;
                    break block242;
                }
                case 191: {
                    this.cp(this.A);
                    break block242;
                }
                case 221: 
                case 253: {
                    j = l;
                    continue block242;
                }
                case 203: {
                    this.group_xy_cb(k);
                    break block242;
                }
                case 237: {
                    this.group_ed();
                    break block242;
                }
                case 192: {
                    ++this.ticks;
                    if (this.Fr == 0) break block242;
                    this.ir = this.PC = this.pop();
                    break block242;
                }
                case 194: {
                    this.jp(this.Fr != 0);
                    break block242;
                }
                case 196: {
                    this.call(this.Fr != 0);
                    break block242;
                }
                case 200: {
                    ++this.ticks;
                    if (this.Fr != 0) break block242;
                    this.ir = this.PC = this.pop();
                    break block242;
                }
                case 202: {
                    this.jp(this.Fr == 0);
                    break block242;
                }
                case 204: {
                    this.call(this.Fr == 0);
                    break block242;
                }
                case 208: {
                    ++this.ticks;
                    if ((this.Ff & 0x100) != 0) break block242;
                    this.ir = this.PC = this.pop();
                    break block242;
                }
                case 210: {
                    this.jp((this.Ff & 0x100) == 0);
                    break block242;
                }
                case 212: {
                    this.call((this.Ff & 0x100) == 0);
                    break block242;
                }
                case 216: {
                    ++this.ticks;
                    if ((this.Ff & 0x100) == 0) break block242;
                    this.ir = this.PC = this.pop();
                    break block242;
                }
                case 218: {
                    this.jp((this.Ff & 0x100) != 0);
                    break block242;
                }
                case 220: {
                    this.call((this.Ff & 0x100) != 0);
                    break block242;
                }
                case 224: {
                    ++this.ticks;
                    if ((this.flags() & 4) != 0) break block242;
                    this.ir = this.PC = this.pop();
                    break block242;
                }
                case 226: {
                    this.jp((this.flags() & 4) == 0);
                    break block242;
                }
                case 228: {
                    this.call((this.flags() & 4) == 0);
                    break block242;
                }
                case 232: {
                    ++this.ticks;
                    if ((this.flags() & 4) == 0) break block242;
                    this.ir = this.PC = this.pop();
                    break block242;
                }
                case 234: {
                    this.jp((this.flags() & 4) != 0);
                    break block242;
                }
                case 236: {
                    this.call((this.flags() & 4) != 0);
                    break block242;
                }
                case 240: {
                    ++this.ticks;
                    if ((this.Ff & 0x80) != 0) break block242;
                    this.ir = this.PC = this.pop();
                    break block242;
                }
                case 242: {
                    this.jp((this.Ff & 0x80) == 0);
                    break block242;
                }
                case 244: {
                    this.call((this.Ff & 0x80) == 0);
                    break block242;
                }
                case 248: {
                    ++this.ticks;
                    if ((this.Ff & 0x80) == 0) break block242;
                    this.ir = this.PC = this.pop();
                    break block242;
                }
                case 250: {
                    this.jp((this.Ff & 0x80) != 0);
                    break block242;
                }
                case 252: {
                    this.call((this.Ff & 0x80) != 0);
                    break block242;
                }
                case 193: {
                    int k2 = this.pop();
                    this.B = k2 >> 8;
                    this.C = k2 & 0xFF;
                    break block242;
                }
                case 197: {
                    this.push(this.B << 8 | this.C);
                    break block242;
                }
                case 209: {
                    int l2 = this.pop();
                    this.D = l2 >> 8;
                    this.E = l2 & 0xFF;
                    break block242;
                }
                case 213: {
                    this.push(this.D << 8 | this.E);
                    break block242;
                }
                case 225: {
                    k = this.pop();
                    break block242;
                }
                case 229: {
                    this.push(k);
                    break block242;
                }
                case 241: {
                    this.af(this.pop());
                    break block242;
                }
                case 245: {
                    this.push(this.A << 8 | this.flags());
                    break block242;
                }
                case 195: {
                    this.PC = this.imm16();
                    break block242;
                }
                case 198: {
                    this.add(this.imm8());
                    break block242;
                }
                case 206: {
                    this.adc(this.imm8());
                    break block242;
                }
                case 214: {
                    this.sub(this.imm8());
                    break block242;
                }
                case 222: {
                    this.sbc(this.imm8());
                    break block242;
                }
                case 230: {
                    this.and(this.imm8());
                    break block242;
                }
                case 238: {
                    this.xor(this.imm8());
                    break block242;
                }
                case 246: {
                    this.or(this.imm8());
                    break block242;
                }
                case 254: {
                    this.cp(this.imm8());
                    break block242;
                }
                case 201: {
                    this.ir = this.PC = this.pop();
                    break block242;
                }
                case 205: {
                    this.call(true);
                    break block242;
                }
                case 211: {
                    this.env.out(this.imm8() | this.A << 8, this.A);
                    this.ticks += 4;
                    break block242;
                }
                case 219: {
                    this.A = this.env.in(this.imm8() | this.A << 8);
                    this.ticks += 4;
                    break block242;
                }
                case 217: {
                    this.exx();
                    break block242;
                }
                case 227: {
                    int i3 = this.env.mem16(this.SP);
                    this.ticks += 7;
                    this.env.mem16(this.SP, k);
                    k = i3;
                    this.ticks += 8;
                    break block242;
                }
                case 233: {
                    this.PC = k;
                    break block242;
                }
                case 235: {
                    int j3 = this.HL;
                    this.HL = this.de();
                    this.de(j3);
                    break block242;
                }
                case 243: {
                    this.IFF = 0;
                    break block242;
                }
                case 251: {
                    this.IFF = 3;
                    break block242;
                }
                case 249: {
                    this.SP = k;
                    this.ticks += 2;
                    break block242;
                }
                case 199: 
                case 207: 
                case 215: 
                case 223: 
                case 231: 
                case 239: 
                case 247: 
                case 255: {
                    this.push(this.PC);
                    this.PC = l - 199;
                    break block242;
                }
            }
            break;
        }
        if (j == 221) {
            this.IX = k;
        } else {
            this.IY = k;
        }
    }

    private void group_ed() {
        int j = this.env.m1(this.PC);
        this.PC = (char)(this.PC + 1);
        this.ticks += 4;
        ++this.R;
        switch (j) {
            case 71: {
                this.I = this.A;
                ++this.ticks;
                break;
            }
            case 79: {
                this.r(this.A);
                ++this.ticks;
                break;
            }
            case 87: {
                this.ld_a_ir(this.I);
                break;
            }
            case 95: {
                this.ld_a_ir(this.r());
                break;
            }
            case 103: {
                this.rrd();
                break;
            }
            case 111: {
                this.rld();
                break;
            }
            case 64: {
                this.B = this.env.in(this.B << 8 | this.C);
                this.f_szh0n0p(this.B);
                this.ticks += 4;
                break;
            }
            case 72: {
                this.C = this.env.in(this.B << 8 | this.C);
                this.f_szh0n0p(this.C);
                this.ticks += 4;
                break;
            }
            case 80: {
                this.D = this.env.in(this.B << 8 | this.C);
                this.f_szh0n0p(this.D);
                this.ticks += 4;
                break;
            }
            case 88: {
                this.E = this.env.in(this.B << 8 | this.C);
                this.f_szh0n0p(this.E);
                this.ticks += 4;
                break;
            }
            case 96: {
                int k = this.env.in(this.B << 8 | this.C);
                this.HL = this.HL & 0xFF | k << 8;
                this.f_szh0n0p(k);
                this.ticks += 4;
                break;
            }
            case 104: {
                int l = this.env.in(this.B << 8 | this.C);
                this.HL = this.HL & 0xFF00 | l;
                this.f_szh0n0p(l);
                this.ticks += 4;
                break;
            }
            case 112: {
                this.f_szh0n0p(this.env.in(this.B << 8 | this.C));
                this.ticks += 4;
                break;
            }
            case 120: {
                this.A = this.env.in(this.B << 8 | this.C);
                this.f_szh0n0p(this.A);
                this.ticks += 4;
                break;
            }
            case 65: {
                this.env.out(this.B << 8 | this.C, this.B);
                this.ticks += 4;
                break;
            }
            case 73: {
                this.env.out(this.B << 8 | this.C, this.C);
                this.ticks += 4;
                break;
            }
            case 81: {
                this.env.out(this.B << 8 | this.C, this.D);
                this.ticks += 4;
                break;
            }
            case 89: {
                this.env.out(this.B << 8 | this.C, this.E);
                this.ticks += 4;
                break;
            }
            case 97: {
                this.env.out(this.B << 8 | this.C, this.HL >>> 8);
                this.ticks += 4;
                break;
            }
            case 105: {
                this.env.out(this.B << 8 | this.C, this.HL & 0xFF);
                this.ticks += 4;
                break;
            }
            case 113: {
                this.env.out(this.B << 8 | this.C, 0);
                this.ticks += 4;
                break;
            }
            case 121: {
                this.env.out(this.B << 8 | this.C, this.A);
                this.ticks += 4;
                break;
            }
            case 66: {
                this.sbc_hl(this.B << 8 | this.C);
                break;
            }
            case 74: {
                this.adc_hl(this.B << 8 | this.C);
                break;
            }
            case 67: {
                this.env.mem16(this.imm16(), this.B << 8 | this.C);
                this.ticks += 6;
                break;
            }
            case 75: {
                int i1 = this.env.mem16(this.imm16());
                this.B = i1 >>> 8;
                this.C = i1 & 0xFF;
                this.ticks += 6;
                break;
            }
            case 82: {
                this.sbc_hl(this.D << 8 | this.E);
                break;
            }
            case 90: {
                this.adc_hl(this.D << 8 | this.E);
                break;
            }
            case 83: {
                this.env.mem16(this.imm16(), this.D << 8 | this.E);
                this.ticks += 6;
                break;
            }
            case 91: {
                int j1 = this.env.mem16(this.imm16());
                this.D = j1 >>> 8;
                this.E = j1 & 0xFF;
                this.ticks += 6;
                break;
            }
            case 98: {
                this.sbc_hl(this.HL);
                break;
            }
            case 106: {
                this.adc_hl(this.HL);
                break;
            }
            case 99: {
                this.env.mem16(this.imm16(), this.HL);
                this.ticks += 6;
                break;
            }
            case 107: {
                this.HL = this.env.mem16(this.imm16());
                this.ticks += 6;
                break;
            }
            case 114: {
                this.sbc_hl(this.SP);
                break;
            }
            case 122: {
                this.adc_hl(this.SP);
                break;
            }
            case 115: {
                this.env.mem16(this.imm16(), this.SP);
                this.ticks += 6;
                break;
            }
            case 123: {
                this.SP = this.env.mem16(this.imm16());
                this.ticks += 6;
                break;
            }
            case 68: 
            case 76: 
            case 84: 
            case 92: 
            case 100: 
            case 108: 
            case 116: 
            case 124: {
                int k1 = this.A;
                this.A = 0;
                this.sub(k1);
                break;
            }
            case 69: 
            case 77: 
            case 85: 
            case 93: 
            case 101: 
            case 109: 
            case 117: 
            case 125: {
                this.IFF |= this.IFF >> 1;
                this.PC = this.pop();
                break;
            }
            case 70: 
            case 78: 
            case 86: 
            case 94: 
            case 102: 
            case 110: 
            case 118: 
            case 126: {
                this.IM = (byte)(j >> 3 & 3);
                break;
            }
            case 160: {
                this.ldir(1, false);
                break;
            }
            case 168: {
                this.ldir(-1, false);
                break;
            }
            case 176: {
                this.ldir(1, true);
                break;
            }
            case 184: {
                this.ldir(-1, true);
                break;
            }
            case 161: {
                this.cpir(1, false);
                break;
            }
            case 169: {
                this.cpir(-1, false);
                break;
            }
            case 177: {
                this.cpir(1, true);
                break;
            }
            case 185: {
                this.cpir(-1, true);
                break;
            }
            case 162: 
            case 163: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 186: 
            case 187: {
                this.inir_otir(j);
                break;
            }
            default: {
                System.out.println(String.valueOf(this.PC) + ": Not emulated ED/" + j);
            }
        }
    }

    private void group_cb() {
        int j = this.env.m1(this.PC);
        this.PC = (char)(this.PC + 1);
        this.ticks += 4;
        ++this.R;
        int k = j >>> 3 & 7;
        switch (j & 0xC7) {
            case 0: {
                this.B = this.shifter(k, this.B);
                break;
            }
            case 1: {
                this.C = this.shifter(k, this.C);
                break;
            }
            case 2: {
                this.D = this.shifter(k, this.D);
                break;
            }
            case 3: {
                this.E = this.shifter(k, this.E);
                break;
            }
            case 4: {
                this.HL = this.HL & 0xFF | this.shifter(k, this.HL >>> 8) << 8;
                break;
            }
            case 5: {
                this.HL = this.HL & 0xFF00 | this.shifter(k, this.HL & 0xFF);
                break;
            }
            case 6: {
                int l = this.shifter(k, this.env.mem(this.HL));
                this.ticks += 4;
                this.env.mem(this.HL, l);
                this.ticks += 3;
                break;
            }
            case 7: {
                this.A = this.shifter(k, this.A);
                break;
            }
            case 64: {
                this.bit(k, this.B);
                break;
            }
            case 65: {
                this.bit(k, this.C);
                break;
            }
            case 66: {
                this.bit(k, this.D);
                break;
            }
            case 67: {
                this.bit(k, this.E);
                break;
            }
            case 68: {
                this.bit(k, this.HL >>> 8);
                break;
            }
            case 69: {
                this.bit(k, this.HL & 0xFF);
                break;
            }
            case 70: {
                this.bit(k, this.env.mem(this.HL));
                this.Ff = this.Ff & 0xFFFFFFD7 | this.ir >>> 8 & 0x28;
                this.ticks += 4;
                break;
            }
            case 71: {
                this.bit(k, this.A);
                break;
            }
            case 128: {
                this.B &= ~(1 << k);
                break;
            }
            case 129: {
                this.C &= ~(1 << k);
                break;
            }
            case 130: {
                this.D &= ~(1 << k);
                break;
            }
            case 131: {
                this.E &= ~(1 << k);
                break;
            }
            case 132: {
                this.HL &= ~(256 << k);
                break;
            }
            case 133: {
                this.HL &= ~(1 << k);
                break;
            }
            case 134: {
                int i1 = this.env.mem(this.HL) & ~(1 << k);
                this.ticks += 4;
                this.env.mem(this.HL, i1);
                this.ticks += 3;
                break;
            }
            case 135: {
                this.A &= ~(1 << k);
                break;
            }
            case 192: {
                this.B |= 1 << k;
                break;
            }
            case 193: {
                this.C |= 1 << k;
                break;
            }
            case 194: {
                this.D |= 1 << k;
                break;
            }
            case 195: {
                this.E |= 1 << k;
                break;
            }
            case 196: {
                this.HL |= 256 << k;
                break;
            }
            case 197: {
                this.HL |= 1 << k;
                break;
            }
            case 198: {
                int j1 = this.env.mem(this.HL) | 1 << k;
                this.ticks += 4;
                this.env.mem(this.HL, j1);
                this.ticks += 3;
                break;
            }
            case 199: {
                this.A |= 1 << k;
            }
        }
    }

    private void group_xy_cb(int j) {
        int k = this.PC;
        this.ir = (char)(j + (byte)this.env.mem(k));
        char c = (char)this.ir;
        this.ticks += 3;
        int l = this.env.mem((char)(k + 1));
        this.PC = (char)(k + 2);
        this.ticks += 5;
        int i1 = this.env.mem(c);
        this.ticks += 4;
        int j1 = l >>> 3 & 7;
        switch (l & 0xC0) {
            case 0: {
                i1 = this.shifter(j1, i1);
                break;
            }
            case 64: {
                this.bit(j1, i1);
                this.Ff = this.Ff & 0xFFFFFFD7 | c >> 8 & 0x28;
                return;
            }
            case 128: {
                i1 &= ~(1 << j1);
                break;
            }
            case 192: {
                i1 |= 1 << j1;
            }
        }
        this.env.mem(c, i1);
        this.ticks += 3;
        switch (l & 7) {
            case 0: {
                this.B = i1;
                break;
            }
            case 1: {
                this.C = i1;
                break;
            }
            case 2: {
                this.D = i1;
                break;
            }
            case 3: {
                this.E = i1;
                break;
            }
            case 4: {
                this.HL = this.HL & 0xFF | i1 << 8;
                break;
            }
            case 5: {
                this.HL = this.HL & 0xFF00 | i1;
                break;
            }
            case 7: {
                this.A = i1;
            }
        }
    }

    boolean interrupt(int j) {
        if ((this.IFF & 1) == 0) {
            return false;
        }
        this.IFF = 0;
        this.halted = false;
        this.ticks += 6;
        this.push(this.PC);
        switch (this.IM) {
            default: {
                break;
            }
            case 0: 
            case 1: {
                if ((j | 0x38) == 255) {
                    this.PC = j - 199;
                    break;
                }
            }
            case 2: {
                this.PC = 56;
                break;
            }
            case 3: {
                this.PC = this.env.mem16(this.I << 8 | j);
                this.ticks += 6;
            }
        }
        return true;
    }

    void nmi() {
        this.IFF &= 2;
        this.halted = false;
        this.push(this.PC);
        this.ticks += 4;
        this.PC = 102;
    }

    void reset() {
        this.halted = false;
        this.IM = 0;
        this.IFF = 0;
        this.PC = 0;
        this.SP = 65535;
        this.af(65535);
    }

    static interface Env {
        public int m1(int var1);

        public int mem(int var1);

        public void mem(int var1, int var2);

        public int in(int var1);

        public void out(int var1, int var2);

        public int mem16(int var1);

        public void mem16(int var1, int var2);

        public void cont(int var1, int var2);
    }
}

