;for TMPX assembler
INT2STR = $A45F  ;print unsigned integer in AC:XR
BSOUT = $FFD2    ;print char in AC

N = 3500   ;1000 digits
;N = 2800  ;800 digits
b = $d4   ;$d5
c = $d6   ;$d7
d = $d0   ;..$d3
i = $d8   ;$d9
k = $da   ;$db

divisor = $de     ;$df, $e0..$e1 used for hi-byte
dividend = $e2	  ;..$e5 used for hi-bytes
remainder = $e6	  ;..$e7 used for hi-byte
result = dividend ;save memory by reusing divident to store the result
product = divisor
fac1 = dividend
fac2 = remainder
rbase = $dc ;$dd

         * = $1030
         .block
         lda #$b
         sta $ff06   ;screen blank
         ;lda #$48
         ;sta $ff07   ;ntsc on
         ;sei         ;no interrupts
         lda #147    ;clear screen
         jsr BSOUT

         ldx #(N+1)/128+1   ;fill r-array
         ldy #0
         sty i
         lda #>r
         sta i+1
lf0      lda #<2000
         sta (i),y
         iny
         lda #>2000
         sta (i),y
         iny
         bne lf0

         inc i+1
         dex
         bne lf0

         lda #<N        ;k <- N
         sta k
         lda #>N
         sta k+1
         lda #0
         sta c
         sta c+1
         sta rbase

loop     lda #0          ;d <- 0
         sta d
         sta d+1
         sta d+2
         sta d+3

         lda k          ;i <-k
         sta i
         lda k+1
         sta i+1
loop2    lda i
         asl
         tay
         sta b
         lda i+1
         rol
         sta b+1       ; b <- 2*i

         adc #>r
         sta rbase+1     ; r[i]
         lda (rbase),y
         sta fac1
         iny
         lda (rbase),y
         sta fac1+1
         lda #<10000
         sta fac2
         lda #>10000
         sta fac2+1
         jsr mul16x16    ;r[i]*10000
         lda product      ; d <- d + r[i]*10000
         clc
         adc d
         sta d
         sta dividend
         lda product+1
         adc d+1
         sta d+1
         sta dividend+1
         lda product+2
         adc d+2
         sta d+2
         sta dividend+2
         lda product+3
         adc d+3
         sta d+3
         sta dividend+3

         ldy b+1
         ldx b             ;b <- b - 1
         bne l1

         dey
         sty b+1
l1       dex
         stx b
         stx divisor
         sty divisor+1
         jsr div32x16
         lda i
         asl
         tay
         lda remainder    ;r[i] <- d%b
m3       sta (rbase),y
         lda remainder+1
         iny
m4       sta (rbase),y

         lda result      ;d <- d/b
         sta d
         lda result+1
         sta d+1
         lda result+2
         sta d+2
         lda result+3
         sta d+3

         ldy i+1      ;i <- i - 1
         ldx i
         bne l3

         dey
         sty i+1
l3       dex
         stx i
         stx fac2
         sty fac2+1
         txa
         ora i+1
         beq l4

         jsr mul32x16
         lda product      ;d <- d*i
         sta d
         lda product+1
         sta d+1
         lda product+2
         sta d+2
         lda product+3
         sta d+3
         jmp loop2

l4       lda #>10000
         sta divisor+1
         lda #<10000
         sta divisor
         lda d
         sta dividend
         lda d+1
         sta dividend+1
         lda d+2
         sta dividend+2
         lda d+3
         sta dividend+3
         jsr div32x16
         clc
         lda result
         adc c
         tax
         lda result+1
         adc c+1
         tay
         lda #48
         cpy #>1000
         beq l6
         bcs l5

l6       cpx #<1000
         bcc l7

l5       tya
         jsr INT2STR
         ;sei
         lda remainder
         sta c
         lda remainder+1
         sta c+1

         lda k      ;k <- k - 14
         sec
         sbc #14
         sta k
         bcs l11

         dec k+1
l11      ora k+1
         beq exit
         jmp loop

exit     lda #$1b
         sta $ff06   ;screen on
         lda #8
         sta $ff07   ;ntsc off
         cli         ;interrupts enabled
         rts

l7       jsr BSOUT
         cpy #>100
         beq l8
         bcs l5

l8       cpx #<100
         bcs l5

         jsr BSOUT
         cpx #10
         bcs l5

         jsr BSOUT
         jmp l5
         .bend

div32x16	.block
        lda #0	        ;preset remainder to 0
	sta remainder
	sta remainder+1

cnt  .var 5      ;6 for N=350, 5 - 2800
loop .lbl   ;optimize to div27x16
        asl dividend	;dividend lb & hb*2, msb -> Carry
	rol dividend+1	
        rol dividend+2
        rol dividend+3
cnt  .var cnt-1
     .ifne cnt
     .goto loop
     .endif

cnt  .var 27
loop2 .lbl
       	asl dividend	;dividend lb & hb*2, msb -> Carry
	rol dividend+1	
        rol dividend+2
        rol dividend+3
	rol remainder	;remainder lb & hb * 2 + msb from carry
	rol remainder+1
	lda remainder
	sec
	sbc divisor	;substract divisor to see if it fits in
	tay	        ;lb result -> Y, for we may need it later
	lda remainder+1
	sbc divisor+1
	bcc *+8	;if carry=0 then divisor didn't fit in yet

	sta remainder+1	;else save substraction result as new remainder,
	sty remainder	
	inc result	;and INCrement result cause divisor fit in 1 times

cnt  .var cnt-1
     .ifne cnt
     .goto loop2
     .endif	
	rts
        .bend

mul8x8    .block   ;in - AC,XR; out - AC:YR
            sta m1+1
            sta m3+1
            eor #$ff                                              
            sta m2+1
            sta m4+1                                             
            sec   
m1          lda sqrsum_lo,x
m2          sbc sqrdif_lo,x
            tay   
m3          lda sqrsum_hi,x
m4          sbc sqrdif_hi,x
    rts
    .bend

mul16x16 .block
         lda fac1
         ldx fac2
         jsr mul8x8
         sta product+1
         sty product

         lda fac1+1
         ldx fac2+1
         jsr mul8x8
         sta product+3
         sty product+2

         ldx fac1
         lda fac2+1
         jsr mul8x8
         clc
         tax
         tya
         adc product+1
         sta product+1
         txa
         adc product+2
         sta product+2
         bcc l1

         inc product+3
l1       ldx fac1+1
         lda fac2
         jsr mul8x8
         clc
         tax
         tya
         adc product+1
         sta product+1
         txa
         adc product+2
         sta product+2
         bcc l2

         inc product+3
l2       rts
         .bend

mul32x16 .block
         jsr mul16x16
         ldx fac1+2
         lda fac2
         jsr mul8x8
         clc
         tax
         tya
         adc product+2
         sta product+2
         txa
         adc product+3
         sta product+3

         ldx fac1+2
         lda fac2+1
         jsr mul8x8
         clc
         tya
         adc product+3
         sta product+3

         ldx fac1+3
         lda fac2
         jsr mul8x8
         clc
         tya
         adc product+3
         sta product+3
         rts
         .bend

         * = $1600
sqrsum_lo .byte $0,$0,$1,$2,$4,$6,$9,$c,$10,$14,$19,$1e,$24,$2a,$31,$38
 .byte $40,$48,$51,$5a,$64,$6e,$79,$84,$90,$9c,$a9,$b6,$c4,$d2,$e1,$f0
 .byte $0,$10,$21,$32,$44,$56,$69,$7c,$90,$a4,$b9,$ce,$e4,$fa,$11,$28
 .byte $40,$58,$71,$8a,$a4,$be,$d9,$f4,$10,$2c,$49,$66,$84,$a2,$c1,$e0
 .byte $0,$20,$41,$62,$84,$a6,$c9,$ec,$10,$34,$59,$7e,$a4,$ca,$f1,$18
 .byte $40,$68,$91,$ba,$e4,$e,$39,$64,$90,$bc,$e9,$16,$44,$72,$a1,$d0
 .byte $0,$30,$61,$92,$c4,$f6,$29,$5c,$90,$c4,$f9,$2e,$64,$9a,$d1,$8
 .byte $40,$78,$b1,$ea,$24,$5e,$99,$d4,$10,$4c,$89,$c6,$4,$42,$81,$c0
 .byte $0,$40,$81,$c2,$4,$46,$89,$cc,$10,$54,$99,$de,$24,$6a,$b1,$f8
 .byte $40,$88,$d1,$1a,$64,$ae,$f9,$44,$90,$dc,$29,$76,$c4,$12,$61,$b0
 .byte $0,$50,$a1,$f2,$44,$96,$e9,$3c,$90,$e4,$39,$8e,$e4,$3a,$91,$e8
 .byte $40,$98,$f1,$4a,$a4,$fe,$59,$b4,$10,$6c,$c9,$26,$84,$e2,$41,$a0
 .byte $0,$60,$c1,$22,$84,$e6,$49,$ac,$10,$74,$d9,$3e,$a4,$a,$71,$d8
 .byte $40,$a8,$11,$7a,$e4,$4e,$b9,$24,$90,$fc,$69,$d6,$44,$b2,$21,$90
 .byte $0,$70,$e1,$52,$c4,$36,$a9,$1c,$90,$4,$79,$ee,$64,$da,$51,$c8
 .byte $40,$b8,$31,$aa,$24,$9e,$19,$94,$10,$8c,$9,$86,$4,$82,$1,$80
 .byte $0,$80,$1,$82,$4,$86,$9,$8c,$10,$94,$19,$9e,$24,$aa,$31,$b8
 .byte $40,$c8,$51,$da,$64,$ee,$79,$4,$90,$1c,$a9,$36,$c4,$52,$e1,$70
 .byte $0,$90,$21,$b2,$44,$d6,$69,$fc,$90,$24,$b9,$4e,$e4,$7a,$11,$a8
 .byte $40,$d8,$71,$a,$a4,$3e,$d9,$74,$10,$ac,$49,$e6,$84,$22,$c1,$60
 .byte $0,$a0,$41,$e2,$84,$26,$c9,$6c,$10,$b4,$59,$fe,$a4,$4a,$f1,$98
 .byte $40,$e8,$91,$3a,$e4,$8e,$39,$e4,$90,$3c,$e9,$96,$44,$f2,$a1,$50
 .byte $0,$b0,$61,$12,$c4,$76,$29,$dc,$90,$44,$f9,$ae,$64,$1a,$d1,$88
 .byte $40,$f8,$b1,$6a,$24,$de,$99,$54,$10,$cc,$89,$46,$4,$c2,$81,$40
 .byte $0,$c0,$81,$42,$4,$c6,$89,$4c,$10,$d4,$99,$5e,$24,$ea,$b1,$78
 .byte $40,$8,$d1,$9a,$64,$2e,$f9,$c4,$90,$5c,$29,$f6,$c4,$92,$61,$30
 .byte $0,$d0,$a1,$72,$44,$16,$e9,$bc,$90,$64,$39,$e,$e4,$ba,$91,$68
 .byte $40,$18,$f1,$ca,$a4,$7e,$59,$34,$10,$ec,$c9,$a6,$84,$62,$41,$20
 .byte $0,$e0,$c1,$a2,$84,$66,$49,$2c,$10,$f4,$d9,$be,$a4,$8a,$71,$58
 .byte $40,$28,$11,$fa,$e4,$ce,$b9,$a4,$90,$7c,$69,$56,$44,$32,$21,$10
 .byte $0,$f0,$e1,$d2,$c4,$b6,$a9,$9c,$90,$84,$79,$6e,$64,$5a,$51,$48
 .byte $40,$38,$31,$2a,$24,$1e,$19,$14,$10,$c,$9,$6,$4,$2,$1,$0

sqrsum_hi .byte $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
 .byte $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
 .byte $1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$2,$2
 .byte $2,$2,$2,$2,$2,$2,$2,$2,$3,$3,$3,$3,$3,$3,$3,$3
 .byte $4,$4,$4,$4,$4,$4,$4,$4,$5,$5,$5,$5,$5,$5,$5,$6
 .byte $6,$6,$6,$6,$6,$7,$7,$7,$7,$7,$7,$8,$8,$8,$8,$8
 .byte $9,$9,$9,$9,$9,$9,$a,$a,$a,$a,$a,$b,$b,$b,$b,$c
 .byte $c,$c,$c,$c,$d,$d,$d,$d,$e,$e,$e,$e,$f,$f,$f,$f
 .byte $10,$10,$10,$10,$11,$11,$11,$11,$12,$12,$12,$12,$13,$13,$13,$13
 .byte $14,$14,$14,$15,$15,$15,$15,$16,$16,$16,$17,$17,$17,$18,$18,$18
 .byte $19,$19,$19,$19,$1a,$1a,$1a,$1b,$1b,$1b,$1c,$1c,$1c,$1d,$1d,$1d
 .byte $1e,$1e,$1e,$1f,$1f,$1f,$20,$20,$21,$21,$21,$22,$22,$22,$23,$23
 .byte $24,$24,$24,$25,$25,$25,$26,$26,$27,$27,$27,$28,$28,$29,$29,$29
 .byte $2a,$2a,$2b,$2b,$2b,$2c,$2c,$2d,$2d,$2d,$2e,$2e,$2f,$2f,$30,$30
 .byte $31,$31,$31,$32,$32,$33,$33,$34,$34,$35,$35,$35,$36,$36,$37,$37
 .byte $38,$38,$39,$39,$3a,$3a,$3b,$3b,$3c,$3c,$3d,$3d,$3e,$3e,$3f,$3f
 .byte $40,$40,$41,$41,$42,$42,$43,$43,$44,$44,$45,$45,$46,$46,$47,$47
 .byte $48,$48,$49,$49,$4a,$4a,$4b,$4c,$4c,$4d,$4d,$4e,$4e,$4f,$4f,$50
 .byte $51,$51,$52,$52,$53,$53,$54,$54,$55,$56,$56,$57,$57,$58,$59,$59
 .byte $5a,$5a,$5b,$5c,$5c,$5d,$5d,$5e,$5f,$5f,$60,$60,$61,$62,$62,$63
 .byte $64,$64,$65,$65,$66,$67,$67,$68,$69,$69,$6a,$6a,$6b,$6c,$6c,$6d
 .byte $6e,$6e,$6f,$70,$70,$71,$72,$72,$73,$74,$74,$75,$76,$76,$77,$78
 .byte $79,$79,$7a,$7b,$7b,$7c,$7d,$7d,$7e,$7f,$7f,$80,$81,$82,$82,$83
 .byte $84,$84,$85,$86,$87,$87,$88,$89,$8a,$8a,$8b,$8c,$8d,$8d,$8e,$8f
 .byte $90,$90,$91,$92,$93,$93,$94,$95,$96,$96,$97,$98,$99,$99,$9a,$9b
 .byte $9c,$9d,$9d,$9e,$9f,$a0,$a0,$a1,$a2,$a3,$a4,$a4,$a5,$a6,$a7,$a8
 .byte $a9,$a9,$aa,$ab,$ac,$ad,$ad,$ae,$af,$b0,$b1,$b2,$b2,$b3,$b4,$b5
 .byte $b6,$b7,$b7,$b8,$b9,$ba,$bb,$bc,$bd,$bd,$be,$bf,$c0,$c1,$c2,$c3
 .byte $c4,$c4,$c5,$c6,$c7,$c8,$c9,$ca,$cb,$cb,$cc,$cd,$ce,$cf,$d0,$d1
 .byte $d2,$d3,$d4,$d4,$d5,$d6,$d7,$d8,$d9,$da,$db,$dc,$dd,$de,$df,$e0
 .byte $e1,$e1,$e2,$e3,$e4,$e5,$e6,$e7,$e8,$e9,$ea,$eb,$ec,$ed,$ee,$ef
 .byte $f0,$f1,$f2,$f3,$f4,$f5,$f6,$f7,$f8,$f9,$fa,$fb,$fc,$fd,$fe,$ff

sqrdif_lo .byte $80,$1,$82,$4,$86,$9,$8c,$10,$94,$19,$9e,$24,$aa,$31,$b8,$40
 .byte $c8,$51,$da,$64,$ee,$79,$4,$90,$1c,$a9,$36,$c4,$52,$e1,$70,$0
 .byte $90,$21,$b2,$44,$d6,$69,$fc,$90,$24,$b9,$4e,$e4,$7a,$11,$a8,$40
 .byte $d8,$71,$a,$a4,$3e,$d9,$74,$10,$ac,$49,$e6,$84,$22,$c1,$60,$0
 .byte $a0,$41,$e2,$84,$26,$c9,$6c,$10,$b4,$59,$fe,$a4,$4a,$f1,$98,$40
 .byte $e8,$91,$3a,$e4,$8e,$39,$e4,$90,$3c,$e9,$96,$44,$f2,$a1,$50,$0
 .byte $b0,$61,$12,$c4,$76,$29,$dc,$90,$44,$f9,$ae,$64,$1a,$d1,$88,$40
 .byte $f8,$b1,$6a,$24,$de,$99,$54,$10,$cc,$89,$46,$4,$c2,$81,$40,$0
 .byte $c0,$81,$42,$4,$c6,$89,$4c,$10,$d4,$99,$5e,$24,$ea,$b1,$78,$40
 .byte $8,$d1,$9a,$64,$2e,$f9,$c4,$90,$5c,$29,$f6,$c4,$92,$61,$30,$0
 .byte $d0,$a1,$72,$44,$16,$e9,$bc,$90,$64,$39,$e,$e4,$ba,$91,$68,$40
 .byte $18,$f1,$ca,$a4,$7e,$59,$34,$10,$ec,$c9,$a6,$84,$62,$41,$20,$0
 .byte $e0,$c1,$a2,$84,$66,$49,$2c,$10,$f4,$d9,$be,$a4,$8a,$71,$58,$40
 .byte $28,$11,$fa,$e4,$ce,$b9,$a4,$90,$7c,$69,$56,$44,$32,$21,$10,$0
 .byte $f0,$e1,$d2,$c4,$b6,$a9,$9c,$90,$84,$79,$6e,$64,$5a,$51,$48,$40
 .byte $38,$31,$2a,$24,$1e,$19,$14,$10,$c,$9,$6,$4,$2,$1,$0,$0
 .byte $0,$1,$2,$4,$6,$9,$c,$10,$14,$19,$1e,$24,$2a,$31,$38,$40
 .byte $48,$51,$5a,$64,$6e,$79,$84,$90,$9c,$a9,$b6,$c4,$d2,$e1,$f0,$0
 .byte $10,$21,$32,$44,$56,$69,$7c,$90,$a4,$b9,$ce,$e4,$fa,$11,$28,$40
 .byte $58,$71,$8a,$a4,$be,$d9,$f4,$10,$2c,$49,$66,$84,$a2,$c1,$e0,$0
 .byte $20,$41,$62,$84,$a6,$c9,$ec,$10,$34,$59,$7e,$a4,$ca,$f1,$18,$40
 .byte $68,$91,$ba,$e4,$e,$39,$64,$90,$bc,$e9,$16,$44,$72,$a1,$d0,$0
 .byte $30,$61,$92,$c4,$f6,$29,$5c,$90,$c4,$f9,$2e,$64,$9a,$d1,$8,$40
 .byte $78,$b1,$ea,$24,$5e,$99,$d4,$10,$4c,$89,$c6,$4,$42,$81,$c0,$0
 .byte $40,$81,$c2,$4,$46,$89,$cc,$10,$54,$99,$de,$24,$6a,$b1,$f8,$40
 .byte $88,$d1,$1a,$64,$ae,$f9,$44,$90,$dc,$29,$76,$c4,$12,$61,$b0,$0
 .byte $50,$a1,$f2,$44,$96,$e9,$3c,$90,$e4,$39,$8e,$e4,$3a,$91,$e8,$40
 .byte $98,$f1,$4a,$a4,$fe,$59,$b4,$10,$6c,$c9,$26,$84,$e2,$41,$a0,$0
 .byte $60,$c1,$22,$84,$e6,$49,$ac,$10,$74,$d9,$3e,$a4,$a,$71,$d8,$40
 .byte $a8,$11,$7a,$e4,$4e,$b9,$24,$90,$fc,$69,$d6,$44,$b2,$21,$90,$0
 .byte $70,$e1,$52,$c4,$36,$a9,$1c,$90,$4,$79,$ee,$64,$da,$51,$c8,$40
 .byte $b8,$31,$aa,$24,$9e,$19,$94,$10,$8c,$9,$86,$4,$82,$1,$80,$0

sqrdif_hi .byte $3f,$3f,$3e,$3e,$3d,$3d,$3c,$3c,$3b,$3b,$3a,$3a,$39,$39,$38,$38
 .byte $37,$37,$36,$36,$35,$35,$35,$34,$34,$33,$33,$32,$32,$31,$31,$31
 .byte $30,$30,$2f,$2f,$2e,$2e,$2d,$2d,$2d,$2c,$2c,$2b,$2b,$2b,$2a,$2a
 .byte $29,$29,$29,$28,$28,$27,$27,$27,$26,$26,$25,$25,$25,$24,$24,$24
 .byte $23,$23,$22,$22,$22,$21,$21,$21,$20,$20,$1f,$1f,$1f,$1e,$1e,$1e
 .byte $1d,$1d,$1d,$1c,$1c,$1c,$1b,$1b,$1b,$1a,$1a,$1a,$19,$19,$19,$19
 .byte $18,$18,$18,$17,$17,$17,$16,$16,$16,$15,$15,$15,$15,$14,$14,$14
 .byte $13,$13,$13,$13,$12,$12,$12,$12,$11,$11,$11,$11,$10,$10,$10,$10
 .byte $f,$f,$f,$f,$e,$e,$e,$e,$d,$d,$d,$d,$c,$c,$c,$c
 .byte $c,$b,$b,$b,$b,$a,$a,$a,$a,$a,$9,$9,$9,$9,$9,$9
 .byte $8,$8,$8,$8,$8,$7,$7,$7,$7,$7,$7,$6,$6,$6,$6,$6
 .byte $6,$5,$5,$5,$5,$5,$5,$5,$4,$4,$4,$4,$4,$4,$4,$4
 .byte $3,$3,$3,$3,$3,$3,$3,$3,$2,$2,$2,$2,$2,$2,$2,$2
 .byte $2,$2,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1
 .byte $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
 .byte $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
 .byte $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0
 .byte $0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$0,$1
 .byte $1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$2,$2,$2
 .byte $2,$2,$2,$2,$2,$2,$2,$3,$3,$3,$3,$3,$3,$3,$3,$4
 .byte $4,$4,$4,$4,$4,$4,$4,$5,$5,$5,$5,$5,$5,$5,$6,$6
 .byte $6,$6,$6,$6,$7,$7,$7,$7,$7,$7,$8,$8,$8,$8,$8,$9
 .byte $9,$9,$9,$9,$9,$a,$a,$a,$a,$a,$b,$b,$b,$b,$c,$c
 .byte $c,$c,$c,$d,$d,$d,$d,$e,$e,$e,$e,$f,$f,$f,$f,$10
 .byte $10,$10,$10,$11,$11,$11,$11,$12,$12,$12,$12,$13,$13,$13,$13,$14
 .byte $14,$14,$15,$15,$15,$15,$16,$16,$16,$17,$17,$17,$18,$18,$18,$19
 .byte $19,$19,$19,$1a,$1a,$1a,$1b,$1b,$1b,$1c,$1c,$1c,$1d,$1d,$1d,$1e
 .byte $1e,$1e,$1f,$1f,$1f,$20,$20,$21,$21,$21,$22,$22,$22,$23,$23,$24
 .byte $24,$24,$25,$25,$25,$26,$26,$27,$27,$27,$28,$28,$29,$29,$29,$2a
 .byte $2a,$2b,$2b,$2b,$2c,$2c,$2d,$2d,$2d,$2e,$2e,$2f,$2f,$30,$30,$31
 .byte $31,$31,$32,$32,$33,$33,$34,$34,$35,$35,$35,$36,$36,$37,$37,$38
 .byte $38,$39,$39,$3a,$3a,$3b,$3b,$3c,$3c,$3d,$3d,$3e,$3e,$3f,$3f,$40

r .word 0

