// Astrolux zx.pk.ru
// Подключаем библиотеки
#include <Ethernet.h>
#include <SPI.h>

// Объявляем типы переменных
boolean receiveFlag = false;
boolean bbsFlag = false;
boolean selectFlag = true;
boolean newselectFlag = false;
int select_bbs;
// Задаём MAC-адрес Ethernet-адаптера
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xEC };

// Задаём IP-адреса Ethernet-адаптера, шлюза, маску подсети и IP-адреса Telnet-BBS
IPAddress ip(192, 168, 1, 7);
IPAddress gateway(192, 168, 1, 110);
IPAddress subnet(255, 255, 255, 0);
IPAddress server1(71, 95, 196, 38);
IPAddress server2(59, 167, 142, 49);
IPAddress server3(72, 84, 210, 33);
IPAddress server4(65, 92, 180, 185);
IPAddress server5(199, 15, 249, 237);
EthernetClient client;

void setup() {
  // Инициализация последовательного порта и Ethernet-адаптера
  Serial.begin(19200);
  Serial.println("---------------------------------");
  Serial.println("Connected to Arduino 19200 bps.");
  Serial.println("Initializing Ethernet connection.");
  Ethernet.begin(mac, ip, subnet, gateway);
  delay(1000);
  Serial.print("My IP-address: ");
  Serial.println(Ethernet.localIP());
  Serial.println("Gateway: 192.168.1.110");
  Serial.println("Subnet: 255.255.255.0");
  delay(300);
  
  // Выводим список Telnet-BBS
  Listing();
  select_bbs == 0;
}
 
void loop() {

    // Если есть доступные данные в последовательном порту от ZX Spectrum, считываем строку
    if (selectFlag == true)
    {
    if (Serial.available() > 0)     
    {  
    int inChar = Serial.read();
    select_bbs += (int)inChar;
    receiveFlag = true;
    }
    }

    // Если символ из последовательного порта считан
    if (receiveFlag == true)
    {
   
    // Выбираем Telnet-BBS и подключаемся к ней
    receiveFlag = false;
    selectFlag = false;

    // Если номер BBS равен 1
    if (select_bbs == 49)
    {
    Serial.println("Vertrauen SynchroNet BBS");
    Serial.println("IP-address of BBS: 71.95.196.38");
    Serial.println("URL of BBS: bbs.synchro.net");
    Serial.println("Connecting to Telnet-BBS...");
    client.connect(server1, 23);
    delay(5000);
    }
    // Если номер BBS равен 2
    if (select_bbs == 50)
    {
    Serial.println("The Dungeon BBS");
    Serial.println("IP-address of BBS: 59.167.142.49");
    Serial.println("URL of BBS: dungeon.synchro.net");
    Serial.println("Connecting to Telnet-BBS...");
    client.connect(server2, 23);
    delay(5000);
    }
    // Если номер BBS равен 3
    if (select_bbs == 51)
    {
    Serial.println("Ner BBS");
    Serial.println("IP-address of BBS: 72.84.210.33");
    Serial.println("URL of BBS: nerbbs.com");
    Serial.println("Connecting to Telnet-BBS...");
    client.connect(server3, 23);
    delay(5000);
    }
    // Если номер BBS равен 4
    if (select_bbs == 52)
    {
    Serial.println("MtlGeek BBS");
    Serial.println("IP-address of BBS: 65.92.180.185");
    Serial.println("URL of BBS: mtlgeek.synchro.net");
    Serial.println("Connecting to Telnet-BBS...");
    client.connect(server4, 23);
    delay(5000);
    }
    // Если номер BBS равен 5
    if (select_bbs == 53)
    {
    Serial.println("Fireball Express BBS");
    Serial.println("IP-address of BBS: 65.15.249.237");
    Serial.println("URL of BBS: fireballex.com");
    Serial.println("Connecting to Telnet-BBS...");
    client.connect(server5, 23);
    delay(5000);
    }

    // Если подключение выполнено успешно, выводим соответствующее сообщение
    if (client.connected())
    {
    Serial.println("************************");  
    Serial.println("CONNECTED to Telnet-BBS.");
    Serial.println("************************");
    bbsFlag = true;
    newselectFlag = true;
    delay(1000);
    } 

    // Если подключение не удалось выполнить, выводим соответствующее сообщение и список Telnet-BBS
    else {
    Serial.println("-------------------");  
    Serial.println("CONNECTION FAILED !");
    Serial.println("-------------------");
    selectFlag = true;
    bbsFlag = false;
    select_bbs = 0;
    Listing();
    delay(1000);
    }
    }

    // Если соединение с Telnet-BBS установлено
    if (bbsFlag == true)
    {
      
    // Если получены данные от Telnet-BBS, считываем их и выводим в последовательный порт
    if (client.available())
    {
    char c = client.read();
    Serial.print( c );
    }

    // Если в последовательный порт поступили данные от ZX Spectrum, то передаем их в Telnet-BBS
    if (Serial.available() > 0)
    {
    char inChar = Serial.read();
    if (client.connected())
    {
    client.print(inChar);
    }
    }
    
    // Если соединение с Telnet-BBS сброшено, то останавливаем клиента и выводим список Telnet-BBS
    if (!client.connected())
    {
    if (newselectFlag == true)
    {
    Serial.println();
    Serial.println("Disconnecting...");
    client.stop();
    delay(2000);
    Serial.println("-------------");
    Serial.println("DISCONNECTED.");
    Serial.println("-------------");
    Listing();
    selectFlag = true;
    newselectFlag = false;
    bbsFlag = false;
    select_bbs = 0;
    }
    }
    }
}

// Подпрограмма вывода списка Telnet-BBS
void Listing()
{
    Serial.println("===================");
    Serial.println("List of Telnet-BBS:");
    Serial.println("===================");
    Serial.println("1 - Vertrauen BBS");
    Serial.println("2 - The Dungeon BBS");
    Serial.println("3 - Ner BBS");
    Serial.println("4 - MtlGeek BBS");
    Serial.println("5 - Fireball Express BBS");
    Serial.println("===================");
    Serial.println("Choose of Telnet-BBS:"); 
}
