--------------------------------------------------------------------------------
--      "VGA & PAL"       : STANOK-CONVERTER_140519-02
-- 
--  :   VGA 640480 60     
--
--  :   16     5551
--         SSI_IN   19.84   
--         KSI_IN   56.26    
--------------------------------------------------------------------------------

-- Compilation Report:
-- Warnings        = 46
-- Total macrocels = 118/128
-- Total pins      = 65/80

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity VGA_PAL is
	port
	(

--------------------------------------------------------------------------------
--                                       140518  --
--------------------------------------------------------------------------------

R_IN        : in std_logic := '1'; --  RED
G_IN        : in std_logic := '1'; --  GREEN
B_IN        : in std_logic := '1'; --  BLUE
I_IN        : in std_logic := '1'; --  BRIGHT

KSI_IN      : in std_logic := '1'; --  
SSI_IN      : in std_logic := '1'; --  
CLK         : in std_logic := '1'; --   
CLK_2       : in std_logic := '1'; -- CLK,     

--------------------------------------------------------------------------------
--              /               090812  --
--------------------------------------------------------------------------------

INVERSE_RGBI  : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_KSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_SSI   : in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .
                                      
INVERSE_F14MHZ: in std_logic := '1'; --   : 
                                     -- 0 - , 1 - .

VGA_SCART     : in std_logic := '1'; --     VGA: 
                                     -- 0 -  SCART, 1 -  VGA.

SET_FK_IN     : in std_logic := '1'; --    : 
                                     -- 0 - 50 (312 ), 1 - 48 (320 .)
                                      
SET_FK_OUT    : in std_logic := '1'; --    : 
                                     -- 1 - 100/96 , 0 - 50/48 .

--------------------------------------------------------------------------------
--                         VGA                    090728  --
--------------------------------------------------------------------------------

R_VGA      : out std_logic := '0'; --  RED
G_VGA      : out std_logic := '0'; --  GREEN
B_VGA      : out std_logic := '0'; --  BLUE
I_VGA      : out std_logic_vector (2 downto 0) := "000"; --   VGA

VSYNC_VGA  : out std_logic := '1'; --  /. SCART
HSYNC_VGA  : out std_logic := '1'; --  /enable RGB SCART

--------------------------------------------------------------------------------
--                                             091016  --
--------------------------------------------------------------------------------
A17        : out std_logic;        --     
A          : out std_logic_vector(16 downto 0); -- 

WE         : out std_logic := '1'; --       
OE         : buffer std_logic := '1'; --       
UB         : out std_logic := '1'; --      (D15..D8)
LB         : out std_logic := '1'; --       (D7..D0)


--------------------------------------------------------------------------------
--                                      090821  --
--------------------------------------------------------------------------------

D          : inout std_logic_vector(15 downto 0) := "ZZZZZZZZZZZZZZZZ" -- 

	);
    end VGA_PAL;
architecture RTL of VGA_PAL is

--------------------------------------------------------------------------------
--                                                       --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                       140518  --
--------------------------------------------------------------------------------

signal R           : std_logic; --  RED
signal G           : std_logic; --  GREEN
signal B           : std_logic; --  BLUE
signal I           : std_logic; --  BRIGHT
signal KSI         : std_logic; --  
signal SSI         : std_logic; --  

--------------------------------------------------------------------------------
--                                            140518  --
--------------------------------------------------------------------------------
signal R3          : std_logic; --  RED      --    
signal G3          : std_logic; --  GREEN
signal B3          : std_logic; --  BLUE
signal I3          : std_logic; --  BRIGHT
signal I_VGA_COM   : std_logic; --   BRIGHT  VGA

--------------------------------------------------------------------------------
--                                           140518  --
--------------------------------------------------------------------------------

signal KSI_1       : std_logic; --   
signal KSI_2       : std_logic; --   
signal SSI_1       : std_logic; --   
signal SSI_2       : std_logic; --   

--------------------------------------------------------------------------------
--                     VGA  VIDEO              140518  --
--------------------------------------------------------------------------------

signal VGA_H     : std_logic_vector(8 downto 0); -- .     VGA
signal VGA_V     : std_logic_vector(9 downto 0); -- .      VGA

signal VGA_V_CLK : std_logic; --     VGA  

signal VIDEO_H   : std_logic_vector(9 downto 0); -- .     VIDEO
signal VIDEO_V   : std_logic_vector(8 downto 0); -- .      VIDEO


--------------------------------------------------------------------------------
--                       VGA                         140518  --
--------------------------------------------------------------------------------

signal VGA_KSI      : std_logic; --    VGA
signal VGA_SSI      : std_logic; --    VGA

signal VGA_RBGI_CLK : std_logic; --     VGA 

--------------------------------------------------------------------------------
--                       VGA                        140518  --
--------------------------------------------------------------------------------

signal VGA_KGI     : std_logic; --     VGA
signal VGA_SGI     : std_logic; --     VGA
signal VGA_BLANK   : std_logic; --    VGA

--------------------------------------------------------------------------------
--                                           091024  --
--------------------------------------------------------------------------------

signal RAM_MODE    : std_logic;    --    : 1 - , 0 - 
signal WR_REG_MUX  : std_logic_vector(1 downto 0);   --   
signal RD_REG_MUX  : std_logic_vector(1 downto 0);   --   
signal WR_ADR      : std_logic_vector(16 downto 0);  --      
signal RD_ADR      : std_logic_vector(16 downto 0);  --     

--------------------------------------------------------------------------------
--                                   140518  --
--------------------------------------------------------------------------------

signal DELAY_REG   : std_logic_vector(5 downto 0); 

--------------------------------------------------------------------------------
--                                   091024  --
--------------------------------------------------------------------------------

signal WR_REG      : std_logic_vector(15 downto 0); --  3-R, 2-G, 1-B, 0-I
signal WR_REG_CLK  : std_logic; --       
--------------------------------------------------------------------------------
--                                   090821  --
--------------------------------------------------------------------------------

signal RD_REG      : std_logic_vector(15 downto 0); --  3-R, 2-G, 1-B, 0-I

begin

--------------------------------------------------------------------------------
--                                                                    --
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--                                         140518  --
--------------------------------------------------------------------------------

--   /    ON, 
--    ,   .
--------------------------------------------------------------------------------
process (CLK)   
begin

  if (rising_edge(CLK)) then                     --     - CLK
    DELAY_REG(0) <= R_IN;
    DELAY_REG(1) <= G_IN;
    DELAY_REG(2) <= B_IN;
    DELAY_REG(3) <= I_IN;
    DELAY_REG(4) <= KSI_IN;
    DELAY_REG(5) <= SSI_IN;
  end if;
--------------------------------------------------------------------------------
  if (falling_edge(CLK)) then                    --       :

    if INVERSE_F14MHZ = '0' then                 --  INVERSE_F14MHZ  -   

      R   <= DELAY_REG(0) xnor INVERSE_RGBI;
      G   <= DELAY_REG(1) xnor INVERSE_RGBI;
      B   <= DELAY_REG(2) xnor INVERSE_RGBI;
      I   <= DELAY_REG(3) xnor INVERSE_RGBI;
      KSI <= DELAY_REG(4) xnor INVERSE_KSI;
      SSI <= DELAY_REG(5) xnor INVERSE_SSI;

    else                                         --  -       

      R   <=         R_IN xnor INVERSE_RGBI;
      G   <=         G_IN xnor INVERSE_RGBI;
      B   <=         B_IN xnor INVERSE_RGBI;
      I   <=         I_IN xnor INVERSE_RGBI;
      KSI <=       KSI_IN xnor INVERSE_KSI;
      SSI <=       SSI_IN xnor INVERSE_SSI;

    end if;

  end if;
end process;

--------------------------------------------------------------------------------
--                              140518  --
--------------------------------------------------------------------------------

process (CLK)
begin

  if (rising_edge(CLK)) then  --    ,   0  1
      SSI_1 <= SSI;
      SSI_2 <= not SSI_1;       --   -  
  end if;
end process;

--------------------------------------------------------------------------------
--                                   140518  --
--------------------------------------------------------------------------------
process (CLK, SSI_1, SSI_2)
begin  
  if (falling_edge(CLK)) then           --    :
 
      if ((VGA_H = 507 or VGA_H = 508) and VIDEO_H(0) = '1') then --      VGA,
                                                                  --     VIDEO
          VGA_H <= (others => '0');     --   VGA
      else
          VGA_H   <= VGA_H   + 1;       --  -    VGA
      end if;    

  --   . :
      if (SSI_1 or SSI_2) = '0'  then
          VIDEO_H <= (others => '0');   --   VIDEO
      else
          VIDEO_H   <= VIDEO_H   + 1;   --    VIDEO,
      end if;    

  end if;   
end process;

--------------------------------------------------------------------------------
--                                     140518  --
--------------------------------------------------------------------------------

process (KSI, KSI_2, VIDEO_H(8), VIDEO_H(9))
begin
  --       3/4  VIDEO
  if (rising_edge(VIDEO_H(8)) and VIDEO_H(9)='1') then
      KSI_1 <= KSI;
      KSI_2 <= not KSI_1;       --     
  end if;

--------------------------------------------------------------------------------
--   VGA:
  if (falling_edge(VGA_H(8))) then   --      

   --     60 
      if VGA_V = 524 then            --     :
        VGA_V <= (others => '0');    --    VGA
      else                           --  
        VGA_V <= VGA_V   + 1;        --    VGA
      end if;    

  end if;    
--------------------------------------------------------------------------------
--   VIDEO:
  if (falling_edge(VIDEO_H(9))) then --   .   
    if (KSI_1 or KSI_2) = '0' then     --    :
      VIDEO_V <= (others => '0');    --    VIDEO
    else    
      VIDEO_V <= VIDEO_V + 1;        --    VIDEO
    end if;    
  end if;    
-------------------------------------------------------------------------------
end process;


--------------------------------------------------------------------------------
--                                       140518  --
--------------------------------------------------------------------------------
  --     60 :

--    VGA
VGA_SSI  <= '0' when VGA_H > 415 and VGA_H < 477 else '1';

--     VGA
VGA_SGI  <= '0' when VGA_H > 405 else '1';

--------------------------------------------------------------------------------
--                                       140517  --
--------------------------------------------------------------------------------
process (VGA_V)                   
begin

  --     60 :
  --    VGA
  if (VGA_V = 425 or VGA_V = 426)  then
     VGA_KSI   <= '0' ;
  else
     VGA_KSI   <= '1';
  end if;     
  
  --     VGA
  if (VGA_V > 349) then
    VGA_KGI    <= '0' ;
  else
    VGA_KGI    <= '1';
  end if;       

  
end process;

--------------------------------------------------------------------------------
--                                   140519  --
--------------------------------------------------------------------------------
UB <= '0'; --      (D15..D8)
LB <= '0'; --      ( D7..D0)
RAM_MODE <= VIDEO_H(0);     --    : 1 - , 0 - 

process (CLK)                   
begin
  --      
  --     60 :
--    WE     <= CLK or (not(VIDEO_H(1) and VIDEO_H(0)) ); --       
    WE <= CLK or (VIDEO_H(1) nand VIDEO_H(0));

    WR_REG_MUX <= VIDEO_H(1) & VIDEO_H(0);   --    
    WR_REG_CLK <= CLK;

  --     
  --     60 :
    OE     <= CLK or VGA_H(0);           --       
    RD_REG_MUX <= VGA_H(0) & CLK;        --        

end process;

--------------------------------------------------------------------------------
--                                       140518  --
--------------------------------------------------------------------------------
process (WR_ADR, RD_ADR, VIDEO_V, VIDEO_H, VGA_V, VGA_H, RAM_MODE)                   
begin
  --      
     WR_ADR <= VIDEO_V(8 downto 0) & VIDEO_H(9 downto 2); 
  
  --     
     RD_ADR <= VGA_V(8 downto 0) & VGA_H(8 downto 1);
  
  --     /  
  if RAM_MODE ='1' then --   :
    A <= WR_ADR;        --  
  else                  -- :   
    A <= RD_ADR;        --  
  end if;  

end process;

--------------------------------------------------------------------------------
--                                              140518  --
--------------------------------------------------------------------------------
--      (    WE) 
D(15 downto 0) <= WR_REG when RAM_MODE = '1' else (others => 'Z');

process (CLK) -- (WR_REG_CLK)                   
begin
  if (falling_edge(CLK))  then
--------------------------------------------------------------------------------
    --     VIDEO      16  :
    case WR_REG_MUX is
      when "11" =>      
        WR_REG( 3 downto  0) <= R & G & B & I; --      
      when "00" =>      
        WR_REG( 7 downto  4) <= R & G & B & I; --     
      when "01" =>      
        WR_REG(11 downto  8) <= R & G & B & I; --      
      when "10" =>      
        WR_REG(15 downto 12) <= R & G & B & I; --     .  
    end case;

  end if;

  if (rising_edge(OE)) then --   OE
      --            VGA
       RD_REG <= D;
  end if;    
--------------------------------------------------------------------------------

end process;
 
--------------------------------------------------------------------------------
--                          VGA                  140518  --
--------------------------------------------------------------------------------
--        :

process (RD_REG_MUX)                   
begin
  case RD_REG_MUX is
 
    when "01" =>       --   
      R3 <= RD_REG(3); 
      G3 <= RD_REG(2);
      B3 <= RD_REG(1);
      I3 <= RD_REG(0);

    when "10" =>       --   
      R3 <= RD_REG(7);
      G3 <= RD_REG(6);
      B3 <= RD_REG(5);
      I3 <= RD_REG(4);

    when "11" =>       --   
      R3 <= RD_REG(11);
      G3 <= RD_REG(10);
      B3 <= RD_REG(9);
      I3 <= RD_REG(8);

    when "00" =>       --   
      R3 <= RD_REG(15);
      G3 <= RD_REG(14);
      B3 <= RD_REG(13);
      I3 <= RD_REG(12);

  end case;
end process;

--------------------------------------------------------------------------------
--      
--------------------------------------------------------------------------------
process (CLK) 
begin
if (rising_edge(CLK)) then              --    ,   0  1
   
    VGA_BLANK <= VGA_KGI and VGA_SGI;   --    VGA
    VSYNC_VGA <= VGA_KSI;               --    VGA
    HSYNC_VGA <= VGA_SSI;               --    VGA
  end if;
end process;

--      
VGA_RBGI_CLK <= (not CLK) xor CLK_2; 
      
--------------------------------------------------------------------------------
--                       RGBI   VGA                      140519  --
--------------------------------------------------------------------------------
process (VGA_RBGI_CLK) 
begin
 -- if (falling_edge(VGA_RBGI_CLK)) then  --     .
  if (rising_edge(VGA_RBGI_CLK)) then     --     .
    R_VGA     <= R3 and VGA_BLANK;
    G_VGA     <= G3 and VGA_BLANK;
    B_VGA     <= B3 and VGA_BLANK;

    if (I3 and VGA_BLANK) = '0'  then     --   :
        I_VGA <= "000";                   --      0
    else
        I_VGA <= "ZZZ";                   --  
    end if;

---    I_VGA_COM <= I3 and VGA_BLANK;
  end if;
end process;

--------------------------------------------------------------------------------

end RTL;

