;for pasmo assembler
;it calculates pi-number using the next C-algorithm
;https://crypto.stanford.edu/pbc/notes/pi/code.html

;#include <stdio.h>
;#define N 2800
;main() {
;   long r[N + 1], i, k, b, c;
;   c = 0;
;   for (i = 0; i < N; i++)
;      r[i] = 2000;
;   for (k = N; k > 0; k -= 14) {
;      d = 0;
;      i = k;
;      for(;;) {
;         d += r[i]*10000;
;         b = i*2 - 1;
;         r[i] = d%b;
;         d /= b;
;         i--;
;         if (i == 0) break;
;         d *= i;
;      }
;      printf("%.4d", (int)(c + d/10000));
;      c = d%10000;
;   }
;}

;the time of the calculation is quadratic, so if T is time to calculate N digits
;then 4*T is required to calculate 2*N digits

TXT_OUTPUT equ $BB5A    ;print char in A

N equ 3500   ;1000 digits
;N equ 2800  ;800 digits
SA equ $800  ;start address

mul8x8l    macro   ;in - L,C; out - A, skips hibyte
  ld h,high(mult0)	; 2
  ld b,(hl)		; 4
  inc h			; 5
  ld h,(hl)		; 7
  ld l,c			; 8
  ld a,(bc)		; 10
  add a,(hl)		; 12
   endm

mul8x8    macro   ;in - L,C; out - DE
  mul8x8l
  ld e,a			; 13
  inc b			; 14
  inc h			; 15
  ld a,(bc)		; 17
  adc a,(hl)		; 19
  ld d,a			; 20
   endm

mul16x16 macro  ;ix*iy  -> a,hl,product
         ld c,ixl
         ld a,iyl
  ld l,a
         mul8x8   ;l*c -> de, uses bc,hl,a
         ld (product),de

         ld c,ixh
         ld a,iyh
  ld l,a
         mul8x8
         ld (product+2),de

         ld c,ixh
         ld a,iyl
  ld l,a
         mul8x8
         ld hl,(product+1)
         add hl,de
         push hl
         ld a,(product+3)
         adc a,0
         ld ixh,a

         ld c,ixl
         ld a,iyh
  ld l,a
         mul8x8
         pop hl
         xor a
         add hl,de
         adc a,ixh
         endm

mul16x16c macro  ;continues mul16x16
         ld (product+1),hl
         ld (product+3),a

         ld a,ixl
         ld c,iyl
  ld l,a
         mul8x8
         ld hl,(product+2)
         add hl,de
         ld (product+2),hl
         ld d,h

         ld a,ixl
         ld c,iyh
  ld l,a
         mul8x8l
         add a,d
         ld d,a

         ld a,ixh
         ld c,iyl
  ld l,a
         mul8x8l
         add a,d
         endm

mul32x16 macro arg  ; arg:ix*iy -> a, product+2, product+1, product
         mul16x16
         ld ix,arg
         mul16x16c
         endm

 div macro
     local t2
     EX    DE, HL
     ADD   HL, HL
     EX    DE, HL
     ADC   HL, HL

     LD    A, L
     ADD   A, C
     LD    A, H
     ADC   A, B
     JR    NC, t2

     ADD   HL, BC
     INC   DE
 t2
     endm

div32x16 macro  ; BCDE = HLDE/BC, HL = HLDE%BC
     local OPT,DIV32_,exitdiv ;may work wrong if BC>$7fff
     DEC   BC
     LD    A, B
     CPL 
     LD    B, A
     LD    A, C
     CPL 
     LD    C, A
     ADD   A, L
     LD    A, B
     ADC   A, H
     JP    NC, DIV32_

     PUSH  DE
OPT equ 3         ;use 3 if N<=14000, limits HL to 0x1f'ff'ff'ff

     rept OPT
     ADD HL,HL
     endm
     EX    DE, HL
     LD    HL, 0000

     rept 16-OPT
     div
     endm
     EX    DE, HL
     EX    (SP), HL
     EX    DE, HL

     rept 16
     div
     endm
     POP   BC
     jp exitdiv

 DIV32_
     rept 16
     div
     endm
     LD    BC, 0
exitdiv
     endm

         org SA
start    proc
         local lf0,loop,l4,loop2
         ;di         ;no interrupts
         ld a,12    ;clear screen
         call TXT_OUTPUT

         ld a,(N+1)/256+1   ;fill r-array
         ld de,2000
         ld hl,ra
         ld b,0

lf0      ld (hl),e
         inc l
         ld (hl),d
         inc hl
         djnz lf0

         dec a
         jr nz,lf0

         ld (cv),a
         ld (cv+1),a

         ld hl,N        ;k <- N
         ld (kv),hl

loop     ld hl,0          ;d <- 0
         ld (dv),hl
         ld (dv+2),hl

         ld hl,(kv)          ;i <-k
         ld (iv),hl
loop2    ld hl,(iv)
         add hl,hl
         ld (bv),hl    ;b <- 2*i
         ld bc,ra
         add hl,bc
         push hl

         ld a,(hl)     ; r[i]
         ld iyl,a
         inc l           ; r is at even addr
         ld a,(hl)
         ld iyh,a

         ld l,high(10000)  ;r[i]*10000, mul16x16
         ld c,a
         mul8x8   ;l*c -> de, uses bc,hl,a
         ld (product+2),de

         ld l,low(10000)
         ld c,iyl
         mul8x8
         ld (product),de

         ld l,high(10000)
         ld c,iyl
         mul8x8
         ld hl,(product+1)
         add hl,de
         push hl
         ld a,(product+3)
         adc a,0
         ld iyl,a

         ld l,low(10000)
         ld c,iyh
         mul8x8
         pop hl
         xor a
         add hl,de
         adc a,iyl

         ld b,a
         ld a,(product)      ; d <- d + r[i]*10000
         ld c,h
         ld d,l
         ld e,a
         ld hl,(dv)
         add hl,de
         ld (dv),hl
         push hl
         ld hl,(dv+2)
         adc hl,bc
         ld (dv+2),hl
         pop de
         ld bc,(bv)
         dec bc

         div32x16
         pop ix
         ld (ix),l
         ld (ix+1),h      ;r[i] <- d%b

         ld (dv),de      ;d <- d/b
         ld (dv+2),bc

         ld iy,(iv)      ;i <- i - 1
         dec iy
         ld a,iyl
         or iyh
         jp z,l4      ;jr with subr-muls

         ld (iv),iy
         ld ix,(dv)
         mul32x16 (dv+2)
         ld hl,(product)      ;d <- d*i
         ld (dv),hl
         ld h,a
         ld a,(product+2)
         ld l,a
         ld (dv+2),hl
         jp loop2

l4       ld bc,10000
         ld de,(dv)
         ld hl,(dv+2)
         call div32x16r
         ld bc,(cv)
         ld (cv),hl     ;c <- d%10000
         ld h,b
         ld l,c

         add hl,de   ;c + d/10000
         call PR0000
         ld hl,(kv)      ;k <- k - 14
         ld de,-14
         add hl,de
         ld a,h
         or l
         ret z

         ld (kv),hl
         jp loop
         endp

PR0000  proc
        local PRD,PR0
        ld de,-1000
	CALL PR0
	ld de,-100
	CALL PR0
	ld de,-10
	CALL PR0
	ld A,L
PRD	add a,$30
        jp TXT_OUTPUT

PR0	ld A,$FF
	ld B,H
	ld C,L
	inc A
	add HL,DE
	jr C,$-4

	ld H,B
	ld L,C
	JR PRD
        endp

div32x16r proc
     local t,t0,t1,t2,t3
     call t
     ld bc,0
     ret
t
     DEC   BC
     LD    A, B
     CPL 
     LD    B, A
     LD    A, C
     CPL 
     LD    C, A
     call t0
t0
     call t1
t1
     call t2
t2
     call t3
t3
     div
     RET
     endp

product db 0,0,0,0
bv dw 0
cv dw 0
dv dw 0,0
iv dw 0
kv dw 0

         org SA+$500
include "mul16k.s"

ra       ld de,SA
         ld hl,SA+$2000
         ld bc,ra-SA+2
         ldir
         ret
  end start
