;for macro-11 assembler
;it calculates pi-number using the next C-algorithm
;https://crypto.stanford.edu/pbc/notes/pi/code.html

;#include <stdio.h>
;#define N 2800
;main() {
;   long r[N + 1], i, k, b, c;
;   c = 0;
;   for (i = 0; i < N; i++)
;      r[i] = 2000;
;   for (k = N; k > 0; k -= 14) {
;      d = 0;
;      i = k;
;      for(;;) {
;         d += r[i]*10000;
;         b = i*2 - 1;
;         r[i] = d%b;
;         d /= b;
;         i--;
;         if (i == 0) break;
;         d *= i;
;      }
;      printf("%.4d", (int)(c + d/10000));
;      c = d%10000;
;   }
;}

;the time of the calculation is quadratic, so if T is time to calculate N digits
;then 4*T is required to calculate 2*N digits

      .radix 10
      .dsabl gbl

N = 350   ;100 digits
;N = 2800  ;800 digits

.macro mul32x16 ?l1 ?l2  ;r3:r1*r2  -> r4:r0
      clr r0
      clr r4
      ror r2
      bcc l1

      mov r1,r0
      mov r3,r4
l1:   asl r1 
      rol r3
      asr r2
      bcc l2

      add r1,r0
      adc r4
      add r3,r4
      tst r2
l2:   bne l1
      .endm

.macro mul16x16 ?l1 ?l2  ;r1*r2  -> r4:r0, r3 is used
      clr r3
      mul32x16
      .endm

.macro div ?l0
     asl r2
     rol r3
     cmp r3,r1
     bcs l0

     sub r1,r3
     inc r2
l0:
     .endm

.macro div32x16 ?div32 ?exit ;R1:R2 = R3:R2/R1, R3 = R3:R2%R1, used: R0,R4
                             ;may work wrong if R1>$7fff
     cmp r3,r1
     bcc div32

     .rept 16
     div
     .endm
     clr r1
     jmp @#exit

OPT = 3         ;use 3 if N<=14000, limits R3 to 0x1f'ff'ff'ff
div32:
     mov r2,r0

     .rept OPT
     asl r3
     .endm

     mov r3,r2
     clr r3

     .rept 16-OPT
     div
     .endm

     mov r2,r4
     mov r0,r2

     .rept 16
     div
     .endm
     mov r4,r1
exit:
     .endm

         .asect
         .=512
start:    
         ;di         ;no interrupts
         mov #12,r0    ;clear screen
         emt ^O16

         mov #N+1,r0   ;fill r-array
         mov #2000,r1
         mov #ra,r2
1$:      mov r1,(r2)+
         sob r0,1$

         clr @#cv
         mov #N,@#kv

0$:      clr @#dv          ;d <- 0
         clr @#dv+2

         mov @#kv,@#iv    ;i <-k
2$:      mov @#iv,r0
         asl r0
         mov r0,r5
         add #ra,r0
         mov r0,-(sp)   ;push r0

         mov @r0,r1     ; r[i]
         mov #10000,r2  ;r[i]*10000, mul16x16
         mul16x16
         add @#dv,r0
         adc r4
         add @#dv+2,r4

         dec r5        ;b <- 2*i-1
         mov r5,r1
         mov r4,r3
         mov r0,r2
         div32x16
         mov r3,@(sp)+   ;r[i] <- d%b
         mov r2,@#dv      ;d <- d/b
         mov r1,@#dv+2

         dec @#iv      ;i <- i - 1
         beq 4$

         mov r1,r3
         mov r2,r1
         mov @#iv,r2
         mul32x16
         mov r0,@#dv      ;d <- d*i
         mov r4,@#dv+2
         jmp @#2$

4$:      mov r1,r3
         mov #10000,r1
         div32x16
         add @#cv,r2  ;c + d/10000
         mov r3,@#cv     ;c <- d%10000
         call @#PR0000
         sub #14,@#kv      ;k <- k - 14
         beq 5$
         jmp @#0$

5$:      halt

PR0000:     ;prints r2
        mov #1000,r3
	CALL @#0$
        mov #100,r3
	CALL @#0$
        mov #10,r3
	CALL @#0$
	mov r2,r0
2$:	add #48,r0
   	emt ^O16
        return

0$:	mov #65535,r0
4$:	inc r0
        mov r2,r5
	sub r3,r2
	bcc 4$

	mov r5,r2
	br 2$

cv: .word 0
dv: .word 0,0
iv: .word 0
kv: .word 0
ra: .word 0
