;for fasm assembler
;it calculates pi-number using the next C-algorithm
;https://crypto.stanford.edu/pbc/notes/pi/code.html

;#include <stdio.h>
;#define N 2800
;main() {
;   long r[N + 1], i, k, b, c;
;   c = 0;
;   for (i = 0; i < N; i++)
;      r[i] = 2000;
;   for (k = N; k > 0; k -= 14) {
;      d = 0;
;      i = k;
;      for(;;) {
;	  d += r[i]*10000;
;	  b = i*2 - 1;
;	  r[i] = d%b;
;	  d /= b;
;	  i--;
;	  if (i == 0) break;
;	  d *= i;
;      }
;      printf("%.4d", (int)(c + d/10000));
;      c = d%10000;
;   }
;}

;the time of the calculation is quadratic, so if T is time to calculate N digits
;then 4*T is required to calculate 2*N digits


N = 350   ;100 digits
;N = 2800  ;800 digits
;N = 3500   ;1000 digits


macro mul32x16 {  ;ax:bx*cx  -> dx:ax
      or ax,ax
      jz .mul321
      mul cx
      xchg ax,cx
      mul bx
      add dx,cx
      jmp .mul322
.mul321:
      xchg ax,cx
      mul bx
.mul322:
}

macro div32x16 a { ;BX:AX = DX:AX/BX, DX = DX:AX%BX, used: cx
     cmp dx,bx
     jc .div32#a
     mov cx,ax
     mov ax,dx
     xor dx,dx
     div bx
     xchg ax,cx
     div bx
     mov bx,cx
     jmp .exit#a
.div32#a:
     div bx
     xor BX,BX
.exit#a:
}

	 use16
	 org 100h

start:
	 ;di	     ;no interrupts
	 ;mov #12,r0	;clear screen
	 ;emt ^O16

	 xor ax,ax
	 push ax
	 pop es
	 mov ax,[es:46ch]
	 mov [time],ax
	 mov ax,[es:46eh]
	 mov [time+2],ax

	 push ds
	 pop es
	 mov cx,N+1   ;fill r-array
	 mov ax,2000
	 mov di,ra
	 rep stosw

	 mov [cv],cx
	 mov [kv],N

.l0:	 xor ax,ax
	 mov di,ax	 ;d <- 0
	 mov si,ax

	 mov ax,[kv]
	 mov bp,ax	 ;i <-k
.l2:
	 mov bx,bp
	 shl bx,1
	 add bx,ra
	 mov ax,[bx]	 ; r[i]

	 mov cx,10000	 ;r[i]*10000, mul16x16
	 mul cx
	 add ax,di
	 adc dx,si

	 mov bx,bp
	 shl bx,1
	 dec bx 	;b <- 2*i-1
	 div32x16 a
	 mov di,ax
	 mov si,bx	;d <- d/b
	 mov bx,bp
	 shl bx,1
	 add bx,ra
	 mov [bx],dx	;r[i] <- d%b

	 dec bp 	;i <- i - 1
	 mov bx,si
	 je .l4

	 xchg ax,bx
	 mov cx,bp
	 mul32x16
	 mov di,ax	  ;d <- d*i
	 mov si,dx
	 jmp .l2

.l4:	 mov dx,bx
	 mov bx,10000
	 div32x16 b
	 add ax,[cv]  ;c + d/10000
	 mov [cv],dx	 ;c <- d%10000
	 mov cx,ax
	 mov [dv],di
	 call PR0000
	 sub [kv],14	  ;k <- k - 14
	 je .l5
	 mov di,[dv]
	 jmp .l0

.l5:	 mov dl,' '
	 call PR0000.le
	   
	 xor ax,ax
	 push ax
	 pop es
	 mov ax,[es:46ch]
	 sub ax,[time]
	 ;mov dx,[es:46eh]
	 ;sbb dx,[time+2]   ;assume dx=0
	 mov di,10000
	 mul di
	 mov bx,1821
	 div32x16
	 mov dx,bx
	 mov di,string
	 mov cx,10
	 div cx
	 mov [di],dl
	 inc di
	 xor dx,dx
	 div cx
	 mov [di],dl
	 inc di
	 xor dx,dx
	 mov byte [di],'.'-'0'
	 inc di
.l12:	 or ax,ax
	 jz .l11

	 div cx
	 mov [di],dl
	 inc di
	 xor dx,dx
	 jmp .l12
	 
.l11:	 dec di
	 mov dl,[di]
	 call PR0000.l2
	 cmp di,string
	 jne .l11
	 int 20h

PR0000:     ;prints cx
	mov bx,1000
	CALL .l0
	mov bx,100
	CALL .l0
	mov bx,10
	CALL .l0
	mov dl,cl
.l2:	add dl,'0'
.le:	mov ah,2
	int 21h
	retn

.l0:	mov dl,0ffh
.l4:	inc dl
	mov bp,cx
	sub cx,bx
	jnc .l4

	mov cx,bp
	jmp .l2

string rb 6

	align 2
cv  dw 0
dv  dw 0
iv  dw 0
kv  dw 0
time dw 0,0
ra  dw 0

