#define ORG .org
#define END .end
#define EQU .equ
#define DB  .db
#define DW  .dw
#define DS  .ds

#define BUF 0B00h
;#define LEN (100/4*14)
#define LEN (1000/4*14)

MUL10kTAB	.equ 800h
bdos		.equ	5

	ORG 0100h

	di
	xra	a
	out	10h
	lxi	sp,100h
	mvi	a,0C3h
	sta	0
	sta	5
	lxi	h,Restart
	shld	1
	lxi	h,bdosDispatch
	shld	6
	call	Cls
	mvi	a,0C9h
	sta	38h
	ei
	hlt
	lxi	h, colors+15
colorset:
	mvi	a, 88h
	out	0
	mvi	c, 15
colorset1:	mov	a, c
	out	2
	mov	a, m
	out	0Ch
	dcx	h
	out	0Ch
	out	0Ch
	dcr	c
	out	0Ch
	out	0Ch
	out	0Ch
	jp	colorset1
	mvi	a,255
	out	3
Restart:
	di
	call	Cls
	lxi	h,0E0FFh
	shld	cursor
	mvi c,2
	mvi e,'P'
	call bdos
	mvi e,'I'
	call bdos
	mvi e,'='
	call bdos
	mvi a,0C3h
	sta 38h
	lxi h,Int
	shld 39h
	lxi h,0
	shld IntCount+1
	ei
	hlt
	lxi d,0
	lxi b,10000
	xra a
	mov l,a
GenMulTab:
	mvi h,MUL10kTAB>>8
	mov m,e
	inr h
	mov m,d
	inr h
	mov m,a
	xchg
	dad b
	xchg
	aci 0
	inr l
	jnz GenMulTab
; for (i = 0; i < 2800; ++i) r[i] = 2000; // 2000 = 7D0h
	lxi h,BUF+(LEN*2)-1
	lxi d,7D0h
	mvi a,(BUF>>8)-1
L1:
	mov m,d
	dcx h
	mov m,e
	dcx h
	cmp h
	JNZ L1
	LXI H,0     ; c = 0;
	SHLD _C
	LXI H,LEN   ; for (k = 2800; k > 0; k -= 14) {
L2:	PUSH H
	MOV B,H     ; i = k;
	MOV C,L
	LXI H,0     ; d = 0;
	SHLD _D
L3_:	SHLD _D+2
L3:	PUSH B      ; while(1) {
	mov h,b
	mov l,c
	dad h
	push h
	mvi a,BUF>>8
	add h
	mov h,a
	SHLD Set_RI+1
	MOV C,M
	INX H
	mov l,m     ; r[i]

;DEBC=BC*10000
	mvi h,2+(MUL10kTAB>>8)
	mov d,m
	dcr h
	mov e,m
	dcr h
	mov a,m
	mov l,c
	mov c,m
	inr h
	add m
	mov b,a
	inr h
	mov a,e
	adc m
	mov e,a
	mvi a,0
	adc d
	mov d,a

	LHLD _D     ; d += (uint32_t)(r[i]) * 10000UL;
	DAD B
	mov b,h
	mov c,l
	LHLD _D+2
	JNC $+4
	inx h
	DAD D
	mov d,b
	mov e,c
	pop b
	dcx b	; b = 2 * i - 1

; _ldivu_(&res, d, (uint32_t)(b));
; BCDE = HLDE/BC, HL = HLDE%BC
	mov a,l
	sub c
	mov a,h
	sbb b
	jc DIV32_
	PUSH D
	xchg
	lxi h,mulmore
	shld mulmore-2
	xchg
	lxi d,0
;hack for pi32
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr d
	call DivLo
	XCHG
	XTHL
	XCHG
	CALL DIV320
	mov b,h
	mov c,l
	lhld Set_RI+1
	mov m,c
	inx h
	mov m,b
	pop h
	jmp AfterDIV
DIV32_:
	call DIV320
Set_RI:	
	shld 0
	lxi h,0
AfterDIV:

; r[i] = res.rem; d = res.quot;
	SHLD _D+2
	POP B
	DCX B       ; if (--i == 0) break;
	MOV A,B
	ORA C
	JZ L4
; d *= (uint32_t)(i);
; DEHL = BC*DE
    mov a,e
	lxi h,0
	mov e,l
	add a\ jnc $+5 \ dad b\ adc e
	dad h\ adc a\ jnc $+5 \ dad b\ adc e
	dad h\ adc a\ jnc $+5 \ dad b\ adc e
	dad h\ adc a\ jnc $+5 \ dad b\ adc e
	dad h\ adc a\ jnc $+5 \ dad b\ adc e
	dad h\ adc a\ jnc $+5 \ dad b\ adc e
	dad h\ adc a\ jnc $+5 \ dad b\ adc e
	dad h\ adc a\ jnc $+5 \ dad b\ adc e	
	mov e,d
	mov d,a
	mov a,e
	mov e,h

	PUSH H
	lxi h,0
	add a\ jnc $+6 \ dad b\ aci 0
	dad h\ adc a\ jnc $+6 \ dad b\ aci 0
	dad h\ adc a\ jnc $+6 \ dad b\ aci 0
	dad h\ adc a\ jnc $+6 \ dad b\ aci 0
	dad h\ adc a\ jnc $+6 \ dad b\ aci 0
	dad h\ adc a\ jnc $+6 \ dad b\ aci 0
	dad h\ adc a\ jnc $+6 \ dad b\ aci 0
	dad h\ adc a\ jnc $+6 \ dad b\ aci 0		
	dad d
	aci 0
	xchg
	pop h
	mov h,e
	mov e,d
	mov d,a
	SHLD _D
	XCHG
	jmp mulmore
mulmore:	
	LDA _D+2
	ora a
	jz breakmulmore
	dad b
	dcr a
	jnz $-2
breakmulmore:
	xchg
	lxi h,L3_
	shld mulmore-2
	xchg
	jmp L3_		; }
L4:	LHLD _D+2
	LXI B,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	PUSH H
	LHLD _C     ; printf("%.4d", c + (uint16_t)(res.quot));
	DAD D
	CALL PR0000
	POP H
	SHLD _C     ; c = res.rem;
	POP H
	LXI B,-14
	DAD B
	MOV A,H
	ORA L
	JNZ L2      ; }
	di
	mvi c,2
	mvi e,' '
	call bdos
	call bdos
	mvi e,'T'
	call bdos
	mvi e,'='
	call bdos
	lhld IntCount+1
	xchg
	lxi h,0
	lxi b,50
	call DIV320
	push h
	xchg
	call PR0000
	mvi c,2
	mvi e,'.'
	call bdos
	pop h
	dad h
	call PR00
	JMP $

DIV320:; DE = HLDE/(BC), HL = HLDE%(BC)
	mov a,e
	mov e,h\ mov h,l\ mov l,d
	mov d,a
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	mov a,d
	mov d,l
	mov l,a
DivLo:
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a
	mov e,l
	mov l,h
	mov h,a
	mov a,l\ sub c\ mov a,h\ sbb b
	rc
	mov h,a\ mov a,l\ sub c\ mov l,a\ inr e
	ret

PR0000:	LXI D,-1000
	lxi b,1000
	CALL PR0
	LXI D,-100
	lxi b,100
	CALL PR0
PR00:	
	LXI D,-10
	lxi b,10
	CALL PR0
	MOV A,L
PRD:	ADI 30h
PRC:
	mvi c,2
	mov e,a
	JMP bdos
PR0:	MVI A,0FFh
	INR A
	DAD D
	jc $-2
	dad b
	JMP PRD

PRINTS:	MOV A,M
	INX H
	ORA A
	RZ
	CALL PRC
	JMP PRINTS

_C:	DW 0
_D:	DW 0,0

bdosDispatch:
		push	psw
		push	d
		mov	a,c
		cpi	2
		cz	PrintCharBDOS
		pop	d
		pop	psw
		ret

cursor		.dw	0E0FFh-7

PrintCharBDOS:
		push	psw
		push	h
		push	b
		mov	a,e
		lhld	cursor
		xchg
		call	PrintChar
		inr	d
		xra a
		ora d
		jnz SaveCur
		mvi d,0E0h
		mvi a,-8
		add e
		mov e,a
SaveCur:
		xchg
		shld	cursor
		pop b
		pop	h
		pop	psw
		ret
PrintChar:
		push	psw
		push	b
		push	d
		push	h
		mov	l, a
		mvi	h, 0
		dad	h
		dad	h
		dad	h
		lxi	b, Font-256
		dad	b
loopchar:
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ stax d
		pop	h
		pop	d
		pop	b
		pop	psw
		ret

Cls:
		lxi	h,0E000h
		xra	a
ClrScr:
		mov	m,a
		inx	h
		cmp	h
		jnz	ClrScr
		ret
Int:
		push h
IntCount:		
		lxi h,0
		inx h
		shld IntCount+1
		pop h
		ei
		ret

#define col 173

colors:
		.db 0,col,0,col,0,col,0,col,0,col,0,col,0,col,0,col
Font:

	END
