;for macro-11 assembler
;it calculates pi-number using the next C-algorithm
;https://crypto.stanford.edu/pbc/notes/pi/code.html

;#include <stdio.h>
;#define N 2800
;main() {
;   long r[N + 1], i, k, b, c;
;   c = 0;
;   for (i = 0; i < N; i++)
;      r[i] = 2000;
;   for (k = N; k > 0; k -= 14) {
;      d = 0;
;      i = k;
;      for(;;) {
;         d += r[i]*10000;
;         b = i*2 - 1;
;         r[i] = d%b;
;         d /= b;
;         i--;
;         if (i == 0) break;
;         d *= i;
;      }
;      printf("%.4d", (int)(c + d/10000));
;      c = d%10000;
;   }
;}

;the time of the calculation is quadratic, so if T is time to calculate N digits
;then 4*T is required to calculate 2*N digits

      .radix 10
      .dsabl gbl

HMUL = 0  ;hardware multiplication, 0 - no
TIMER = 0 ;use timer to calculate time, if TIMER=0 then video 48.5 Hz interrupt will be used

;N = 10500   ;3000 digits
;N = 3500   ;1000 digits
N = 350   ;100 digits
;N = 2800  ;800 digits
kbddtport  = ^O177662            ;kbd data, palette, timer, $ffb2
pageport   = ^O177716            ;$ffce
timerport1 = ^O177706            ;$ffc6
timerport2 = ^O177710            ;$ffc8
timerport3 = ^O177712            ;$ffca
todata     = ^B010101100000000   ;open pages 2 and 3
toandos    = ^B001110000000000   ;open pages 1 (soft 5) and 4 (AnDOS)

.macro mul32x16 ?l1 ?l2  ;r3:r1*r2  -> r4:r0
.if ne HMUL
      mul r2,r3
      mov r1,r0
      mul r2,r0
      bpl l1

      add r2,r0
l1:   add r3,r0
      mov r0,r4
      mov r1,r0
.iff
      clr r0
      clr r4
      ror r2
      bcc l1

      mov r1,r0
      mov r3,r4
l1:   asl r1 
      rol r3
      asr r2
      bcc l2

      add r1,r0
      adc r4
      add r3,r4
      tst r2
l2:   bne l1
.endc
      .endm

.macro mul16x16 ?l1 ?l2  ;r1*r2  -> r4:r0, r3 is used
.if ne HMUL
      mul r1,r2
      mov r2,r4
      mov r3,r0
.iff
      clr r3
      mul32x16
.endc
      .endm

.macro div0 ?l0
     asl r2
     rol r3
     cmp r3,r1
     bcs l0

     sub r1,r3
     inc r2
l0:
     .endm

.macro div32x16 ?div32 ?exit ;R1:R2 = R3:R2/R1, R3 = R3:R2%R1, used: R0,R4
                             ;may work wrong if R1>$7fff
     cmp r3,r1
     bcc div32

     .rept 16
     div0
     .endm
     clr r1
     jmp @#exit

OPT = 3         ;use 3 if N<=14000, limits R3 to 0x1f'ff'ff'ff
div32:
     mov r2,r0

     .rept OPT
     asl r3
     .endm

     mov r3,r2
     clr r3

     .rept 16-OPT
     div0
     .endm

     mov r2,r4
     mov r0,r2

     .rept 16
     div0
     .endm
     mov r4,r1
exit:
     .endm

         .asect
         .=512
start:   mov #12,r0    ;clear screen
         emt ^O16
.if eq TIMER
         mov #timerirq,@#^O100        ;sets timer irq
.iff
         mov #^B1110010,@#timerport3    ;sets timer, /64
.endc
         mov #21,r1
         clr r2
         emt ^O24
         mov #msg1,r1
         mov #127,r2
         emt ^O20

         mov #9,r1
         mov #1,r2
         emt ^O24
         mov #msg2,r1
         mov #127,r2
         emt ^O20
200$:    call @#getnum
         mov #10,r0
         emt ^O16

         mov r2,r4
         add #3,r4
         bic #3,r4
         cmp r2,r4
         beq 7$

         mov r4,r2
         call @#PR0000
         mov #msg3,r1
         mov #127,r2
         emt ^O20

7$:      asr r4
         mov r4,r0
         asl r0
         add r0,r4
         asl r0
         add r0,r4   ;r4 <- r4/2*7
         mov r4,@#101$+2
         inc r4
         mov r4,@#100$+2

         mov #todata,@#pageport
         clr @#time
         clr @#time+2
.if eq TIMER
         clr @#kbddtport              ;starts 48.5 Hz video irq
.iff
         mov @#timerport2,@#prevtime
.endc

100$:    mov #N+1,r0   ;fill r-array
         mov #2000,r1
         mov #ra,r2
1$:      mov r1,(r2)+
         sob r0,1$

         clr @#cv
101$:    mov #N,@#kv

0$:      clr @#dv          ;d <- 0
         clr @#dv+2

         mov @#kv,@#iv    ;i <-k
2$:      mov @#iv,r0
         asl r0
         mov r0,r5
         add #ra,r0
         mov r0,-(sp)   ;push r0

         mov @r0,r1     ; r[i]
         mov #10000,r2  ;r[i]*10000, mul16x16
         mul16x16
         add @#dv,r0
         adc r4
         add @#dv+2,r4

         dec r5        ;b <- 2*i-1
         mov r5,r1
         mov r4,r3
         mov r0,r2
         div32x16
         mov r3,@(sp)+   ;r[i] <- d%b
         mov r2,@#dv      ;d <- d/b
         mov r1,@#dv+2

         dec @#iv      ;i <- i - 1
         beq 4$

         mov r1,r3
         mov r2,r1
         mov @#iv,r2
         mul32x16
         mov r0,@#dv      ;d <- d*i
         mov r4,@#dv+2
         jmp @#2$

4$:      mov r1,r3
         mov #10000,r1
         call @#div32x16s
         add @#cv,r2  ;c + d/10000
         mov r3,@#cv     ;c <- d%10000
         mov #toandos,@#pageport
         call @#PR0000
         mov #todata,@#pageport
.if ne TIMER
         mov @#timerport2,r1
         mov @#prevtime,r3
         sub r1,r3
         mov r1,@#prevtime
         add r3,@#time
         adc @#time+2
.endc
         sub #14,@#kv      ;k <- k - 14
         beq 5$
         jmp @#0$

5$:      
         mov @#time,r1
         mov @#time+2,r3
.if eq TIMER
         mov #16384,@#kbddtport        ;stops video irq
         mov #20,r2
         mul32x16
         mov r0,r2
         mov r4,r3
         mov #97,r1
.iff
         mov r1,r2
         mov #49,r1            ;4MHz
.endc
         call @#div32x16s
         mov r2,r1
         mov #toandos,@#pageport
         mov #32,r0
         emt ^O16
         call @#printsec
         mov #msg4,r1
         mov #127,r2
         emt ^O20
         jmp @#200$

div32x16s: ;R1:R2 = R3:R2/R1, R3 = R3:R2%R1, used: R0,R4
           ;compact form - 64 bytes
                             ;may work wrong if R1>$7fff
     cmp r3,r1
     bcc 32$

     call @#3$
     clr r1
     return

32$: mov r2,r0
     mov r3,r2
     clr r3
     call @#3$
     mov r2,r4
     mov r0,r2
     call @#3$
     mov r4,r1
     return

3$:  call @#.+4
     call @#.+4
     call @#.+4
     call @#.+4
     asl r2
     rol r3
     cmp r3,r1
     bcs 0$

     sub r1,r3
     inc r2
0$:  return

PR0000:     ;prints r2
        mov #1000,r3
	CALL @#0$
        mov #100,r3
	CALL @#0$
        mov #10,r3
	CALL @#0$
	mov r2,r0
2$:	add #48,r0
   	emt ^O16
        return

0$:	mov #65535,r0
4$:	inc r0
        mov r2,r5
	sub r3,r2
	bcc 4$

	mov r5,r2
	br 2$

printsec:  ;prints R1/10
        clr r4
        mov #10000,r3
        call @#0$
        mov #1000,r3
        call @#0$
        mov #100,r3
        call @#0$
        mov #10,r3
        call @#0$
        movb #'.,r0
        emt ^O16
        mov r1,r0
2$:     add #48,r0
        emt ^O16
        inc r4
5$:     return

0$:     cmp r1,r3
        bcc 7$

        tst r4
        beq 5$

        xor r0,r0
        br 2$

7$:     mov #65535,r0
4$:	inc r0
        mov r1,r5
	sub r3,r1
	bcc 4$

	mov r5,r1
	br 2$

getnum: clr r1    ;length
        clr r2    ;number
0$:     emt 6
        cmp #10,r0
        beq 5$

        cmp #24,r0
        beq 1$

        cmp #47,r0
        bcc 0$

        cmp #48+9,r0
        bcs 0$

        cmp #4,r1
        beq 0$

        mov r2,-(sp)
        emt ^O16
        inc r1
        sub #48,r0
        mov r2,r3
        asl r3
        asl r3
        add r3,r2
        asl r2
        add r0,r2
        br 0$

1$:     tst r1
        beq 0$

        dec r1
        emt ^O16

        mov (sp)+,r2
        br 0$

5$:     tst r1
        beq 0$

        cmp #3000,r2
        bcs 0$

        mov r1,r3
8$:     mov (sp)+,r0
        sob r3,8$
        return

timerirq:  inc @#time
           bne noirq

           inc @#time+2
noirq:     rti

cv: .word 0
dv: .word 0,0
iv: .word 0
kv: .word 0
time: .word 0,0
prevtime: .word 0
msg1: .ascii "number "
      .byte 160
      .ascii " calculator"
      .byte 10,0
msg2: .ascii "  it may give 3000 digits in about an hour!"
msg4: .byte 10,10
      .asciz "number of digits (up to 3000)? "
msg3: .ascii " digits will be printed"
      .byte 10,0,0

ra: .word 0
       mov r0,r0
