#define ORG .org
#define END .end
#define EQU .equ
#define DB  .db
#define DW  .dw
#define DS  .ds

#define BUF 0C00h

;#define pi100
#ifdef pi100
#define LEN (100/4*14)
#else
#define LEN (1000/4*14)
#endif

MUL10kTAB	.equ 0900h

	ORG 0100h

	di
	xra	a
	out	10h
	lxi	sp,100h
	mvi	a,0C3h
	sta	0
	lxi	h,Restart
	shld	1
	call	Cls
	mvi	a,0C9h
	sta	38h
	ei
	hlt
	lxi	h, colors+15
colorset:
	mvi	a, 88h
	out	0
	mvi	c, 15
colorset1:	mov	a, c
	out	2
	mov	a, m
	out	0Ch
	dcx	h
	out	0Ch
	out	0Ch
	dcr	c
	out	0Ch
	out	0Ch
	out	0Ch
	jp	colorset1
	mvi	a,255
	out	3
Restart:
	di
	xra a
	out 10h
	call	Cls
	lxi	h,0E0FFh
	shld	cursor
	mvi e,'P'
	call PrintCharBDOS
	mvi e,'I'
	call PrintCharBDOS
	mvi e,'='
	call PrintCharBDOS
	mvi a,0C3h
	sta 38h
	lxi h,Int
	shld 39h
	lxi h,0
	shld IntCount+1

	ei
	hlt
	lxi d,0
	lxi b,10000
	xra a
	mov l,a
GenMulTab:
	mvi h,MUL10kTAB>>8
	mov m,e
	inr h
	mov m,d
	inr h
	mov m,a
	xchg
	dad b
	xchg
	aci 0
	inr l
	jnz GenMulTab
	
; for (i = 0; i < 2800; ++i) r[i] = 2000;
	lxi h,BUF+(LEN*2)-1
	lxi d,2000
	mvi a,(BUF>>8)-1
L1:
	mov m,d
	dcx h
	mov m,e
	dcx h
	cmp h
	JNZ L1
	LXI H,0     ; c = 0;
	SHLD _C
	LXI H,LEN   ; for (k = 2800; k > 0; k -= 14) {
L2:	PUSH H
	MOV B,H     ; i = k;
	MOV C,L
	LXI H,0     ; d = 0;
	SHLD Set_D+1
L3_:
	SHLD Set_D2+1
L3:	PUSH B      ; while(1) {
	mov h,b
	mov l,c
	dad h
	push h
	mvi a,BUF>>8
	add h
	mov h,a
	SHLD Set_RI+1
	mov e,m
	INX H
	mov l,m     ; r[i]

;BCDE=BC*10000
	mvi h,2+(MUL10kTAB>>8)
	mov b,m
	dcr h
	mov c,m
	dcr h
	mov a,m
	mov l,e
	mov e,m
	inr h
	add m
	mov d,a
	inr h
	mov a,m
	adc c
	mov c,a
#ifndef pi100
	jnc AfterMUL10k
	inr b
AfterMUL10k:
#endif


; d += (uint32_t)(r[i]) * 10000UL;
Set_D:	
	lxi h,0
	dad d
	xchg
Set_D2:
	lxi h,0
	JNC $+4
	inx h
	dad b
	pop b
	dcx b	; b = 2 * i - 1

; _ldivu_(&res, d, (uint32_t)(b));
; BCDE = HLDE/BC, HL = HLDE%BC
	mov a,l
	sub c
	mov a,h
	sbb b
	jc DIV32_
	PUSH D
	xchg
	lxi h,mulmore
	shld mulmore-2
	xchg
	lxi d,0
;hack for pi32
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr d

	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a\ mov e,a
	mov a,h\ sub c\ mov a,e\ sbb b\ jc $+8 \ mov e,a\ mov a,h\ sub c\ mov h,a\ inr l
	dad h\ mov a,e\ adc a
	mov e,l
	mov l,h
	mov h,a
	mov a,l\ sub c\ mov a,h\ sbb b
	jc	AfterDiv1
	mov h,a\ mov a,l\ sub c\ mov l,a\ inr e
AfterDiv1:
	XCHG
	XTHL
	XCHG
	CALL DIV320
	mov b,h
	mov c,l
	lhld Set_RI+1
	mov m,c
	inx h
	mov m,b
	pop h
	jmp AfterDIV
DIV32_:
	call DIV320
Set_RI:	
	shld 0
	lxi h,0
AfterDIV:

; r[i] = res.rem; d = res.quot;
	SHLD Set_D2+1
	POP B
	DCX B       ; if (--i == 0) break;
	MOV A,B
	ORA C
	JZ L4
; d *= (uint32_t)(i);
	push b
; DEHL = BC*DE
    mov a,c
	lxi h,0
	mov c,l
	add a\ jc MUL1
	add a\ jc MUL2
	add a\ jc MUL3
	add a\ jc MUL4
	add a\ jc MUL5
	add a\ jc MUL6
	add a\ jc MUL7
	add a\ jc MUL8
	add b
	mov b,c
	jmp MUL8_

MUL1: dad d\ dad h\ adc a\ jnc $+5
MUL2: dad d\ adc c\	dad h\ adc a\ jnc $+5
MUL3: dad d\ adc c\	dad h\ adc a\ jnc $+5
MUL4: dad d\ adc c\	dad h\ adc a\ jnc $+5
MUL5: dad d\ adc c\	dad h\ adc a\ jnc $+5
MUL6: dad d\ adc c\	dad h\ adc a\ jnc $+5
MUL7: dad d\ adc c\	dad h\ adc a\ jnc $+5
MUL8: dad d\ adc c
	mov c,a
	xra a\ add b
	mov b,c
	mov c,h
MUL8_:
	jz MUL16_0
	PUSH H
	lxi h,0
	add a\ jc MUL9
	add a\ jc MUL10
	add a\ jc MUL11
	add a\ jc MUL12
	add a\ jc MUL13
	add a\ jc MUL14
	add a\ jc MUL15
	add a\ jmp MUL16
MUL16_0:
	SHLD Set_D+1
	mov l,b
	mov h,a
	jmp MUL16_

MUL9: dad d\ dad h\ adc a\ jnc $+6
MUL10: dad d\ aci 0\ dad h\ adc a\ jnc $+6
MUL11: dad d\ aci 0\ dad h\ adc a\ jnc $+6
MUL12: dad d\ aci 0\ dad h\ adc a\ jnc $+6
MUL13: dad d\ aci 0\ dad h\ adc a\ jnc $+6
MUL14: dad d\ aci 0\ dad h\ adc a\ jnc $+6
MUL15: dad d\ aci 0\ dad h\ adc a\ jnc $+6
MUL16: dad d\ aci 0
	dad b
	aci 0
	xchg
	pop h
	mov h,e
	SHLD Set_D+1
	mov l,d
	mov h,a
MUL16_:
	pop b
	jmp mulmore
mulmore:
	LDA Set_D2+1
	ora a
	jz breakmulmore
	dad b
	dcr a
	jnz $-2
breakmulmore:
	xchg
	lxi h,L3_
	shld mulmore-2
	xchg
	jmp L3_		; }
L4:
	LHLD Set_D2+1
	LXI B,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	PUSH H
	LHLD _C     ; printf("%.4d", c + (uint16_t)(res.quot));
	DAD D
	CALL PR0000
	POP H
	SHLD _C     ; c = res.rem;
	POP H
	LXI B,-14
	DAD B
	MOV A,H
	ORA L
	JNZ L2      ; }
	di
	mvi e,' '
	call PrintCharBDOS
	call PrintCharBDOS
	mvi e,'T'
	call PrintCharBDOS
	mvi e,'='
	call PrintCharBDOS
	lhld IntCount+1
	xchg
	lxi h,0
	lxi b,50
	call DIV320
	push h
	xchg
	call PR0000
	mvi e,'.'
	call PrintCharBDOS
	pop h
	dad h
	call PR00
	JMP $

DIV320:; DE = HLDE/(BC), HL = HLDE%(BC)
	push d
	mov a,e
	sta SetE+1
	mov a,b
	cma
	mov d,a
	mov a,c
	cma
	mov e,a
	inx d
	pop psw
	add a\ jnc DIV0_1\ dad h\ inr l\ dad d\ jc DIV0_\ jmp DIV0_-2
DIV0_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV0_:
	adc a\ jnc DIV1_1\ dad h\ inr l\ dad d\ jc DIV1_\ jmp DIV1_-2
DIV1_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV1_:
	adc a\ jnc DIV2_1\ dad h\ inr l\ dad d\ jc DIV2_\ jmp DIV2_-2
DIV2_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV2_:
	adc a\ jnc DIV3_1\ dad h\ inr l\ dad d\ jc DIV3_\ jmp DIV3_-2
DIV3_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV3_:
	adc a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ jmp DIV4_-2
DIV4_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV4_:
	adc a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ jmp DIV5_-2
DIV5_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV5_:
	adc a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ jmp DIV6_-2
DIV6_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV6_:
	adc a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ jmp DIV7_-2
DIV7_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV7_:
	adc a
	sta	SetD2+1

SetE:
	mvi a,0
	add a\ jnc DIV8_1\ dad h\ inr l\ dad d\ jc DIV8_\ jmp DIV8_-2
DIV8_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV8_:
	adc a\ jnc DIV9_1\ dad h\ inr l\ dad d\ jc DIV9_\ jmp DIV9_-2
DIV9_1:	dad h\ dad d\ jc $+5\ dad b\ ora a
DIV9_:
	adc a\ jnc DIV10_1\ dad h\ inr l\ dad d\ jc DIV10_\ jmp DIV10_-2
DIV10_1: dad h\ dad d\ jc $+5\ dad b\ ora a
DIV10_:
	adc a\ jnc DIV11_1\ dad h\ inr l\ dad d\ jc DIV11_\ jmp DIV11_-2
DIV11_1: dad h\ dad d\ jc $+5\ dad b\ ora a
DIV11_:
	adc a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ jmp DIV12_-2
DIV12_1: dad h\ dad d\ jc $+5\ dad b\ ora a
DIV12_:
	adc a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ jmp DIV13_-2
DIV13_1: dad h\ dad d\ jc $+5\ dad b\ ora a
DIV13_:
	adc a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ jmp DIV14_-2
DIV14_1: dad h\ dad d\ jc $+5\ dad b\ ora a
DIV14_:
	adc a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ jmp DIV15_-2
DIV15_1: dad h\ dad d\ jc $+5\ dad b\ ora a
DIV15_:
	adc a
	mov e,a
SetD2:
	mvi d,0
	ret

PR0000:	LXI D,-1000
	lxi b,1000
	CALL PR0
	LXI D,-100
	lxi b,100
	CALL PR0
PR00:	
	LXI D,-10
	lxi b,10
	CALL PR0
	MOV A,L
PRD:	ADI 30h
PRC:
	mov e,a
	JMP PrintCharBDOS
PR0:	MVI A,0FFh
	INR A
	DAD D
	jc $-2
	dad b
	JMP PRD

_C:	DW 0


cursor		.dw	0E0FFh-7

PrintCharBDOS:
		push	psw
		push	d
		push	h
		mov	a,e
		lhld	cursor
		xchg
		call	PrintChar
		inr	d
		xra a
		ora d
		jnz SaveCur
		mvi d,0E0h
		mvi a,-8
		add e
		mov e,a
SaveCur:
		xchg
		shld	cursor
		pop	h
		pop d
		pop	psw
		ret
		
PrintChar:
		push	psw
		push	d
		push	h
		rlc\ rlc\ rlc
		mov h,a
		ani 11111000b
		mov l,a
		xra h
		inr l
		adi (Font>>8)-1
		mov h,a
loopchar:
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ stax d
		pop	h
		pop	d
		pop	psw
		ret

Cls:
		lxi	h,0E000h
		xra	a
ClrScr:
		mov	m,a
		inx	h
		cmp	h
		jnz	ClrScr
		ret
Int:
		push h
IntCount:		
		lxi h,0
		inx h
		shld IntCount+1
		pop h
		ei
		ret

#define col 173

colors:
		.db 0,col,0,col,0,col,0,col,0,col,0,col,0,col,0,col

	.org 600h-1
	.db 0
Font:

	END
