#define ORG .org
#define END .end
#define EQU .equ
#define DB  .db
#define DW  .dw
#define DS  .ds

#define BUF 1000h-2

;#define pi100
#ifdef pi100
#define LEN (100/4*14)
#else
#define LEN (1000/4*14)
#endif

MUL10kTAB	.equ 3000h
MULprocs	.equ 0A000h

	ORG 0100h

	di
	xra	a
	out	10h
	lxi	sp,100h
	mvi	a,0C3h
	sta	0
	lxi	h,Restart
	shld	1
	call	Cls
	mvi	a,0C9h
	sta	38h
	ei
	hlt
	lxi	h, colors+15
colorset:
	mvi	a, 88h
	out	0
	mvi	c, 15
colorset1:	mov	a, c
	out	2
	mov	a, m
	out	0Ch
	dcx	h
	out	0Ch
	out	0Ch
	dcr	c
	out	0Ch
	out	0Ch
	out	0Ch
	jp	colorset1
	mvi	a,255
	out	3
Restart:
	di
	xra a
	out 10h
	call	Cls
	lxi	h,0E0FFh
	shld	cursor
	mvi a,'P'
	call PrintChar
	mvi a,'I'
	call PrintChar
	mvi a,'='
	call PrintChar
	mvi a,0C3h
	sta 38h
	lxi h,Int
	shld 39h

	lxi h,MULprocs
	lxi d,40h
	mvi c,0
GenMUL1_:
	push h
GenMUL1:
	push h
	mov a,c
	mvi b,0
CountLoop:
	add a
	jnc	No1
	inr b
No1:
	ora a
	jz ExitCount1
	jmp CountLoop
ExitCount1:
	mov a,b
	cpi 3
	mov a,c
	mvi m,62h\ inx h	;mov h,d
	mvi m,6Bh\ inx h	;mov l,e	
	jnc WithC

;0-2
	add a\ jc SwToOne8noC
	add a\ jc SwToOne7noC
	add a\ jc SwToOne6noC
	add a\ jc SwToOne5noC
	add a\ jc SwToOne4noC
	add a\ jc SwToOne3noC
	add a\ jc SwToOne2noC
	jmp PreSw1

SwToOne8noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne7noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne6noC:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne5noC:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne4noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne3noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne2noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
	jmp SwToOne1

;3-8
WithC:
	mvi m,4Fh\ inx h	;mov c,a
	add a\ jc SwToOne8
	add a\ jc SwToOne7
	add a\ jc SwToOne6
	add a\ jc SwToOne5
	add a\ jc SwToOne4
	add a\ jc SwToOne3
	add a\ jc SwToOne2
PreSw1:	
	add a\ jc SwToOne1
	dcx h\ dcx h
	mvi m,21h\ inx h
	mvi m,0\ inx h
	mvi m,0\ inx h	;lxi h,0
	jmp SwToOne1

SwToOne8:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne7:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne6:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne5:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne4:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne3:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne2:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne1:
	mvi m,0C3h\ inx h	;jmp
	mvi m,(MUL8_ & 255)\ inx h
	mvi m,(MUL8_ >> 8)
	pop h
	inr h
	inr c
	mvi a,00111111b
	ana c
	jnz GenMUL1
	pop h
	dad d
	xra a
	ora c
	jnz GenMUL1_

	lxi h,0
	shld dword
	shld dword+2
	lxi b,10000
	lxi h,MUL10kTAB
	mvi a,(MULprocs>>8)
GenMulTab:
	xchg
	lhld dword
	xchg
	mov m,e
	inr h
	mov m,d
	inr h
	xchg
	lhld dword+2
	xchg
	mov m,e
	inr h
	mov m,d
	xchg
	lhld dword
	dad b
	shld dword
	xchg
	jnc NoCdword
	xchg
	lhld dword+2
	inx h
	shld dword+2
	xchg
NoCdword:
	dcr h\ dcr h\ dcr h
	inr l
	jnz GenMulTab
	lxi d,1024
	dad d
	cmp h
	jnz GenMulTab

	ei
	hlt
	lxi h,0
	shld IntCount+1	

; for (i = 0; i < LEN; ++i) r[i] = 2000;
	lxi h,BUF+(LEN*2)-1
	lxi d,2000
	mvi a,(BUF>>8)-1
L1:
	mov m,d
	dcx h
	mov m,e
	dcx h
	cmp h
	JNZ L1
	LXI H,0     ; c = 0;
	SHLD _C
	LXI H,LEN   ; for (k = LEN; k > 0; k -= 14) {
L2:	PUSH H
	xchg		; i = k;
	LXI H,0     ; d = 0;
	SHLD Set_D+1
L3_:
	SHLD Set_D2+1
	dcx d
	push d      ; while(1) {
	xchg
	dad h
	push h
	mvi a,BUF>>8
	add h
	mov h,a
	SHLD Set_RI+1
	mov e,m
	INX H
	mov a,m     ; r[i]
	
;BCDE=AE*10000
	xchg
	add a\ add a
	adi MUL10kTAB>>8
	mov h,a
	mov e,m
	inr h
	mov d,m
	inr h
	mov c,m
	inr h
	mov b,m

; d += (uint32_t)(r[i]) * 10000UL;
Set_D:	
	lxi h,0
	dad d
	xchg
Set_D2:
	lxi h,0
	JNC $+4
	inx h
	dad b
	pop b	; b = 2 * i - 2

; _ldivu_(&res, d, (uint32_t)(b));
; BCDE = HLDE/BC, HL = HLDE%BC
	push d
	mov a,e
	sta SetE+1
	mov a,c
	cma
	mov e,a
	add l
	mov a,b
	cma
	mov d,a
	adc h
	inx b
	jnc DIV32_
	push d
	xchg
	lxi h,mulmore
	shld mulmore-2	
;hack for pi32
	mov l,d
	mov a,e
	sta SetE2+1
	pop d
	xra a
	mov h,a
	dad d\ jc $+5\ dad b\ ora a
	adc a
	sta	SetD2+1
	call DivLo
	XCHG
	SHLD Set_D2+1
	pop h
	XCHG
	CALL DIV320
	mov b,h
	mov c,l
	lhld Set_RI+1
	mov m,c
	inx h
	mov m,b
	jmp AfterDIV
DIV32_:
	pop psw
	add a\ jnc DIV0_1\ dad h\ inr l\ dad d\ jc DIV0_\ dad b
	add a\ jnc DIV1_1\ dad h\ inr l\ dad d\ jc DIV1_\ dad b
	add a\ jnc DIV2_1\ dad h\ inr l\ dad d\ jc DIV2_\ dad b
	add a\ jnc DIV3_1\ dad h\ inr l\ dad d\ jc DIV3_\ dad b
	add a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV0_1:	dad h\ dad d\ jc DIV0_\ dad b
	add a\ jnc DIV1_1\ dad h\ inr l\ dad d\ jc DIV1_\ dad b
	add a\ jnc DIV2_1\ dad h\ inr l\ dad d\ jc DIV2_\ dad b
	add a\ jnc DIV3_1\ dad h\ inr l\ dad d\ jc DIV3_\ dad b
	add a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV0_:
	adc a\ jnc DIV1_1\ dad h\ inr l\ dad d\ jc DIV1_\ dad b
	add a\ jnc DIV2_1\ dad h\ inr l\ dad d\ jc DIV2_\ dad b
	add a\ jnc DIV3_1\ dad h\ inr l\ dad d\ jc DIV3_\ dad b
	add a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV1_1:	dad h\ dad d\ jc DIV1_\ dad b
	add a\ jnc DIV2_1\ dad h\ inr l\ dad d\ jc DIV2_\ dad b
	add a\ jnc DIV3_1\ dad h\ inr l\ dad d\ jc DIV3_\ dad b
	add a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV1_:
	adc a\ jnc DIV2_1\ dad h\ inr l\ dad d\ jc DIV2_\ dad b
	add a\ jnc DIV3_1\ dad h\ inr l\ dad d\ jc DIV3_\ dad b
	add a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV2_1:	dad h\ dad d\ jc DIV2_\ dad b
	add a\ jnc DIV3_1\ dad h\ inr l\ dad d\ jc DIV3_\ dad b
	add a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV2_:
	adc a\ jnc DIV3_1\ dad h\ inr l\ dad d\ jc DIV3_\ dad b
	add a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV3_1:	dad h\ dad d\ jc DIV3_\ dad b
	add a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV3_:
	adc a\ jnc DIV4_1\ dad h\ inr l\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV4_1:	dad h\ dad d\ jc DIV4_\ dad b
	add a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV4_:
	adc a\ jnc DIV5_1\ dad h\ inr l\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV5_1:	dad h\ dad d\ jc DIV5_\ dad b
	add a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV5_:
	adc a\ jnc DIV6_1\ dad h\ inr l\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV6_1:	dad h\ dad d\ jc DIV6_\ dad b
	add a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV6_:
	adc a\ jnc DIV7_1\ dad h\ inr l\ dad d\ jc DIV7_\ dad b\ add a\ jmp DIV7_2
DIV7_1:	dad h\ dad d\ jc DIV7_\ dad b\ ora a
DIV7_:
	adc a
DIV7_2:
	sta SetD+1
SetE:
	mvi a,0
	add a\ jnc DIV8_1\ dad h\ inr l\ dad d\ jc DIV8_\ dad b
	add a\ jnc DIV9_1\ dad h\ inr l\ dad d\ jc DIV9_\ dad b
	add a\ jnc DIV10_1\ dad h\ inr l\ dad d\ jc DIV10_\ dad b
	add a\ jnc DIV11_1\ dad h\ inr l\ dad d\ jc DIV11_\ dad b
	add a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
DIV8_1:	dad h\ dad d\ jc DIV8_\ dad b
	add a\ jnc DIV9_1\ dad h\ inr l\ dad d\ jc DIV9_\ dad b
	add a\ jnc DIV10_1\ dad h\ inr l\ dad d\ jc DIV10_\ dad b
	add a\ jnc DIV11_1\ dad h\ inr l\ dad d\ jc DIV11_\ dad b
	add a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
DIV8_:
	adc a\ jnc DIV9_1\ dad h\ inr l\ dad d\ jc DIV9_\ dad b\
	add a\ jnc DIV10_1\ dad h\ inr l\ dad d\ jc DIV10_\ dad b
	add a\ jnc DIV11_1\ dad h\ inr l\ dad d\ jc DIV11_\ dad b
	add a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
DIV9_1:	dad h\ dad d\ jc DIV9_\ dad b\
	add a\ jnc DIV10_1\ dad h\ inr l\ dad d\ jc DIV10_\ dad b
	add a\ jnc DIV11_1\ dad h\ inr l\ dad d\ jc DIV11_\ dad b
	add a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
DIV9_:
	adc a\ jnc DIV10_1\ dad h\ inr l\ dad d\ jc DIV10_\ dad b
	add a\ jnc DIV11_1\ dad h\ inr l\ dad d\ jc DIV11_\ dad b
	add a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD

DIV10_1: dad h\ dad d\ jc DIV10_\ dad b
	add a\ jnc DIV11_1\ dad h\ inr l\ dad d\ jc DIV11_\ dad b
	add a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
DIV10_:
	adc a\ jnc DIV11_1\ dad h\ inr l\ dad d\ jc DIV11_\ dad b
	add a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD

DIV11_1: dad h\ dad d\ jc DIV11_\ dad b
	add a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
DIV11_:
	adc a\ jnc DIV12_1\ dad h\ inr l\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD

DIV12_1: dad h\ dad d\ jc DIV12_\ dad b
	add a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
DIV12_:
	adc a\ jnc DIV13_1\ dad h\ inr l\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD

DIV13_1: dad h\ dad d\ jc DIV13_\ dad b
	add a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b\
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
DIV13_:
	adc a\ jnc DIV14_1\ dad h\ inr l\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
	
DIV14_1: dad h\ dad d\ jc DIV14_\ dad b
	add a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD
DIV14_:
	adc a\ jnc DIV15_1\ dad h\ inr l\ dad d\ jc DIV15_\ dad b\ add a\ jmp SetD

DIV15_1: dad h\ dad d\ jc DIV15_\ dad b\ ora a
DIV15_:	adc a

SetD:
	mvi d,0
	mov e,a
Set_RI:	
	shld 0
AfterDIV:

; r[i] = res.rem; d = res.quot;
	POP B
	xra a
	ora c
	jnz NoL4
	ora b
	JZ L4	; if (--i == 0) break;
	mov a,c
NoL4:
; d *= (uint32_t)(i);

; HL:(Set_D+1) = BC*DE
	push b
	ani 11000000b
	mov l,a
	xra c
	adi (MULprocs>>8)
	mov h,a
	xra a
	pchl

MUL8_:
	mov c,a
	xra a\ add b
	jz MUL16_0
#ifdef pi100
	mov a,e
	add h
	mov h,a
	SHLD Set_D+1
	mov a,d
	adc c
	mov l,a
	mvi a,0
	adc a
	mov h,a
	jmp MUL16_
#else
	mov b,c
	mov c,h
	PUSH H
	mov h,d\ mov l,e
	add a
	add a
	add a
	add a
	add a\ jc MUL13
	add a\ jc MUL14+3
	add a\ jc MUL15+3
	dad b\ adc a\ jmp MUL16_16
#endif
MUL16_0:
	SHLD Set_D+1
	mov l,c
	mov h,a
	jmp MUL16_
MUL16_00:
	SHLD Set_D+1
	mov l,a
	mov h,b
	pop d
	jmp L3_

MUL13: dad h\ adc a\ jnc MUL14+3
MUL14: dad d\ aci 0\ dad h\ adc a\ jnc MUL15+3
MUL15: dad d\ aci 0\ dad h\ adc a\ jnc MUL16+3
MUL16: dad d\ aci 0
	dad b
	aci 0
MUL16_16:
	xchg
	pop h
	mov h,e
	SHLD Set_D+1
	mov l,d
	mov h,a
MUL16_:
	pop d
	jmp mulmore
mulmore:
	LDA Set_D2+1
	ora a
	jz breakmulmore
	dad d
	dcr a
	jnz $-2
breakmulmore:
	push h
	lxi h,L3_
	shld mulmore-2
	pop h
	jmp L3_		; }

L4:
	LHLD Set_D2+1
	LXI B,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	PUSH H
	LHLD _C     ; printf("%.4d", c + (uint16_t)(res.quot));
	DAD D
	CALL PR0000
	POP H
	SHLD _C     ; c = res.rem;
	POP H
	LXI B,-14
	DAD B
	xra a
Check:
	ora h
	jnz L2
	lda Check
	cpi 0B5h
	jz MakeAsItWas
	mvi a,0B5h
	sta Check
	call Mov9
	jmp L2
MakeAsItWas:
	mvi a,0B4h
	sta Check
	call Mov9
	
	di
	mvi a,' '
	call PrintChar
	mvi a,'T'
	call PrintChar
	mvi a,'='
	call PrintChar
	lhld IntCount+1
	xra a
	dad h\ adc a
	dad h\ adc a	;*4
	mov e,l
	mov d,h
	mov c,a
	dad h\ adc a
	dad h\ adc a
	dad h\ adc a	;*32
	push h
	push psw
	dad d
	adc c			;*36
	mov e,l
	mov d,h
	mov c,a
	pop psw
	pop h
	dad h\ adc a	;*64
	dad d
	adc c			;*100
	xchg
	mov l,a
	mvi h,0
	
	lxi b,5008
	call DIV320
	push h
	xchg
	call PR0000
	mvi a,'.'
	call PrintChar
	pop h
	dad h
	call PR0000
	JMP $
	
Mov9:	
	push h
	lxi h,MUL8_
	lxi d,MUL16_00
	mvi c,9
Mov1:
	mov b,m
	ldax d
	mov m,a
	mov a,b
	stax d
	inx h
	inx d
	dcr c
	jnz Mov1
	pop h
	ret
	
MakeOne:
	mvi m,19h\ inx h	;dad d
	mvi m,89h\ inx h	;adc c
	ret

MakeOneNoC:
	mvi m,19h\ inx h	;dad d
	mvi m,0CEh\ inx h	;
	mvi m,00h\ inx h	;aci 0
	ret

DIV320:; DE = HLDE/(BC), HL = HLDE%(BC)
	push d
	mov a,e
	sta SetE2+1
	mov a,b
	cma
	mov d,a
	mov a,c
	cma
	mov e,a
	inx d
	pop psw
	add a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\	dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a
	sta	SetD2+1

DivLo:	
SetE2:
	mvi a,0
	add a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a\ jnc $+12\ dad h\ inr l\ dad d\ jc $+13\ jmp $+8\ dad h\ dad d\ jc $+5\ dad b\ ora a
	adc a
	mov e,a
SetD2:
	mvi d,0
	ret


PR0000:	LXI D,-1000
	lxi b,1000
	CALL PR0
	LXI D,-100
	lxi b,100
	CALL PR0
PR00:	
	LXI D,-10
	lxi b,10
	CALL PR0
	MOV A,L
PRD:	ADI 30h
PRC:
	JMP PrintChar
PR0:	MVI A,0FFh
	INR A
	DAD D
	jc $-2
	dad b
	ADI 30h
PrintChar:
		push	h
		lhld	cursor
		xchg
		push	d
		rlc\ rlc\ rlc
		mov h,a
		ani 11111000b
		mov l,a
		xra h
		inr l
		adi (Font>>8)-1
		mov h,a
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ stax d
		pop	d
		inr	d
		jm SaveCur
		mvi d,0E0h
		mvi a,-8
		add e
		mov e,a
SaveCur:
		xchg
		shld	cursor
		pop	h
		ret

_C:	DW 0


cursor		.dw	0E0FFh-7
		
Cls:
		lxi	h,0E000h
		xra	a
ClrScr:
		mov	m,a
		inx	h
		cmp	h
		jnz	ClrScr
		ret
Int:
		push h
IntCount:		
		lxi h,0
		inx h
		shld IntCount+1
		pop h
		ei
		ret

#define col 173

colors:
		.db 0,col,0,col,0,col,0,col,0,col,0,col,0,col,0,col

dword .db 0,0,0,0
	
	.org 0D00h-1
	.db 0
Font:

	END
