#define ORG .org
#define END .end
#define EQU .equ
#define DB  .db
#define DW  .dw
#define DS  .ds

#define BUF 0E00h-2

;#define pi100
#ifdef pi100
#define LEN (100/4*14)
#else
#define LEN (1000/4*14)
#endif

MUL10kTAB	.equ 3000h
MULprocs	.equ 0A000h

	ORG 0100h

	di
	xra	a
	out	10h
	lxi	sp,100h
	mvi	a,0C3h
	sta	0
	lxi	h,Restart
	shld	1
	call	Cls
	mvi	a,0C9h
	sta	38h
	ei
	hlt
	lxi	h, colors+15
colorset:
	mvi	a, 88h
	out	0
	mvi	c, 15
colorset1:	mov	a, c
	out	2
	mov	a, m
	out	0Ch
	dcx	h
	out	0Ch
	out	0Ch
	dcr	c
	out	0Ch
	out	0Ch
	out	0Ch
	jp	colorset1
	mvi	a,255
	out	3
Restart:
	di
	xra a
	out 10h
	call	Cls
	lxi	h,0E0FFh
	shld	cursor
	mvi a,'P'
	call PrintChar
	mvi a,'I'
	call PrintChar
	mvi a,'='
	call PrintChar
	mvi a,0C3h
	sta 38h
	lxi h,Int
	shld 39h

	lxi h,MULprocs
	lxi d,40h
	mvi c,0
GenMUL1_:
	push h
GenMUL1:
	push h
	mov a,c
	mvi b,0
CountLoop:
	add a
	jnc	No1
	inr b
No1:
	ora a
	jz ExitCount1
	jmp CountLoop
ExitCount1:
	mov a,b
	cpi 3
	mov a,c
	mvi m,62h\ inx h	;mov h,d
	mvi m,6Bh\ inx h	;mov l,e	
	jnc WithC

;0-2
	add a\ jc SwToOne8noC
	add a\ jc SwToOne7noC
	add a\ jc SwToOne6noC
	add a\ jc SwToOne5noC
	add a\ jc SwToOne4noC
	add a\ jc SwToOne3noC
	add a\ jc SwToOne2noC
	jmp PreSw1

SwToOne8noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne7noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne6noC:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne5noC:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne4noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne3noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
SwToOne2noC:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOneNoC
	jmp SwToOne1

;3-8
WithC:
	mvi m,4Fh\ inx h	;mov c,a
	add a\ jc SwToOne8
	add a\ jc SwToOne7
	add a\ jc SwToOne6
	add a\ jc SwToOne5
	add a\ jc SwToOne4
	add a\ jc SwToOne3
	add a\ jc SwToOne2
PreSw1:	
	add a\ jc SwToOne1
	dcx h\ dcx h
	mvi m,21h\ inx h
	mvi m,0\ inx h
	mvi m,0\ inx h	;lxi h,0
	jmp SwToOne1

SwToOne8:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne7:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne6:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne5:	
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne4:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne3:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne2:
	mvi m,29h\ inx h	;dad h
	mvi m,8Fh\ inx h	;adc a
	add a\ cc MakeOne
SwToOne1:
	mvi m,0C3h\ inx h	;jmp
	mvi m,(MUL8_ & 255)\ inx h
	mvi m,(MUL8_ >> 8)
	pop h
	inr h
	inr c
	mvi a,00111111b
	ana c
	jnz GenMUL1
	pop h
	dad d
	xra a
	ora c
	jnz GenMUL1_

	lxi h,0
	shld dword
	shld dword+2
	lxi b,10000
	lxi h,MUL10kTAB
	mvi a,(MULprocs>>8)
GenMulTab:
	xchg
	lhld dword
	xchg
	mov m,e
	inr h
	mov m,d
	inr h
	xchg
	lhld dword+2
	xchg
	mov m,e
	inr h
	mov m,d
	xchg
	lhld dword
	dad b
	shld dword
	xchg
	jnc NoCdword
	xchg
	lhld dword+2
	inx h
	shld dword+2
	xchg
NoCdword:
	dcr h\ dcr h\ dcr h
	inr l
	jnz GenMulTab
	lxi d,1024
	dad d
	cmp h
	jnz GenMulTab

	ei
	hlt
	lxi h,0
	shld IntCount+1

; for (i = 0; i < LEN; ++i) r[i] = 2000;
	lxi h,BUF+(LEN*2)-1
	lxi d,2000
	mvi a,(BUF>>8)-1
L1:
	mov m,d
	dcx h
	mov m,e
	dcx h
	cmp h
	JNZ L1
	LXI H,0     ; c = 0;
	SHLD _C
	LXI H,LEN   ; for (k = LEN; k > 0; k -= 14) {
L2:	PUSH H
	xchg		; i = k;
	LXI H,0     ; d = 0;
	SHLD Set_D+1
L3_:
	SHLD Set_D2+1
	dcx d
	push d      ; while(1) {
	xchg
	dad h
	push h
	mvi a,BUF>>8
	add h
	mov h,a
	SHLD Set_RI+1
	mov e,m
	inr l
	mov a,m     ; r[i]
	
;BCDE=AE*10000
	xchg
	add a\ add a
	adi MUL10kTAB>>8
	mov h,a
	mov e,m
	inr h
	mov d,m
	inr h
	mov c,m
	inr h
	mov b,m

; d += (uint32_t)(r[i]) * 10000UL;
Set_D:	
	lxi h,0
	dad d
	xchg
Set_D2:
	lxi h,0
	JNC $+4
	inx h
	dad b
	pop b	; b = 2 * i - 2

; _ldivu_(&res, d, (uint32_t)(b));
; BCDE = HLDE/BC, HL = HLDE%BC
	push d
	mov a,e
	sta SetE+1
	mov a,c
	cma
	mov e,a
	add l
	mov a,b
	cma
	mov d,a
	adc h
	inx b
	jnc DIV32_
	push d
	xchg
	lxi h,mulmore
	shld mulmore-2	
;hack for pi32
	mov l,d
	mov a,e
	sta SetE2+1
	pop d
	xra a
	mov h,a
	dad d\ jc $+5\ dad b\ ora a
	adc a
	sta	SetD2+1
	call DivLo
	XCHG
	SHLD Set_D2+1
	pop h
	XCHG
	CALL DIV320
	mov b,h
	mov c,l
	lhld Set_RI+1
	mov m,c
	inr l
	mov m,b
	jmp AfterDIV
DIV32_:
	xra a
	ora b
	jnz FastDiv
	ora c
	jm SlowDiv
	pop psw
	mov b,c\ mov c,h
	mov h,l\ mov l,a
	mov d,e\ mov e,c

	dad h\ dad d\ jnc A1_
	adc a\ dad h\ dad d\ jnc A2_
S2_:	adc a\ dad h\ dad d\ jnc A3_
S3_:	adc a\ dad h\ dad d\ jnc A4_
S4_:	adc a\ dad h\ dad d\ jnc A5_
S5_:	adc a\ dad h\ dad d\ jnc A6_
S6_:	adc a\ dad h\ dad d\ jnc A7_
S7_:	adc a\ dad h\ dad d\ jnc A8_
S8_:	adc a\ dad d\ jnc A9_
S9_: inr a
	jmp DIV_2

A1_: adc a\ dad h\ dad b\ jc S2_
A2_: adc a\ dad h\ dad b\ jc S3_
A3_: adc a\ dad h\ dad b\ jc S4_
A4_: adc a\ dad h\ dad b\ jc S5_
A5_: adc a\ dad h\ dad b\ jc S6_
A6_: adc a\ dad h\ dad b\ jc S7_
A7_: adc a\ dad h\ dad b\ jc S8_
A8_: adc a
A9_: dad b

DIV_2:
	sta SetD+1
	lda SetE+1
	mov l,a
	dad h\ dad d\ jnc A10_
	adc a\ dad h\ dad d\ jnc A11_
S11_: adc a\ dad h\ dad d\ jnc A12_
S12_: adc a\ dad h\ dad d\ jnc A13_
S13_: adc a\ dad h\ dad d\ jnc A14_
S14_: adc a\ dad h\ dad d\ jnc A15_
S15_: adc a\ dad h\ dad d\ jnc A16_
S16_: adc a\ dad h\ dad d\ jnc A17_
S17_: adc a\
	dad d\ jnc A18_
S18_: inr a
	mov l,h\ mov h,c
	jmp SetD

A10_: adc a\ dad h\ dad b\ jc S11_
A11_: adc a\ dad h\ dad b\ jc S12_
A12_: adc a\ dad h\ dad b\ jc S13_
A13_: adc a\ dad h\ dad b\ jc S14_
A14_: adc a\ dad h\ dad b\ jc S15_
A15_: adc a\ dad h\ dad b\ jc S16_
A16_: adc a\ dad h\ dad b\ jc S17_
A17_: adc a
A18_: dad b
	mov l,h\ mov h,c
	jmp SetD

SlowDiv:
	pop psw
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA0
	adc a\ jc DIVS0_1\ dad h\ dad d\ jnc DIVA1
DIVS1:	adc a\ jc DIVS1_1
DIVS1_0: dad h\ dad d\ jnc DIVA2
DIVS2:	adc a\ jc DIVS2_1
DIVS2_0: dad h\ dad d\ jnc DIVA3
DIVS3:	adc a\ jc DIVS3_1
DIVS3_0: dad h\ dad d\ jnc DIVA4
DIVS4:	adc a\ jc DIVS4_1
DIVS4_0: dad h\ dad d\ jnc DIVA5
DIVS5:	adc a\ jc DIVS5_1
DIVS5_0: dad h\ dad d\ jnc DIVA6
DIVS6:	adc a\ jc DIVS6_1
DIVS6_0: dad h\ dad d\ jnc DIVA7
DIVS7:	adc a\ jmp DIV7_2

DIVS0_1: dad h\ inr l\ dad d\ jnc DIVA1\ adc a\ jnc DIVS1_0
DIVS1_1: dad h\ inr l\ dad d\ jnc DIVA2\ adc a\ jnc DIVS2_0
DIVS2_1: dad h\ inr l\ dad d\ jnc DIVA3\ adc a\ jnc DIVS3_0
DIVS3_1: dad h\ inr l\ dad d\ jnc DIVA4\ adc a\ jnc DIVS4_0
DIVS4_1: dad h\ inr l\ dad d\ jnc DIVA5\ adc a\ jnc DIVS5_0
DIVS5_1: dad h\ inr l\ dad d\ jnc DIVA6\ adc a\ jnc DIVS6_0
DIVS6_1: dad h\ inr l\ dad d\ jnc DIVA7\ adc a\ jmp DIV7_2

DIVA0: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS1
DIVA1: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS2
DIVA2: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS3
DIVA3: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS4
DIVA4: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS5
DIVA5: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS6
DIVA6: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS7
DIVA7: adc a\ dad b
DIV7_2:
	sta SetD+1
	lda SetE+1
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA8
	adc a\ jc DIVS8_1\ dad h\ dad d\ jnc DIVA9
DIVS9:	adc a\ jc DIVS9_1
DIVS9_0: dad h\ dad d\ jnc DIVA10
DIVS10:	adc a\ jc DIVS10_1
DIVS10_0: dad h\ dad d\ jnc DIVA11
DIVS11:	adc a\ jc DIVS11_1
DIVS11_0: dad h\ dad d\ jnc DIVA12
DIVS12:	adc a\ jc DIVS12_1
DIVS12_0: dad h\ dad d\ jnc DIVA13
DIVS13:	adc a\ jc DIVS13_1
DIVS13_0: dad h\ dad d\ jnc DIVA14
DIVS14:	adc a\ jc DIVS14_1
DIVS14_0: dad h\ dad d\ jnc DIVA15
DIVS15:	adc a\ jmp SetD

DIVS8_1: dad h\ inr l\ dad d\ jnc DIVA9\ adc a\ jnc DIVS9_0
DIVS9_1: dad h\ inr l\ dad d\ jnc DIVA10\ adc a\ jnc DIVS10_0
DIVS10_1: dad h\ inr l\ dad d\ jnc DIVA11\ adc a\ jnc DIVS11_0
DIVS11_1: dad h\ inr l\ dad d\ jnc DIVA12\ adc a\ jnc DIVS12_0
DIVS12_1: dad h\ inr l\ dad d\ jnc DIVA13\ adc a\ jnc DIVS13_0
DIVS13_1: dad h\ inr l\ dad d\ jnc DIVA14\ adc a\ jnc DIVS14_0
DIVS14_1: dad h\ inr l\ dad d\ jnc DIVA15\ adc a\ jmp SetD	

DIVA8: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS9
DIVA9: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS10
DIVA10: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS11
DIVA11: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS12
DIVA12: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS13
DIVA13: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS14
DIVA14: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS15
DIVA15: adc a\ dad b\ jmp SetD

FastDiv:
	pop psw
	sta S8+3
	sta A8+3
	dad h\ dad d\ jnc A1
	adc a\ dad h\ dad d\ jnc A2
S2:	adc a\ dad h\ dad d\ jnc A3
S3:	adc a\ dad h\ dad d\ jnc A4
S4:	adc a\ dad h\ dad d\ jnc A5
S5:	adc a\ dad h\ dad d\ jnc A6
S6:	adc a\ dad h\ dad d\ jnc A7
S7:	adc a\ dad h\ dad d\ jnc A8
S8:	adc a
	push d\ lxi d,0\ dad d\ pop d
	dad d\ jnc A9
S9: inr a
	jmp DIV_

A1: adc a\ dad h\ dad b\ jc S2
A2: adc a\ dad h\ dad b\ jc S3
A3: adc a\ dad h\ dad b\ jc S4
A4: adc a\ dad h\ dad b\ jc S5
A5: adc a\ dad h\ dad b\ jc S6
A6: adc a\ dad h\ dad b\ jc S7
A7: adc a\ dad h\ dad b\ jc S8
A8: adc a
	push d\ lxi d,0\ dad d\ pop d
	jc S9
A9: dad b

DIV_:
	sta SetD+1
SetE:
	mvi a,0
	sta S17+3
	sta A17+3
	dad h\ dad d\ jnc A10
	adc a\ dad h\ dad d\ jnc A11
S11:	adc a\ dad h\ dad d\ jnc A12
S12:	adc a\ dad h\ dad d\ jnc A13
S13:	adc a\ dad h\ dad d\ jnc A14
S14:	adc a\ dad h\ dad d\ jnc A15
S15:	adc a\ dad h\ dad d\ jnc A16
S16:	adc a\ dad h\ dad d\ jnc A17
S17:	adc a\
	push d\ lxi d,0\ dad d\ pop d
	dad d\ jnc A18
S18: inr a
	jmp SetD

A10: adc a\ dad h\ dad b\ jc S11
A11: adc a\ dad h\ dad b\ jc S12
A12: adc a\ dad h\ dad b\ jc S13
A13: adc a\ dad h\ dad b\ jc S14
A14: adc a\ dad h\ dad b\ jc S15
A15: adc a\ dad h\ dad b\ jc S16
A16: adc a\ dad h\ dad b\ jc S17
A17: adc a
	push d\ lxi d,0\ dad d\ pop d
	jc S18
A18: dad b
SetD:
	mvi d,0
	mov e,a
Set_RI:	
	shld 0
AfterDIV:

; r[i] = res.rem; d = res.quot;
	POP B
	xra a
	ora c
	jnz NoL4
	ora b
	JZ L4	; if (--i == 0) break;
	mov a,c
NoL4:
; d *= (uint32_t)(i);

; HL:(Set_D+1) = BC*DE
	push b
	ani 11000000b
	mov l,a
	xra c
	adi (MULprocs>>8)
	mov h,a
	xra a
	pchl

MUL8_:
	mov c,a
	xra a\ add b
	jz MUL16_0
#ifdef pi100
	mov a,e
	add h
	mov h,a
	SHLD Set_D+1
	mov a,d
	adc c
	mov l,a
	mvi a,0
	adc a
	mov h,a
	jmp MUL16_
#else
	mov b,c
	mov c,h
	PUSH H
	mov h,d\ mov l,e
	add a
	add a
	add a
	add a
	add a\ jc MUL13
	add a\ jc MUL14+3
	add a\ jc MUL15+3
	dad b\ adc a\ jmp MUL16_16
#endif
MUL16_0:
	SHLD Set_D+1
	mov l,c
	mov h,a
	jmp MUL16_
MUL16_00:
	SHLD Set_D+1
	mov l,a
	mov h,b
	pop d
	jmp L3_

MUL13: dad h\ adc a\ jnc MUL14+3
MUL14: dad d\ aci 0\ dad h\ adc a\ jnc MUL15+3
MUL15: dad d\ aci 0\ dad h\ adc a\ jnc MUL16+3
MUL16: dad d\ aci 0
	dad b
	aci 0
MUL16_16:
	xchg
	pop h
	mov h,e
	SHLD Set_D+1
	mov l,d
	mov h,a
MUL16_:
	pop d
	jmp mulmore
mulmore:
	LDA Set_D2+1
	ora a
	jz breakmulmore
	dad d
	dcr a
	jnz $-2
breakmulmore:
	push h
	lxi h,L3_
	shld mulmore-2
	pop h
	jmp L3_		; }

L4:
	LHLD Set_D2+1
	LXI B,10000 ; _ldivu_(&res, d, 10000UL);
	CALL DIV320
	PUSH H
	LHLD _C     ; printf("%.4d", c + (uint16_t)(res.quot));
	DAD D
	CALL PR0000
	POP H
	SHLD _C     ; c = res.rem;
	POP H
	LXI B,-14
	DAD B
	xra a
Check:
	ora h
	jnz L2
	lda Check
	cpi 0B5h
	jz MakeAsItWas
	mvi a,0B5h
	sta Check
	call Mov9
	jmp L2
MakeAsItWas:
	mvi a,0B4h
	sta Check
	call Mov9
	
	di
	mvi a,' '
	call PrintChar
	mvi a,'T'
	call PrintChar
	mvi a,'='
	call PrintChar
	lhld IntCount+1
	xra a
	dad h\ adc a
	dad h\ adc a	;*4
	mov e,l
	mov d,h
	mov c,a
	dad h\ adc a
	dad h\ adc a
	dad h\ adc a	;*32
	push h
	push psw
	dad d
	adc c			;*36
	mov e,l
	mov d,h
	mov c,a
	pop psw
	pop h
	dad h\ adc a	;*64
	dad d
	adc c			;*100
	xchg
	mov l,a
	mvi h,0

	lxi b,5008
	call DIV320
	push h
	xchg
	call PR0000
	mvi a,'.'
	call PrintChar
	pop h
	dad h
	call PR0000
	JMP $

Mov9:	
	push h
	lxi h,MUL8_
	lxi d,MUL16_00
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d\ inx h\ inx d
	mov b,m\ ldax d\ mov m,a\ mov a,b\ stax d
	pop h
	ret

MakeOne:
	mvi m,19h\ inx h	;dad d
	mvi m,89h\ inx h	;adc c
	ret

MakeOneNoC:
	mvi m,19h\ inx h	;dad d
	mvi m,0CEh\ inx h	;
	mvi m,00h\ inx h	;aci 0
	ret

DIV320:; DE = HLDE/(BC), HL = HLDE%(BC)
	push d
	mov a,e
	sta SetE2+1
	mov a,b
	cma
	mov d,a
	mov a,c
	cma
	mov e,a
	inx d
	pop psw
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA0_
	adc a\ jc DIVS0_1_\ dad h\ dad d\ jnc DIVA1_
DIVS1_:	adc a\ jc DIVS1_1_
DIVS1_0_: dad h\ dad d\ jnc DIVA2_
DIVS2_:	adc a\ jc DIVS2_1_
DIVS2_0_: dad h\ dad d\ jnc DIVA3_
DIVS3_:	adc a\ jc DIVS3_1_
DIVS3_0_: dad h\ dad d\ jnc DIVA4_
DIVS4_:	adc a\ jc DIVS4_1_
DIVS4_0_: dad h\ dad d\ jnc DIVA5_
DIVS5_:	adc a\ jc DIVS5_1_
DIVS5_0_: dad h\ dad d\ jnc DIVA6_
DIVS6_:	adc a\ jc DIVS6_1_
DIVS6_0_: dad h\ dad d\ jnc DIVA7_
DIVS7_:	adc a\ jmp DIV7_2_

DIVS0_1_: dad h\ inr l\ dad d\ jnc DIVA1_\ adc a\ jnc DIVS1_0_
DIVS1_1_: dad h\ inr l\ dad d\ jnc DIVA2_\ adc a\ jnc DIVS2_0_
DIVS2_1_: dad h\ inr l\ dad d\ jnc DIVA3_\ adc a\ jnc DIVS3_0_
DIVS3_1_: dad h\ inr l\ dad d\ jnc DIVA4_\ adc a\ jnc DIVS4_0_
DIVS4_1_: dad h\ inr l\ dad d\ jnc DIVA5_\ adc a\ jnc DIVS5_0_
DIVS5_1_: dad h\ inr l\ dad d\ jnc DIVA6_\ adc a\ jnc DIVS6_0_
DIVS6_1_: dad h\ inr l\ dad d\ jnc DIVA7_\ adc a\ jmp DIV7_2_

DIVA0_:	dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS1_
DIVA1_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS2_
DIVA2_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS3_
DIVA3_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS4_
DIVA4_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS5_
DIVA5_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS6_
DIVA6_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS7_
DIVA7_: adc a\ dad b
DIV7_2_:
	sta	SetD2+1

DivLo:	
SetE2:
	mvi a,0
	dad h\ add a\ jnc $+4\ inr l\ dad d\ jnc DIVA8_
	adc a\ jc DIVS8_1_\ dad h\ dad d\ jnc DIVA9_
DIVS9_:	adc a\ jc DIVS9_1_
DIVS9_0_: dad h\ dad d\ jnc DIVA10_
DIVS10_:	adc a\ jc DIVS10_1_
DIVS10_0_: dad h\ dad d\ jnc DIVA11_
DIVS11_:	adc a\ jc DIVS11_1_
DIVS11_0_: dad h\ dad d\ jnc DIVA12_
DIVS12_:	adc a\ jc DIVS12_1_
DIVS12_0_: dad h\ dad d\ jnc DIVA13_
DIVS13_:	adc a\ jc DIVS13_1_
DIVS13_0_: dad h\ dad d\ jnc DIVA14_
DIVS14_:	adc a\ jc DIVS14_1_
DIVS14_0_: dad h\ dad d\ jnc DIVA15_
DIVS15_:	adc a\ jmp SetD2

DIVS8_1_: dad h\ inr l\ dad d\ jnc DIVA9_\ adc a\ jnc DIVS9_0_
DIVS9_1_: dad h\ inr l\ dad d\ jnc DIVA10_\ adc a\ jnc DIVS10_0_
DIVS10_1_: dad h\ inr l\ dad d\ jnc DIVA11_\ adc a\ jnc DIVS11_0_
DIVS11_1_: dad h\ inr l\ dad d\ jnc DIVA12_\ adc a\ jnc DIVS12_0_
DIVS12_1_: dad h\ inr l\ dad d\ jnc DIVA13_\ adc a\ jnc DIVS13_0_
DIVS13_1_: dad h\ inr l\ dad d\ jnc DIVA14_\ adc a\ jnc DIVS14_0_
DIVS14_1_: dad h\ inr l\ dad d\ jnc DIVA15_\ adc a\ jmp SetD2

DIVA8_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS9_
DIVA9_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS10_
DIVA10_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS11_
DIVA11_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS12_
DIVA12_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS13_
DIVA13_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS14_
DIVA14_: dad h\ add a\ jnc $+4\ inr l\ dad b\ jc DIVS15_
DIVA15_: adc a\ dad b
SetD2:
	mvi d,0
	mov e,a
	ret


PR0000:	LXI D,-1000
	lxi b,1000
	CALL PR0
	LXI D,-100
	lxi b,100
	CALL PR0
PR00:	
	LXI D,-10
	lxi b,10
	CALL PR0
	MOV A,L
PRD:	ADI 30h
PRC:
	JMP PrintChar
PR0:	MVI A,0FFh
	INR A
	DAD D
	jc $-2
	dad b
	ADI 30h
PrintChar:
		push	h
		lhld	cursor
		xchg
		push	d
		rlc\ rlc\ rlc
		mov h,a
		ani 11111000b
		mov l,a
		xra h
		inr l
		adi (Font>>8)-1
		mov h,a
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ inx h\ stax d\ dcr e
		mov	a,m\ stax d
		pop	d
		inr	d
		jm SaveCur
		mvi d,0E0h
		mvi a,-8
		add e
		mov e,a
SaveCur:
		xchg
		shld	cursor
		pop	h
		ret

_C:	DW 0


cursor		.dw	0E0FFh-7
		
Cls:
		lxi	h,0E000h
		xra	a
ClrScr:
		mov	m,a
		inx	h
		cmp	h
		jnz	ClrScr
		ret
Int:
		push h
IntCount:		
		lxi h,0
		inx h
		shld IntCount+1
		pop h
		ei
		ret

#define col 173

colors:
		.db 0,col,0,col,0,col,0,col,0,col,0,col,0,col,0,col

dword .db 0,0,0,0
	
	.org 0B00h-1
	.db 0
Font:

	END
