;=======================================================================
element register
element B?   : register + 0000h  
element C?   : register + 0FF1h
element D?   : register + 0112h
element E?   : register + 0FF3h
element H?   : register + 0224h
element L?   : register + 0FF5h
element M?   : register + 0FF6h
element A?   : register + 0FF7h
element SP?  : register + 0F3Fh
element PSW? : register + 03FFh
;                          ^^^
;                          |||- any 8-bit register operation
;                          ||-- any 16-bit operation, except push&pop
;                          |--- push&pop operations 
;-----------------------------------------------------------------------
condition_nz = 0 shl 3
condition_z  = 1 shl 3
condition_nc = 2 shl 3
condition_c  = 3 shl 3
condition_po = 4 shl 3
condition_pe = 5 shl 3
condition_p  = 6 shl 3
condition_m  = 7 shl 3
;-----------------------------------------------------------------------
macro regX name,param,disp
    name = 0Fh
    match param,x
        if param relativeto param element 1 & \
           param scale 0 = 0 & \
           param metadata 1 relativeto register
    		name = (param metadata 1 - register) \
    		        shr disp and 0Fh
        end if
    end match
    if name = 0Fh
       err "bad register"
    end if
end macro
;-----------------------------------------------------------------------
macro reg8 name,param
    regX name,param,0
end macro
;-----------------------------------------------------------------------
macro reg16 name,param
    regX name,param,4
end macro
;-----------------------------------------------------------------------
macro pushpop name,param
    regX name,param,8
end macro
;-----------------------------------------------------------------------
macro DS? num
    rb num
end macro
;-----------------------------------------------------------------------
macro LXI? r1,imm
    reg16 dest,r1
    db dest shl 4 or 1
    dw imm 
end macro    
;-----------------------------------------------------------------------
macro INX? r1
    reg16 dest,r1
    db dest shl 4 or 3
end macro    
;-----------------------------------------------------------------------
macro DAD? r1
    reg16 dest,r1
    db dest shl 4 or 9
end macro    
;-----------------------------------------------------------------------
macro DCX? r1
    reg16 dest,r1
    db dest shl 4 or 0Bh
end macro    
;-----------------------------------------------------------------------
macro STAX? r1
    reg16 dest,r1
    if dest and 0Eh
        err "bad register pair"
    else
        db dest shl 4 or 2
    end if
end macro    
;-----------------------------------------------------------------------
macro LDAX? r1
    reg16 dest,r1
    if dest and 0Eh
        err "bad register pair"
    else
        db dest shl 4 or 0Ah
    end if
end macro    
;-----------------------------------------------------------------------
macro PUSH? r1
    pushpop dest,r1
    db dest shl 4 or 0C5h
end macro    
;-----------------------------------------------------------------------
macro POP? r1
    pushpop dest,r1
    db dest shl 4 or 0C1h
end macro    
;-----------------------------------------------------------------------
macro MVI? r1,imm
    reg8 dest,r1
    db dest shl 3 or 6,imm
end macro 
;-----------------------------------------------------------------------
macro MOV? r1,r2
    reg8 dest,r1
    reg8 src,r2
    if src = dest & dest = 6
        err "illegal registers combination"
    else
        db dest shl 3 or src or 040h
    end if
end macro 
;-----------------------------------------------------------------------
macro INR? r1
    reg8 dest,r1
    db dest shl 3 or 4
end macro 
;-----------------------------------------------------------------------
macro DCR? r1
    reg8 dest,r1
    db dest shl 3 or 5
end macro 
;-----------------------------------------------------------------------
macro ADD? r1
    reg8 src,r1
    db src or 080h
end macro 
;-----------------------------------------------------------------------
macro ADC? r1
    reg8 src,r1
    db src or 088h
end macro 
;-----------------------------------------------------------------------
macro SUB? r1
    reg8 src,r1
    db src or 090h
end macro 
;-----------------------------------------------------------------------
macro SBB? r1
    reg8 src,r1
    db src or 098h
end macro 
;-----------------------------------------------------------------------
macro ANA? r1
    reg8 src,r1
    db src or 0A0h
end macro 
;-----------------------------------------------------------------------
macro XRA? r1
    reg8 src,r1
    db src or 0A8h
end macro 
;-----------------------------------------------------------------------
macro ORA? r1
    reg8 src,r1
    db src or 0B0h
end macro 
;-----------------------------------------------------------------------
macro CMP? r1
    reg8 src,r1
    db src or 0B8h
end macro 
;-----------------------------------------------------------------------
macro NOP?
	db 0
end macro
;-----------------------------------------------------------------------
macro HLT?
    db 076h
end macro
;-----------------------------------------------------------------------
macro EI?
	db 0FBh
end macro
;-----------------------------------------------------------------------
macro DI?
    db 0F3h
end macro
;-----------------------------------------------------------------------
macro XCHG?
    db 0EBh
end macro
;-----------------------------------------------------------------------
macro PCHL?
    db 0E9h
end macro
;-----------------------------------------------------------------------
macro XTHL? 
    db 0E3h 
end macro    
;-----------------------------------------------------------------------
macro SPHL?  
    db 0F9h
end macro    
;-----------------------------------------------------------------------
macro RET?
    db 0C9h
end macro
;-----------------------------------------------------------------------
macro RC? addr
    db 0C0h or condition_c
end macro
;-----------------------------------------------------------------------
macro RNC? addr
    db 0C0h or condition_nc
end macro
;-----------------------------------------------------------------------
macro RZ? addr
    db 0C0h or condition_z
end macro
;-----------------------------------------------------------------------
macro RNZ? addr
    db 0C0h or condition_nz
end macro
;-----------------------------------------------------------------------
macro RP? addr
    db 0C0h or condition_p
end macro
;-----------------------------------------------------------------------
macro RM? addr
    db 0C0h or condition_m
end macro
;-----------------------------------------------------------------------
macro RPO? addr
    db 0C0h or condition_po
end macro
;-----------------------------------------------------------------------
macro RPE? addr
    db 0C0h or condition_pe
end macro
;-----------------------------------------------------------------------
macro RLC?
    db 07h 
end macro
;-----------------------------------------------------------------------
macro RRC?
    db 0Fh
end macro
;-----------------------------------------------------------------------
macro RAL?
    db 17h
end macro
;-----------------------------------------------------------------------
macro RAR?
    db 1Fh
end macro
;-----------------------------------------------------------------------
macro CMA?
    db 2Fh
end macro
;-----------------------------------------------------------------------
macro STC?
    db 37h
end macro
;-----------------------------------------------------------------------
macro CMC?
    db 3Fh
end macro
;-----------------------------------------------------------------------
macro DAA?
    db 27h
end macro
;-----------------------------------------------------------------------
macro JMP? addr
	db 0C3h
	dw addr
end macro
;-----------------------------------------------------------------------
macro JC? addr
    db 0C2h or condition_c
    dw addr 
end macro
;-----------------------------------------------------------------------
macro JNC? addr
    db 0C2h or condition_nc
    dw addr 
end macro
;-----------------------------------------------------------------------
macro JZ? addr
    db 0C2h or condition_z
    dw addr 
end macro
;-----------------------------------------------------------------------
macro JNZ? addr
    db 0C2h or condition_nz
    dw addr 
end macro
;-----------------------------------------------------------------------
macro JP? addr
    db 0C2h or condition_p
    dw addr 
end macro
;-----------------------------------------------------------------------
macro JM? addr
    db 0C2h or condition_m
    dw addr 
end macro
;-----------------------------------------------------------------------
macro JPO? addr
    db 0C2h or condition_po
    dw addr 
end macro
;-----------------------------------------------------------------------
macro JPE? addr
    db 0C2h or condition_pe
    dw addr
end macro
;-----------------------------------------------------------------------
macro CALL? addr
	db 0CDh
	dw addr
end macro
;-----------------------------------------------------------------------
macro CC? addr
    db 0C4h or condition_c
    dw addr 
end macro
;-----------------------------------------------------------------------
macro CNC? addr
    db 0C4h or condition_nc
    dw addr 
end macro
;-----------------------------------------------------------------------
macro CZ? addr
    db 0C4h or condition_z
    dw addr 
end macro
;-----------------------------------------------------------------------
macro CNZ? addr
    db 0C4h or condition_nz
    dw addr 
end macro
;-----------------------------------------------------------------------
macro CP? addr
    db 0C4h or condition_p
    dw addr 
end macro
;-----------------------------------------------------------------------
macro CM? addr
    db 0C4h or condition_m
    dw addr 
end macro
;-----------------------------------------------------------------------
macro CPO? addr
    db 0C4h or condition_po
    dw addr 
end macro
;-----------------------------------------------------------------------
macro CPE? addr
    db 0C4h or condition_pe
    dw addr
end macro
;-----------------------------------------------------------------------
macro STA? addr
	db 032h
	dw addr
end macro
;-----------------------------------------------------------------------
macro LDA? addr
	db 03Ah
	dw addr
end macro
;-----------------------------------------------------------------------
macro SHLD? addr
	db 022h
	dw addr
end macro
;-----------------------------------------------------------------------
macro LHLD? addr
	db 02Ah
	dw addr
end macro
;-----------------------------------------------------------------------
macro ADI? imm
    db 0C6h,imm
end macro
;-----------------------------------------------------------------------
macro ACI? imm
    db 0CEh,imm
end macro
;-----------------------------------------------------------------------
macro SUI? imm
    db 0D6h,imm
end macro
;-----------------------------------------------------------------------
macro SBI? imm
    db 0DEh,imm
end macro
;-----------------------------------------------------------------------
macro ANI? imm
    db 0E6h,imm
end macro
;-----------------------------------------------------------------------
macro XRI? imm
    db 0EEh,imm
end macro
;-----------------------------------------------------------------------
macro ORI? imm
    db 0F6h,imm
end macro
;-----------------------------------------------------------------------
macro CPI? imm
    db 0FEh,imm
end macro
;-----------------------------------------------------------------------
macro IN? ioaddr
    db 0DBh,ioaddr
end macro
;-----------------------------------------------------------------------
macro OUT? ioaddr
    db 0D3h,ioaddr
end macro
;-----------------------------------------------------------------------
macro RIM? 
    db 020h
end macro
;-----------------------------------------------------------------------
macro SIM? 
    db 030h
end macro
;-----------------------------------------------------------------------
macro RST? imm 
    if imm>7 | imm<0
        err "value is out of range"
    end if
    db 0C7h or (imm shl 3)
end macro   
;=======================================================================
