;----------------------------------------------------------------------------
; Copyright (C) 2006 Arturo Ragozini and Daniel Vik
;
;  This software is provided 'as-is', without any express or implied
;  warranty.  In no event will the authors be held liable for any damages
;  arising from the use of this software.
;
;  Permission is granted to anyone to use this software for any purpose,
;  including commercial applications, and to alter it and redistribute it
;  freely, subject to the following restrictions:
;
;  1. The origin of this software must not be misrepresented; you must not
;     claim that you wrote the original software. If you use this software
;     in a product, an acknowledgment in the product documentation would be
;     appreciated but is not required.
;  2. Altered source versions must be plainly marked as such, and must not be
;     misrepresented as being the original software.
;  3. This notice may not be removed or altered from any source distribution.
;----------------------------------------------------------------------------

;
; Replayer core to play RLE encoded 22.05kHz samples generated by pcmenc
;
; pcmenc should use the following command line arguments:
;
;    pcmenc -rto 2 -dt1 156 -dt2 27 -dt3 141 file.wav
;
; and optionally -r to split sample into 8kB blocks for rom replayer
;

;-------------------------------------
; Plays one sample
; IN   HL - Encoded sample start address
;      DE - Sample length (#pcm samples)
;-------------------------------------
PLAY_SAMPLE:
        ld      c,$a1
        push    hl
        ex      de,hl
        inc     h
        exx
        pop     hl
        ld      bc,$0010
        ld      de,$0000
        exx
        
PsgLoop:
        exx                 ; 5     -> 5
        
; Calculate and output channel A volume
        ld      a,b         ; 5
        sub     $10         ; 8
        jr      nc,PsgWaitA ; 8/13
        ld      a,8         ; 8
        out     ($a0),a     ; 12
        ld      a,(hl)      ; 8
        inc     hl          ; 7
        ld      b,a         ; 5
        and     $0f         ; 8
        out     ($a1),a     ; 12    -> 81  Out at 86 after loop start
PsgDoneA:

; Calculate channel B volume
        ld      a,d         ; 5
        sub     c           ; 5
        jr      nc,PsgWaitB ; 8/13
        ld      a,(hl)      ; 8
        inc     hl          ; 7
        ld      d,a         ; 5
        and     $0f         ; 8
        exx                 ; 5
        ld      d,a         ; 5
        exx                 ; 5     -> 61
PsgDoneB:
        
; Calculate channel C volume
        ld      a,e         ; 5
        sub     c           ; 5
        jr      nc,PsgWaitC ; 8/13
        ld      a,(hl)      ; 8
        inc     hl          ; 7
        ld      e,a         ; 5
        and     $0f         ; 8
        exx                 ; 5
        ld      e,a         ; 5     -> 56
PsgDoneC:

        ; Output channels B and C
        ld      a,9         ; 8
        out     ($a0),a     ; 12
        inc     a           ; 5
        out     (c),d       ; 15          Out at 157+86 after loop start
        out     ($a0),a     ; 12
        out     (c),e       ; 15   -> 67  Out at 27+157+86 after loop start
        
        ; Wait32
        or      0           ; 8
        or      0           ; 8
        or      0           ; 8
        or      0           ; 8
        
        ; Decrement length and return if zero
        dec     l           ; 5
        jr      nz,PsgLoop  ; 8/13   -> 18   Total: 325
        dec     h           ; 5
        jp      nz,PsgLoop  ; 11
        ret
        
PsgWaitA:
        ld      b,a         ; 5
        inc     hl          ; 7
        dec     hl          ; 7
        nop                 ; 5
        nop                 ; 5
        nop                 ; 5
        jr      PsgDoneA    ; 13   -> 60 including branch
        
PsgWaitB:
        ld      d,a         ; 5
        nop                 ; 5
        nop                 ; 5
        nop                 ; 5
        nop                 ; 5
        jr      PsgDoneB    ; 13   -> 51 including branch
        
PsgWaitC:
        ld      e,a         ; 5
        exx                 ; 5
        nop                 ; 5
        nop                 ; 5
        nop                 ; 5
        jr      PsgDoneC    ; 11   -> 51 including branch
