' ----------------------------------------------------------------
' BIFROST*2 ENGINE DEMO - converted to Boriel's ZX BASIC Compiler
'
' This program can be compiled as follows:
'
' zxb.exe bifrost2dm.bas -t
'
' After compiling it, use the following loader to execute:
'
' 10 CLEAR 32767
' 20 LOAD "BIFROST2"CODE
' 30 LOAD "bifrost2dm"CODE
' 40 RANDOMIZE USR 32768
'
' Original version and further information is available at
' ?
' ----------------------------------------------------------------
#include "bifrost2.bas"

sub waitNoKey()
    PRINT AT 23,4;INK 7;"PRESS ANY KEY!"
    WHILE INKEY$="" END WHILE
    PRINT AT 23,4,,
end sub

DIM px,py,tile,attr,lin,col,f,g AS UBYTE

INK 5: PAPER 0: BORDER 0: CLS: RANDOMIZE
PRINT INK 4;AT 5,22;"BIFROST*2";AT 7,23;"ENGINE";AT 9,22;"BY EINAR";

' Install BIFROST*2 ENGINE (first time only!)
BIFROST2install()

' Configure tile images address
BIFROST2resetTileImages(@ctile)

' Clear tilemap area
FOR px=0 TO 10: FOR py=0 TO 9
    BIFROST2setTile(px, py, BIFROST2DISABLED)
NEXT py: NEXT px

' Start BIFROST*2 ENGINE
BIFROST2start()
DO
    PRINT AT 16,23;"STATIC",AT 18,23;"TILES";

    ' Fill tilemap with random static tiles
    FOR px=0 TO 10: FOR py=0 TO 9
        LET tile = INT(RND*64)
        IF tile < 32 THEN
            BIFROST2setTile(px, py, BIFROST2STATIC + tile)
        END IF
    NEXT py: NEXT px

    waitNoKey()

    PRINT AT 16,23;"ANIMATED";AT 20,22;"(4 FRAMES)";

    ' Animate tiles
    FOR px=0 TO 10: FOR py=0 TO 9
        LET tile = BIFROST2getTile(px, py)
        IF tile <> BIFROST2DISABLED THEN
            BIFROST2setTile(px, py, tile - BIFROST2STATIC)
        END IF
    NEXT py: NEXT px

    PRINT AT 23,1;INK 7;"CHOOSE FRAMES 2-4 OR 0 TO EXIT";
    BIFROST2resetAnim4Frames()
    WHILE INKEY$<>"0"
        ' Modify number of animation frames
        IF INKEY$="2" THEN BIFROST2resetAnim2Frames(): PRINT AT 20,23;"2";: END IF
        IF INKEY$="4" THEN BIFROST2resetAnim4Frames(): PRINT AT 20,23;"4";: END IF
    END WHILE
    PRINT AT 23,1,,

    PRINT AT 16,23;"PAINTING";AT 20,22,

    LET px=0
    LET py=0
    DO
        LET attr = INT(RND*128)
        BIFROST2setTile(px, py, BIFROST2DISABLED)
        BIFROST2halt()
        BIFROST2fillTileAttrH(PX2LIN(px), PY2COL(py), attr)
        BIFROST2halt()
        BIFROST2fillTileAttrH(PX2LIN(px), PY2COL(py), 0)

        LET py=py+7: IF py > 9 THEN LET py = py-10: LET px = (px+1) MOD 11: END IF
    LOOP UNTIL px=0 AND py=0

    waitNoKey()
LOOP

ctile:
asm
    incbin "bifrost2.ctile"
end asm
