/* procedury graficzne, zakladaja tryb graficzny CGA 320 x 200 mono,
   na ogol przewidziane tylko dla fragmentu ekranu XSIZE x YSIZE,
   tzn. 256 x 192
   punkt x=0, y=0 jest w lewym gornym rogu ekranu, inaczej niz konwencja
   przyjeta w grze, gdzie ten punkt jest w lewym dolnym rogu ekranu ! */

#include "typedefs.h"
#include "bool.h"
#include "fl_grap2.h"

#pragma inline

/* tablica wzorow uzywanych do zpelniania powierzchni - szer=2 bajty,wys=0x10
   8 kolejnych bajtow jest danymi dla kolumny szer=1 bajt, wys=0x08
   jest to inna organizacja danych, niz dla map bitowych	*/

uchar patterns[] = {
/* kod wzoru E6 */
0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,
0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,
0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,
0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,
/* kod wzoru E7 - poziome linie */
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,0xFF,
/* kod wzoru E8 - pionowe linie */
0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
/* kod wzoru E9 */
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
/* kod wzoru EA - kafelki */
0x03,0x0D,0x3A,0xD5,0x3A,0x0D,0x03,0x00,
0x00,0xC0,0xB0,0x5C,0xAB,0x5C,0xB0,0xCC,
0x03,0xCC,0x37,0xEA,0x55,0xEA,0x35,0x0E,
0x03,0x00,0x00,0xC0,0x7B,0xAC,0x70,0xC0,
/* kod wzoru EB - cegly */
0x10,0x10,0x10,0xFF,0x01,0x01,0x01,0xFF,
0x10,0x10,0x10,0xFF,0x01,0x01,0x01,0xFF,
0x10,0x10,0x10,0xFF,0x01,0x01,0x01,0xFF,
0x10,0x10,0x10,0xFF,0x01,0x01,0x01,0xFF,
/* kod wzoru EC - cegly na prawej scianie */
0xC4,0x74,0x4C,0x43,0xC0,0x30,0x0C,0x07,
0xC0,0x30,0x0C,0x07,0xC4,0x74,0x4C,0x43,
0xC4,0x74,0x4C,0x43,0xC0,0x30,0x0C,0x07,
0xC0,0x30,0x0C,0x07,0xC4,0x74,0x4C,0x43,
/* kod wzoru ED - cegly na lewej scianie */
0x23,0x2E,0x32,0xC2,0x03,0x0C,0x30,0xE0,
0x03,0x0C,0x30,0xE0,0x23,0x2E,0x32,0xC2,
0x23,0x2E,0x32,0xC2,0x03,0x0C,0x30,0xE0,
0x03,0x0C,0x30,0xE0,0x23,0x2E,0x32,0xC2,
/* kod wzoru EE */
0xDF,0x55,0xDD,0x55,0xFD,0x05,0xFF,0x50,
0xFD,0x05,0xFF,0x50,0xDF,0x55,0xDD,0x55,
0xDF,0x55,0xDD,0x55,0xFD,0x05,0xFF,0x50,
0xFD,0x05,0xFF,0x50,0xDF,0x55,0xDD,0x55,
/* kod wzoru EF */
0x1E,0x21,0x81,0x92,0xB8,0x44,0x0F,0x10,
0x02,0x07,0xC8,0x28,0x11,0x3A,0x44,0x84,
0x20,0x71,0x8B,0x04,0x0E,0x31,0x81,0x41,
0xF3,0x0C,0xC4,0x26,0x19,0x11,0x73,0x8C,
/* kod wzoru F0 */
0x00,0x00,0xC3,0xFF,0xE7,0x81,0x00,0x00,
0x3C,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0x18,
0x00,0x00,0xC3,0xFF,0xE7,0x81,0x00,0x00,
0x3C,0xFF,0xFF,0xFF,0xFF,0xFF,0x7E,0x18,
/* kod wzoru F1 */
0x77,0xAA,0x77,0xAA,0x77,0xAA,0x57,0xAA,
0x5D,0xAA,0x5D,0xAA,0x5D,0xAA,0x5D,0xAA,
0x57,0xAA,0x77,0xAA,0x77,0xAA,0x77,0xAA,
0x5D,0xAA,0x5D,0xAA,0x7D,0xAA,0x5D,0xAA,
/* kod wzoru F2 */
0x39,0x32,0x57,0x53,0x5A,0x20,0x0D,0x50,
0x30,0x31,0x51,0x41,0xE3,0xC4,0xE0,0xE4,
0xB4,0xBC,0xBD,0xBB,0xAF,0xB0,0xB1,0xC0,
0xA7,0xA6,0xBE,0xAD,0xB2,0xBA,0xE5,0xA5,
/* kod wzoru F3 - drewniana podloga */
0x03,0x0D,0x38,0xD0,0x38,0x0C,0x03,0x00,
0x00,0xC0,0x30,0x1C,0x0B,0x1C,0xB0,0xCC,
0x03,0xCC,0x37,0xE0,0x40,0xE0,0x30,0x0E,
0x03,0x00,0x00,0xC0,0x7B,0x2C,0x70,0xC0,
/* kod wzoru F4 */
0x41,0x41,0x41,0x49,0x41,0x41,0x41,0x45,
0x08,0x88,0x08,0x08,0x08,0x08,0x09,0x08,
0x41,0x05,0x41,0x41,0x41,0x41,0x41,0x41,
0x28,0x08,0x08,0x08,0x0A,0x08,0x48,0x08,
/* kod wzoru F5 */
0xC0,0x30,0x1C,0x07,0x03,0x04,0x04,0x04,
0x10,0x10,0x10,0x10,0xF0,0x78,0x1E,0x03,
0xC4,0xFE,0x4E,0x83,0x80,0x80,0x80,0x80,
0x00,0x00,0x00,0x00,0xC0,0x30,0x1E,0x1B,
/* kod wzoru F6 */
0x08,0x08,0x08,0x08,0x0F,0x1E,0x78,0xC0,
0x03,0x0C,0x38,0xE0,0xC0,0x20,0x20,0x20,
0x00,0x00,0x00,0x00,0x03,0x0C,0x78,0xD8,
0x23,0x7F,0x72,0xC1,0x01,0x01,0x01,0x01,
/* kod wzoru F7 */
0x00,0x00,0x00,0x00,0x03,0x0C,0x33,0xC0,
0x03,0x0C,0x30,0xC0,0x00,0x00,0x00,0xC0,
0x00,0x00,0x00,0x00,0x03,0x0C,0x30,0xC0,
0x33,0x0C,0x30,0xC0,0x00,0x00,0x00,0x00,
/* kod wzoru F8 */
0x08,0xA9,0x42,0x11,0x0C,0x96,0x5C,0x58,
0x43,0x08,0x20,0x04,0x52,0x23,0x25,0xB5,
0x14,0x16,0x24,0x2A,0x95,0x0A,0x3A,0xD8,
0x42,0x59,0x16,0xD5,0x31,0xA0,0x15,0x81,
/* kod wzoru F9 */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* kod wzoru FA */
0x88,0x00,0x22,0x00,0x88,0x00,0x22,0x00,
0x88,0x00,0x22,0x00,0x88,0x00,0x22,0x00,
0x88,0x00,0x22,0x00,0x88,0x00,0x22,0x00,
0x88,0x00,0x22,0x00,0x88,0x00,0x22,0x00,
/* kod wzoru FB */
0x1E,0x61,0xAD,0x92,0xB8,0x44,0x0F,0xD0,
0x42,0x37,0xC8,0x2E,0xD1,0x3A,0x45,0xB4,
0x2E,0x71,0x8B,0x34,0xCE,0x31,0x8D,0x51,
0xD3,0x0C,0xD4,0x26,0xD9,0x15,0x73,0x8C
};


uint screen_segm = SCREEN;
uint shadow_segm = SHADOW;


uint read_video_mode (void)
{
  asm {	mov	ah,0Fh
	int	10h
	mov	ah,0	}
  return _AX;
}


void set_video_mode (uint mode)
{
  asm {	mov	ax,word ptr mode
	mov	ah,0
	int	10h	}
}


/* procedura kasujaca Video-RAM lub Shadow-Screen */
void clear_screen (uint segm)
{
  asm {	push	es
	mov	es,word ptr segm
	xor	ax,ax
	mov	di,ax
	mov	cx,2000h
	cld
	rep stosw
	pop	es	}
}


/* procedura kopiuje Video-RAM do Shadow-Screen lub odwrotnie */
void copy_screen (uint src_segm, uint dest_segm)
{
  asm {	push	es
	push	ds
	mov	ds,word ptr src_segm
	mov	es,word ptr dest_segm
	mov	si,0
	mov	di,si
	mov	cx,2000h
	cld
	rep movsw
	pop	ds
	pop	es	}
}


/* Procedura wykresla odcinek laczacy dwa punkty w Video-RAM lub Shadow-Screen
   - algorytm Bresenhama
   Znaczenie bitow mode w danej wejsciowej: 
	bit 1 set - tryb XOR, gdy bit 1 clr - tryb OR
	bit 0 set - w trybie OR rysowany piksel w kolorze tla
	bit 0 clr - w trybie OR rysowany piksel w kolorze kontrastowym
   Dodatkowo wewnatrz procedury:
	bit 2 set gdy delta X ujemne
	bit 3 set gdy delta Y ujemne
	bit 4 set gdy |delta Y| > |delta X| (flag F)
	bit 5 set gdy nieparzysty numer wiersza
	bit 6 set gdy delta X = 0 i delta Y = 0
   Procedura dziala poprawnie dla calego ekranu 320 x 200. */
void draw_line (uint x0, uint y0, uint x1, uint y1, uint mode, uint segm)
{
  if (x0>=XSIZE || y0>=YSIZE || x1>=XSIZE || y1>=YSIZE)
    return;
  mode &= 0x03;
  if (x1 < x0)
  {
    x1 = x0 - x1;
    mode |= 0x04;
  }
  else
  {
    x1 -= x0;
  }
  if (y1 < y0)
  {
    y1 = y0 - y1;
    mode |= 0x08;
  }
  else
  {
    y1 -= y0;
  }
  if (x1==0 && y1==0)
    mode |= 0x40;
  if (y1 > x1)
  {
  asm {	mov	ax,word ptr x1
	mov	bx,word ptr y1
	mov	word ptr x1,bx
	mov	word ptr y1,ax	}
    mode |= 0x10;
  }
  if (y0 & 0x01)
    mode |= 0x20;
/* obliczenie w DI offsetu bajtu pamieci ekranu dla piksela x0,y0 */
  _DI = 40*(y0 & ~1) + (x0>>2) + ((y0 & 1)<<13);
  asm {	push	es
	mov	es,word ptr segm
/* obliczenie w AL maski bitowej dla piksela x0,y0 */
	mov	cx,word ptr x0
	and	cl,03h
	shl	cl,1
	mov	al,0c0h
	shr	al,cl

	mov	bx,word ptr mode
	mov	ah,bl		/* AH jest rowne mode */
	mov	cx,word ptr x1	/* CX jest licznikiem rysowanych pikseli */
	mov	bx,cx
	shl	bx,1		/* BX jest rowne 2 * |delta X| */
	mov	si,word ptr y1
	shl	si,1		/* SI jest rowne 2 * |delta Y| */
	mov	dx,si		/* DX jest roznica E */
	sub	dx,cx	}	/* E = 2 * |delta Y| - |delta X| */
  draw_loop:
/* rysowanie punktu */
  asm {	test	ah,02h
	jz	draw_1
	xor	es:[di],al
	jmp	short draw_2a	}
  draw_1:
  asm {	test	ah,01h
	jnz	draw_2
	or	es:[di],al
	jmp	short draw_2a	}
  draw_2:
  asm {	not	al
	and	es:[di],al
	not	al	}
  draw_2a:
  asm {	test	ah,40h
	jnz	draw_end
	and	dx,dx
	jmp	short draw_4	}
/* przyrost pierwszej wspolrzednej */
  draw_3:
  asm {	sub	dx,bx	}	/* BX jest rowne 2 * |delta X| */
  draw_4:
  asm {	jl	draw_7
	test	ah,10h		/* flag F */
	jz	draw_5
	test	ah,04h		/* znak delta X */
	jz	draw_4a
	rol	al,1
	rol	al,1
	jnc	draw_3
	dec	di
	jmp	short draw_3	}
  draw_4a:
  asm {	ror	al,1
	ror	al,1
	jnc	draw_3
	inc	di
	jmp	short draw_3	}
  draw_5:
  asm {	add	di,2000h
	xor	ah,20h
	test	ah,20h
	jnz	draw_6
	sub	di,3fb0h	}
  draw_6:
  asm {	test	ah,08h		/* znak delta Y */
	jz	draw_3
	sub	di,0050h
	jmp	short draw_3	}
/* przyrost drugiej wspolrzednej */
  draw_7:
  asm {	test	ah,10h		/* flag F */
	jnz	draw_8
	test	ah,04h		/* znak delta X */
	jz	draw_7a
	rol	al,1
	rol	al,1
	jnc	draw_10
	dec	di
	jmp	short draw_10	}
  draw_7a:
  asm {	ror	al,1
	ror	al,1
	jnc	draw_10
	inc	di
	jmp	short draw_10	}
  draw_8:
  asm {	add	di,2000h
	xor	ah,20h
	test	ah,20h
	jnz	draw_9
	sub	di,3fb0h	}
  draw_9:
  asm {	test	ah,08h		/* znak delta Y */
	jz	draw_10
	sub	di,0050h	}
  draw_10:
  asm {	add	dx,si		/* SI jest rowne 2 * |delta Y| */
	dec	cx
	jl	draw_end
	jmp	draw_loop	}
  draw_end:
  asm {	pop	es	}
}


/* Procedura wypelniajaca wzorem zamkniety obszar.
   Algorytm: w biezacym wierszu wypelniane sa wzorem wszystkie piksele
   miedzy ustawionymi granicznymi pikselami. Nieustawione piksele powyzej
   i ponizej biezacego sa zapamietywane na stosie. W przypadku natrafienia
   na ciag sasiadujacych ze soba nieustawionych pikseli, zapamietywane sa
   wspolrzedne tylko jednego piksela. Obsluzone piksele za zapamietywane jako
   ustawione punkty w Shadow-Screen (nie byloby to potrzebne w przypadku
   wypelniania kolorem a nie wzorem).
   Procedura wymaga kopii Video-RAM w Shadow-Screen.
   Dziala tylko na fragmencie ekranu ograniczonym XSIZE, YSIZE. */
void fill_area (
uint x, uint y,		/* wspolrzedne poczatkowego punktu */
uint pattern )		/* numer wzoru wypelniajacego */
{
  if (x>=XSIZE || y>=YSIZE)
    return;
  asm {	mov	dx,word ptr x
	mov	ax,word ptr y
	mov	dh,al
	mov	ax,word ptr pattern
	mov	bx,word ptr shadow_segm
	mov	si,offset patterns
/* po zmianie BP i rejestrow segmentowych odciety dostep do zmiennych */
	push	bp
	push	ds
	push	es
	mov	bp,SCREEN	/* BP przechowuje segment Video-RAM */
	push	ds
	pop	es		/* ES = segment wzoru wypelniajacego */
	mov	ds,bx		/* DS = segment Shadow-Screen */
	mov	cl,5
	shl	ax,cl
	add	si,ax		/* adres wzoru wypelniajacego */
	mov	ax,0ffffh
	push	ax	}	/* znacznik konca stosu */

/* wejscie do petli ze wspolrzednymi punktu w DH=Y i DL=X */
  fill_loop1:
  asm {	mov	ch,0		/* flag zapamietywania na stosie
				   nieustawionych pikseli */
/* obliczenie w DI offsetu bajtu pamieci ekranu dla piksela DH=Y i DL=X */
	mov	ah,0
	mov	al,dh
	and	al,0feh
	shl	ax,1
	shl	ax,1
	shl	ax,1
	mov	di,ax
	shl	ax,1
	shl	ax,1
	add	di,ax		/* DI=80*Y/2 */
	test	dh,01h
	jz	pix_addr1
	add	di,2000h	}
  pix_addr1:
  asm {	mov	ah,0
	mov	al,dl
	shr	ax,1
	shr	ax,1
	add	di,ax		/* DI=DI+2*X/8 */
/* obliczenie w AL maski bitowej dla piksela DX */
	mov	cl,dl
	and	cl,03h
	shl	cl,1
	mov	al,0c0h
	shr	al,cl

	test	al,[di]
	jz	fill_1
	jmp	fill_19	}

  fill_1:
/* szukanie prawego punktu granicznego w linii */
  asm {	cmp	dl,XSIZE-1	/* czy to prawa granica ekranu ? */
	jz	fill_3		/* skok, gdy tak */
	inc	dl
	ror	al,1
	ror	al,1
	jnc	fill_2
	inc	di	}
  fill_2:
  asm {	test	al,[di]		/* czy piksel ustawiony ? */
	jz	fill_1		/* szukanie dalej, gdy nie */
/* cofniecie sie o jeden piksel w lewo */
	dec	dl
	rol	al,1
	rol	al,1
	jnc	fill_3
	dec	di	}
  fill_3:

/* obliczenie w BX offsetu bajtu wzoru wypelniajacego */
  asm {	mov	bl,dl
	and	bl,08h
	mov	ah,dh
	shl	ah,1
	and	ah,10h
	add	bl,ah
	mov	ah,dh
	and	ah,07h
	add	bl,ah
	mov	bh,0
/* CL = maska bitowa dla punktu wzoru wypelniajacego */
	mov	cl,dl
	and	cl,07h
	mov	ah,80h
	shr	ah,cl	
	mov	cl,ah	}

  fill_loop2:
/* jezeli piksel powyzej biezacego nie jest ustawiony, zostaje zapamietany
   na stosie */
  asm {	test	dh,01h
	jz	fill_6
	sub	di,3fb0h	}
  fill_6:
  asm {	add	di,1fb0h
	and	dh,dh		/* czy to pierwsza linia ekranu ? */
	jz	fill_9		/* skok, gdy tak */
	test	al,[di]		/* czy piksel powyzej biezacego ustawiony ? */
	jnz	fill_8		/* skok, gdy tak */
	test	ch,01h		/* czy sasiedni nieustawiony piksel byl juz
				   zapamietany na stosie ? */
	jnz	fill_9		/* skok, gdy tak */
	dec	dh		/* dec Y */
	push	dx		/* zapamietanie wspolrzednych piksela */
	inc	dh		/* inc Y */
	or	ch,01h
	jmp	short fill_9	}
  fill_8:
  asm {	and	ch,0feh	}	/* nastepny nieustawiony piksel musi byc
				   zapamietany na stosie */

  fill_9:
/* jezeli piksel ponizej biezacego nie jest ustawiony, zostaje zapamietany
   na stosie */
  asm {	add	di,0050h
	cmp	dh,YSIZE-1	/* czy to ostatnia linia ekranu ? */
	jnc	fill_11		/* skok, gdy tak */
	test	al,[di]		/* czy piksel ponizej biezacego ustawiony ? */
	jnz	fill_10		/* skok, gdy tak */
	test	ch,02h		/* czy sasiedni nieustawiony piksel byl juz
				   zapamietany na stosie ? */
	jnz	fill_11		/* skok, gdy tak */
	inc	dh		/* inc Y */
	push	dx		/* zapamietanie wspolrzednych piksela */
	dec	dh		/* dec Y */
	or	ch,02h
	jmp	short fill_11	}
  fill_10:
  asm {	and	ch,0fdh	}	/* nastepny nieustawiony piksel musi byc
				   zapamietany na stosie */

  fill_11:
/* odtworzenie adresu biezacego piksela w Shadow-Screen */
  asm { test	dh,01h
	jz	fill_12
	add	di,3fb0h	}
  fill_12:
  asm {	sub	di,2000h
/* zaznaczenie w Shadow-Screen obsluzonego piksela */
	or	[di],al
/* przepisanie piksela z wzoru wypelniajacego do Video-RAM */
	test	cl,es:[si+bx]
	push	ds
	mov	ds,bp		/* DS = segment Video-RAM */
	jz	fill_13
	or	[di],al 	/* ustawienie piksela w Video-RAM */
	jmp	short fill_14	}
  fill_13:
  asm {	not	al
	and	[di],al		/* skasowanie piksela w Video-RAM */
	not	al	}
  fill_14:
  asm {	pop	ds
/* cofniecie sie o jeden piksel w lewo */
	sub	dl,1
	jc	fill_19		/* skok, gdy lewa granica ekranu */
	rol	al,1
	rol	al,1
	jnc	fill_15
	dec	di	}
  fill_15:
/* obliczenie nastepnego punktu z wzoru wypelniajacego */
  asm {	rol	cl,1
	jnc	fill_18
	xor	bl,08h	}
  fill_18:
  asm {	test	al,[di]		/* czy piksel ustawiony ? */
	jz	fill_loop2 }	/* skok, gdy nie */
  fill_19:
/* jezeli piksel jest ustawiony lub jest to lewa granica ekranu,
   pobrane zostaja ze stosu wspolrzedne nastepnego piksela */
  asm {	pop	dx
	cmp	dx,0ffffh		/* czy znacznik konca stosu ? */
	jz	fill_end
	jmp	fill_loop1	}

  fill_end:
  asm {	pop	es
	pop	ds
	pop	bp	}
}


/* Procedura kopiujaca na ekran fragment bitmapy. Kopiowane sa tylko punkty
   nalezace do rysunku, okreslane na podstawie maski bitowej (konturu)
   umieszczonej po danych opisujacych bitmape. Punkty nie nalezace do rysunku
   sa kopiowane z wzoru tla zawartego w Shadow-Screen. Maska bitowa ma
   skasowane bity nalezace do bitmapy a ustawione bity nalezace do tla.
   Gdy parametr maska = 0, kopiowane sa wszystkie punkty bitmapy.
   Szerokosc bitmapy liczona w bajtach.
   Procedura dziala poprawnie dla calego ekranu 320 x 200. */
void image (
uint rysunek,		/* adres rysunku */
uint maska,		/* offset maski bitowej wzgledem adresu rysunku,
			   zwykle szer*wys lub 0 */
uint x, uint y,		/* wspolrzedne lewego gornego punktu */
uint szer, uint wys )	/* wymiary bitmapy (szerokosc w bajtach) */
{
/* obliczenie w DI offsetu bajtu pamieci ekranu dla piksela x,y */
  _DI = 40*(y & ~1) + (x>>2) + ((y & 1)<<13);
  asm {	push	es
	mov	es,word ptr shadow_segm
	mov	si,word ptr rysunek
	mov	bx,word ptr maska
/* obliczenie w AL maski bitowej dla piksela DX */
	mov	cx,word ptr x
	and	cl,03h
	shl	cl,1
	mov	al,0c0h
	shr	al,cl

	mov	cx,word ptr wys
	mov	ah,cl
	mov	cx,word ptr szer /* CL=szer */
	mov	ch,ah		/* CH=wys */
	mov	ah,80h	}	/* maska bitowa dla bitmapy */
image_loop1:
  asm {	mov	dl,cl		/* licznik bajtow bitmapy w wierszu */
	mov	dh,es:[di]
	push	di	}
image_loop2:
  asm {	cmp	bx,0		/* czy uwzgledniamy maske ? */
	jz	image_2
	test	ah,[si+bx]	/* czy punkt nalezy do bitmapy ? */
	jnz	image_4	}	/* skok, gdy nie */
/* kopiowanie punktu bitmapy do DH */
image_2:
  asm {	test	ah,[si]		/* czy punkt ustawiony ? */
	jz	image_3		/* skok, gdy nie */
	or	dh,al
	jmp	short image_4	}
image_3:
  asm {	not	al
	and	dh,al
	not	al	}
image_4:
  asm {	ror	al,1
	ror	al,1
	jnc	image_5
	push	ds
	mov	ds,word ptr screen_segm
	mov	[di],dh
	pop	ds
	inc	di
	mov	dh,es:[di]	}
image_5:
  asm {	ror	ah,1
	jnc	image_loop2
	inc	si
	dec	dl
	jnz	image_loop2
/* nastepny wiersz ekranu i bitmapy */
	pop	di
	add	di,2000h
	inc	word ptr y
	test	word ptr y,0001h
	jnz	image_6
	sub	di,3fb0h	}
image_6:
  asm {	dec	ch
	jnz	image_loop1
	pop	es	}
}
