/* program testowy dla funkcji rysowania obiektow zdefiniowanych przez
   bitmapy */

#include <stdio.h>
#include "typedefs.h"
#include "bool.h"
#include "fl_grap2.h"
#include "keyboard.h"

#define OFFSET 0x5b00
#define BUFSIZE 32767
uchar bufor[BUFSIZE];


int main (void)
{
  FILE *infp;
  uint old_video_mode;
  int bajt;
  uint x, y, obiekt, adres, szer, wys;

  if ((infp=fopen("FL_CODE.BIN","rb"))==NULL)
  {
    fprintf (stderr,"\nNie moge otworzyc pliku FL_CODE.BIN\n");
    return 0;
  }
  for (x=0; x<BUFSIZE && (bajt=getc(infp))!=EOF; x++ )
    bufor[x] = (uchar) bajt;
  (void) fclose (infp);
  old_video_mode = read_video_mode();
  set_video_mode (5);		/* CGA 320x200, grayscale */

  clear_screen (SCREEN);
  draw_line (0, 0, 200, 10, 0, SCREEN);
  draw_line (200, 10, 150, 190, 0, SCREEN);
  draw_line (150, 190, 10, 100, 0, SCREEN);
  draw_line (10, 100, 0, 0, 0, SCREEN);
  copy_screen (SCREEN, SHADOW);
  fill_area (100, 100, 0xf7-0xe6);
  copy_screen (SCREEN, SHADOW);
  obiekt = 0xb734 - OFFSET - 11;
  for (y=0; y<160; y+=0x28)
  {
    for (x=0; x<200; x+=5*8)
    {
      do {
        obiekt+=11;
        adres = ((uint) bufor[obiekt+5] << 8) + (uint) bufor[obiekt+4];
      } while (adres==0) ;
      szer = (uint) bufor[obiekt+2] >> 3;
      wys = (uint) bufor[obiekt+3];
      image (adres - OFFSET + (uint) bufor, szer*wys, x, y, szer, wys);
    }
  }
  (void) read_key();

  set_video_mode (old_video_mode);
  return 0;
}
