;!!!
;align 100h
tab0 .equ 200h
tab1 .equ tab0+100h
tab2 .equ tab1+100h
tab3 .equ tab2+100h
tab21 .equ tab3+100h
tab31 .equ tab21+100h
tab22 .equ tab31+100h
tab32 .equ tab22+100h
tab23 .equ tab32+100h
tab33 .equ tab23+100h
tab24 .equ tab33+100h
tab4 .equ tab24+100h

TABL_SQR	.equ 1F00h

	.org 0
	call gentab
	jmp test

	.org 100h
test:
	lxi d,1
	call sqrt		;sqrt(1)=1
	lxi d,3969
	call sqrt		;sqrt(3969)=63=3Fh
	lxi d,4096
	call sqrt		;sqrt(4096)=64=40h
	lxi d,0FFFFh
	call sqrt		;sqrt(FFFFh)=FFh
	jmp $
	
gentab:
MK_SQ_TAB:
			xra a
			mov h,a
			mov l,a
			mov e,a
MSQT2:
			mvi d,TABL_SQR>>8
			xchg
			mov m,e
			inr h
			mov m,d
			xchg
			mov d,a
			dad d
			inr e
			dad d
			jnz MSQT2
			
	lxi h,tab1
	lxi d,tab0
gentab0:
	mov a,m
	add a
	adi tab4>>8
	stax d
	mov a,m
	adi tab2>>8
	mov m,a
	inr l
	inr e
	jnz gentab0

	mvi l,0
gentab4:
	mvi h,tab4>>8
	mov a,l
	mov m,a
	inr h\ inr h\ ora a\ ral\ mov m,a
	inr h\ inr h\ ora a\ ral\ mov m,a
	inr h\ inr h\ ora a\ ral\ mov m,a
	inr h\ inr h\ ora a\ ral\ mov m,a
	inr h\ inr h\ ora a\ ral\ mov m,a
	inr h\ inr h\ ora a\ ral\ mov m,a
	inr h\ inr h\ ora a\ ral\ mov m,a
	inr h\ inr h\ ora a\ ral\ mov m,a
	inr l
	jnz gentab4

	mvi l,0
gentab5:
	mvi h,(tab4>>8)+(9*2)-1
	mov a,l
	mov m,a
	dcr h\ dcr h\ ora a\ rar\ mov m,a
	dcr h\ dcr h\ ora a\ rar\ mov m,a
	dcr h\ dcr h\ ora a\ rar\ mov m,a
	dcr h\ dcr h\ ora a\ rar\ mov m,a
	dcr h\ dcr h\ ora a\ rar\ mov m,a
	dcr h\ dcr h\ ora a\ rar\ mov m,a
	dcr h\ dcr h\ ora a\ rar\ mov m,a
	dcr h\ dcr h\ ora a\ rar\ mov m,a
	inr l
	jnz gentab5
	ret

;Input
;DE-X
;Output
;L-sqrt(X)
sqrt:
	mov l,d
	mvi h,tab0>>8
	mov h,m			;N
	mov a,m			;M msb
	inr h
	mov l,e
	ora m			;or M lsb
	mov c,a			;M
	mvi h,tab1>>8
	mov l,d
	mov b,m
	ldax b
;~sqrt(X) in A	
;Correction
	mov l,a
	mvi h,(TABL_SQR>>8)+1
	mov a,d
	cmp m
	jc Corr		;X>sqrt(M)^2
	jz EqualH	;X=sqrt(M)^2
;X<sqrt(M)^2
	inr l
	jnz Not0
	dcr l
	ret
Not0:
	cmp m
	jc Corr		;X>(sqrt(M)+1)^2
;<?	
EqualH:
	dcr h
	mov a,e
	cmp m
	rnc
Corr:
	dcr l
	ret


	.org tab1-1
	.db 0
	
		.end

