;=======================================================================
include "8085.inc"
include "rks.inc"
include "win2koi7.inc"
include "spec.inc"
;-----------------------------------------------------------------------
maxfuelout equ 320  ; kg / 10 -    ( < 32768! )
;-----------------------------------------------------------------------
RKS_START 
;-----------------------------------------------------------------------
    lxi  h,hud
    call show_status ;   
;-----------------------------------------------------------------------
mainloop:
;-----------------------------------------------------------------------
    lxi  h,status
    call show_status ;   
;-----------------------------------------------------------------------
    lxi  h, 1 shl 12 ;    
    shld dl
;-----------------------------------------------------------------------
control:
    call getkey
    inr  a
    jz   nokey
    dcr  a
    cpi  1Fh
    jz   monitor ;  - 
    cpi  20h
    jz   engine  ;         :   
    cpi  08h     ; SHIFT + :  
    jz   turn_l  ; / -  
    cpi  18h     ; SHIFT: 
    jz   turn_r
    cpi  19h
    jz   rr_up   ; / -    
    cpi  1Ah     ; SHIFT: 
    jz   rr_down
;-----------------------------------------------------------------------
nokey:
    lhld dl
    dcx  h
    shld dl
    mov  a,h
    ora  l
    jnz  control
    call calculate
    jmp  mainloop
;-----------------------------------------------------------------------
rr_up:
    call getshift
    lhld rr
    inx  h
    jz   .check
    lxi  b,9
    dad  b
.check:    
    mvi  a,maxfuelout and 0FFh
    cmp  l
    mvi  a,maxfuelout shr 8
    sbb  h
    jnc  .ok
    lxi  h,maxfuelout
.ok:    
    shld rr
    jmp  mainloop    
;-----------------------------------------------------------------------
rr_down:
    call getshift
    lhld rr
    dcx  h
    jz   .check
    lxi  b,-9
    dad  b
.check:
    mov  a,h
    ora  a
    jp   rr_up.ok
    lxi  h,0
    jmp  rr_up.ok
;-----------------------------------------------------------------------
turn_r:
    call getshift
    lda  ax
    mvi  l,1
    jz   .ok
    mvi  l,5
.ok:
    add  l
    jp   .pos
    cpi  -90
    jp   .set
    adi  180
    jmp  .set
.pos:        
    cpi  90
    jm   .set
    sui  180
.set:    
    sta  ax
    call a2w
    dad  h
    call w2d
    shld aa
    xchg
    shld aa+2
    jmp  mainloop       
;-----------------------------------------------------------------------
turn_l:
    call getshift
    lda  ax
    mvi  l,-1
    jz   turn_r.ok
    mvi  l,-5
    jmp  turn_r.ok
;-----------------------------------------------------------------------
engine:
    call getshift
    sta  en
    jmp  mainloop
;-----------------------------------------------------------------------
include "hud.inc" 
include "fizika.inc"
include "math.inc"  
include "misc.inc" 
;-----------------------------------------------------------------------
;pi: dw 355,113
;-----------------------------------------------------------------------
dl: dw 0
;-----------------------------------------------------------------------
vf: dd 3300 ;    / [(/)/10] 
mm: dd 25000;    x 10 ( mm + ff < 65536 ! )
ff: dd 30000;    x 10
;-----------------------------------------------------------------------
g:  dd -16  ; g /*
rr: dd 0    ;   / x 10
vh: dd 0    ;   /
vv: dd 0    ;   /
hh: dd 0    ;  
;-----------------------------------------------------------------------
va: dd 0    ;   /
xx: dd 0    ;  
aa: dd 0    ;    ()
ax: db 0    ; aa / 2
en: db 0    ;  /
;-----------------------------------------------------------------------
en.msg: dw en.off
en.on:  dr "[  ]",0
en.off: dr "[ --- ]",0
;-----------------------------------------------------------------------
buff: rb 31
.x:   db 0    
;-----------------------------------------------------------------------
RKS_END
;=======================================================================

