;=======================================================================
;   extra opcodes for 8080/8085 as commands combinations
;=======================================================================
;include "warn.inc"
;-----------------------------------------------------------------------
if ~ defined warn

    restore warn
    define warn 1

    macro warn msg*
            repeat 1 num:__LINE__
                    display __FILE__,' [',`num,']',13,10
            end repeat
            display 'Warning: ',msg,'.',13,10
    end macro 
    
end if
;-----------------------------------------------------------------------
;element register
;element B?   : register + 0000h  
;element C?   : register + 0FF1h
;element D?   : register + 0112h
;element E?   : register + 0FF3h
;element H?   : register + 0224h
;element L?   : register + 0FF5h
;element M?   : register + 0FF6h
;element A?   : register + 0FF7h
;element SP?  : register + 0F3Fh
;element PSW? : register + 03FFh
;;                          |||
;;                          ||\- any 8-bit register operation
;;                          |\-- any 16-bit operation, except push&pop
;;                          \--- push&pop operations 
;-----------------------------------------------------------------------
macro MOVX? r1,r2 ; r1h:r1l <- r2h:r2l
    reg16 dest,r1
    reg16 src,r2
    if dest = 3 | src = 3
       err "Bad register pair"
    else 
        db 040h or dest shl 4 or src shl 1
        db 040h or dest shl 4 or src shl 1 or 9
    end if
end macro    
;-----------------------------------------------------------------------
macro ADDX? r1,r2 ; r1h:r1l = r1h:r1l + r2h:r2l
    reg16 dest,r1
    reg16 src,r2
    if dest = 3 | src = 3
       err "Bad register pair"
    else 
        if dest = 2
            warn 'Usage of ADDX H,X (DAD possible)'
        end if
        db 040h or 7 shl 3 or dest shl 1 or 1 ; mov a,r1l
        db 080h or src shl 1 or 1             ; add r2l
        db 040h or dest shl 4 or 8 or 7       ; mov r1l,a
        db 040h or 7 shl 3 or dest shl 1      ; mov a,r1h
        db 088h or src shl 1                  ; adc r2h
        db 040h or dest shl 4 or 7            ; mov r1h,a
    end if
end macro    
;-----------------------------------------------------------------------
macro ADCX? r1,r2 ; r1h:r1l = r1h:r1l + r2h:r2l
    reg16 dest,r1
    reg16 src,r2
    if dest = 3 | src = 3
       err "Bad register pair"
    else 
        db 040h or 7 shl 3 or dest shl 1 or 1 ; mov a,r1l
        db 088h or src shl 1 or 1             ; adc r2l
        db 040h or dest shl 4 or 8 or 7       ; mov r1l,a
        db 040h or 7 shl 3 or dest shl 1      ; mov a,r1h
        db 088h or src shl 1                  ; adc r2h
        db 040h or dest shl 4 or 7            ; mov r1h,a
    end if
end macro    
;-----------------------------------------------------------------------
macro SUBX? r1,r2 ; r1h:r1l = r1h:r1l - r2h:r2l
    reg16 dest,r1
    reg16 src,r2
    if dest = 3 | src = 3
       err "Bad register pair"
    else 
        db 040h or 7 shl 3 or dest shl 1 or 1 ; mov a,r1l
        db 090h or src shl 1 or 1             ; sub r2l
        db 040h or dest shl 4 or 8 or 7       ; mov r1l,a
        db 040h or 7 shl 3 or dest shl 1      ; mov a,r1h
        db 098h or src shl 1                  ; sbb r2h
        db 040h or dest shl 4 or 7            ; mov r1h,a
    end if
end macro    
;-----------------------------------------------------------------------
macro SBBX? r1,r2 ; r1h:r1l = r1h:r1l - r2h:r2l
    reg16 dest,r1
    reg16 src,r2
    if dest = 3 | src = 3
       err "Bad register pair"
    else 
        db 040h or 7 shl 3 or dest shl 1 or 1 ; mov a,r1l
        db 098h or src shl 1 or 1             ; sbb r2l
        db 040h or dest shl 4 or 8 or 7       ; mov r1l,a
        db 040h or 7 shl 3 or dest shl 1      ; mov a,r1h
        db 098h or src shl 1                  ; sbb r2h
        db 040h or dest shl 4 or 7            ; mov r1h,a
    end if
end macro    
;-----------------------------------------------------------------------
macro RALX? r1 
    reg16 dest,r1
    if dest = 3 
       err "Bad register pair"
    else 
        if dest = 2
            warn "Usage of RALX H (DAD possible)"
        end if
        db 040h or 7 shl 3 or dest shl 1 or 1 ; mov a,r1l
        db 017h                               ; ral
        db 040h or dest shl 4 or 8 or 7       ; mov r1l,a
        db 040h or 7 shl 3 or dest shl 1      ; mov a,r1h
        db 017h                               ; ral
        db 040h or dest shl 4 or 7            ; mov r1h,a
    end if
end macro    
;-----------------------------------------------------------------------
macro RARX? r1 
    reg16 dest,r1
    if dest = 3 
       err "Bad register pair"
    else 
        db 040h or 7 shl 3 or dest shl 1      ; mov a,r1h
        db 01Fh                               ; rar
        db 040h or dest shl 4 or 7            ; mov r1h,a
        db 040h or 7 shl 3 or dest shl 1 or 1 ; mov a,r1l
        db 01Fh                               ; rar
        db 040h or dest shl 4 or 8 or 7       ; mov r1l,a
    end if
end macro    
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
macro PUSHX?
    push b
    push d
    push h
end macro
;-----------------------------------------------------------------------
macro POPX?
    pop  h
    pop  d
    pop  b
end macro
;-----------------------------------------------------------------------
macro PUSHA?
    push psw
    pushx
end macro
;-----------------------------------------------------------------------
macro POPA?
    popx
    pop  psw
end macro
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
macro SHLD32? addr ; DEHL -> addr 
    shld addr
    xchg
    shld addr+2
    xchg
end macro
macro LHLD32? addr ; DEHL <- addr 
    lhld addr+2
    xchg
    lhld addr
end macro
;-----------------------------------------------------------------------
