;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; Gurtovtsev & Gudymenko ISBN 5-339-00216-0
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;   HLDE / BC = DE (HL)
;   CY=0 -> result overflow
;-----------------------------------------------------------------------
proc gg_d32a ; 32
;-----------------------------------------------------------------------
    mov  a,l
    sub  c
    mov  a,h
    sbb  b
    rnc
    call negb
    xra  a
.loop:
    dad  h
    rar
    xchg
    dad  h
    xchg
    jnc  .m1
    inx  h
.m1:
    push h
    dad  b
    jnc  .m2
    ral
.m3:
    inx  d
    inx  sp
    inx  sp
    adi  16
    jnc  .loop
;    stc
    ret
.m2:
    ral
    jc   .m3
    pop  h
    adi  16
    jnc  .loop
;    stc
    ret 
;-----------------------------------------------------------------------
endp    
;-----------------------------------------------------------------------
proc negb
    mov  a,b
    cma
    mov  b,a
    mov  a,c
    cma
    mov  c,a
    inx  b
    ret
endp    
;-----------------------------------------------------------------------
proc negd
    mov  a,d
    cma
    mov  d,a
    mov  a,e
    cma
    mov  e,a
    inx  d
    ret
endp    
;-----------------------------------------------------------------------
proc negh
    mov  a,h
    cma
    mov  h,a
    mov  a,l
    cma
    mov  l,a
    inx  h
    ret
endp    
;-----------------------------------------------------------------------
neg_hl equ negh
neg_de equ negd
neg_bc equ negb
;-----------------------------------------------------------------------
;   HL / C = L (H)
;   DE = const
;   C  = const
;   CY = 1 -> result overflow
;-----------------------------------------------------------------------
proc gg_d16 ; 16
;-----------------------------------------------------------------------
    mov  a,h
    sub  c
    rnc
    mvi  b,8
.loop:
    dad  h
    mov  a,h
    jc   .m1
    sub  c
    jnc  .m2
    add  c
    mov  h,a
    jmp  .m3
.m1:
    sub  c
.m2:
    mov  h,a
    inx  h
.m3:
    dcr  b
    jnz  .loop
    stc
    ret
;-----------------------------------------------------------------------
endp    
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   HL = H * E
;   B,E:CONST
;-----------------------------------------------------------------------
umul88 equ gg_u88b1
;-----------------------------------------------------------------------
proc gg_u88b1 ; 881 
;-----------------------------------------------------------------------
    mvi  d,0
    mvi  l,0
    mvi  a,8
.loop:
    dad  h
    jnc  .skip
    dad  d
.skip:
    dcr  a
    jnz  .loop
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;=======================================================================
;    : DEHL = DEHL / BC ; BC = DEHL MOD BC 
;-----------------------------------------------------------------------
udiv32 equ gg_udiv3216
;-----------------------------------------------------------------------
proc gg_udiv3216
;-----------------------------------------------------------------------
    push h   
    lxi  h,0
    push b
    call gg_d32a
    pop  b
    xchg
    xthl
    xchg
    call gg_d32a
    mov  b,h
    mov  c,l
    pop  h
    xchg
	ret
;-----------------------------------------------------------------------
endp  
;-----------------------------------------------------------------------
