;-----------------------------------------------------------------------
;   DEHL - dword (signed)
;   BC --> end of the text buffer
;   A  --> dp position (0 ignored)
;   return:
;   HL --> start of the number string
;-----------------------------------------------------------------------
proc dword2idec_dp
;-----------------------------------------------------------------------
    push d
    push psw
    mov  a,d
    ora  a
    cm   neg_dehl
    pop  psw
    call dword2dec_dp
    pop  d
    mov  a,d
    ora  a
    rp
    dcx  h
    mvi  m,"-"
    ret
;-----------------------------------------------------------------------
endp    
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   DEHL - dword (signed)
;   BC --> end of the text buffer
;   return:
;   HL --> start of the number string
;-----------------------------------------------------------------------
proc dword2idec
;-----------------------------------------------------------------------
    mov  a,d
    ora  a
    push psw
    cm   neg_dehl
    call dword2dec
    pop  psw
    rp
    dcx  h
    mvi  m,"-"
    ret
;-----------------------------------------------------------------------
endp    
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   DEHL - dword 
;   BC --> end of the text buffer
;   return:
;   HL --> start of the number string
;-----------------------------------------------------------------------
proc dword2dec
;-----------------------------------------------------------------------
    xra  a
    stax b
    push b
    mvi  c,10
.loop:
    call dword_div_byte
    adi  30h
    xthl
    dcx  h
    mov  m,a
    xthl
    mov  a,h
    ora  l
    ora  d
    ora  e
    jnz  .loop
    pop  h
    ret
;-----------------------------------------------------------------------
endp    
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   DEHL - dword 
;   BC --> end of the text buffer
;   A  --> dp position (0 ignored)
;   return:
;   HL --> start of the number string
;-----------------------------------------------------------------------
proc dword2dec_dp
;-----------------------------------------------------------------------
    ora  a
    jz   dword2dec
;-----------------------------------------------------------------------
    push psw
    push b
    call dword2dec
    pop  d
    pop  b
;-----------------------------------------------------------------------
    dcx  d
    mov  a,e
    sub  b
    mov  e,a
    mov  a,d
    sbi  0
    mov  d,a
;-----------------------------------------------------------------------
    mov  a,l
    sub  e
    mov  c,a
    mov  a,h
    sbb  d
    jm   .forward
    ora  c
    jz   .forward
;-----------------------------------------------------------------------
.m3:
    dcx  h
    dcr  c
    jz   .m2
    mvi  m,"0"
    jmp  .m3
.m2:
    mvi  m,"."
    dcx  h
    mvi  m,"0"
    ret    
;-----------------------------------------------------------------------
.forward:
    mov  d,h
    mov  e,l
    dcr  c
    dcx  d
    push d
.m1:
    mov  a,m
    stax d
    inr  c
    inx  h
    inx  d
    jnz  .m1
    dcx  h
    mvi  m,"."
    pop  h
    ret 
;-----------------------------------------------------------------------
endp    
;-----------------------------------------------------------------------
;
;=======================================================================
;   DEHL = HL << A
;-----------------------------------------------------------------------
proc shl_hl_a
;-----------------------------------------------------------------------
    lxi  d,0
    cpi  32
    jnc  .zero_hl
    push psw
    ani  7
    jz   .move
    mov  d,a
    xra  a
.loop:
    dad  h
    ral
    dcr  d
    jnz  .loop
    mov  e,a
.move:    
    pop  psw
    ani  18h
    rar
    rar
    rar
    rar
    jnc  .next  
    mov  d,e
    mov  e,h
    mov  h,l
    mvi  l,0
.next:
    rar
    rnc
    xchg    
.zero_hl:
    lxi  h,0
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;-----------------------------------------------------------------------
;   DEHL - dword 
;   BC --> end of the text buffer
;   A  = dp position
;   [SP] --> field width (high byte)
;   return:
;   HL --> start of the number string
;-----------------------------------------------------------------------
proc dword2field_dp
;-----------------------------------------------------------------------
    push b
    call dword2dec_dp
    pop  b
    mov  a,c
    sub  l
    mov  c,a
    xchg
    pop  h
    xthl
    xchg
    mov  a,d
    sub  c
    rc
    mov  c,a
    mvi  a," "
.loop:
    rz
    dcx  h
    mov  m,a
    dcr  c
    jmp  .loop
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   DEHL - dword 
;   BC --> end of the text buffer
;   A  - field width
;   return:
;   HL --> start of the number string
;-----------------------------------------------------------------------
proc dword2field
;-----------------------------------------------------------------------
    push psw
    push b
    call dword2dec
    pop  b
    mov  a,c
    sub  l
    mov  c,a
    pop  psw
    sub  c
    rc
    mov  c,a
    mvi  a," "
.loop:
    rz
    dcx  h
    mov  m,a
    dcr  c
    jmp  .loop
;-----------------------------------------------------------------------
endp
;=======================================================================
;=======================================================================
proc word_div_byte ; DE/C = DE (H) : C = CONST
;-----------------------------------------------------------------------
    mvi  h,0
    mov  l,d
    call gg_d16
    mov  d,l
    mov  l,e
    call gg_d16
    mov  e,l
    ret    
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
proc dword_div_byte ; DEHL/C = DEHL (A) : C = CONST
;-----------------------------------------------------------------------
    push h
    mvi  h,0
    mov  l,d
    call gg_d16
    mov  d,l
    mov  l,e
    call gg_d16
    mov  e,l
    xchg
    xthl
    xchg
    mov  l,d
    call gg_d16
    mov  d,l
    mov  l,e
    call gg_d16
    mov  e,l
    mov  a,h
    xchg
    pop  d
    ret
;-----------------------------------------------------------------------
endp    
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;proc pusha
;-----------------------------------------------------------------------
;    push psw
;    push b
;    push d
;    push h
;    push h
;    push psw
;    lxi  h,12
;    dad  sp
;    mov  a,m
;    inx  h
;    mov  h,m
;    mov  l,a
;    pop  psw
;    xthl
;	ret
;-----------------------------------------------------------------------
;endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;proc popa
;-----------------------------------------------------------------------
;    pop  b
;    lxi  h,8
;    dad  sp
;    mov  m,c
;    inx  h
;    mov  m,b
;    pop  h
;    pop  d
;    pop  b
;    pop  psw
;	ret
;-----------------------------------------------------------------------
;endp
;-----------------------------------------------------------------------
