;=======================================================================
include "proc.inc"
include "numio.inc"
include "sincos.inc"
include "roots.inc"
include "multibyte.inc"
include "legacy.inc"
include "gg.inc"
;=======================================================================
;    : DEHL = HL * BC ()
;-----------------------------------------------------------------------
proc umul  
;-----------------------------------------------------------------------
    lxi  d,0
    mvi  a,16
umx1: 
    dad  h
    xchg
    jnc  umx3
    dad  h
    jnc  umx2
    inx  d
umx2: 
    dad  b
    jnc  umx4
    inx  d
    jmp  umx4
umx3: 
    dad  h
    jnc  umx4
    inx  d
umx4: 
    xchg
    dcr  a
    jnz  umx1
    xchg
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;    : DEHL = DEHL / BC ; BC = DEHL MOD BC
;-----------------------------------------------------------------------
proc udiv  
;-----------------------------------------------------------------------
    xchg
    push h
    lxi  h,0
    mvi  a,33
umd1: 
    dcr  a
    jz   umd6
    xchg
    dad  h
    xchg
    ral
    xthl
    dad  h
    rar
    jnc  umd2
    inx  h
umd2: 
    xthl
    dad  h
    ral
    jnc  umd3
    inx  h
umd3: 
    ora  a
    rar
    push h
    push psw
    mov  a,l
    sub  c
    mov  l,a
    mov  a,h
    sbb  b
    mov  h,a
    jnc  umd4
    pop  psw
    jc   umd5
    pop  h
    jmp  umd1
umd4: 
    pop  psw
umd5: 
    inx  sp
    inx  sp
    inx  d
    jmp  umd1
umd6: 
    xchg
    mov b,d
    mov c,e
    pop d
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   HL [A] = HL/10  ( DE = HL )
;-----------------------------------------------------------------------
proc udiv10
;-----------------------------------------------------------------------
    ora  a
    mov  a,h
    rar   
    mov  b,a
    mov  a,l
    rar
    mov  c,a ; bc = n >> 1
    ora  a
    mov  a,b
    rar
    mov  d,a
    mov  a,c
    rar
    add  c
    mov  e,a
    mov  c,a
    mov  a,d
    adc  b
    mov  b,a
    mov  d,a       ; bc = de = (hl>>1)+(hl>>2) = q
    xchg           ; de = n ; bc = hl = q
    xra  a
    call shr_hl.s4 ; hl = q >> 4 
    dad  b         ; hl = q = q + (q>>4)
    mov  c,h
    mvi  b,0
    dad  b         ; hl = q = q + (q>>8)
    xra  a
    call shr_hl.s3 ; hl = q = q >> 3
    mov  b,h
    mov  c,l       ; bc = q
    dad  h
    dad  h
    dad  b
    dad  h         ; hl = q*10
    mov  a,e
    sub  l
    adi  6
    rar
    rar
    rar
    rar
    ani  15        ; a = (r+6)>>4
    add  c
    mov  l,a
    mov  a,b
    aci  0
    mov  h,a       ; hl = q + ((r+6)>>4) = n/10
    mov  a,l
    add  a
    add  a
    add  l
    add  a         ; a = l*10
    sub  e
    cma 
    inr  a         ; a = e - l*10 (remainder)
	ret
;-----------------------------------------------------------------------
.dummy = shr_hl	
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   A MUST BE 0 !
;-----------------------------------------------------------------------
proc shr_hl
;-----------------------------------------------------------------------
.s1:dad  h
    ral
.s2:dad  h
    ral
.s3:dad  h
    ral
.s4:dad  h
    ral
.s5:dad  h
    ral
.s6:dad  h
    ral
.s7:dad  h
    ral
    mov  l,h
    mov  h,a
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   A -> HL ()
;-----------------------------------------------------------------------
proc a2w          
;-----------------------------------------------------------------------
    mov l,a
    mvi h,0
    ora a
    rp
    dcr h
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   L -> HL ()
;-----------------------------------------------------------------------
proc b2w          
;-----------------------------------------------------------------------
    mvi h,0
    mov a,l
    ora a
    rp
    dcr h
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   HL -> DEHL ()
;-----------------------------------------------------------------------
proc w2d  
;-----------------------------------------------------------------------
    lxi d,0
    mov a,h
    ora a
    rp
    dcx d
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   L -> DEHL ()
;-----------------------------------------------------------------------
proc b2d  
;-----------------------------------------------------------------------
    lxi d,0
    mov h,e
    mov a,l
    ora a
    rp
    dcr h
    dcx d
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   A -> DEHL ()
;-----------------------------------------------------------------------
proc a2d  
;-----------------------------------------------------------------------
    lxi d,0
    mov h,e
    mov l,a
    ora a
    rp
    dcr h
    dcx d
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   DEHL = DEHL*10
;-----------------------------------------------------------------------
proc mul10
;-----------------------------------------------------------------------
    push b
    call shl_dehl
    push h
    push d
    call shl_dehl
    call shl_dehl
    xchg
    pop b
    dad b
    xchg
    pop b
    dad b
    pop b
    rnc
    inx d
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   DEHL << 1
;-----------------------------------------------------------------------
proc shl_dehl
;-----------------------------------------------------------------------
    xchg
    dad h
    xchg
    dad h
    rnc
    inx d
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   DEHL = |DEHL|
;-----------------------------------------------------------------------
proc abs_dehl
;-----------------------------------------------------------------------
    mov  a,d
    ora  a
    push psw
    cm   neg_dehl
    pop  psw
    ret    
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   DEHL = -DEHL
;-----------------------------------------------------------------------
proc neg_dehl
;-----------------------------------------------------------------------
    mov a,d
    cma
    mov d,a
    mov a,e
    cma
    mov e,a
    mov a,l
    cma
    mov l,a
    mov a,h
    cma
    mov h,a
    inx h
    rnc
    inx d
    ret
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   RND -> DEHL
;-----------------------------------------------------------------------
proc get_rnd
;-----------------------------------------------------------------------
    lda .cnt
    dcr a
    jnz .lfsr
    lhld rnd
    lxi b,64525
    call umul
    push h
    push d
    lhld rnd+2
    call umul
    pop b
    dad h
    xchg
    pop h
    lxi b,1013904223 shr 16
    xchg
    dad b
    xchg
    lxi b,1013904223 and 0FFFFh
    dad b
    jnc .m1
    inx d
.m1:
    shld rnd
    xchg
    shld rnd+2
    mvi a,31
;-----------------------------------------------------------------------
.lfsr:
    sta .cnt
    lhld rnd+2
    xchg
    lhld rnd
    mov a,l
    xri 57h
    mov l,a
    mov a,d
    xri 80h
    mov d,a
    xchg
    dad h
    xchg
    dad h
    jnc .m2
    inx d
.m2:
    ral
    jnc .m3
    inx h
.m3:
    shld rnd
    xchg
    shld rnd+2
    xchg
    ret
;-----------------------------------------------------------------------
.cnt:   db 31
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
rnd:    dd 1
;=======================================================================
;
;=======================================================================
proc set_rnd
;-----------------------------------------------------------------------
    shld rnd
    xchg
    shld rnd+2
    xchg
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   DEHL = DEHL << A
;-----------------------------------------------------------------------
proc shl_dehl_a
;-----------------------------------------------------------------------
    ora  a
    rz
    cpi  32
    jnc  .zero_dehl
    push psw
    ani  7
    inr  a
.loop:
    dcr  a
    jz   .move
    xchg
    dad  h
    xchg
    dad  h
    jnc  .loop
    inx  d
    jmp  .loop
.move:    
    pop  psw
    ani  18h
    rar
    rar
    rar
    rar
    jnc  .next  
    mov  d,e
    mov  e,h
    mov  h,l
    mvi  l,0
.next:
    rar
    rnc
    xchg    
    lxi  h,0
    ret
.zero_dehl:
    lxi  d,0
    lxi  h,0
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   DEHL = DEHL + [BC]
;-----------------------------------------------------------------------
proc add32
;-----------------------------------------------------------------------
    ldax b
    add  l
    mov  l,a
    inx  b
    ldax b
    adc  h
    mov  h,a
    inx  b
    ldax b
    adc  e
    mov  e,a
    inx  b
    ldax b
    adc  d
    mov  d,a
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   DEHLBC = DEHL * BC
;-----------------------------------------------------------------------
proc mul3216
;-----------------------------------------------------------------------
    push d
    call umul
    xthl
    push d
    call umul
    pop  b
    dad  b
    pop  b
    rnc
    inx  d
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   DEHL = DEHL * BC ; BC -> CONST
;-----------------------------------------------------------------------
proc mul3216p
;-----------------------------------------------------------------------
    push d
    call umul
    xthl
    push d
    call umul
    pop  d
    dad  d
    xchg
    pop  h
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   SHIFT DEHL RIGHT ARITHMETICAL 
;-----------------------------------------------------------------------
proc sar_dehl
    mov  a,d
    rlc
    rrc
    jmp  shr_dehl.shift
;-----------------------------------------------------------------------
.dummy = shr_dehl    
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   SHIFT DEHL RIGHT LOGICAL
;-----------------------------------------------------------------------
proc shr_dehl
;-----------------------------------------------------------------------
    ora  a
    mov  a,d
.shift:
    ral
    mov  d,a
    mov  a,e
    ral
    mov  e,a
    mov  a,h
    ral
    mov  h,a
    mov  a,l
    ral
    mov  l,a
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================

