;-----------------------------------------------------------------------
include "proc.inc"
;-----------------------------------------------------------------------
proc xhlx? ; call xhlx = call [hl]
;-----------------------------------------------------------------------
    pchl
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   HL: FIRST BYTE, E: COUNTER
;-----------------------------------------------------------------------
proc print_mbin 
;-----------------------------------------------------------------------
    mvi  d,0
    dad  d
.loop:
    dcx  h
    mov  a,m
    call print_bin
    mvi  c,32
    call 0C809h
    dcr  e
    jnz  .loop
    ret
;-----------------------------------------------------------------------
endp    
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   A --> 
;-----------------------------------------------------------------------
proc print_bin 
;-----------------------------------------------------------------------
    push b
    mvi  b,8
.loop:
    ral
    push psw
    mvi  a,"0"
    aci  0
    mov  c,a
    call 0C809h
    pop  psw
    dcr  b
    jnz  .loop
    pop  b
    ret
;-----------------------------------------------------------------------
endp    
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc read_buff
;-----------------------------------------------------------------------
    push h
    call 0C80Fh
    mvi  m,0
    pop  d
    xchg
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc crlf
;-----------------------------------------------------------------------
    mvi  c,10
    jmp  0C809h
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc print_ehl
;-----------------------------------------------------------------------
    mov  a,e
    call 0C815h
    call 0CC6Ch
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc print_dehl
;-----------------------------------------------------------------------
    xchg
    call 0CC6Ch
    xchg
    call 0CC6Ch
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc print_bc
;-----------------------------------------------------------------------
    push b
    xthl
    call 0CC6Ch
    pop  h
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc print_msg
;-----------------------------------------------------------------------
    xthl
    push psw
    push b
    push d
.next:
    mov  a,m
    inx  h
    ora  a
    jz   .done
    mov  c,a
    call 0C809h
    jmp  .next
.done:
    pop  d
    pop  b
    pop  psw
    xthl
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc getshift ; 0/1 --> shift pressed/not pressed
;-----------------------------------------------------------------------
    lda  0FF01h
    rrc
    ani  1
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc fill_buff ; HL -> buff, B - count, C - byte to fill
;-----------------------------------------------------------------------
    push b
    push h
.loop:
    mov  m,c
    inx  h
    dcr  b
    jnz  .loop
    pop  h
    pop  b
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
