;-----------------------------------------------------------------------
proc mmul10 ; HL^NUM B=BYTES -> HL^NUM*10 B=BYTES A=HIGHEST VALUE 
;-----------------------------------------------------------------------
    push d
    push h
    push b
    xra  a
.loop:
    push b
    mov  c,m
    xchg
    mvi  h,0
    mov  b,h
    mov  l,c
    dad  h
    dad  h
    dad  b
    dad  h
    pop  b
    xchg
    add  e
    mov  m,a
    mov  a,d
    aci  0
    inx  h
    dcr  b
    jnz  .loop
    pop  b
    pop  h
    pop  d
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mdiv10 ; HL^NUM B=BYTES -> HL^NUM/10 B=BYTES A=REMAINDER 
;-----------------------------------------------------------------------
    push b
    push d
    push h
;-----------------------------------------------------------------------
    mov  c,b
    mvi  b,0
    dad  b
    dcx  h
;-----------------------------------------------------------------------
    xchg
    mov  h,b
.loop:    
    ldax d
    mov  l,a
    push d
    push b
    call udiv10
    pop  b
    pop  d
    mov  h,a
    mov  a,l
    stax d
    dcx  d
    dcr  c
    jnz  .loop
    mov  a,h
    pop  h
    pop  d
    pop  b
	ret
;-----------------------------------------------------------------------
endp        
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mzero ; HL->NUM B=BYTES -> (A)
;-----------------------------------------------------------------------
    push h
    push b
    xra  a
.loop:
    ora  m
    jnz  .done
    inx  h
    dcr  b
    jnz  .loop
.done:
    pop  b
    pop  h
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mset ; HL-> NUM B=BYTES A=BYTE TO SET
;-----------------------------------------------------------------------
    push h
    push b
.loop:    
    mov  m,a
    inx  h
    dcr  b
    jnz  .loop
    pop  b
    pop  h
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mui2a ; HL-> NUM B=BYTES DE-> END OF STRING >> DE-> OUTPUT STRING
;-----------------------------------------------------------------------
;   NOTE: mui2a turns number to zero while conversion!
;-----------------------------------------------------------------------
    call mdiv10
    adi  "0"
    dcx  d
    stax d
    call mzero
    ora  a
    jnz  mui2a
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mi2a ; HL^NUM B=BYTES DE -> END OF STRING -> DE -> OUTPUT STRING
;-----------------------------------------------------------------------
;   NOTE: mui2a turns number to zero while conversion!
;-----------------------------------------------------------------------
    call mmod
    push psw
    call mui2a
    pop  psw
    rp
    dcx  d
    mvi  a,"-"
    stax d
	ret
endp
;-----------------------------------------------------------------------
proc mi2hex ; HL^NUM B=BYTES DE -> BUFFER
;-----------------------------------------------------------------------
    push d
    push d
    mov  e,b
    mvi  d,0
    dad  d
.loop:
    dcx  h
    mov  a,m
    call i2h
    xthl
    mov  m,b
    inx  h
    mov  m,c
    inx  h
    xthl
    dcr  e
    jnz  .loop
    pop  d
    xra  a
    stax d
    pop  d
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
a2im equ ma2i
;-----------------------------------------------------------------------
proc ma2i ; HL^NUM B=BYTES DE=INPUT STRING -> DE=END OF STRING
;-----------------------------------------------------------------------
    push h
    push b
    xra  a
.zero:
    mov  m,a
    inx  h
    dcr  b
    jnz  .zero
    pop  b
    pop  h
;-----------------------------------------------------------------------
    mov  c,a    
    ldax d
    inx  d
    cpi  "-"
    jz   .loop
    dcr  c
    cpi  "+"
    jz   .loop
    dcx  d
.loop:
    ldax d
    cpi  "0"
    jc   .done
    cpi  "9"+1
    jnc  .done
    call mmul10 ;   !
    ldax d
    sui  "0"
    call maddbyte  ;   ! CY=1: overflow!
    inx  d    
	jmp  .loop
.done:
    inr  c
    rz 
    call mneg
    ret	
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc maddbyte ; HL^NUM B=BYTES -> HL^NUM+A 
;-----------------------------------------------------------------------
    push h
    push b
    add  m
    mov  m,a
    jnc  .done  
.loop:
    inx  h
    dcr  b
    jz   .done
    mov  a,m
    aci  0
    mov  m,a
    jc   .loop
.done:    
    pop  b
    pop  h                       
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mcopy ; HL->NUM <- DE->NUM B=BYTES 
;-----------------------------------------------------------------------
    push d
    push h
    push b
.loop:    
    ldax d
    mov  m,a
    inx  h
    inx  d
    dcr  b
    jnz  .loop
    pop  b
    pop  h
    pop  d
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc madd ; [HL] = [HL] + [DE], B - bytes
;-----------------------------------------------------------------------
    push h
    ora  a
.loop:
    ldax d
    adc  m
    mov  m,a
    inx  h
    inx  d
    dcr  b
    jnz .loop
    pop  h
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc msub ; [HL] = [HL] - [DE], B - bytes
;-----------------------------------------------------------------------
    push h
    ora  a
.loop:
    mov  a,m
    xchg
    sbb  m
    xchg
    mov  m,a
    inx  h
    inx  d
    dcr  b
    jnz .loop
    pop  h
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc msubz ; [HL] = [HL] - [DE], B - bytes, C - zero if zero
;-----------------------------------------------------------------------
    push h
    mvi  c,0
    ora  a
.loop:
    mov  a,m
    xchg
    sbb  m
    xchg
    mov  m,a
    jz   .zero
    inr  c
.zero:    
    inx  h
    inx  d
    dcr  b
    jnz .loop
    pop  h
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc maddx ; [BC] = [HL] + [DE], A - bytes
;-----------------------------------------------------------------------
    push b
    push b
    mov  b,a
    ora  a
.loop:
    ldax d
    adc  m
    xthl
    mov  m,a
    inx  h
    xthl
    inx  h
    inx  d
    dcr  b
    jnz .loop
    pop  b
    pop  b
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc msubxz ; [BC] = [HL] - [DE], A - bytes -> A - zero if zero
;-----------------------------------------------------------------------
    push b
    mov  b,a
    mvi  c,0
    xchg
    ora  a
.loop:
    ldax d
    sbb  m
    xthl
    mov  m,a
    inx  h
    xthl
    jz   .zero
    inr  c
.zero:    
    inx  h
    inx  d
    dcr  b
    jnz .loop
    mov  a,c
    pop  b
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc msubx ; [BC] = [HL] - [DE], A - bytes 
;-----------------------------------------------------------------------
    push b
    mov  b,a
    xchg
    ora  a
.loop:
    ldax d
    sbb  m
    xthl
    mov  m,a
    inx  h
    xthl
    inx  h
    inx  d
    dcr  b
    jnz .loop
    pop  b
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc msubxd ; [DE] = [HL] - [BC], A - bytes
;-----------------------------------------------------------------------
    push b
    push h
    push d
    mov  d,a
    xchg
    ora  a
.loop:
    ldax b
    sbb  m
    xthl
    mov  m,a
    inx  h
    xthl
    inx  h
    inx  b
    dcr  d
    jnz .loop
    pop  d
    pop  h
    pop  b
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mmulb ; HL^NUM B=BYTES -> HL^NUM x A, B=BYTES, A=HIGHEST VALUE 
;-----------------------------------------------------------------------
    push d
    push b
    push h
    mov  e,a
    mvi  c,0
.loop:
    push h
    mov  h,m
    call umul88
    mov  a,l
    add  c
    mov  c,h
    pop  h
    mov  m,a
    mov  a,c
    aci  0
    mov  c,a
    inx  h
    dcr  b
    jnz  .loop
    pop  h
    pop  b
    pop  d
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   [BC] = [HL] x [DE] , A - BYTES , [BC] - A x 2 BYTES
;-----------------------------------------------------------------------
;   NOTE: mmul converts negative sources to positive!
;-----------------------------------------------------------------------
proc mmul
;-----------------------------------------------------------------------
    push b
    mov  b,a
    call mmod
    ral
    mov  a,b
    pop  b
    push psw
    xchg
    push b
    mov  b,a
    call mmod
    ral
    mov  a,b
    pop  b
    push psw
    call mumul
    mov  h,b
    mov  l,c
    mov  b,a
    pop  psw
    rar
    mov  c,a
    pop  psw
    rar
    xra  c
    ral
    cc   mneg
    mov  b,h
    mov  c,l  
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   [BC] = [HL] x [DE] , A - BYTES , [BC] - A x 2 BYTES
;-----------------------------------------------------------------------
proc mumul
;-----------------------------------------------------------------------
    push b
    push psw
;-----------------------------------------------------------------------
    push h
    push b
    mov  h,a
    add  a
    mov  l,a
    xra  a
.m3:
    stax b
    inx  b
    dcr  l
    jnz  .m3
    mov  a,h 
    pop  b
    pop  h
;-----------------------------------------------------------------------
.m2:           
    push d
    xchg
    mov  l,m 
    xchg
;-----------------------------------------------------------------------
    inr  e
    dcr  e
    jz   .m4
;-----------------------------------------------------------------------
    push b            
    push h
    push psw   
;-----------------------------------------------------------------------
    push h    
    lxi  h,11
    dad  sp
    mov  a,m  
    pop  h  
;-----------------------------------------------------------------------
.m1:            
    push psw  
    push h
    mov  h,m 
;-----------------------------------------------------------------------
    inx  b
    inr  h
    dcr  h
    jz   .m5
    dcx  b   
;-----------------------------------------------------------------------
    call umul88
    ldax b      
    add  l
    stax b
    inx  b
    ldax b
    adc  h
    stax b
    jnc  .m5
;-----------------------------------------------------------------------
    push b
.m6:
    inx  b
    ldax b
    aci  0
    stax b
    jc   .m6 
    pop  b
;-----------------------------------------------------------------------
.m5:
    pop  h
    inx  h
    pop  psw
    dcr  a
    jnz  .m1  
;-----------------------------------------------------------------------
    pop  psw
    pop  h
    pop  b
.m4:    
    pop  d
    inx  b
    inx  d
    dcr  a   
    jnz  .m2
;-----------------------------------------------------------------------
    pop  psw
    add  a
    pop  b
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   [HL] = -[HL], B - BYTES
;-----------------------------------------------------------------------
proc mneg
;-----------------------------------------------------------------------
    push h
    push b
    stc
.loop:    
    mov  a,m
    cma
    aci  0
    mov  m,a
    inx  h
    dcr  b
    jnz  .loop
    pop  b
    pop  h
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   [HL] << 1 B=BYTES
;-----------------------------------------------------------------------
proc mshl
;-----------------------------------------------------------------------
    ora  a
;-----------------------------------------------------------------------
.uses = mral
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mral ; CY <- [HL] <- CY , B=BYTES
;-----------------------------------------------------------------------
    push b
    push h
.loop:
    mov  a,m
    ral
    mov  m,a
    dcr  b
    inx  h
    jnz  .loop
    pop  h
    pop  b
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   [HL] >> 1 ARITHMETICAL
;-----------------------------------------------------------------------
proc msar
;-----------------------------------------------------------------------
	push b
	mov  c,b
	mvi  b,0
	dad  b
	dcx  h
    mov  a,m
    rlc
    jmp  mrar.msar
;-----------------------------------------------------------------------
.uses = mrar    
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;    [HL] >> 1 LOGICAL
;-----------------------------------------------------------------------
proc mshr
;-----------------------------------------------------------------------
    ora  a
;-----------------------------------------------------------------------
.use = mrar
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mrar
;-----------------------------------------------------------------------
    push b
    push psw
	mov  c,b
	mvi  b,0
	dad  b
	pop  psw
.loop:
	dcx  h
	mov  a,m
.msar:
	rar
	mov  m,a
	dcr  c
	jnz  .loop
	inx  h
	pop  b
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mmod ; HL -> NUM, B=BYTES >> HL -> NUM, A -> MSB
;-----------------------------------------------------------------------
    push h
    mov  c,b
    mvi  b,0
    dad  b
    dcx  h
    mov  a,m
    pop  h
    mov  b,c
    ora  a
    push psw
    cm   mneg
    pop  psw
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc malloc ; HL=size > DE->memblock in stack
;-----------------------------------------------------------------------
    movx d,h     ;
    call neg_hl  
    dad  sp
    sphl         ; | MEM RET 
    inx  sp
    inx  sp  
    push d       ; | SIZE MEM-2 RET
    xchg
    dad  sp
    mov  e,m
    inx  h
    mov  d,m     ; DE=RET | SIZE MEM
    lxi  h,2
    dad  sp
    xchg
    pchl
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mfree ; frees memblock after malloc
;-----------------------------------------------------------------------
    pop  d
    pop  h
    dad  sp
    sphl
    xchg
    pchl
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   NOTE: mdiv converts negative sources to positive!
;-----------------------------------------------------------------------
proc mdiv ; [HL] = [HL] / [BC], [DE] - REMAINDER, A - BYTES 
;-----------------------------------------------------------------------
    push b
    mov  b,a
    call mmod
    ral
    mov  a,b
    pop  b
    push psw
;-----------------------------------------------------------------------
    push h
    mov  h,b  
    mov  l,c  
    mov  b,a
    call mmod
    ral
    mov  a,b
    mov  b,h
    mov  c,l
    pop  h
    push psw
;-----------------------------------------------------------------------
    call mudiv
;-----------------------------------------------------------------------
    mov  b,a
    pop  psw
    rar
    mov  c,a
    pop  psw
    rar
    xra  c
    ral
    rnc
    call mneg
    xchg
    call mneg
    xchg
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mudiv   ; [HL] = [HL] / [BC], [DE] - REMAINDER, A - BYTES  
;-----------------------------------------------------------------------
    sta  .bytes
    shld .pa
    movx h,b
    shld .pb
    xchg
    shld .pr
    shld .px
    mov  b,a
    xra  a
    call mset
;-----------------------------------------------------------------------
    mov  l,b
    mov  h,a
    call malloc
    xchg 
    shld .py
;-----------------------------------------------------------------------
    lda  .bytes
    mov  c,a
    xra  a
    mov  b,a
    lhld .pa
    dad  b
    dcx  h
;-----------------------------------------------------------------------
.opt_loop:
    cmp  m 
    jnz  .opt_ok
    dcr  c
    jz   .pa_zero
    mov  d,h
    mov  e,l
    mov  b,c
    push h
.opt_shift:
    dcx  d
    ldax d
    mov  m,a
    dcx  h
    dcr  b
    jnz  .opt_shift
    xra  a
    mov  m,a
    pop  h
    jmp  .opt_loop  
.opt_ok:    
;-----------------------------------------------------------------------
    mov  l,c
    mov  h,a
    dad  h
    dad  h
    dad  h
    jmp  .start    
;-----------------------------------------------------------------------
.loop:
    lhld .count
    dcx  h
    mov  a,h
    ora  l
    jz   .done
.start:
    shld .count
    lda  .bytes ; px:pa << 1
    mov  b,a
    lhld .pa
    call mral
    lhld .px
    call mral 
;-----------------------------------------------------------------------
    xchg
    lhld .py
    call mcopy  ; py = px
;-----------------------------------------------------------------------
    xchg
    lhld .pb
    xchg
    call msub   ; py = py - pb  
    jc   .loop
;-----------------------------------------------------------------------
    lhld .px
    xchg
    lhld .py
    shld .px
    xchg
    shld .py    ; px = px - pb
    lhld .pa
    inr  m
    jmp  .loop
;-----------------------------------------------------------------------
.done:
    lhld .px
    xchg
    lhld .pr
    mov  a,l
    sub  e
    mov  l,a
    mov  a,h
    sbb  d
    ora  l
    lhld .pr
    cnz  mcopy
    call mfree
    lhld .pr
    xchg
    lhld .pb
    movx b,h
    lhld .pa   
    lda  .bytes     
    ret
;-----------------------------------------------------------------------
.pa_zero:
    call mfree
    lhld .pr
    lda  .bytes
    mov  b,a
    xra  a
    call mset
    xchg
    lhld .pa
    call mset
    lda  .bytes
    ret    
;-----------------------------------------------------------------------
;   !!! RAM AREA !!!
;-----------------------------------------------------------------------
.bytes: ds 1
.count: ds 2
.pa:    ds 2 ; HL
.pb:    ds 2 ; BC
.pr:    ds 2 ; DE - to restore
.px:    ds 2 ; DE
.py:    ds 2 ; TEMP
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mexpand ; [HL]->NUM, B=BYTES NEW, C=BYTES OLD
;-----------------------------------------------------------------------
    mov  a,b
    sub  c
    rz
    jnc  .ok
    mov  b,c ; OLD > NEW
    ret
.ok:
    push h
    push b
    mvi  b,0
    dad  b
    dcx  h
    mov  c,a
    mov  a,m
    ral
    mov  a,b
    sbb  b
.loop:
    inx  h
    mov  m,a
    dcr  c
    jnz  .loop                 
    pop  b
    pop  h
    ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc mushrink ; [HL]->NUM B=BYTES OLD >> B=BYTES NEW     
;-----------------------------------------------------------------------
    push h
    mov  c,b
    xra  a
    mov  b,a
    dad  b
    mov  b,c
.loop:
    dcx  h
    cmp  m
    jnz  .done
    dcr  b
    jnz  .loop
    inr  b
.done:
    pop  h
    ret    
;-----------------------------------------------------------------------
proc
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
proc malign ; [HL]->NUM1, [DE]->NUM2, B->BYTES [HL], C->BYTES [DE]
;-----------------------------------------------------------------------
    mov  a,b
    cmp  c
    rz
;-----------------------------------------------------------------------
    jc   .swap
    mov  b,c
    mov  c,a
    jmp  mexpand
;-----------------------------------------------------------------------
.swap:    
    xchg
    call mexpand
    xchg
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
            