;=======================================================================
;   HL -  , BC ->   (0)
;   : BC -> 
;-----------------------------------------------------------------------
proc ui2aw 
    push b
    call udiv10
    ori 30h
    pop b
    dcx b
    stax b
    mov a,l
    ora h
    rz
    jmp ui2aw  
;-----------------------------------------------------------------------
endp     
;=======================================================================
;
;=======================================================================
;   HL -  , BC ->   (0)
;   : BC -> 
;-----------------------------------------------------------------------
proc i2aw 
    mov  a,h
    ora  a
    jp   ui2aw
    call neg_hl
    call ui2aw
    dcx  b
    mvi  a,"-"
    stax b
    ret
endp    
;=======================================================================
;
;=======================================================================
;   DEHL -  , BC ->   (0)
;   : BC -> 
;-----------------------------------------------------------------------
proc ui2a 
;-----------------------------------------------------------------------
    push b
    lxi b,10
    call udiv
    mov a,c
    ori 30h
    pop b
    dcx b
    stax b
    mov a,l
    ora h
    ora e
    ora d
    rz
    jmp ui2a  
;-----------------------------------------------------------------------
endp     
;=======================================================================
;
;=======================================================================
;   DEHL -  , BC ->   (0)
;   : BC -> 
;-----------------------------------------------------------------------
proc i2a 
    mov  a,d
    ora  a
    jp   ui2a
    call neg_dehl
    call ui2a
    dcx  b
    mvi  a,"-"
    stax b
    ret
endp    
;=======================================================================
;
;=======================================================================
;   BC -> ; : DEHL - , BC ->   
;-----------------------------------------------------------------------
proc a2i 
;-----------------------------------------------------------------------
    lxi  d,0
    lxi  h,0
    xra  a
    push psw
.lead:
    ldax b
    cpi  "+"
    jz   .next
    cpi  "-"
    jnz  .start
    pop  psw
    cma
    push psw
.next:
    inx  b
    ldax b
.start:    
    sui  "0" 
    jm   .done   
    cpi  10
    jnc  .done
    push psw
    call mul10
    pop  psw
    add  l
    mov  l,a
    mov  a,h
    aci  0
    mov  h,a
    jnc  .next
    inx  d
    jmp  .next
.done:
    pop  psw
    ora  a
    rz
    call neg_dehl
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   A - , BC -  hex
;-----------------------------------------------------------------------
proc i2h 
;-----------------------------------------------------------------------
    mov b,a
    ani 15
    cpi 10
    jc  .m1
    adi 7
.m1:    
    adi 30h
    mov c,a
    mov a,b
    rrc
    rrc
    rrc
    rrc
    ani 15
    cpi 10
    jc  .m2
    adi 7
.m2:    
    adi 30h
    mov b,a
    ret
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   BC -> ; : DEHL - , BC ->   
;-----------------------------------------------------------------------
proc h2i
;-----------------------------------------------------------------------
    lxi h,0
    lxi d,0
.next:
    ldax b
    sui 30h
    rc
    cpi 10
    jc  .m1
    sui 7
    rc
    cpi 7
    rc
.m1:
    call shl_dehl
    call shl_dehl
    call shl_dehl
    call shl_dehl
    ora l
    mov l,a
    inx b                
    jmp .next
;-----------------------------------------------------------------------
endp    
;=======================================================================
;
;=======================================================================
;   HL --> text  start (buffer must have enough of space prior the text) 
;   B  --> field width
;   C  --> symbol to fill
;-----------------------------------------------------------------------
proc pad2field
;-----------------------------------------------------------------------
    push h
    dcx  h
    xra  a
    inr  b
.search:  
    inx  h
    dcr  b
    jz   .toomuch  
    cmp  m
    jnz  .search
.toomuch:    
    pop  h
    inr  b
.fill:
    dcr  b
    rz
    dcx  h
    mov  m,c
    jmp  .fill
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;    HL - start of the string [+/-][1..9](0)
;    at least one free byte must be available before start of the string
;    A - DP position   
;-----------------------------------------------------------------------
proc add_dp
;-----------------------------------------------------------------------
    ora a
    rz
    mov  e,a
    mov  a,m
    ora  a
    rz      
    inx  h
    cpi  "-"
    jz   .sign
    cpi  "+"
    jz   .sign
    dcx  h
.sign:
    push psw    
    mov  b,h
    mov  c,l
    xra  a
    mov  d,a
    cmp  m
    jz   .done 
.search:
    inx  h
    inr  d
    cmp  m
    jnz  .search
    mov  h,b
    mov  l,c
    mov  a,e
    sub  d
    jz   .point
    jp   .lead0
    mov  d,a
    dcx  h
    push h
.move:
    ldax b
    mov  m,a
    inx  b
    inx  h
    inr  d
    jnz  .move
    mvi  m,"."
    pop  h
    jmp  .done
.lead0:
    dcx  h
    mvi  m,"0"
    dcr  a
    jnz  .lead0    
.point:
    dcx  h
    mvi  m,"."
    dcx  h
    mvi  m,"0"
.done:
    pop  psw
    rnz
    dcx  h
    mov  m,a    
	ret
;-----------------------------------------------------------------------
endp
;=======================================================================
