;-----------------------------------------------------------------------
; B  = SQRT(HL) -- by b2m 
;-----------------------------------------------------------------------
proc sqrt	
;-----------------------------------------------------------------------
    lxi b,8
	lxi d,0
.m1:	
    call shl_dehl
	call shl_dehl
	push h
	mov a,b
	add a
	mov b,a
	cma
	mov l,a
	mvi h,0ffh
	dad h
	inx h
	dad d
	jnc .m2
	inr b
	xchg
.m2:	
    pop h
    dcr c
	jnz .m1
	ret
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;-----------------------------------------------------------------------
;   BC = SQRT(DEHL)
;   DEHL: CONST
;-----------------------------------------------------------------------
proc sqrt32
;-----------------------------------------------------------------------
    mvi  a,30 + 2
    push psw  
    lxi  b, 0 
    push d    
    push h    
;-----------------------------------------------------------------------
.loop:
    pop  h
    pop  d
    pop  psw
    sui  2  
    rm
;-----------------------------------------------------------------------
    push psw
    push d
    push h
    mov  l,c
    mov  h,b
    dad  h
    mov  c,l
    mov  b,h 
;-----------------------------------------------------------------------
    lxi  d,0
    dad  h
    inx  h   
;-----------------------------------------------------------------------
    inr  a
.shift:
    dcr  a
    jz   .skip
    xchg
    dad  h
    jc   .loop
    xchg
    dad  h
    jnc  .shift
    inx  d
    jmp  .shift    
.skip:        
;-----------------------------------------------------------------------
    push d
    push h
    lxi  h,4
    dad  sp
    xchg    
    lxi  h,0
    dad  sp 
;-----------------------------------------------------------------------
    ldax d
    sub  m
    mov  m,a
    inx  h
    inx  d
    ldax d
    sbb  m
    mov  m,a
    inx  h
    inx  d
    ldax d
    sbb  m
    mov  m,a
    inx  h
    inx  d
    ldax d
    sbb  m
    mov  m,a
;-----------------------------------------------------------------------
    pop  h
    pop  d
    jc   .loop
;-----------------------------------------------------------------------
    xthl
    pop  h
    xchg
    xthl
    push d
    inx  b
    jmp  .loop    
;-----------------------------------------------------------------------
endp
;-----------------------------------------------------------------------
;
;=======================================================================
;   E = CBRT(HL)
;-----------------------------------------------------------------------
proc cbrt
;-----------------------------------------------------------------------
    push h
    lxi  d,16 shl 8 
.loop:
    mov  a,e 
    add  e
    mov  e,a
    mov  h,e 
    inr  h   
    push d
    call umul88 
    pop  d
    push h
    pop  b
    dad  h 
    dad  b 
    inx  h 
    mov  a,d
    dcr  a
    jz   .ok
.shift:
    dad  h
    jc   .skip
    dcr  a
    jnz  .shift
.ok:    
    pop  b
    mov  a,c
    sub  l
    mov  l,a
    mov  a,b
    sbb  h
    jc   .endif
    mov  b,a
    mov  c,l
    inr  e
.endif:
    push b
.skip:
    mov  a,d
    sui  3
    mov  d,a
    jp   .loop            
    pop  b
    ret      
;-----------------------------------------------------------------------
endp
;=======================================================================
;
;=======================================================================
;   DEHL = SQRT([HL]) APPROX FOR > 32 BIT (VIA 32-BIT SQRT)
;-----------------------------------------------------------------------
proc sqrt64a
;-----------------------------------------------------------------------
    lxi  b,7
    dad  b
    mvi  b,4
    xra  a
.loop:
    cmp  m
    jnz  .ok
    dcx  h
    dcr  b
    jnz  .loop
.ok:
    push b
    mov  d,m
    dcx  h
    mov  e,m
    dcx  h
    mov  a,m
    dcx  h
    mov  l,m
    mov  h,a
    call sqrt32
    lxi  d,0
    mov  h,b
    mov  l,c
    pop  psw
    add  a
    rz
    add  a
    jmp  shl_dehl_a
;-----------------------------------------------------------------------
endp
;=======================================================================
