;=======================================================================
; HL = BC/cos(HL) HL - 
;-----------------------------------------------------------------------
proc divcos
    push b
    call quadrant
    mov a,e
    ani 1
    jz  .m1
    mov a,e
    xri 2
    mov e,a
.m1:    
    mvi a,90
    sub l
    mov l,a
    jmp divsin.cos
endp    
;=======================================================================
;
;=======================================================================
; HL = BC/sin(HL) HL - 
;-----------------------------------------------------------------------
proc divsin
    push b
    call quadrant
    mov a,l
.cos:
    ora a
    jz  .zero
    cpi 90
    jz  .one
    push d
    lxi b,sintab2
    dad h
    dad b
    mov a,m
    inx h
    mov h,m
    mov l,a
    pop d
    pop b
    push d
    call umul
    mov l,h
    mov h,e
    pop d
    mov a,e
    sui 2
    jc .m1
    inr d
.m1:
    mov a,d
    ora a
    rpe    
    mov a,h
    cma
    mov h,a
    mov a,l
    cma
    mov l,a
    inx h
    ret
;-----------------------------------------------------------------------
.one:
    pop h
    ret
;-----------------------------------------------------------------------
.zero:
    lxi h,-1
    lxi d,-1
    pop b
    stc
    ret  
endp
;-----------------------------------------------------------------------
proc sintab2    ; 256/sin(a)
    dw    -1,14668, 7335, 4891, 3670, 2937, 2449, 2101, 1839, 1636
    dw  1474, 1342, 1231, 1138, 1058,  989,  929,  876,  828,  786
    dw   748,  714,  683,  655,  629,  606,  584,  564,  545,  528
    dw   512,  497,  483,  470,  458,  446,  436,  425,  416,  407
    dw   398,  390,  383,  375,  369,  362,  356,  350,  344,  339
    dw   334,  329,  325,  321,  316,  313,  309,  305,  302,  299
    dw   296,  293,  290,  287,  285,  282,  280,  278,  276,  274
    dw   272,  271,  269,  268,  266,  265,  264,  263,  262,  261
    dw   260,  259,  259,  258,  257,  257,  257,  256,  256,  256
endp    
;=======================================================================
;
;=======================================================================
; HL = cos(HL)*BC HL - 
;-----------------------------------------------------------------------
proc mulcos
    push b
    call quadrant
    mov a,e
    ani 1
    jz  .m1
    mov a,e
    xri 2
    mov e,a
.m1:    
    mvi a,90
    sub l
    mov l,a
    jmp mulsin.cos
endp    
;=======================================================================
;
;=======================================================================
; HL = sin(HL)*BC HL - 
;-----------------------------------------------------------------------
proc mulsin
    push b
    call quadrant
    mov a,l
.cos:    
    ora a
    jz  .zero
    cpi 90
    jz  .one
    push d
    lxi b,sintab
    dad h
    dad b
    mov a,m
    inx h
    mov h,m
    mov l,a
    pop d
    pop b
    push d
    call umul
    xchg
    pop d
    mov a,e
    sui 2
    jc .m1
    inr d
.m1:
    mov a,d
    ora a
    rpe    
    mov a,h
    cma
    mov h,a
    mov a,l
    cma
    mov l,a
    inx h
    ret
;-----------------------------------------------------------------------
.one:
    pop h
    ret
;-----------------------------------------------------------------------
.zero:
    mov h,a
    pop b
    ret  
endp      
;-----------------------------------------------------------------------
proc sintab     ; 65536*sin(a)
    dw     0, 1144, 2287, 3430, 4572, 5712, 6850, 7987, 9121,10252
    dw 11380,12505,13626,14742,15855,16962,18064,19161,20252,21336
    dw 22415,23486,24550,25607,26656,27697,28729,29753,30767,31772
    dw 32768,33754,34729,35693,36647,37590,38521,39441,40348,41243
    dw 42126,42995,43852,44695,45525,46341,47143,47930,48703,49461
    dw 50203,50931,51643,52339,53020,53684,54332,54963,55578,56175
    dw 56756,57319,57865,58393,58903,59396,59870,60326,60764,61183
    dw 61584,61966,62328,62672,62997,63303,63589,63856,64104,64332
    dw 64540,64729,64898,65048,65177,65287,65376,65446,65496,65526
endp    
;=======================================================================
;
;=======================================================================
proc quadrant
    lxi d,0
    mov a,h
    ora a
    jp  .m1
    inr d       ;  
    cma  
    mov h,a
    mov a,l
    cma
    mov l,a
    inx h
.m1:    
    mov a,l
    sui 67h
    mov a,h
    sbi 1
    jc  .m2
    push d
    lxi b,360   ;     360 
    lxi d,0
    call udiv
    mov l,c
    mov h,b
    pop d
.m2:
    dcr h
    mov a,l
    jnz .m255   ;   256 
    cpi 14
    jc  .m3     ;  256-270 
    mvi a,68h   ;  270-360 
    sub l
    mov l,a
    mvi e,3
    ret            
.m255:
    inr h
    cpi 180
    jnc .m3
    cpi 90
    rc
    mvi a,180
    sub l
    mov l,a
    mvi e,1
    ret
.m3:
    sui 180
    mov l,a
    mvi e,2
    ret    
endp    
;=======================================================================
