;=======================================================================
include "8085.inc"
include "extra85.inc"
include "rks.inc"
include "win2koi7.inc"
include "spec.inc"
;-----------------------------------------------------------------------
RKS_START 
;-----------------------------------------------------------------------
bytes = 8
;-----------------------------------------------------------------------
    lxi  h,hello
    call print
;-----------------------------------------------------------------------
loop:
;-----------------------------------------------------------------------
    call print_msg
    dr   10,"  : ",0
    lxi  h,m64.a
    call input64
;-----------------------------------------------------------------------
    call print_msg
    dr   10,"  : ",0
    lxi  h,m64.b
    call input64
;-----------------------------------------------------------------------
    call crlf
    lxi  h,m64.a
    call output64 
    call print   
;-----------------------------------------------------------------------
;    call crlf   
;    lxi  h,m64.a
;    call output64hex 
;    call print   
;-----------------------------------------------------------------------
    call crlf
    lxi  h,m64.b
    call output64 
    call print   
;-----------------------------------------------------------------------
;    call crlf   
;    lxi  h,m64.b
;    call output64hex 
;    call print   
;-----------------------------------------------------------------------
    lxi  h,m64.a
    lxi  d,m64.b
    lxi  b,m64.x
    mvi  a,bytes
    call maddx    
;-----------------------------------------------------------------------
    call print_msg
    dr   10,"+ : ",0
    lxi  h,m64.x
    call output64 
    call print   
;-----------------------------------------------------------------------
    lxi  h,m64.a
    lxi  d,m64.b
    lxi  b,m64.y
    mvi  a,bytes
    call msubx    
;-----------------------------------------------------------------------
    call print_msg
    dr   10,"- : ",0
    lxi  h,m64.y
    call output64 
    call print
;-----------------------------------------------------------------------
    lxi  d,m64.a
    lxi  h,m64.x
    mvi  b,bytes
    call mcopy
;-----------------------------------------------------------------------
    lxi  d,m64.b
    lxi  h,m64.y
    mvi  b,bytes
    call mcopy
;-----------------------------------------------------------------------
    lxi  h,m64.x
    lxi  b,m64.y
    lxi  d,m64.z
    mvi  a,bytes
    call mdiv 
;-----------------------------------------------------------------------
    call print_msg
    dr   10,"/ : ",0
    lxi  h,m64.x
    call output64 
    call print
;-----------------------------------------------------------------------
    call print_msg
    dr   10,"M : ",0
    lxi  h,m64.z
    call output64 
    call print
;-----------------------------------------------------------------------
    lxi  h,m64.a
    lxi  d,m64.b
    lxi  b,m64.x
    mvi  a,bytes
    call mmul 
;-----------------------------------------------------------------------
    call print_msg
    dr   10,"* : ",0
    lxi  h,m64.x
    mvi  b,bytes * 2
    call output 
    call print
;-----------------------------------------------------------------------
;    call crlf   
;    lxi  h,m64.x
;    mvi  b,bytes * 2
;    call output_hex 
;    call print 
;-----------------------------------------------------------------------
    jmp  loop
;-----------------------------------------------------------------------
in_buff:
    lxi  h,buff
    lxi  d,buff.x
    jmp  read_buff  
;-----------------------------------------------------------------------
input64:
    push h
    call in_buff
    xchg
    pop  h
    mvi  b,bytes
    jmp  ma2i
;-----------------------------------------------------------------------
output64:
    mvi  b,bytes
output:    
    xchg
    lxi  h,pp
    call mcopy
    xra  a
    lxi  d,buff.x
    stax d
    call mi2a
    xchg
    ret
;-----------------------------------------------------------------------
output64hex:
    mvi  b,bytes
output_hex:    
    lxi  d,buff
    call mi2hex
    xchg
    ret
;-----------------------------------------------------------------------
include "misc.inc"
include "math.inc"    
;-----------------------------------------------------------------------
test_num dq -1,-1
;-----------------------------------------------------------------------
hello:
    dr 10,"   ",10,0
;-----------------------------------------------------------------------
RKS_END
;=======================================================================
;
;=======================================================================
m64:
;-----------------------------------------------------------------------
.a:     ds bytes
.b:     ds bytes
.x:     ds bytes
.y:     ds bytes
.z:     ds bytes
;-----------------------------------------------------------------------
pp:     ds bytes*2
;-----------------------------------------------------------------------
buff:   ds 256
.x:     ds 1
;=======================================================================

