#include <htc.h>

#include "tft9163.h"
#include "text.h"
#include "keyb.h"
#include "menu.h"


const char *ic_data;
const char *ic_name;


int max_height;   //     
int col_width;    //     
int start_y;      //     

//   
const MENU *stk[6];
signed char curr[6];


#define GET_START_Y(m, y)   if (m->flags & MENU_SINGLECOL) \
                            {                                \
                                y = start_y + ((tft_GetScreenHeight() - (m->count * txt_GetFontHeight())) >> 1); \
                            } else { \
                                y = start_y; \
                            }


void mnu_Show(const MENU *mnu)
{
    int i, sy, sx, x, y;

    GET_START_Y(mnu, sy);
    sx = 0;
    y = sy;
    tft_Color(MENU_FOREGROUND, MENU_BACKGROUND);
    tft_FillScreen();
    for (i = 0; i < mnu->count; i++)
    {
        x = (col_width - txt_GetStringLength(mnu->text[i])) >> 1;
        txt_DrawString(sx+x, y, mnu->text[i]);
        y += txt_GetFontHeight();
        if (y >= max_height)
        {
            y = sy;
            sx += col_width;
            if (sx >= tft_GetScreenWidth())
                break;
        }
    }
}

void mnu_Select(const MENU *mnu, char cur, char sel)
{
    int sx, sy;

    GET_START_Y(mnu, sy);
    sy += (cur * txt_GetFontHeight());
    if (sel)
    {
        tft_Color(MENU_FORESEL, MENU_BACKSEL);
    } else {
        tft_Color(MENU_FOREGROUND, MENU_BACKGROUND);
    }
    sx = (col_width - txt_GetStringLength(mnu->text[cur])) >> 1;

    if (!(mnu->flags & MENU_SINGLECOL))
    {
        sx += (sy / max_height)* col_width;
    }
    txt_DrawString(sx, sy % max_height, mnu->text[cur]);
}



void mnu_Run(const MENU *mnu)
{
    char c;
    signed char incr;
    char curstk = 0;

    stk[curstk] = mnu;
    curr[curstk] = 0;

    while(-1)
    {
        //   
        max_height = tft_GetScreenHeight() - (tft_GetScreenHeight() % txt_GetFontHeight());
        start_y = (tft_GetScreenHeight() - max_height) >> 1;
        if (mnu->flags & MENU_SINGLECOL)
        {
            col_width = tft_GetScreenWidth();
        } else {
            c = ((mnu->count-1) * txt_GetFontHeight()) / max_height + 1;
            if (c <= 1)
                c++;
            col_width = tft_GetScreenWidth() / c;
        }

        mnu_Show(mnu);
        mnu_Select(mnu, curr[curstk], 1);
        //   
        while (-1)
        {
            c = key_Get();
            if (c == KEY_ENTER)
            {
                if (!mnu->next[curr[curstk]])
                {
                    //   . 
                    if (curstk > 0)
                    {
                        curstk--;
                        mnu = stk[curstk];
                    }
                } else if (mnu->flags & MENU_ENDLVL)
                {
                    //        
                    ic_data = (const char *) mnu->next[curr[curstk]];
                    ic_name = mnu->text[curr[curstk]];
                    return;
                } else {
                    //    
                    mnu = mnu->next[curr[curstk]];
                    curstk++;
                    stk[curstk] = mnu;
                    curr[curstk] = 0;
                }
                break;

            } else {
                mnu_Select(mnu, curr[curstk], 0);
                switch (c)
                {
                    case KEY_LEFT:  { incr = -(max_height/txt_GetFontHeight()); break; }
                    case KEY_RIGHT: { incr = max_height/txt_GetFontHeight(); break; }
                    case KEY_UP:    { incr = -1; break; }
                    case KEY_DOWN:  { incr = 1; break; }
                    default: { break; }
                }
                curr[curstk] += incr;
                if (curr[curstk] < 0)
                    curr[curstk] = 0;
                else if (curr[curstk] > mnu->count-1)
                    curr[curstk] = mnu->count-1;
                mnu_Select(mnu, curr[curstk], 1);
            }
        } // while keyboard
    }
}





