#ifdef DEBUG

#include <stdio.h>
#include <stdarg.h>

static FILE *log = NULL;

void dbg_LogFile(const char *filename)
{
    if (log)
        fclose(log);
    log = fopen(filename,"wt");
}

void dbg_LogWrite(const char *fmt, ...)
{
    va_list argptr;

    va_start(argptr, fmt);
    if (log)
    {
        vfprintf(log, fmt, argptr);
        fflush(log);
    } else
        vfprintf(stderr, fmt, argptr);
    va_end(argptr);
}

#else

void dbg_LogFile(const char *filename)  {}
void dbg_LogWrite(const char *fmt, ...) {}

#endif
