;mem map
C0 = $03
A0 = $1C
A1 = $1D
A2 = $1E
A3 = $1F
B0 = $20
B1 = $30
;table in ram
B2 = $70
B3 = $80
;$90 - code and stack
C1 = -75
C2 = -50
C3 = -25

        ORG 0
START:
        LD SP,C1*256
        EI
;CLS
        LD BC,$2FF
        LD DE,$5801
        LD HL,$5800
        LD (HL),$44
        LDIR
;random fill
        LD DE,$4000
        LD HL,(TICK50Hz)
        LD BC,(FRAME)
        ADD HL,BC
        ADD HL,HL
        LD BC,$1021
LIFE_RND:
        LD A,L
        XOR C
        LD L,A
        LD A,H
        XOR B
        LD H,A
LIFE_RND_1:
        ADD HL,HL
        JP C,LIFE_RND
        ADD L
        LD (DE),A
        INC DE
        LD A,$58
        CP A,D
        JP NZ,LIFE_RND_1
        JP MAIN
        
        ORG $38
TICK_INT:
        LD (RET_HL+1),HL
        POP HL
        LD (RET_PC+1),HL
        LD (RET_SP+1),SP
        PUSH DE
        LD SP,INT_SP
        PUSH AF
        PUSH HL
        LD HL,(TICK50Hz)
        INC HL
        LD (TICK50Hz),HL
        POP HL
        POP AF
        JP INT_EXIT

       ORG $9000

INT_EXIT:
RET_SP: LD SP,0
RET_HL: LD HL,0
        EI
RET_PC: JP 0

TICK50Hz: DEFW 0
FRAME: DEFW 0
COLOR: DEFW $444D
LIFE_SP: DEFW 0
;pointers to line
LIFE_PB: DEFW 0 
LIFE_PC: DEFW 0
LIFE_PD: DEFW 0
LIFE_PE: DEFW 0
;buf on 20 frames for calc 1/FPS in ms
TICK: DEFW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PTICK: DEFW TICK


        DEFW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;stack for interrupt
INT_SP: DEFW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;and buf read
;buf for 4 line
LIFE_C: DEFB 0
LIFE_B: DEFB 0
LIFE_E: DEFB 0
LIFE_D: DEFB 0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        DEFB 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

STR_1_FPS = $5801 ; 1/FPS
STR_FRAME = $58C1 ; frame
STR_20_ms = $5981 ; time in 20 ms unit

MAIN:
;create torus
        LD A,$58
        LD DE,$4000
;for each line
;copy pixel 8-15 to 248-255
;copy pixel 240-247 to 0-7
LIFE_TOR:
        LD HL,$1E
        ADD HL,DE
        LDI
        EX DE,HL
        LDI
        CP D
        JP NZ,LIFE_TOR
;copy line 1 to line 191
;copy line 190 to line 0
        LD BC,32
        LD DE,$4000
        LD HL,$56E0
        LDIR
        LD BC,32
        LD DE,$57E0
        LD HL,$4100
        LDIR

        CALL LIFE_STEP
;calc 1/fps in ms and print
        LD HL,(PTICK)
        LD DE,(TICK50Hz)
        LD C,(HL)
        LD (HL),E
        INC HL
        LD B,(HL)
        LD (HL),D
        INC HL
        LD A,L
        CP A,PTICK
        JP NZ,MAIN_PT
        LD HL,TICK
MAIN_PT:
        LD (PTICK),HL
        XOR A,A
        EX DE,HL
        SBC HL,BC
        LD DE,STR_1_FPS
        CALL PRINT_NUM
;inc and print frame
        LD HL,(FRAME)
        INC HL
        LD (FRAME),HL
        LD DE,STR_FRAME
        CALL PRINT_NUM
;print time
        LD DE,STR_20_ms
        LD HL,(TICK50Hz)
        CALL PRINT_NUM

        JP MAIN

PRINT_DIG MACRO AA,BB,CC,DD,EE,FF,GG,HH,II,JJ,KK,LL,MM,NN,OO
        SBC HL,BC
        PUSH HL
        EX DE,HL
        LD DE,30
        LD BC,(COLOR)
        LD (HL),AA
        INC L
        LD (HL),BB
        INC L
        LD (HL),CC
        PUSH HL
        ADD HL,DE
        LD (HL),DD
        INC L
        LD (HL),EE
        INC L
        LD (HL),FF
        ADD HL,DE
        LD (HL),GG
        INC L
        LD (HL),HH
        INC L
        LD (HL),II
        ADD HL,DE
        LD (HL),JJ
        INC L
        LD (HL),KK
        INC L
        LD (HL),LL
        ADD HL,DE
        LD (HL),MM
        INC L
        LD (HL),NN
        INC L
        LD (HL),OO
        POP DE
        INC E
        INC E
        POP HL
        RET
        ENDM

PRINT_NUM_COL:
        LD (COLOR),BC
PRINT_NUM:
        LD BC,-10000
        CALL PRINT_0
        LD BC,-1000
        CALL PRINT_0
        LD BC,-100
        CALL PRINT_0
        LD BC,-10
        CALL PRINT_0
        LD BC,-1
PRINT_0:
        ADD HL,BC
        JR C,PRINT_1
        PRINT_DIG C,C,C, C,B,C, C,B,C, C,B,C, C,C,C
PRINT_1:
        ADD HL,BC
        JR C,PRINT_2
        PRINT_DIG B,B,C, B,C,C, B,B,C, B,B,C, B,B,C
PRINT_2:
        ADD HL,BC
        JR C,PRINT_3
        PRINT_DIG C,C,C, B,B,C, B,C,C, C,B,B, C,C,C
PRINT_3:
        ADD HL,BC
        JR C,PRINT_4
        PRINT_DIG C,C,C, B,B,C, B,C,B, B,B,C, C,C,C
PRINT_4:
        ADD HL,BC
        JR C,PRINT_5
        PRINT_DIG C,B,B, C,B,C, C,C,C, B,B,C, B,B,C
PRINT_5:
        ADD HL,BC
        JR C,PRINT_6
        PRINT_DIG C,C,C, C,B,B, C,C,C, B,B,C, C,C,C
PRINT_6:
        ADD HL,BC
        JR C,PRINT_7
        PRINT_DIG B,C,C, C,B,B, C,C,C, C,B,C, C,C,C
PRINT_7:
        ADD HL,BC
        JR C,PRINT_8
        PRINT_DIG C,C,C, B,B,C, B,B,C, B,B,C, B,B,C
PRINT_8:
        ADD HL,BC
        JR C,PRINT_9
        PRINT_DIG C,C,C, C,B,C, B,C,B, C,B,C, C,C,C
PRINT_9:
        ADD HL,BC
        PRINT_DIG C,C,C, C,B,C, C,C,C, B,B,C, C,C,B

;read 3 bytes from line
;split on 4 group (6 bits in each + 2 near bit)
;and save 4 bytes into LIFE_x buf
LIFE_READ_6_8 MACRO ADR
        LD A,L
        XOR H
        AND B
        XOR H
        LD (ADR),A
        LD A,H
        POP HL
        XOR L
        AND C
        XOR L
        LD (ADR+4),A
        LD A,L
        XOR H
        AND D
        XOR H
        LD (ADR+8),A
        LD A,H
        EX AF,AF'
        LD A,H
        POP HL
        XOR L
        AND E
        XOR L
        LD (ADR+12),A
        EX AF,AF'
        XOR L
        AND B
        XOR L
        LD (ADR+16),A
        LD A,L
        XOR H
        AND C
        XOR H
        LD (ADR+20),A
        LD A,H
        POP HL
        XOR L
        AND D
        XOR L
        LD (ADR+24),A
        LD A,L
        XOR H
        AND E
        XOR H
        LD (ADR+28),A
        ENDM

        
;read first two lines and do loop:
;  read two lines
;  write two lines
LIFE_STEP:
;push LIFE_STEP_S for skip write
        LD HL,LIFE_STEP_S
        PUSH HL
;save sp
        LD (LIFE_SP),SP
        LD HL,$4000
        LD (LIFE_PB),HL
        INC H
        LD (LIFE_PC),HL
        JP LIFE_READ_BC ; read first two line
LIFE_STEP_L:
        LD (LIFE_PB),HL
        INC H
        LD (LIFE_PC),HL
        CALL LIFE_READ_BC
        CALL LIFE_WRITE_EB 
LIFE_STEP_S: ; point to return after read first two line
        LD HL,(LIFE_PC)
        INC H
        LD (LIFE_PD),HL
        INC H
        LD (LIFE_PE),HL
        CALL LIFE_READ_DE
        CALL LIFE_WRITE_CD
        LD HL,(LIFE_PE)
        INC H
        LD (LIFE_PB),HL
        INC H
        LD (LIFE_PC),HL
        CALL LIFE_READ_BC
        CALL LIFE_WRITE_EB
        LD HL,(LIFE_PC)
        INC H
        LD (LIFE_PD),HL
        INC H
        LD (LIFE_PE),HL
        CALL LIFE_READ_DE
        CALL LIFE_WRITE_CD
        LD HL,(LIFE_PE)
        LD DE,32-7*256 
        ADD HL,DE
        LD A,L
        AND A,A
        JP NZ,LIFE_STEP_L ; next block in 8 line
        LD A,H
        ADD A,7
        LD H,A
        CP A,$58
        JP NZ,LIFE_STEP_L ; next block in 64 line
        RET

;read two line
LIFE_READ_BC:
;read first word and set sp
        LD HL,(LIFE_PB)
        LD E,(HL)
        INC L
        LD D,(HL)
        INC L
        LD SP,HL
        EX DE,HL
;set masks
        LD BC,$0107
        LD DE,$1F7F
        LIFE_READ_6_8 LIFE_B
        LIFE_READ_6_8 LIFE_B+32
        LIFE_READ_6_8 LIFE_B+64
        LIFE_READ_6_8 LIFE_B+96
        LIFE_READ_6_8 LIFE_B+128
        LD HL,(LIFE_PC)
        LD E,(HL)
        INC L
        LD D,(HL)
        INC L
        LD SP,HL
        EX DE,HL
        LD DE,$1F7F
        LIFE_READ_6_8 LIFE_C
        LIFE_READ_6_8 LIFE_C+32
        LIFE_READ_6_8 LIFE_C+64
        LIFE_READ_6_8 LIFE_C+96
        LIFE_READ_6_8 LIFE_C+128
        LD SP,(LIFE_SP)
        RET
        
LIFE_READ_DE:
        LD HL,(LIFE_PD)
        LD E,(HL)
        INC L
        LD D,(HL)
        INC L
        LD SP,HL
        EX DE,HL
        LD BC,$0107
        LD DE,$1F7F
        LIFE_READ_6_8 LIFE_D
        LIFE_READ_6_8 LIFE_D+32
        LIFE_READ_6_8 LIFE_D+64
        LIFE_READ_6_8 LIFE_D+96
        LIFE_READ_6_8 LIFE_D+128
        LD HL,(LIFE_PE)
        LD E,(HL)
        INC L
        LD D,(HL)
        INC L
        LD SP,HL
        EX DE,HL
        LD DE,$1F7F
        LIFE_READ_6_8 LIFE_E
        LIFE_READ_6_8 LIFE_E+32
        LIFE_READ_6_8 LIFE_E+64
        LIFE_READ_6_8 LIFE_E+96
        LIFE_READ_6_8 LIFE_E+128
        LD SP,(LIFE_SP)
        RET

;calculate two bits in LINE_C
LIFE_WRITE_C_S MACRO TBL
        LD H,TBL
        LD L,B
        LD H,(HL)
        LD L,D
        LD H,(HL)
        LD L,C
        LD A,(HL)
        ENDM

LIFE_WRITE_C MACRO TBL
        LD H,TBL
        LD L,B
        LD H,(HL)
        LD L,D
        LD H,(HL)
        LD L,C
        OR A,(HL)
        ENDM

;calculate two bits in LINE_D
LIFE_WRITE_D_S MACRO TBL
        LD H,TBL
        LD L,C
        LD H,(HL)
        LD L,E
        LD H,(HL)
        LD L,D
        LD A,(HL)
        ENDM

LIFE_WRITE_D MACRO TBL
        LD H,TBL
        LD L,C
        LD H,(HL)
        LD L,E
        LD H,(HL)
        LD L,D
        OR A,(HL)
        ENDM

;read 4x4 bytes from buf and calc 2x24 cells
LIFE_WRITE MACRO XX,YY,OFS
        POP XX
        POP YY
        LIFE_WRITE_D_S A3
        LIFE_WRITE_D A2
        LIFE_WRITE_D A1
        EX AF,AF'
        LIFE_WRITE_C_S A3
        LIFE_WRITE_C A2
        LIFE_WRITE_C A1
        POP XX
        POP YY
        LIFE_WRITE_C A0
        LD (IX+OFS+1),A
        LIFE_WRITE_C_S A3
        LIFE_WRITE_C A2
        EX AF,AF'
        LIFE_WRITE_D A0
        LD (IY+OFS+1),A
        LIFE_WRITE_D_S A3
        LIFE_WRITE_D A2
        POP XX
        POP YY
        LIFE_WRITE_D A1
        LIFE_WRITE_D A0
        LD (IY+OFS+2),A
        LIFE_WRITE_D_S A3
        EX AF,AF'
        LIFE_WRITE_C A1
        LIFE_WRITE_C A0
        LD (IX+OFS+2),A
        LIFE_WRITE_C_S A3
        POP XX
        POP YY
        LIFE_WRITE_C A2
        LIFE_WRITE_C A1
        LIFE_WRITE_C A0
        LD (IX+OFS+3),A
        EX AF,AF'
        LIFE_WRITE_D A2
        LIFE_WRITE_D A1
        LIFE_WRITE_D A0
        LD (IY+OFS+3),A
        ENDM

;read buf and calc line c and d
LIFE_WRITE_CD:
        LD IX,(LIFE_PC)
        LD IY,(LIFE_PD)
        LD SP,LIFE_C
        LIFE_WRITE BC,DE,0
        LIFE_WRITE BC,DE,3
        LIFE_WRITE BC,DE,6
        LIFE_WRITE BC,DE,9
        LIFE_WRITE BC,DE,12
        LIFE_WRITE BC,DE,15
        LIFE_WRITE BC,DE,18
        LIFE_WRITE BC,DE,21
        LIFE_WRITE BC,DE,24
        LIFE_WRITE BC,DE,27
        LD SP,(LIFE_SP)
        RET

;read buf and calc line e and b
LIFE_WRITE_EB:
        LD IX,(LIFE_PE)
        LD IY,(LIFE_PB)
        LD SP,LIFE_C
        LIFE_WRITE DE,BC,0
        LIFE_WRITE DE,BC,3
        LIFE_WRITE DE,BC,6
        LIFE_WRITE DE,BC,9
        LIFE_WRITE DE,BC,12
        LIFE_WRITE DE,BC,15
        LIFE_WRITE DE,BC,18
        LIFE_WRITE DE,BC,21
        LIFE_WRITE DE,BC,24
        LIFE_WRITE DE,BC,27
        LD SP,(LIFE_SP)
        RET

;       END
;tables for calc new state of cells
        
        ORG A0*256
        FOR i=0 TO 255 STEP 1
        DEFB B0+(((i*257)/128)&15)
        ENDFOR

        ORG A1*256
        FOR i=0 TO 255 STEP 1
        DEFB B1+(((i*257)/2)&15)
        ENDFOR

        ORG A2*256
        FOR i=0 TO 255 STEP 1
        DEFB B2+(((i*257)/8)&15)
        ENDFOR

        ORG A3*256
        FOR i=0 TO 255 STEP 1
        DEFB B3+(((i*257)/32)&15)
        ENDFOR

        ORG B0*256
        FOR i=0 TO 15 STEP 1
        FOR j=0 TO 255 STEP 1
        bits=(((j*257)/128)&15)
        s1=((i*$111)&$124)*$49/$100+((bits*$111)&$124)*$49/$100
        s2=((i*$111)&$248)*$49/$200+((bits*$111)&$248)*$49/$200
        s1=s1&7
        s2=s2&7
        IF s1>4
                s1=4
        ENDIF
        IF s2>4
                s2=4
        ENDIF
        DEFB C0+s2*5+s1
        ENDFOR
        ENDFOR

        ORG B1*256
        FOR i=0 TO 15 STEP 1
        FOR j=0 TO 255 STEP 1
        bits=(((j*257)/2)&15)
        s1=((i*$111)&$124)*$49/$100+((bits*$111)&$124)*$49/$100
        s2=((i*$111)&$248)*$49/$200+((bits*$111)&$248)*$49/$200
        s1=s1&7
        s2=s2&7
        IF s1>4
                s1=4
        ENDIF
        IF s2>4
                s2=4
        ENDIF
        DEFB C1+s2*5+s1
        ENDFOR
        ENDFOR

        ORG B2*256
        FOR i=0 TO 15 STEP 1
        FOR j=0 TO 255 STEP 1
        bits=(((j*257)/8)&15)
        s1=((i*$111)&$124)*$49/$100+((bits*$111)&$124)*$49/$100
        s2=((i*$111)&$248)*$49/$200+((bits*$111)&$248)*$49/$200
        s1=s1&7
        s2=s2&7
        IF s1>4
                s1=4
        ENDIF
        IF s2>4
                s2=4
        ENDIF
        DEFB C2+s2*5+s1
        ENDFOR
        ENDFOR

        ORG B3*256
        FOR i=0 TO 15 STEP 1
        FOR j=0 TO 255 STEP 1
        bits=(((j*257)/32)&15)
        s1=((i*$111)&$124)*$49/$100+((bits*$111)&$124)*$49/$100
        s2=((i*$111)&$248)*$49/$200+((bits*$111)&$248)*$49/$200
        s1=s1&7
        s2=s2&7
        IF s1>4
                s1=4
        ENDIF
        IF s2>4
                s2=4
        ENDIF
        DEFB C3+s2*5+s1
        ENDFOR
        ENDFOR



        ORG C0*256
        FOR j=0 TO 24 STEP 1
        FOR k=0 TO 255 STEP 1
        s2=j/5
        s1=j-s2*5
        bits=(((k*257)/128)&15)
        s1=s1*2+((bits*$111)&$104)*$49/$80
        s2=s2*2+((bits*$111)&$208)*$49/$100
        s1=(s1&14)+((k/1)&1)
        s2=(s2&14)+((k/2)&1)
        if s1<5
                s1=0
        elseif s1>7
                s1=0
        else
                s1=1
        endif
        if s2<5
                s2=0
        elseif s2>7
                s2=0
        else
                s2=2
        endif
        DEFB s1+s2
        ENDFOR
        ENDFOR

        ORG C1*256
        FOR j=0 TO 24 STEP 1
        FOR k=0 TO 255 STEP 1
        s2=j/5
        s1=j-s2*5
        bits=(((k*257)/2)&15)
        s1=s1*2+((bits*$111)&$104)*$49/$80
        s2=s2*2+((bits*$111)&$208)*$49/$100
        s1=(s1&14)+((k/4)&1)
        s2=(s2&14)+((k/8)&1)
        if s1<5
                s1=0
        elseif s1>7
                s1=0
        else
                s1=4
        endif
        if s2<5
                s2=0
        elseif s2>7
                s2=0
        else
                s2=8
        endif
        DEFB s1+s2
        ENDFOR
        ENDFOR

        ORG C2*256
        FOR j=0 TO 24 STEP 1
        FOR k=0 TO 255 STEP 1
        s2=j/5
        s1=j-s2*5
        bits=(((k*257)/8)&15)
        s1=s1*2+((bits*$111)&$104)*$49/$80
        s2=s2*2+((bits*$111)&$208)*$49/$100
        s1=(s1&14)+((k/16)&1)
        s2=(s2&14)+((k/32)&1)
        if s1<5
                s1=0
        elseif s1>7
                s1=0
        else
                s1=16
        endif
        if s2<5
                s2=0
        elseif s2>7
                s2=0
        else
                s2=32
        endif
        DEFB s1+s2
        ENDFOR
        ENDFOR

        ORG C3*256
        FOR j=0 TO 24 STEP 1
        FOR k=0 TO 255 STEP 1
        s2=j/5
        s1=j-s2*5
        bits=(((k*257)/32)&15)
        s1=s1*2+((bits*$111)&$104)*$49/$80
        s2=s2*2+((bits*$111)&$208)*$49/$100
        s1=(s1&14)+((k/64)&1)
        s2=(s2&14)+((k/128)&1)
        if s1<5
                s1=0
        elseif s1>7
                s1=0
        else
                s1=64
        endif
        if s2<5
                s2=0
        elseif s2>7
                s2=0
        else
                s2=128
        endif
        DEFB s1+s2
        ENDFOR
        ENDFOR





