#ifndef PS2_SCANCODES_H_INCLUDED
#define PS2_SCANCODES_H_INCLUDED

#define KEY_NONE            0x00

#define KEY_ESC             0x76
#define KEY_F1              0x05
#define KEY_F2              0x06
#define KEY_F3              0x04
#define KEY_F4              0x0C
#define KEY_F5              0x03
#define KEY_F6              0x0B
#define KEY_F7              0x83
#define KEY_F8              0x0A
#define KEY_F9              0x01
#define KEY_F10             0x09
#define KEY_F11             0x78
#define KEY_F12             0x07

#define KEY_BACKQUOTE       0x0E // `
#define KEY_1               0x16
#define KEY_2               0x1E
#define KEY_3               0x26
#define KEY_4               0x25
#define KEY_5               0x2E
#define KEY_6               0x36
#define KEY_7               0x3D
#define KEY_8               0x3E
#define KEY_9               0x46
#define KEY_0               0x45
#define KEY_MINUS           0x4E // -
#define KEY_EQUALS          0x55 // =
#define KEY_BACKSLASH       0x5D // \ .
#define KEY_BACKSPACE       0x66

#define KEY_TAB             0x0D
#define KEY_Q               0x15
#define KEY_W               0x1D
#define KEY_E               0x24
#define KEY_R               0x2D
#define KEY_T               0x2C
#define KEY_Y               0x35
#define KEY_U               0x3C
#define KEY_I               0x43
#define KEY_O               0x44
#define KEY_P               0x4D
#define KEY_LEFTBRACKET     0x54 // [
#define KEY_RIGHTBRACKET    0x5B // ]

#define KEY_CAPSLOCK        0x58
#define KEY_A               0x1C
#define KEY_S               0x1B
#define KEY_D               0x23
#define KEY_F               0x2B
#define KEY_G               0x34
#define KEY_H               0x33
#define KEY_J               0x3B
#define KEY_K               0x42
#define KEY_L               0x4B
#define KEY_SEMICOLON       0x4C // ;
#define KEY_QUOTE           0x52 // '
#define KEY_RETURN          0x5A

#define KEY_LSHIFT          0x12
#define KEY_Z               0x1A
#define KEY_X               0x22
#define KEY_C               0x21
#define KEY_V               0x2A
#define KEY_B               0x32
#define KEY_N               0x31
#define KEY_M               0x3A
#define KEY_COMMA           0x41 // ,
#define KEY_PERIOD          0x49 // .
#define KEY_SLASH           0x4A // /
#define KEY_RSHIFT          0x59

#define KEY_LCTRL           0x14
#define KEY_LWIN            0xE01F
#define KEY_LALT            0x11
#define KEY_SPACE           0x29
#define KEY_RALT            0xE011
#define KEY_RWIN            0xE027
#define KEY_MENU            0xE02F
#define KEY_RCTRL           0xE014

#define KEY_PRNTSCR         0xE07C
#define KEY_SCROLLOCK       0x7E
#define KEY_PAUSE           0x77
#define KEY_PRNTSCR_SKIP    0xE012 //      !
#define KEY_PAUSE_SKIP      0xE114

#define KEY_INSERT          0xE070
#define KEY_HOME            0xE06C
#define KEY_PAGEUP          0xE07D
#define KEY_DELETE          0xE071
#define KEY_END             0xE069
#define KEY_PAGEDOWN        0xE07A
#define KEY_UP              0xE075
#define KEY_LEFT            0xE06B
#define KEY_DOWN            0xE072
#define KEY_RIGHT           0xE074

#define KEY_NUMLOCK         0x77
#define KEY_KP_DIVIDE       0xE04A  // /
#define KEY_KP_MULTIPLY     0x7C // *
#define KEY_KP_MINUS        0x7B // -
#define KEY_KP7             0x6C
#define KEY_KP8             0x75
#define KEY_KP9             0x7D
#define KEY_KP_PLUS         0x79 // +
#define KEY_KP4             0x6B
#define KEY_KP5             0x73
#define KEY_KP6             0x74
#define KEY_KP1             0x69
#define KEY_KP2             0x72
#define KEY_KP3             0x7A
#define KEY_KP0             0x70
#define KEY_KP_PERIOD       0x71 // .
#define KEY_KP_ENTER        0xE05A

#define KEY_KP_PERIOD       0x71 // .

#define KEY_POWER           0xE037
#define KEY_SLEEP           0xE03F
#define KEY_WAKE            0xE05E

#endif

